/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.model.HoodieActionInstant;
import org.apache.hudi.avro.model.HoodieArchivedMetaEntry;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieCommitMetadata;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.common.model.ActionType;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.versioning.clean.CleanPlanV2MigrationHandler;
import org.apache.hudi.common.table.timeline.versioning.v1.ArchivedTimelineV1;
import org.apache.hudi.common.table.timeline.versioning.v1.InstantComparatorV1;
import org.apache.hudi.common.table.timeline.versioning.v1.InstantGeneratorV1;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathFilter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestArchivedTimelineV1
extends HoodieCommonTestHarness {
    private static final InstantGeneratorV1 INSTANT_GENERATOR_V1 = new InstantGeneratorV1();
    private HoodieArchivedTimeline timeline;

    @BeforeEach
    public void setUp() throws IOException {
        this.initMetaClient();
    }

    @AfterEach
    public void clean() {
        this.cleanMetaClient();
    }

    @Test
    public void testArchivedInstantsNotLoadedToMemory() throws Exception {
        List<HoodieInstant> instants = this.createInstants();
        this.timeline = new ArchivedTimelineV1(this.metaClient);
        this.validateInstantsLoaded(this.timeline, Arrays.asList("01", "03", "05", "08", "09", "11"), false);
        Assertions.assertEquals(instants, (Object)this.timeline.getInstants());
    }

    @Test
    public void testLoadArchivedInstantsInStartTsRangeToMemory() throws Exception {
        List<HoodieInstant> instants = this.createInstants();
        this.timeline = new ArchivedTimelineV1(this.metaClient, "08");
        this.validateInstantsLoaded(this.timeline, Arrays.asList("01", "03", "05", "11"), false);
        this.validateInstantsLoaded(this.timeline, Arrays.asList("08", "09"), true);
        List<HoodieInstant> completedInstants = this.getCompletedInstantForTs(instants, Arrays.asList("08", "09"));
        Assertions.assertEquals(completedInstants, (Object)this.timeline.getInstants());
    }

    @Test
    public void testLoadArchivedInstantsInInclusiveTsRangeToMemory() throws Exception {
        List<HoodieInstant> instants = this.createInstants();
        this.timeline = new ArchivedTimelineV1(this.metaClient, "05", "09");
        this.validateInstantsLoaded(this.timeline, Arrays.asList("01", "03", "11"), false);
        this.validateInstantsLoaded(this.timeline, Arrays.asList("05", "08", "09"), true);
        List<HoodieInstant> completedInstants = this.getCompletedInstantForTs(instants, Arrays.asList("05", "08", "09"));
        Assertions.assertEquals(completedInstants, (Object)this.timeline.getInstants());
    }

    @Test
    public void testLoadArchivedCompletedInstantsToMemory() throws Exception {
        List<HoodieInstant> instants = this.createInstants();
        this.timeline = new ArchivedTimelineV1(this.metaClient, "01", "11");
        this.validateInstantsLoaded(this.timeline, Arrays.asList("01", "11"), false);
        this.validateInstantsLoaded(this.timeline, Arrays.asList("03", "05", "08", "09"), true);
        Assertions.assertEquals(instants.stream().filter(HoodieInstant::isCompleted).collect(Collectors.toList()), (Object)this.timeline.getInstants());
    }

    @Test
    public void testLoadArchivedCompactionInstantsToMemory() throws Exception {
        List<HoodieInstant> instants = this.createInstants();
        this.timeline = new ArchivedTimelineV1(this.metaClient);
        this.timeline.loadCompactionDetailsInMemory("08");
        this.validateInstantsLoaded(this.timeline, Arrays.asList("01", "03", "05", "09", "11"), false);
        this.validateInstantsLoaded(this.timeline, Arrays.asList("08"), true, Arrays.asList(HoodieInstant.State.INFLIGHT));
        Assertions.assertEquals(instants, (Object)this.timeline.getInstants());
    }

    @Test
    public void testLoadArchivedInstantsToMemory() throws Exception {
        List<HoodieInstant> instants = this.createInstants();
        this.timeline = new ArchivedTimelineV1(this.metaClient);
        this.timeline.loadInstantDetailsInMemory("02", "11");
        this.validateInstantsLoaded(this.timeline, Arrays.asList("03"), true, Arrays.asList(HoodieInstant.State.REQUESTED, HoodieInstant.State.COMPLETED));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("03"), false, Collections.singletonList(HoodieInstant.State.INFLIGHT));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("05", "08", "09"), true, Arrays.asList(HoodieInstant.State.REQUESTED, HoodieInstant.State.INFLIGHT, HoodieInstant.State.COMPLETED));
        this.validateInstantsLoaded(this.timeline, Collections.singletonList("11"), true, Arrays.asList(HoodieInstant.State.REQUESTED, HoodieInstant.State.INFLIGHT));
        Assertions.assertEquals(instants, (Object)this.timeline.getInstants());
    }

    @Test
    public void testLoadAllArchivedCompletedInstantsByLogFilePaths() throws Exception {
        List<HoodieInstant> instants = this.createInstants();
        List<String> archivedLogFilePaths = this.getArchiveLogFilePaths();
        this.timeline = new ArchivedTimelineV1(this.metaClient, new HashSet<String>(archivedLogFilePaths));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("01", "11"), false);
        this.validateInstantsLoaded(this.timeline, Arrays.asList("03", "05", "08", "09"), true);
        Assertions.assertEquals(instants.stream().filter(HoodieInstant::isCompleted).collect(Collectors.toList()), (Object)this.timeline.getInstants());
    }

    @Test
    public void testLoadFilteredArchivedCompletedInstantsBySingleLogFilePath() throws Exception {
        List<HoodieInstant> instants = this.createInstants();
        List<String> archivedLogFilePaths = this.getArchiveLogFilePaths();
        this.timeline = new ArchivedTimelineV1(this.metaClient, Collections.singleton(archivedLogFilePaths.get(0)));
        this.validateInstantsLoaded(this.timeline, Collections.singletonList("03"), true, Collections.singletonList(HoodieInstant.State.COMPLETED));
        this.validateInstantsLoaded(this.timeline, Collections.singletonList("03"), false, Arrays.asList(HoodieInstant.State.REQUESTED, HoodieInstant.State.INFLIGHT));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("01", "05", "08", "09", "11"), false);
        Assertions.assertEquals(instants.stream().filter(HoodieInstant::isCompleted).filter(instant -> Collections.singletonList("03").contains(instant.requestedTime())).collect(Collectors.toList()), (Object)this.timeline.getInstants());
        Assertions.assertEquals((long)0L, (long)this.timeline.getInstants().stream().filter(HoodieInstant::isInflight).count());
        Assertions.assertEquals((long)0L, (long)this.timeline.getInstants().stream().filter(HoodieInstant::isRequested).count());
    }

    @Test
    public void testLoadFilteredArchivedRequestedInstantsBySingleLogFilePath() throws Exception {
        List<HoodieInstant> instants = this.createInstants();
        List<String> archivedLogFilePaths = this.getArchiveLogFilePaths();
        this.timeline = new ArchivedTimelineV1(this.metaClient, Collections.singleton(archivedLogFilePaths.get(0)), Option.of((Object)HoodieInstant.State.REQUESTED));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("01", "03", "05"), true, Collections.singletonList(HoodieInstant.State.REQUESTED));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("01", "03", "05"), false, Arrays.asList(HoodieInstant.State.INFLIGHT, HoodieInstant.State.COMPLETED));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("08", "09", "11"), false);
        Assertions.assertEquals(instants.stream().filter(HoodieInstant::isRequested).filter(instant -> new HashSet<String>(Arrays.asList("01", "03", "05")).contains(instant.requestedTime())).collect(Collectors.toList()), (Object)this.timeline.getInstants());
        Assertions.assertEquals((long)0L, (long)this.timeline.getInstants().stream().filter(HoodieInstant::isCompleted).count());
        Assertions.assertEquals((long)0L, (long)this.timeline.getInstants().stream().filter(HoodieInstant::isInflight).count());
    }

    @Test
    public void testLoadFilteredArchivedInflightInstantsBySingleLogFilePath() throws Exception {
        List<HoodieInstant> instants = this.createInstants();
        List<String> archivedLogFilePaths = this.getArchiveLogFilePaths();
        this.timeline = new ArchivedTimelineV1(this.metaClient, Collections.singleton(archivedLogFilePaths.get(0)), Option.of((Object)HoodieInstant.State.INFLIGHT));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("01"), true, Collections.singletonList(HoodieInstant.State.INFLIGHT));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("01"), false, Arrays.asList(HoodieInstant.State.REQUESTED, HoodieInstant.State.COMPLETED));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("03"), false);
        this.validateInstantsLoaded(this.timeline, Arrays.asList("05", "08", "09", "11"), false);
        Assertions.assertEquals(instants.stream().filter(HoodieInstant::isInflight).filter(instant -> new HashSet<String>(Arrays.asList("01", "03")).contains(instant.requestedTime())).collect(Collectors.toList()), (Object)this.timeline.getInstants());
        Assertions.assertEquals((long)0L, (long)this.timeline.getInstants().stream().filter(HoodieInstant::isCompleted).count());
        Assertions.assertEquals((long)0L, (long)this.timeline.getInstants().stream().filter(HoodieInstant::isRequested).count());
    }

    @Test
    public void testLoadFilteredArchivedAllInstantsBySingleLogFilePath() throws Exception {
        List<HoodieInstant> instants = this.createInstants();
        List<String> archivedLogFilePaths = this.getArchiveLogFilePaths();
        this.timeline = new ArchivedTimelineV1(this.metaClient, Collections.singleton(archivedLogFilePaths.get(0)), Option.empty());
        this.validateInstantsLoaded(this.timeline, Collections.singletonList("03"), true, Arrays.asList(HoodieInstant.State.REQUESTED, HoodieInstant.State.COMPLETED));
        this.validateInstantsLoaded(this.timeline, Collections.singletonList("03"), false, Collections.singletonList(HoodieInstant.State.INFLIGHT));
        this.validateInstantsLoaded(this.timeline, Collections.singletonList("01"), true, Arrays.asList(HoodieInstant.State.REQUESTED, HoodieInstant.State.INFLIGHT));
        this.validateInstantsLoaded(this.timeline, Collections.singletonList("01"), false, Collections.singletonList(HoodieInstant.State.COMPLETED));
        this.validateInstantsLoaded(this.timeline, Collections.singletonList("05"), true, Collections.singletonList(HoodieInstant.State.REQUESTED));
        this.validateInstantsLoaded(this.timeline, Collections.singletonList("05"), false, Arrays.asList(HoodieInstant.State.INFLIGHT, HoodieInstant.State.COMPLETED));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("01", "05"), true);
        this.validateInstantsLoaded(this.timeline, Arrays.asList("08", "09", "11"), false);
        Assertions.assertEquals(instants.subList(0, 6), (Object)this.timeline.getInstants());
    }

    @Test
    public void testLoadFilteredArchivedCompletedInstantsByMultipleLogFilePath() throws Exception {
        List<HoodieInstant> instants = this.createInstants();
        List<String> archivedLogFilePaths = this.getArchiveLogFilePaths();
        this.timeline = new ArchivedTimelineV1(this.metaClient, new HashSet<String>(archivedLogFilePaths.subList(0, 2)));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("03", "05", "08", "09"), true, Collections.singletonList(HoodieInstant.State.COMPLETED));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("03", "05", "08", "09"), false, Arrays.asList(HoodieInstant.State.REQUESTED, HoodieInstant.State.INFLIGHT));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("01", "11"), false);
        Assertions.assertEquals(instants.stream().filter(HoodieInstant::isCompleted).filter(instant -> Arrays.asList("03", "05", "08", "09").contains(instant.requestedTime())).collect(Collectors.toList()), (Object)this.timeline.getInstants());
        Assertions.assertEquals((long)0L, (long)this.timeline.getInstants().stream().filter(HoodieInstant::isRequested).count());
        Assertions.assertEquals((long)0L, (long)this.timeline.getInstants().stream().filter(HoodieInstant::isInflight).count());
    }

    @Test
    public void testLoadFilteredArchivedRequestedInstantsByMultipleLogFilePath() throws Exception {
        List<HoodieInstant> instants = this.createInstants();
        List<String> archivedLogFilePaths = this.getArchiveLogFilePaths();
        this.timeline = new ArchivedTimelineV1(this.metaClient, new HashSet<String>(archivedLogFilePaths.subList(0, 2)), Option.of((Object)HoodieInstant.State.REQUESTED));
        this.validateInstantsLoaded(this.timeline, Collections.singletonList("03"), true, Collections.singletonList(HoodieInstant.State.REQUESTED));
        this.validateInstantsLoaded(this.timeline, Collections.singletonList("03"), false, Arrays.asList(HoodieInstant.State.INFLIGHT, HoodieInstant.State.COMPLETED));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("01", "05", "08", "09"), true, Collections.singletonList(HoodieInstant.State.REQUESTED));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("01", "05", "08", "09"), false, Arrays.asList(HoodieInstant.State.INFLIGHT, HoodieInstant.State.COMPLETED));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("11"), false);
        Assertions.assertEquals(instants.stream().filter(HoodieInstant::isRequested).filter(instant -> Arrays.asList("01", "03", "05", "08", "09").contains(instant.requestedTime())).collect(Collectors.toList()), (Object)this.timeline.getInstants());
        Assertions.assertEquals((long)0L, (long)this.timeline.getInstants().stream().filter(HoodieInstant::isCompleted).count());
        Assertions.assertEquals((long)0L, (long)this.timeline.getInstants().stream().filter(HoodieInstant::isInflight).count());
    }

    @Test
    public void testLoadFilteredArchivedInflightInstantsByMultipleLogFilePath() throws Exception {
        List<HoodieInstant> instants = this.createInstants();
        List<String> archivedLogFilePaths = this.getArchiveLogFilePaths();
        this.timeline = new ArchivedTimelineV1(this.metaClient, new HashSet<String>(archivedLogFilePaths.subList(0, 2)), Option.of((Object)HoodieInstant.State.INFLIGHT));
        this.validateInstantsLoaded(this.timeline, Collections.singletonList("03"), false);
        this.validateInstantsLoaded(this.timeline, Arrays.asList("01", "05", "08", "09"), true, Collections.singletonList(HoodieInstant.State.INFLIGHT));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("11"), false);
        Assertions.assertEquals(instants.stream().filter(HoodieInstant::isInflight).filter(instant -> Arrays.asList("01", "03", "05", "08", "09").contains(instant.requestedTime())).collect(Collectors.toList()), (Object)this.timeline.getInstants());
        Assertions.assertEquals((long)0L, (long)this.timeline.getInstants().stream().filter(HoodieInstant::isCompleted).count());
        Assertions.assertEquals((long)0L, (long)this.timeline.getInstants().stream().filter(HoodieInstant::isRequested).count());
    }

    @Test
    public void testLoadFilteredArchivedAllInstantsByMultipleLogFilePath() throws Exception {
        List<HoodieInstant> instants = this.createInstants();
        List<String> archivedLogFilePaths = this.getArchiveLogFilePaths();
        this.timeline = new ArchivedTimelineV1(this.metaClient, new HashSet<String>(archivedLogFilePaths.subList(0, 2)), Option.empty());
        this.validateInstantsLoaded(this.timeline, Collections.singletonList("03"), true, Arrays.asList(HoodieInstant.State.REQUESTED, HoodieInstant.State.COMPLETED));
        this.validateInstantsLoaded(this.timeline, Collections.singletonList("03"), false, Collections.singletonList(HoodieInstant.State.INFLIGHT));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("01", "05", "08", "09"), true);
        this.validateInstantsLoaded(this.timeline, Arrays.asList("11"), false);
        Assertions.assertEquals(instants.subList(0, 14), (Object)this.timeline.getInstants());
    }

    @Test
    public void testLoadArchivedCompletedInstantsForAdditionalActions() throws Exception {
        List<HoodieInstant> instants = this.createAdditionalInstants();
        this.timeline = new ArchivedTimelineV1(this.metaClient, "15", "21");
        List<String> timestamps = Arrays.asList("15", "17", "19", "21");
        this.validateInstantsLoaded(this.timeline, timestamps, true, Collections.singletonList(HoodieInstant.State.COMPLETED));
        this.validateInstantsLoaded(this.timeline, timestamps, false, Arrays.asList(HoodieInstant.State.REQUESTED, HoodieInstant.State.INFLIGHT));
        Assertions.assertEquals(this.getCompletedInstantForTs(instants, timestamps), (Object)this.timeline.getInstants());
    }

    @Test
    public void testLoadArchivedRequestedInstantsForAdditionalActions() throws Exception {
        List<HoodieInstant> instants = this.createAdditionalInstants();
        this.timeline = new ArchivedTimelineV1(this.metaClient, "15", "21", Option.of((Object)HoodieInstant.State.REQUESTED));
        List<String> timestamps = Arrays.asList("15", "17", "19", "21");
        this.validateInstantsLoaded(this.timeline, Arrays.asList("17", "21"), true, Collections.singletonList(HoodieInstant.State.REQUESTED));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("15", "19"), false, Collections.singletonList(HoodieInstant.State.REQUESTED));
        this.validateInstantsLoaded(this.timeline, timestamps, false, Arrays.asList(HoodieInstant.State.INFLIGHT, HoodieInstant.State.COMPLETED));
        Assertions.assertEquals(instants.stream().filter(HoodieInstant::isRequested).collect(Collectors.toList()), (Object)this.timeline.getInstants());
    }

    @Test
    public void testLoadArchivedInflightInstantsForAdditionalActions() throws Exception {
        List<HoodieInstant> instants = this.createAdditionalInstants();
        this.timeline = new ArchivedTimelineV1(this.metaClient, "15", "21", Option.of((Object)HoodieInstant.State.INFLIGHT));
        List<String> timestamps = Arrays.asList("15", "17", "19", "21");
        this.validateInstantsLoaded(this.timeline, Arrays.asList("17", "21"), true, Collections.singletonList(HoodieInstant.State.INFLIGHT));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("15", "19"), false, Collections.singletonList(HoodieInstant.State.INFLIGHT));
        this.validateInstantsLoaded(this.timeline, timestamps, false, Arrays.asList(HoodieInstant.State.REQUESTED, HoodieInstant.State.COMPLETED));
        Assertions.assertEquals(instants.stream().filter(HoodieInstant::isInflight).collect(Collectors.toList()), (Object)this.timeline.getInstants());
    }

    @Test
    public void testLoadArchivedInstantsForAdditionalActions() throws Exception {
        List<HoodieInstant> instants = this.createAdditionalInstants();
        this.timeline = new ArchivedTimelineV1(this.metaClient, "15", "21", Option.empty());
        List<String> timestamps = Arrays.asList("15", "17", "19", "21");
        this.validateInstantsLoaded(this.timeline, Arrays.asList("15", "19"), true, Collections.singletonList(HoodieInstant.State.COMPLETED));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("15", "19"), false, Arrays.asList(HoodieInstant.State.REQUESTED, HoodieInstant.State.INFLIGHT));
        this.validateInstantsLoaded(this.timeline, Arrays.asList("17", "21"), true);
        Assertions.assertEquals(instants, (Object)this.timeline.getInstants());
    }

    @Test
    void readLegacyArchivedTimelineWithNullFields() {
        String samplePath = this.getClass().getClassLoader().getResource("archived_timeline").getPath();
        this.metaClient = HoodieTableMetaClient.builder().setBasePath(samplePath).setConf(HoodieTestUtils.getDefaultStorageConf()).setLoadActiveTimelineOnLoad(false).build();
        ArchivedTimelineV1 timeline = new ArchivedTimelineV1(this.metaClient);
        timeline.loadCompletedInstantDetailsInMemory();
        Assertions.assertEquals((int)3, (int)timeline.getInstants().size());
    }

    @ParameterizedTest
    @ValueSource(strings={"hudi_0_13_0_archive", "hudi_0_8_0_archive"})
    void shouldReadArchivedFileAndValidateContent(String archivePath) {
        String path = this.getClass().getClassLoader().getResource(archivePath).getPath() + "/.commits_.archive.1_1-0-1";
        Assertions.assertDoesNotThrow(() -> this.readAndValidateArchivedFile(path, this.metaClient.getStorage()));
    }

    @Test
    public void testDuplicateTimestampDifferentActions() throws Exception {
        HoodieInstant commit30 = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.COMPLETED, "commit", "30");
        HoodieInstant clean30 = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.COMPLETED, "clean", "30");
        HoodieInstant commit31 = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.COMPLETED, "commit", "31");
        try (HoodieLogFormat.Writer writer = this.buildWriter(ArchivedTimelineV1.getArchiveLogPath((StoragePath)this.metaClient.getArchivePath()));){
            ArrayList<IndexedRecord> records = new ArrayList<IndexedRecord>();
            records.add((IndexedRecord)this.createArchivedMetaWrapper(commit30));
            records.add((IndexedRecord)this.createArchivedMetaWrapper(clean30));
            records.add((IndexedRecord)this.createArchivedMetaWrapper(commit31));
            this.writeArchiveLog(writer, records);
        }
        ArchivedTimelineV1 dupTimeline = new ArchivedTimelineV1(this.metaClient);
        dupTimeline.loadCompletedInstantDetailsInMemory();
        Assertions.assertTrue((boolean)dupTimeline.getInstantDetails(commit30).isPresent(), (String)"commit metadata for ts=30 must be loaded");
        Assertions.assertTrue((boolean)dupTimeline.getInstantDetails(clean30).isPresent(), (String)"clean metadata for ts=30 must be loaded");
        Assertions.assertFalse((boolean)Arrays.equals((byte[])dupTimeline.getInstantDetails(commit30).get(), (byte[])dupTimeline.getInstantDetails(clean30).get()), (String)"clean and commit metadata should have different payloads");
        HoodieInstant fakeClean31 = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.COMPLETED, "clean", "31");
        Assertions.assertTrue((boolean)dupTimeline.getInstantDetails(commit31).isPresent(), (String)"commit metadata for ts=31 must be loaded");
        Assertions.assertFalse((boolean)dupTimeline.getInstantDetails(fakeClean31).isPresent(), (String)"clean metadata for ts=31 must NOT be loaded");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readAndValidateArchivedFile(String path, HoodieStorage storage) throws IOException {
        try (HoodieLogFormat.Reader reader = HoodieLogFormat.newReader((HoodieStorage)storage, (HoodieLogFile)new HoodieLogFile(path), (Schema)HoodieArchivedMetaEntry.getClassSchema());){
            while (reader.hasNext()) {
                ClosableIterator itr;
                block23: {
                    HoodieLogBlock block = (HoodieLogBlock)reader.next();
                    if (!(block instanceof HoodieAvroDataBlock)) continue;
                    HoodieAvroDataBlock avroBlock = (HoodieAvroDataBlock)block;
                    itr = avroBlock.getRecordIterator(HoodieRecord.HoodieRecordType.AVRO);
                    Throwable throwable = null;
                    try {
                        if (itr.hasNext()) {
                            itr.next();
                        }
                        if (itr == null) continue;
                        if (throwable == null) break block23;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (itr == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    itr.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            itr.close();
                            throw throwable3;
                        }
                    }
                    try {
                        itr.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                itr.close();
            }
            return;
        }
    }

    private void validateInstantsLoaded(HoodieArchivedTimeline hoodieArchivedTimeline, List<String> instantTsList, boolean isInstantLoaded) {
        HashSet<String> instantTsSet = new HashSet<String>(instantTsList);
        this.timeline.getInstants().stream().filter(instant -> instantTsSet.contains(instant.requestedTime())).forEach(instant -> {
            if (isInstantLoaded) {
                Assertions.assertTrue((boolean)hoodieArchivedTimeline.getInstantDetails(instant).isPresent());
            } else {
                Assertions.assertFalse((boolean)hoodieArchivedTimeline.getInstantDetails(instant).isPresent());
            }
        });
    }

    private void validateInstantsLoaded(HoodieArchivedTimeline hoodieArchivedTimeline, List<String> instantTsList, boolean isInstantLoaded, List<HoodieInstant.State> acceptableStates) {
        if (acceptableStates.isEmpty()) {
            this.validateInstantsLoaded(hoodieArchivedTimeline, instantTsList, isInstantLoaded);
            return;
        }
        Map<String, String> instantTsToStateMap = this.getInstantTsToActionMap();
        ArrayList<HoodieInstant> instantsToTest = new ArrayList<HoodieInstant>();
        for (String ts : instantTsList) {
            for (HoodieInstant.State state : acceptableStates) {
                instantsToTest.add(new HoodieInstant(state, instantTsToStateMap.get(ts), ts, InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR));
            }
        }
        for (HoodieInstant instant : instantsToTest) {
            if (isInstantLoaded) {
                Assertions.assertTrue((boolean)hoodieArchivedTimeline.getInstantDetails(instant).isPresent());
                continue;
            }
            Assertions.assertFalse((boolean)hoodieArchivedTimeline.getInstantDetails(instant).isPresent());
        }
    }

    private List<HoodieInstant> getCompletedInstantForTs(List<HoodieInstant> instants, List<String> instantTsList) {
        return instants.stream().filter(HoodieInstant::isCompleted).filter(instant -> new HashSet(instantTsList).contains(instant.requestedTime())).collect(Collectors.toList());
    }

    private Map<String, String> getInstantTsToActionMap() {
        return new HashMap<String, String>(){
            {
                this.put("01", "commit");
                this.put("03", "replacecommit");
                this.put("05", "commit");
                this.put("08", "compaction");
                this.put("09", "commit");
                this.put("11", "commit");
                this.put("15", "clean");
                this.put("17", "deltacommit");
                this.put("19", "rollback");
                this.put("21", "compaction");
            }
        };
    }

    private List<HoodieInstant> createInstants() throws Exception {
        HoodieInstant instant1Requested = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.REQUESTED, "commit", "01");
        HoodieInstant instant1Inflight = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.INFLIGHT, "commit", "01");
        HoodieInstant instant2Requested = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.REQUESTED, "replacecommit", "03");
        HoodieInstant instant2Inflight = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.INFLIGHT, "replacecommit", "03");
        HoodieInstant instant2Complete = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.COMPLETED, "replacecommit", "03");
        HoodieInstant instant3Requested = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.REQUESTED, "commit", "05");
        HoodieInstant instant3Inflight = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.INFLIGHT, "commit", "05");
        HoodieInstant instant3Complete = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.COMPLETED, "commit", "05");
        HoodieInstant instant4Requested = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.REQUESTED, "compaction", "08");
        HoodieInstant instant4Inflight = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.INFLIGHT, "compaction", "08");
        HoodieInstant instant4Complete = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.COMPLETED, "compaction", "08");
        HoodieInstant instant5Requested = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.REQUESTED, "commit", "09");
        HoodieInstant instant5Inflight = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.INFLIGHT, "commit", "09");
        HoodieInstant instant5Complete = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.COMPLETED, "commit", "09");
        HoodieInstant instant6Requested = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.REQUESTED, "commit", "11");
        HoodieInstant instant6Inflight = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.INFLIGHT, "commit", "11");
        List<HoodieInstant> instants = Arrays.asList(instant1Requested, instant1Inflight, instant2Requested, instant2Inflight, instant2Complete, instant3Requested, instant3Inflight, instant3Complete, instant4Requested, instant4Inflight, instant4Complete, instant5Requested, instant5Inflight, instant5Complete, instant6Requested, instant6Inflight);
        ArrayList<IndexedRecord> records = new ArrayList<IndexedRecord>();
        StoragePath archiveFilePath = ArchivedTimelineV1.getArchiveLogPath((StoragePath)this.metaClient.getArchivePath());
        HoodieLogFormat.Writer writer = this.buildWriter(archiveFilePath);
        records.add((IndexedRecord)this.createArchivedMetaWrapper(instant1Requested));
        records.add((IndexedRecord)this.createArchivedMetaWrapper(instant1Inflight));
        records.add((IndexedRecord)this.createArchivedMetaWrapper(instant2Requested));
        this.writeArchiveLog(writer, records);
        records.add((IndexedRecord)this.createArchivedMetaWrapper(instant2Inflight));
        records.add((IndexedRecord)this.createArchivedMetaWrapper(instant2Complete));
        records.add((IndexedRecord)this.createArchivedMetaWrapper(instant3Requested));
        this.writeArchiveLog(writer, records);
        writer.close();
        writer = this.buildWriter(archiveFilePath);
        records.add((IndexedRecord)this.createArchivedMetaWrapper(instant3Inflight));
        this.writeArchiveLog(writer, records);
        records.add((IndexedRecord)this.createArchivedMetaWrapper(instant3Complete));
        records.add((IndexedRecord)this.createArchivedMetaWrapper(instant4Requested));
        records.add((IndexedRecord)this.createArchivedMetaWrapper(instant4Inflight));
        records.add((IndexedRecord)this.createArchivedMetaWrapper(instant4Complete));
        records.add((IndexedRecord)this.createArchivedMetaWrapper(instant5Requested));
        records.add((IndexedRecord)this.createArchivedMetaWrapper(instant5Inflight));
        records.add((IndexedRecord)this.createArchivedMetaWrapper(instant5Complete));
        this.writeArchiveLog(writer, records);
        writer.close();
        writer = this.buildWriter(archiveFilePath);
        records.add((IndexedRecord)this.createArchivedMetaWrapper(instant6Requested));
        records.add((IndexedRecord)this.createArchivedMetaWrapper(instant6Inflight));
        this.writeArchiveLog(writer, records);
        writer.close();
        return instants;
    }

    private List<HoodieInstant> createAdditionalInstants() throws Exception {
        HoodieInstant instant7Requested = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.REQUESTED, "clean", "15");
        HoodieInstant instant7Inflight = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.INFLIGHT, "clean", "15");
        HoodieInstant instant7Complete = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.COMPLETED, "clean", "15");
        HoodieInstant instant8Requested = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.REQUESTED, "deltacommit", "17");
        HoodieInstant instant8Inflight = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.INFLIGHT, "deltacommit", "17");
        HoodieInstant instant8Complete = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.COMPLETED, "deltacommit", "17");
        HoodieInstant instant9Requested = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.REQUESTED, "rollback", "19");
        HoodieInstant instant9Inflight = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.INFLIGHT, "rollback", "19");
        HoodieInstant instant9Complete = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.COMPLETED, "rollback", "19");
        HoodieInstant instant10Requested = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.REQUESTED, "compaction", "21");
        HoodieInstant instant10Inflight = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.INFLIGHT, "compaction", "21");
        HoodieInstant instant10Complete = TestArchivedTimelineV1.createInstantV1(HoodieInstant.State.COMPLETED, "compaction", "21");
        List<HoodieInstant> instantsInCommit1 = Arrays.asList(instant7Requested, instant7Inflight, instant7Complete, instant8Requested, instant8Inflight, instant8Complete);
        List<HoodieInstant> instantsInCommit2 = Arrays.asList(instant9Requested, instant9Inflight, instant9Complete, instant10Requested, instant10Inflight, instant10Complete);
        ArrayList<IndexedRecord> records = new ArrayList<IndexedRecord>();
        StoragePath archiveFilePath = ArchivedTimelineV1.getArchiveLogPath((StoragePath)this.metaClient.getArchivePath());
        HoodieLogFormat.Writer writer = this.buildWriter(archiveFilePath);
        for (HoodieInstant instant : instantsInCommit1) {
            records.add((IndexedRecord)this.createArchivedMetaWrapper(instant));
        }
        this.writeArchiveLog(writer, records);
        writer.close();
        writer = this.buildWriter(archiveFilePath);
        for (HoodieInstant instant : instantsInCommit2) {
            records.add((IndexedRecord)this.createArchivedMetaWrapper(instant));
        }
        this.writeArchiveLog(writer, records);
        writer.close();
        return Stream.concat(instantsInCommit1.stream(), instantsInCommit2.stream()).collect(Collectors.toList());
    }

    private List<String> getArchiveLogFilePaths() throws IOException {
        return this.metaClient.getStorage().listDirectEntries(new StoragePath(this.metaClient.getArchivePath() + "/"), new StoragePathFilter(){

            public boolean accept(StoragePath path) {
                return path.getName().contains("commits_.archive");
            }
        }).stream().map(storagePathInfo -> storagePathInfo.getPath().toString()).sorted().collect(Collectors.toList());
    }

    private HoodieArchivedMetaEntry createArchivedMetaWrapper(HoodieInstant hoodieInstant) throws IOException {
        HoodieArchivedMetaEntry archivedMetaWrapper = new HoodieArchivedMetaEntry();
        archivedMetaWrapper.setCommitTime(hoodieInstant.requestedTime());
        archivedMetaWrapper.setActionState(hoodieInstant.getState().name());
        switch (hoodieInstant.getAction()) {
            case "commit": {
                archivedMetaWrapper.setActionType(ActionType.commit.name());
                archivedMetaWrapper.setHoodieCommitMetadata(HoodieCommitMetadata.newBuilder().build());
                break;
            }
            case "compaction": {
                archivedMetaWrapper.setActionType(ActionType.compaction.name());
                archivedMetaWrapper.setHoodieCompactionPlan(HoodieCompactionPlan.newBuilder().build());
                break;
            }
            case "replacecommit": {
                archivedMetaWrapper.setActionType(ActionType.replacecommit.name());
                if (hoodieInstant.isCompleted()) {
                    archivedMetaWrapper.setHoodieReplaceCommitMetadata(HoodieReplaceCommitMetadata.newBuilder().build());
                    break;
                }
                if (hoodieInstant.isInflight()) {
                    archivedMetaWrapper.setHoodieInflightReplaceMetadata(TestArchivedTimelineV1.convertCommitMetadata(new org.apache.hudi.common.model.HoodieCommitMetadata(false)));
                    break;
                }
                archivedMetaWrapper.setHoodieRequestedReplaceMetadata(new HoodieRequestedReplaceMetadata());
                break;
            }
            case "deltacommit": {
                archivedMetaWrapper.setActionType(ActionType.deltacommit.name());
                archivedMetaWrapper.setHoodieCommitMetadata(HoodieCommitMetadata.newBuilder().build());
                break;
            }
            case "clean": {
                archivedMetaWrapper.setActionType(ActionType.clean.name());
                if (hoodieInstant.isCompleted()) {
                    archivedMetaWrapper.setHoodieCleanMetadata(HoodieCleanMetadata.newBuilder().setVersion(Integer.valueOf(1)).setTimeTakenInMillis(100L).setTotalFilesDeleted(1).setStartCleanTime("01").setEarliestCommitToRetain("01").setLastCompletedCommitTimestamp("").setPartitionMetadata(new HashMap()).build());
                } else {
                    archivedMetaWrapper.setHoodieCleanerPlan(HoodieCleanerPlan.newBuilder().setEarliestInstantToRetainBuilder(HoodieActionInstant.newBuilder().setAction("commit").setTimestamp("01").setState("COMPLETED")).setPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS.name()).setFilesToBeDeletedPerPartition(new HashMap()).setVersion(CleanPlanV2MigrationHandler.VERSION).build());
                }
                archivedMetaWrapper.setActionType(ActionType.clean.name());
                break;
            }
            case "rollback": {
                if (hoodieInstant.isCompleted()) {
                    archivedMetaWrapper.setHoodieRollbackMetadata(HoodieRollbackMetadata.newBuilder().setVersion(Integer.valueOf(1)).setStartRollbackTime("16").setTotalFilesDeleted(1).setTimeTakenInMillis(1000L).setCommitsRollback(Collections.singletonList("15")).setPartitionMetadata(Collections.emptyMap()).setInstantsRollback(Collections.emptyList()).build());
                }
                archivedMetaWrapper.setActionType(ActionType.rollback.name());
                break;
            }
            case "logcompaction": {
                archivedMetaWrapper.setActionType(ActionType.logcompaction.name());
                HoodieCompactionPlan plan = CompactionUtils.getLogCompactionPlan((HoodieTableMetaClient)this.metaClient, (String)hoodieInstant.requestedTime());
                archivedMetaWrapper.setHoodieCompactionPlan(plan);
                break;
            }
        }
        return archivedMetaWrapper;
    }

    private HoodieLogFormat.Writer buildWriter(StoragePath archiveFilePath) throws IOException {
        return HoodieLogFormat.newWriterBuilder().onParentPath(archiveFilePath.getParent()).withFileId(archiveFilePath.getName()).withFileExtension(".archive").withStorage(this.metaClient.getStorage()).withInstantTime("").build();
    }

    private void writeArchiveLog(HoodieLogFormat.Writer writer, List<IndexedRecord> records) throws Exception {
        HashMap<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>();
        header.put(HoodieLogBlock.HeaderMetadataType.SCHEMA, HoodieArchivedMetaEntry.getClassSchema().toString());
        String keyField = this.metaClient.getTableConfig().getRecordKeyFieldProp();
        List indexRecords = records.stream().map(HoodieAvroIndexedRecord::new).collect(Collectors.toList());
        HoodieAvroDataBlock block = new HoodieAvroDataBlock(indexRecords, header, keyField);
        writer.appendBlock((HoodieLogBlock)block);
        records.clear();
    }

    private static HoodieInstant createInstantV1(HoodieInstant.State state, String action, String requestedTime) {
        return INSTANT_GENERATOR_V1.createNewInstant(state, action, requestedTime);
    }

    private static HoodieCommitMetadata convertCommitMetadata(org.apache.hudi.common.model.HoodieCommitMetadata hoodieCommitMetadata) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        HoodieCommitMetadata avroMetaData = (HoodieCommitMetadata)mapper.convertValue((Object)hoodieCommitMetadata, HoodieCommitMetadata.class);
        if (hoodieCommitMetadata.getCompacted().booleanValue()) {
            avroMetaData.setOperationType(WriteOperationType.COMPACT.name());
        }
        avroMetaData.getExtraMetadata().put("ROLLING_STAT", "");
        return avroMetaData;
    }
}

