/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.timeline.versioning.v1.TimelinePathProviderV1;
import org.apache.hudi.common.table.timeline.versioning.v2.TimelinePathProviderV2;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestTimelinePathProvider
extends HoodieCommonTestHarness {
    @BeforeEach
    public void setUp() throws Exception {
        this.initMetaClient();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanMetaClient();
    }

    @Test
    public void testTimelinePathProviderV1() {
        HoodieTableConfig tableConfig = this.metaClient.getTableConfig();
        StoragePath basePath = new StoragePath("file:/tmp");
        TimelinePathProviderV1 timelinePathProviderV1 = new TimelinePathProviderV1();
        StoragePath timelinePath = timelinePathProviderV1.getTimelinePath(tableConfig, basePath);
        Assertions.assertEquals((Object)"file:/tmp/.hoodie", (Object)timelinePath.toString());
        StoragePath timelineHistoryPath = timelinePathProviderV1.getTimelineHistoryPath(tableConfig, basePath);
        Assertions.assertEquals((Object)"file:/tmp/.hoodie/archived", (Object)timelineHistoryPath.toString());
    }

    @Test
    public void testTimelinePathProviderV2() {
        HoodieTableConfig tableConfig = this.metaClient.getTableConfig();
        StoragePath basePath = new StoragePath("file:/tmp");
        TimelinePathProviderV2 timelinePathProviderV2 = new TimelinePathProviderV2();
        StoragePath timelinePath = timelinePathProviderV2.getTimelinePath(tableConfig, basePath);
        Assertions.assertEquals((Object)"file:/tmp/.hoodie/timeline", (Object)timelinePath.toString());
        StoragePath timelineHistoryPath = timelinePathProviderV2.getTimelineHistoryPath(tableConfig, basePath);
        Assertions.assertEquals((Object)"file:/tmp/.hoodie/timeline/history", (Object)timelineHistoryPath.toString());
    }
}

