/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieClusteringStrategy;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieFSPermission;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.avro.model.HoodiePath;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.common.bootstrap.index.BootstrapIndex;
import org.apache.hudi.common.bootstrap.index.hfile.HFileBootstrapIndex;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.BootstrapFileMapping;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.AbstractTableFileSystemView;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.table.view.TableFileSystemView;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHoodieTableFileSystemView
extends HoodieCommonTestHarness {
    private static final Logger LOG = LoggerFactory.getLogger(TestHoodieTableFileSystemView.class);
    private static final String TEST_NAME_WITH_PARAMS = "[{index}] Test with bootstrap enable={0}";
    private static final String TEST_NAME_WITH_PARAMS_2 = "[{index}] Test with bootstrap enable={0}, preTableVersion8={1}";
    private static final String TEST_WRITE_TOKEN = "1-0-1";
    private static final String BOOTSTRAP_SOURCE_PATH = "/usr/warehouse/hive/data/tables/src1/";
    protected SyncableFileSystemView fsView;
    protected TableFileSystemView.BaseFileOnlyView roView;
    protected TableFileSystemView.SliceView rtView;

    public static Stream<Arguments> configParams() {
        return Arrays.stream(new Boolean[][]{{true}, {false}}).map(Arguments::of);
    }

    public static Stream<Arguments> configParams2x2() {
        return Arrays.stream(new Boolean[][]{{true, false}, {false, false}, {true, true}, {false, true}}).map(Arguments::of);
    }

    @BeforeEach
    public void setup() throws IOException {
        this.metaClient = HoodieTestUtils.init((String)this.tempDir.toAbsolutePath().toString(), (HoodieTableType)this.getTableType(), (String)BOOTSTRAP_SOURCE_PATH, (boolean)false);
        this.basePath = this.metaClient.getBasePath().toString();
        this.refreshFsView();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.closeFsView();
        this.cleanMetaClient();
    }

    @Override
    protected void refreshFsView() throws IOException {
        this.refreshFsView(false);
    }

    protected void refreshFsView(boolean preTableVersion8) throws IOException {
        super.refreshFsView();
        this.closeFsView();
        if (preTableVersion8) {
            this.metaClient.getTableConfig().setTableVersion(HoodieTableVersion.SIX);
            HoodieTableConfig.update((HoodieStorage)this.metaClient.getStorage(), (StoragePath)this.metaClient.getMetaPath(), (Properties)this.metaClient.getTableConfig().getProps());
            this.metaClient.reloadTableConfig();
        }
        this.fsView = this.getFileSystemView(this.metaClient.getActiveTimeline().filterCompletedAndCompactionInstants());
        this.roView = this.fsView;
        this.rtView = this.fsView;
    }

    private void closeFsView() {
        if (null != this.fsView) {
            this.fsView.close();
            this.fsView = null;
        }
    }

    @ParameterizedTest
    @MethodSource(value={"configParams"})
    public void testViewForFileSlicesWithNoBaseFile(boolean preTableVersion8) throws Exception {
        this.testViewForFileSlicesWithNoBaseFile(1, 0, "2016/05/01", preTableVersion8);
    }

    @ParameterizedTest
    @MethodSource(value={"configParams"})
    public void testViewForFileSlicesWithNoBaseFileNonPartitioned(boolean preTableVersion8) throws Exception {
        this.testViewForFileSlicesWithNoBaseFile(1, 0, "", preTableVersion8);
    }

    @Test
    public void testCloseHoodieTableFileSystemView() throws Exception {
        String instantTime1 = "1";
        String instantTime2 = "2";
        String clusteringInstantTime3 = "3";
        String clusteringInstantTime4 = "4";
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HashMap partitionToReplaceFileIds = new HashMap();
        ArrayList<String> replacedFileIds = new ArrayList<String>();
        replacedFileIds.add("fake_file_id");
        partitionToReplaceFileIds.put("fake_partition_path", replacedFileIds);
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", instantTime1);
        HoodieInstant instant2 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", instantTime2);
        HoodieInstant clusteringInstant3 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "clustering", clusteringInstantTime3);
        HoodieInstant clusteringInstant4 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "clustering", clusteringInstantTime4);
        HoodieCommitMetadata commitMetadata = CommitUtils.buildMetadata(Collections.emptyList(), partitionToReplaceFileIds, (Option)Option.empty(), (WriteOperationType)WriteOperationType.CLUSTER, (String)"", (String)"replacecommit");
        this.saveAsComplete(commitTimeline, instant1, new HoodieCommitMetadata());
        this.saveAsComplete(commitTimeline, instant2, new HoodieCommitMetadata());
        this.saveAsCompleteCluster(commitTimeline, clusteringInstant3, (HoodieCommitMetadata)((HoodieReplaceCommitMetadata)commitMetadata));
        this.saveAsCompleteCluster(commitTimeline, clusteringInstant4, (HoodieCommitMetadata)((HoodieReplaceCommitMetadata)commitMetadata));
        this.refreshFsView();
        StoragePath completeInstantPath = HoodieTestUtils.getCompleteInstantPath((HoodieStorage)this.metaClient.getStorage(), (StoragePath)this.metaClient.getTimelinePath(), (String)clusteringInstantTime3, (String)"replacecommit");
        boolean deleteReplaceCommit = this.metaClient.getStorage().deleteDirectory(completeInstantPath);
        boolean deleteClusterCommitRequested = new File(this.basePath + "/.hoodie/timeline/" + clusteringInstantTime3 + ".clustering.requested").delete();
        boolean deleteClusterCommitInflight = new File(this.basePath + "/.hoodie/timeline/" + clusteringInstantTime3 + ".clustering.inflight").delete();
        Assertions.assertTrue((deleteReplaceCommit && deleteClusterCommitInflight && deleteClusterCommitRequested ? 1 : 0) != 0);
        Assertions.assertDoesNotThrow(() -> this.fsView.close());
        if (this.fsView.getClass().isAssignableFrom(AbstractTableFileSystemView.class)) {
            Assertions.assertThrows(NullPointerException.class, () -> ((AbstractTableFileSystemView)this.fsView).getCompletionTime(""));
        }
    }

    protected void testViewForFileSlicesWithNoBaseFile(int expNumTotalFileSlices, int expNumTotalDataFiles, String partitionPath, boolean preTableVersion8) throws Exception {
        Paths.get(this.basePath, partitionPath).toFile().mkdirs();
        String fileId = UUID.randomUUID().toString();
        String instantTime1 = "1";
        String deltaInstantTime2 = "2";
        String deltaInstantTime3 = "3";
        String fileName1 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)deltaInstantTime2, (int)0, (String)TEST_WRITE_TOKEN);
        String fileName2 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)(preTableVersion8 ? deltaInstantTime2 : deltaInstantTime3), (int)1, (String)TEST_WRITE_TOKEN);
        Paths.get(this.basePath, partitionPath, fileName1).toFile().createNewFile();
        Paths.get(this.basePath, partitionPath, fileName2).toFile().createNewFile();
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", instantTime1);
        HoodieInstant deltaInstant2 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", deltaInstantTime2);
        HoodieInstant deltaInstant3 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", deltaInstantTime3);
        this.saveAsComplete(commitTimeline, instant1, new HoodieCommitMetadata());
        this.saveAsComplete(commitTimeline, deltaInstant2, new HoodieCommitMetadata());
        this.saveAsComplete(commitTimeline, deltaInstant3, new HoodieCommitMetadata());
        this.refreshFsView();
        List dataFiles = this.roView.getLatestBaseFiles().collect(Collectors.toList());
        Assertions.assertTrue((boolean)dataFiles.isEmpty(), (String)"No data file expected");
        List fileSliceList = this.rtView.getLatestFileSlices(partitionPath).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)fileSliceList.size());
        FileSlice fileSlice = (FileSlice)fileSliceList.get(0);
        Assertions.assertEquals((Object)fileId, (Object)fileSlice.getFileId(), (String)"File-Id must be set correctly");
        Assertions.assertFalse((boolean)fileSlice.getBaseFile().isPresent(), (String)"Data file for base instant must be present");
        Assertions.assertEquals((Object)deltaInstantTime2, (Object)fileSlice.getBaseInstantTime(), (String)"Base Instant for file-group set correctly");
        List logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)logFiles.size(), (String)"Correct number of log-files shows up in file-slice");
        Assertions.assertEquals((Object)fileName2, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((Object)fileName1, (Object)((HoodieLogFile)logFiles.get(1)).getFileName(), (String)"Log File Order check");
        fileSliceList = this.rtView.getLatestMergedFileSlicesBeforeOrOn(partitionPath, deltaInstantTime3).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)fileSliceList.size());
        fileSlice = (FileSlice)fileSliceList.get(0);
        Assertions.assertEquals((Object)fileId, (Object)fileSlice.getFileId(), (String)"File-Id must be set correctly");
        Assertions.assertFalse((boolean)fileSlice.getBaseFile().isPresent(), (String)"Data file for base instant must be present");
        Assertions.assertEquals((Object)deltaInstantTime2, (Object)fileSlice.getBaseInstantTime(), (String)"Base Instant for file-group set correctly");
        logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)logFiles.size(), (String)"Correct number of log-files shows up in file-slice");
        Assertions.assertEquals((Object)fileName2, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((Object)fileName1, (Object)((HoodieLogFile)logFiles.get(1)).getFileName(), (String)"Log File Order check");
        Option fileSliceOpt = this.rtView.getLatestMergedFileSliceBeforeOrOn(partitionPath, deltaInstantTime3, fileId);
        Assertions.assertTrue((boolean)fileSliceOpt.isPresent());
        fileSlice = (FileSlice)fileSliceOpt.get();
        Assertions.assertEquals((Object)fileId, (Object)fileSlice.getFileId(), (String)"File-Id must be set correctly");
        Assertions.assertFalse((boolean)fileSlice.getBaseFile().isPresent(), (String)"Data file for base instant must be present");
        Assertions.assertEquals((Object)deltaInstantTime2, (Object)fileSlice.getBaseInstantTime(), (String)"Base Instant for file-group set correctly");
        logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)logFiles.size(), (String)"Correct number of log-files shows up in file-slice");
        Assertions.assertEquals((Object)fileName2, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((Object)fileName1, (Object)((HoodieLogFile)logFiles.get(1)).getFileName(), (String)"Log File Order check");
        fileSliceList = this.rtView.getLatestUnCompactedFileSlices(partitionPath).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)fileSliceList.size());
        fileSlice = (FileSlice)fileSliceList.get(0);
        Assertions.assertEquals((Object)fileId, (Object)fileSlice.getFileId(), (String)"File-Id must be set correctly");
        Assertions.assertFalse((boolean)fileSlice.getBaseFile().isPresent(), (String)"Data file for base instant must be present");
        Assertions.assertEquals((Object)deltaInstantTime2, (Object)fileSlice.getBaseInstantTime(), (String)"Base Instant for file-group set correctly");
        logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)logFiles.size(), (String)"Correct number of log-files shows up in file-slice");
        Assertions.assertEquals((Object)fileName2, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((Object)fileName1, (Object)((HoodieLogFile)logFiles.get(1)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((long)expNumTotalFileSlices, (long)this.rtView.getAllFileSlices(partitionPath).count(), (String)"Total number of file-slices in view matches expected");
        Assertions.assertEquals((long)expNumTotalDataFiles, (long)this.roView.getAllBaseFiles(partitionPath).count(), (String)"Total number of data-files in view matches expected");
        Assertions.assertEquals((long)1L, (long)this.fsView.getAllFileGroups(partitionPath).count(), (String)"Total number of file-groups in view matches expected");
    }

    @ParameterizedTest(name="[{index}] Test with bootstrap enable={0}, preTableVersion8={1}")
    @MethodSource(value={"configParams2x2"})
    public void testViewForFileSlicesWithNoBaseFileAndRequestedCompaction(boolean testBootstrap, boolean preTableVersion8) throws Exception {
        this.testViewForFileSlicesWithAsyncCompaction(true, false, 2, 1, true, testBootstrap, preTableVersion8);
    }

    @ParameterizedTest(name="[{index}] Test with bootstrap enable={0}, preTableVersion8={1}")
    @MethodSource(value={"configParams2x2"})
    public void testViewForFileSlicesWithBaseFileAndRequestedCompaction(boolean testBootstrap, boolean preTableVersion8) throws Exception {
        this.testViewForFileSlicesWithAsyncCompaction(false, false, 2, 2, true, testBootstrap, true);
    }

    @ParameterizedTest(name="[{index}] Test with bootstrap enable={0}, preTableVersion8={1}")
    @MethodSource(value={"configParams2x2"})
    public void testViewForFileSlicesWithNoBaseFileAndInflightCompaction(boolean testBootstrap, boolean preTableVersion8) throws Exception {
        this.testViewForFileSlicesWithAsyncCompaction(true, true, 2, 1, true, testBootstrap, preTableVersion8);
    }

    @ParameterizedTest(name="[{index}] Test with bootstrap enable={0}, preTableVersion8={1}")
    @MethodSource(value={"configParams2x2"})
    public void testViewForFileSlicesWithBaseFileAndInflightCompaction(boolean testBootstrap, boolean preTableVersion8) throws Exception {
        this.testViewForFileSlicesWithAsyncCompaction(false, true, 2, 2, true, testBootstrap, preTableVersion8);
    }

    @Test
    public void testViewForFileSlicesWithPartitionMetadataFile() throws Exception {
        String partitionPath = "2023/09/13";
        new File(this.basePath + "/" + partitionPath).mkdirs();
        new File(this.basePath + "/" + partitionPath + "/" + ".hoodie_partition_metadata" + ".parquet").mkdirs();
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        String commitTime1 = "1";
        String fileName1 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId1, (String)BASE_FILE_EXTENSION);
        String fileName2 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId2, (String)BASE_FILE_EXTENSION);
        new File(this.basePath + "/" + partitionPath + "/" + fileName1).createNewFile();
        new File(this.basePath + "/" + partitionPath + "/" + fileName2).createNewFile();
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", commitTime1);
        this.saveAsComplete(commitTimeline, instant1, new HoodieCommitMetadata());
        this.refreshFsView();
        List fileSlices = this.fsView.getLatestFileSlices(partitionPath).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)fileSlices.size());
        FileSlice fileSlice = (FileSlice)fileSlices.get(0);
        Assertions.assertEquals((Object)commitTime1, (Object)fileSlice.getBaseInstantTime());
        Assertions.assertEquals((long)2L, (long)this.fsView.getAllFileGroups(partitionPath).count());
    }

    @Test
    public void testViewForGetAllFileGroupsStateless() throws Exception {
        String partitionPath1 = "2023/11/22";
        new File(this.basePath + "/" + partitionPath1).mkdirs();
        new File(this.basePath + "/" + partitionPath1 + "/" + ".hoodie_partition_metadata" + ".parquet").mkdirs();
        String partitionPath2 = "2023/11/23";
        new File(this.basePath + "/" + partitionPath2).mkdirs();
        new File(this.basePath + "/" + partitionPath2 + "/" + ".hoodie_partition_metadata" + ".parquet").mkdirs();
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        String commitTime1 = "1";
        String fileName1 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId1, (String)BASE_FILE_EXTENSION);
        String fileName2 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId2, (String)BASE_FILE_EXTENSION);
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName1).createNewFile();
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName2).createNewFile();
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", commitTime1);
        this.saveAsComplete(commitTimeline, instant1, new HoodieCommitMetadata());
        String fileId3 = UUID.randomUUID().toString();
        String fileId4 = UUID.randomUUID().toString();
        String commitTime2 = "2";
        String fileName3 = FSUtils.makeBaseFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileId3, (String)BASE_FILE_EXTENSION);
        String fileName4 = FSUtils.makeBaseFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileId4, (String)BASE_FILE_EXTENSION);
        new File(this.basePath + "/" + partitionPath2 + "/" + fileName3).createNewFile();
        new File(this.basePath + "/" + partitionPath2 + "/" + fileName4).createNewFile();
        HoodieInstant instant2 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", commitTime2);
        this.saveAsComplete(commitTimeline, instant2, new HoodieCommitMetadata());
        this.fsView.sync();
        List actual1 = this.fsView.getAllFileGroupsStateless(partitionPath1).sorted(Comparator.comparing(HoodieFileGroup::getFileGroupId)).collect(Collectors.toList());
        List expected1 = this.fsView.getAllFileGroups(partitionPath1).sorted(Comparator.comparing(HoodieFileGroup::getFileGroupId)).collect(Collectors.toList());
        for (int i = 0; i < expected1.size(); ++i) {
            MatcherAssert.assertThat((String)"The stateless API should return the same result", (Object)((HoodieFileGroup)actual1.get(i)).toString(), (Matcher)CoreMatchers.is((Object)((HoodieFileGroup)expected1.get(i)).toString()));
            Assertions.assertNotSame(actual1.get(i), expected1.get(i), (String)"The stateless API does not cache");
        }
        List expected2 = this.fsView.getAllFileGroupsStateless(partitionPath2).sorted(Comparator.comparing(HoodieFileGroup::getFileGroupId)).collect(Collectors.toList());
        List actual2 = this.fsView.getAllFileGroups(partitionPath2).sorted(Comparator.comparing(HoodieFileGroup::getFileGroupId)).collect(Collectors.toList());
        for (int i = 0; i < expected2.size(); ++i) {
            MatcherAssert.assertThat((String)"The stateless API should return the same result", (Object)((HoodieFileGroup)actual2.get(i)).toString(), (Matcher)CoreMatchers.is((Object)((HoodieFileGroup)expected2.get(i)).toString()));
            Assertions.assertNotSame(actual2.get(i), expected2.get(i), (String)"The stateless API does not cache");
        }
    }

    @Test
    public void testViewForGetLatestFileSlicesStateless() throws Exception {
        String partitionPath1 = "2023/11/22";
        new File(this.basePath + "/" + partitionPath1).mkdirs();
        new File(this.basePath + "/" + partitionPath1 + "/" + ".hoodie_partition_metadata" + ".parquet").mkdirs();
        String partitionPath2 = "2023/11/23";
        new File(this.basePath + "/" + partitionPath2).mkdirs();
        new File(this.basePath + "/" + partitionPath2 + "/" + ".hoodie_partition_metadata" + ".parquet").mkdirs();
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        String commitTime1 = "1";
        String fileName1 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId1, (String)BASE_FILE_EXTENSION);
        String fileName2 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId2, (String)BASE_FILE_EXTENSION);
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName1).createNewFile();
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName2).createNewFile();
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", commitTime1);
        this.saveAsComplete(commitTimeline, instant1, new HoodieCommitMetadata());
        String fileId3 = UUID.randomUUID().toString();
        String fileId4 = UUID.randomUUID().toString();
        String commitTime2 = "2";
        String fileName3 = FSUtils.makeBaseFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileId3, (String)BASE_FILE_EXTENSION);
        String fileName4 = FSUtils.makeBaseFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileId4, (String)BASE_FILE_EXTENSION);
        new File(this.basePath + "/" + partitionPath2 + "/" + fileName3).createNewFile();
        new File(this.basePath + "/" + partitionPath2 + "/" + fileName4).createNewFile();
        HoodieInstant instant2 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", commitTime2);
        this.saveAsComplete(commitTimeline, instant2, new HoodieCommitMetadata());
        this.fsView.sync();
        List actual1 = this.fsView.getLatestFileSlicesStateless(partitionPath1).sorted(Comparator.comparing(FileSlice::getFileId)).collect(Collectors.toList());
        List expected1 = this.fsView.getLatestFileSlices(partitionPath1).sorted(Comparator.comparing(FileSlice::getFileId)).collect(Collectors.toList());
        for (int i = 0; i < expected1.size(); ++i) {
            MatcherAssert.assertThat((String)"The stateless API should return the same result", actual1.get(i), (Matcher)CoreMatchers.is(expected1.get(i)));
            Assertions.assertNotSame(actual1.get(i), expected1.get(i), (String)"The stateless API does not cache");
        }
        List expected2 = this.fsView.getLatestFileSlicesStateless(partitionPath2).sorted(Comparator.comparing(FileSlice::getFileId)).collect(Collectors.toList());
        List actual2 = this.fsView.getLatestFileSlices(partitionPath2).sorted(Comparator.comparing(FileSlice::getFileId)).collect(Collectors.toList());
        for (int i = 0; i < expected2.size(); ++i) {
            MatcherAssert.assertThat((String)"The stateless API should return the same result", actual2.get(i), (Matcher)CoreMatchers.is(expected2.get(i)));
            Assertions.assertNotSame(actual2.get(i), expected2.get(i), (String)"The stateless API does not cache");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"configParams"})
    protected void testInvalidLogFiles(boolean preTableVersion8) throws Exception {
        String partitionPath = "2016/05/01";
        Paths.get(this.basePath, partitionPath).toFile().mkdirs();
        String fileId = UUID.randomUUID().toString();
        String instantTime1 = "1";
        String deltaInstantTime1 = "2";
        String deltaInstantTime2 = "3";
        String fileName1 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)deltaInstantTime1, (int)0, (String)TEST_WRITE_TOKEN);
        String fileName2 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)(preTableVersion8 ? deltaInstantTime1 : deltaInstantTime2), (int)1, (String)TEST_WRITE_TOKEN);
        String fileName3 = "_GCS_SYNCABLE_TEMPFILE_" + fileName1;
        String fileName4 = "_DUMMY_" + fileName1.substring(1);
        Paths.get(this.basePath, partitionPath, fileName1).toFile().createNewFile();
        Paths.get(this.basePath, partitionPath, fileName2).toFile().createNewFile();
        Paths.get(this.basePath, partitionPath, fileName3).toFile().createNewFile();
        Paths.get(this.basePath, partitionPath, fileName4).toFile().createNewFile();
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", instantTime1);
        HoodieInstant deltaInstant2 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", deltaInstantTime1);
        HoodieInstant deltaInstant3 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", deltaInstantTime2);
        this.saveAsComplete(commitTimeline, instant1, new HoodieCommitMetadata());
        this.saveAsComplete(commitTimeline, deltaInstant2, new HoodieCommitMetadata());
        this.saveAsComplete(commitTimeline, deltaInstant3, new HoodieCommitMetadata());
        this.refreshFsView();
        List dataFiles = this.roView.getLatestBaseFiles().collect(Collectors.toList());
        Assertions.assertTrue((boolean)dataFiles.isEmpty(), (String)"No data file expected");
        List fileSliceList = this.rtView.getLatestFileSlices(partitionPath).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)fileSliceList.size());
        FileSlice fileSlice = (FileSlice)fileSliceList.get(0);
        Assertions.assertEquals((Object)fileId, (Object)fileSlice.getFileId(), (String)"File-Id must be set correctly");
        Assertions.assertFalse((boolean)fileSlice.getBaseFile().isPresent(), (String)"Data file for base instant must be present");
        Assertions.assertEquals((Object)deltaInstantTime1, (Object)fileSlice.getBaseInstantTime(), (String)"Base Instant for file-group set correctly");
        List logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)logFiles.size(), (String)"Correct number of log-files shows up in file-slice");
        Assertions.assertEquals((Object)fileName2, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((Object)fileName1, (Object)((HoodieLogFile)logFiles.get(1)).getFileName(), (String)"Log File Order check");
    }

    @Test
    void testFileSlicingWithMultipleDeltaWriters() throws Exception {
        String partitionPath = "2016/05/01";
        Paths.get(this.basePath, partitionPath).toFile().mkdirs();
        String fileId = UUID.randomUUID().toString();
        String instantTime1 = "10";
        String deltaInstantTime1 = "21";
        String deltaInstantTime2 = "30";
        String deltaInstantTime3 = "35";
        String baseFile1 = FSUtils.makeBaseFileName((String)instantTime1, (String)TEST_WRITE_TOKEN, (String)fileId, (String)BASE_FILE_EXTENSION);
        String deltaFile1 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)deltaInstantTime1, (int)0, (String)TEST_WRITE_TOKEN);
        String deltaFile2 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)deltaInstantTime2, (int)0, (String)TEST_WRITE_TOKEN);
        String deltaFile3 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)deltaInstantTime3, (int)0, (String)TEST_WRITE_TOKEN);
        Paths.get(this.basePath, partitionPath, baseFile1).toFile().createNewFile();
        Paths.get(this.basePath, partitionPath, deltaFile1).toFile().createNewFile();
        Paths.get(this.basePath, partitionPath, deltaFile2).toFile().createNewFile();
        Paths.get(this.basePath, partitionPath, deltaFile3).toFile().createNewFile();
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", instantTime1);
        HoodieInstant deltaInstant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", deltaInstantTime1);
        HoodieInstant deltaInstant2 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", deltaInstantTime2);
        HoodieInstant deltaInstant3 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", deltaInstantTime3);
        this.metaClient.getActiveTimeline().createNewInstant(deltaInstant3);
        this.saveAsComplete(commitTimeline, instant1, new HoodieCommitMetadata());
        this.saveAsComplete(commitTimeline, deltaInstant1, new HoodieCommitMetadata());
        this.saveAsComplete(commitTimeline, deltaInstant2, new HoodieCommitMetadata());
        this.refreshFsView();
        List fileSlices = this.rtView.getLatestFileSlices(partitionPath).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Multiple file slices", (Object)fileSlices.size(), (Matcher)CoreMatchers.is((Object)1));
        FileSlice fileSlice = (FileSlice)fileSlices.get(0);
        MatcherAssert.assertThat((String)"Base file is missing", (boolean)fileSlice.getBaseFile().isPresent());
        MatcherAssert.assertThat((String)"Base Instant for file-group set correctly", (Object)fileSlice.getBaseInstantTime(), (Matcher)CoreMatchers.is((Object)instantTime1));
        MatcherAssert.assertThat((String)"File-Id must be set correctly", (Object)fileSlice.getFileId(), (Matcher)CoreMatchers.is((Object)fileId));
        List logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)logFiles.size(), (String)"Correct number of log-files shows up in file-slice");
        Assertions.assertEquals((Object)deltaFile2, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((Object)deltaFile1, (Object)((HoodieLogFile)logFiles.get(1)).getFileName(), (String)"Log File Order check");
        String compactionInstantTime1 = HoodieInstantTimeGenerator.getCurrentInstantTimeStr();
        String compactionFile1 = FSUtils.makeBaseFileName((String)compactionInstantTime1, (String)TEST_WRITE_TOKEN, (String)fileId, (String)BASE_FILE_EXTENSION);
        ArrayList<Pair> partitionFileSlicesPairs = new ArrayList<Pair>();
        partitionFileSlicesPairs.add(Pair.of((Object)partitionPath, fileSlices.get(0)));
        HoodieCompactionPlan compactionPlan = CompactionUtils.buildFromFileSlices(partitionFileSlicesPairs, (Option)Option.empty(), (Option)Option.empty());
        Paths.get(this.basePath, partitionPath, compactionFile1).toFile().createNewFile();
        HoodieInstant compactionInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "compaction", compactionInstantTime1);
        HoodieInstant requested = HoodieTestUtils.INSTANT_GENERATOR.getCompactionRequestedInstant(compactionInstant.requestedTime());
        commitTimeline.saveToCompactionRequested(requested, compactionPlan);
        commitTimeline.transitionCompactionRequestedToInflight(requested);
        this.refreshFsView();
        fileSlices = this.rtView.getLatestFileSlices(partitionPath).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Multiple file slices", (Object)fileSlices.size(), (Matcher)CoreMatchers.is((Object)1));
        fileSlice = (FileSlice)fileSlices.get(0);
        Assertions.assertFalse((boolean)fileSlice.getBaseFile().isPresent(), (String)"No base file for pending compaction");
        MatcherAssert.assertThat((String)"Base Instant for file-group set correctly", (Object)fileSlice.getBaseInstantTime(), (Matcher)CoreMatchers.is((Object)compactionInstantTime1));
        MatcherAssert.assertThat((String)"File-Id must be set correctly", (Object)fileSlice.getFileId(), (Matcher)CoreMatchers.is((Object)fileId));
        logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)0, (int)logFiles.size(), (String)"Correct number of log-files shows up in file-slice");
        this.saveAsComplete(commitTimeline, compactionInstant, new HoodieCommitMetadata());
        this.refreshFsView();
        fileSlices = this.rtView.getAllFileSlices(partitionPath).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Multiple file slices", (Object)fileSlices.size(), (Matcher)CoreMatchers.is((Object)2));
        fileSlice = (FileSlice)fileSlices.get(0);
        Assertions.assertTrue((boolean)fileSlice.getBaseFile().isPresent(), (String)"Base file missing");
        MatcherAssert.assertThat((String)"Base file set correctly", (Object)((HoodieBaseFile)fileSlice.getBaseFile().get()).getCommitTime(), (Matcher)CoreMatchers.is((Object)compactionInstantTime1));
        MatcherAssert.assertThat((String)"Base Instant for file-group set correctly", (Object)fileSlice.getBaseInstantTime(), (Matcher)CoreMatchers.is((Object)compactionInstantTime1));
        MatcherAssert.assertThat((String)"File-Id must be set correctly", (Object)fileSlice.getFileId(), (Matcher)CoreMatchers.is((Object)fileId));
        logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)logFiles.size(), (String)"Correct number of log-files shows up in file-slice");
        Assertions.assertEquals((Object)deltaFile3, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
        commitTimeline.saveAsComplete(deltaInstant3, Option.empty());
        this.refreshFsView();
        fileSlices = this.rtView.getLatestFileSlices(partitionPath).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Multiple file slices", (Object)fileSlices.size(), (Matcher)CoreMatchers.is((Object)1));
        fileSlice = (FileSlice)fileSlices.get(0);
        Assertions.assertTrue((boolean)fileSlice.getBaseFile().isPresent(), (String)"Base file missing");
        MatcherAssert.assertThat((String)"Base file set correctly", (Object)((HoodieBaseFile)fileSlice.getBaseFile().get()).getCommitTime(), (Matcher)CoreMatchers.is((Object)compactionInstantTime1));
        MatcherAssert.assertThat((String)"Base Instant for file-group set correctly", (Object)fileSlice.getBaseInstantTime(), (Matcher)CoreMatchers.is((Object)compactionInstantTime1));
        MatcherAssert.assertThat((String)"File-Id must be set correctly", (Object)fileSlice.getFileId(), (Matcher)CoreMatchers.is((Object)fileId));
        logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)logFiles.size(), (String)"Correct number of log-files shows up in file-slice");
        Assertions.assertEquals((Object)deltaFile3, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
        fileSlices = this.rtView.getLatestFileSlicesBeforeOrOn(partitionPath, "15", true).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Multiple file slices", (Object)fileSlices.size(), (Matcher)CoreMatchers.is((Object)1));
        fileSlice = (FileSlice)fileSlices.get(0);
        Assertions.assertTrue((boolean)fileSlice.getBaseFile().isPresent(), (String)"Base file missing");
        MatcherAssert.assertThat((String)"Base file set correctly", (Object)((HoodieBaseFile)fileSlice.getBaseFile().get()).getCommitTime(), (Matcher)CoreMatchers.is((Object)instantTime1));
        MatcherAssert.assertThat((String)"Base Instant for file-group set correctly", (Object)fileSlice.getBaseInstantTime(), (Matcher)CoreMatchers.is((Object)instantTime1));
        logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)logFiles.size(), (String)"Correct number of log-files shows up in file-slice");
        Assertions.assertEquals((Object)deltaFile2, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((Object)deltaFile1, (Object)((HoodieLogFile)logFiles.get(1)).getFileName(), (String)"Log File Order check");
        fileSlices = this.rtView.getLatestFileSliceInRange(Arrays.asList(instantTime1, compactionInstantTime1)).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Multiple file slices", (Object)fileSlices.size(), (Matcher)CoreMatchers.is((Object)1));
        fileSlice = (FileSlice)fileSlices.get(0);
        Assertions.assertTrue((boolean)fileSlice.getBaseFile().isPresent(), (String)"Base file missing");
        MatcherAssert.assertThat((String)"Base file set correctly", (Object)((HoodieBaseFile)fileSlice.getBaseFile().get()).getCommitTime(), (Matcher)CoreMatchers.is((Object)compactionInstantTime1));
        MatcherAssert.assertThat((String)"Base Instant for file-group set correctly", (Object)fileSlice.getBaseInstantTime(), (Matcher)CoreMatchers.is((Object)compactionInstantTime1));
        logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)logFiles.size(), (String)"Correct number of log-files shows up in file-slice");
        Assertions.assertEquals((Object)deltaFile3, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
    }

    @Test
    void testLoadPartitions_unPartitioned() throws Exception {
        String partitionPath = "";
        Paths.get(this.basePath, partitionPath).toFile().mkdirs();
        String fileId = UUID.randomUUID().toString();
        String instantTime1 = "1";
        String fileName1 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)instantTime1, (int)0, (String)TEST_WRITE_TOKEN);
        Paths.get(this.basePath, partitionPath, fileName1).toFile().createNewFile();
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", instantTime1);
        this.saveAsComplete(commitTimeline, instant1, new HoodieCommitMetadata());
        this.refreshFsView();
        Assertions.assertEquals((long)0L, (long)this.fsView.getLatestFileSliceInRange(Collections.singletonList("1")).count());
        this.fsView.loadPartitions(Collections.singletonList(partitionPath));
        Assertions.assertEquals((long)1L, (long)this.fsView.getLatestFileSliceInRange(Collections.singletonList("1")).count());
    }

    @Test
    void testLoadPartitions_partitioned() throws Exception {
        String partitionPath1 = "2016/05/01";
        String partitionPath2 = "2016/05/02";
        Paths.get(this.basePath, partitionPath1).toFile().mkdirs();
        Paths.get(this.basePath, partitionPath2).toFile().mkdirs();
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        String instantTime1 = "1";
        String fileName1 = FSUtils.makeLogFileName((String)fileId1, (String)".log", (String)instantTime1, (int)0, (String)TEST_WRITE_TOKEN);
        String fileName2 = FSUtils.makeLogFileName((String)fileId2, (String)".log", (String)instantTime1, (int)0, (String)TEST_WRITE_TOKEN);
        Paths.get(this.basePath, partitionPath1, fileName1).toFile().createNewFile();
        Paths.get(this.basePath, partitionPath2, fileName2).toFile().createNewFile();
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", instantTime1);
        this.saveAsComplete(commitTimeline, instant1, new HoodieCommitMetadata());
        this.refreshFsView();
        Assertions.assertEquals((long)0L, (long)this.fsView.getLatestFileSliceInRange(Collections.singletonList("1")).count());
        this.fsView.loadPartitions(Collections.singletonList(partitionPath1));
        Assertions.assertEquals((long)1L, (long)this.fsView.getLatestFileSliceInRange(Collections.singletonList("1")).count());
    }

    private Stream<FileSlice> getAllRawFileSlices(String partitionPath) {
        return this.fsView.getAllFileGroups(partitionPath).flatMap(HoodieFileGroup::getAllFileSlicesIncludingInflight);
    }

    public Stream<FileSlice> getLatestRawFileSlices(String partitionPath) {
        return this.fsView.getAllFileGroups(partitionPath).map(HoodieFileGroup::getLatestFileSlicesIncludingInflight).filter(Option::isPresent).map(Option::get);
    }

    private void checkExternalFile(HoodieFileStatus srcFileStatus, Option<BaseFile> bootstrapBaseFile, boolean testBootstrap) {
        if (testBootstrap) {
            Assertions.assertTrue((boolean)bootstrapBaseFile.isPresent());
            Assertions.assertEquals((Object)HadoopFSUtils.toPath((HoodiePath)srcFileStatus.getPath()), (Object)new Path(((BaseFile)bootstrapBaseFile.get()).getPath()));
            Assertions.assertEquals((Object)srcFileStatus.getPath(), (Object)HadoopFSUtils.fromPath((Path)new Path(((BaseFile)bootstrapBaseFile.get()).getPath())));
            Assertions.assertEquals((Long)srcFileStatus.getModificationTime(), (Long)new Long(((BaseFile)bootstrapBaseFile.get()).getPathInfo().getModificationTime()));
            Assertions.assertEquals((Long)srcFileStatus.getBlockSize(), (Long)new Long(((BaseFile)bootstrapBaseFile.get()).getPathInfo().getBlockSize()));
            Assertions.assertEquals((Long)srcFileStatus.getLength(), (Long)new Long(((BaseFile)bootstrapBaseFile.get()).getPathInfo().getLength()));
            Assertions.assertEquals((Object)(srcFileStatus.getIsDir() != null && srcFileStatus.getIsDir() != false ? 1 : 0), (Object)((BaseFile)bootstrapBaseFile.get()).getPathInfo().isDirectory());
        } else {
            Assertions.assertFalse((boolean)bootstrapBaseFile.isPresent());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"configParams"})
    public void testGetLatestFileSlicesIncludingInflight(boolean preTableVersion8) throws Exception {
        this.initMetaClient(preTableVersion8);
        String partitionPath = "2016/05/01";
        new File(this.basePath + "/" + partitionPath).mkdirs();
        String fileId = UUID.randomUUID().toString();
        String instantTime1 = "1";
        String deltaInstantTime1 = "2";
        String deltaInstantTime2 = "3";
        String dataFileName = FSUtils.makeBaseFileName((String)instantTime1, (String)TEST_WRITE_TOKEN, (String)fileId, (String)BASE_FILE_EXTENSION);
        new File(this.basePath + "/" + partitionPath + "/" + dataFileName).createNewFile();
        String fileName1 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)(preTableVersion8 ? instantTime1 : deltaInstantTime1), (int)0, (String)TEST_WRITE_TOKEN);
        String fileName2 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)(preTableVersion8 ? instantTime1 : deltaInstantTime2), (int)1, (String)TEST_WRITE_TOKEN);
        new File(this.basePath + "/" + partitionPath + "/" + fileName1).createNewFile();
        new File(this.basePath + "/" + partitionPath + "/" + fileName2).createNewFile();
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", instantTime1);
        HoodieInstant deltaInstant2 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", deltaInstantTime1);
        this.saveAsComplete(commitTimeline, instant1, new HoodieCommitMetadata());
        this.saveAsComplete(commitTimeline, deltaInstant2, new HoodieCommitMetadata());
        this.refreshFsView(preTableVersion8);
        this.rtView.getLatestFileSlices(partitionPath).collect(Collectors.toList()).forEach(fs -> {
            Assertions.assertEquals((Object)fs.getBaseInstantTime(), (Object)instantTime1);
            Assertions.assertTrue((boolean)fs.getBaseFile().isPresent());
            Assertions.assertEquals((Object)((HoodieBaseFile)fs.getBaseFile().get()).getCommitTime(), (Object)instantTime1);
            Assertions.assertEquals((Object)((HoodieBaseFile)fs.getBaseFile().get()).getFileId(), (Object)fileId);
            Assertions.assertEquals((Object)((HoodieBaseFile)fs.getBaseFile().get()).getPath(), (Object)("file:" + this.basePath + "/" + partitionPath + "/" + dataFileName));
            if (preTableVersion8) {
                Assertions.assertEquals((long)2L, (long)fs.getLogFiles().count());
            } else {
                Assertions.assertEquals((long)1L, (long)fs.getLogFiles().count());
            }
        });
        this.rtView.getLatestFileSlicesIncludingInflight(partitionPath).collect(Collectors.toList()).forEach(fs -> {
            Assertions.assertEquals((Object)fs.getBaseInstantTime(), (Object)instantTime1);
            Assertions.assertTrue((boolean)fs.getBaseFile().isPresent());
            Assertions.assertEquals((Object)((HoodieBaseFile)fs.getBaseFile().get()).getCommitTime(), (Object)instantTime1);
            Assertions.assertEquals((Object)((HoodieBaseFile)fs.getBaseFile().get()).getFileId(), (Object)fileId);
            Assertions.assertEquals((Object)((HoodieBaseFile)fs.getBaseFile().get()).getPath(), (Object)("file:" + this.basePath + "/" + partitionPath + "/" + dataFileName));
            Assertions.assertEquals((long)fs.getLogFiles().count(), (long)2L);
        });
    }

    protected void testViewForFileSlicesWithAsyncCompaction(boolean skipCreatingDataFile, boolean isCompactionInFlight, int expTotalFileSlices, int expTotalDataFiles, boolean includeInvalidAndInflight, boolean testBootstrap, boolean preTableVersion8) throws Exception {
        HoodieInstant compactionInstant;
        String logTime1;
        this.initMetaClient(preTableVersion8);
        if (testBootstrap) {
            this.metaClient = HoodieTestUtils.init((String)this.tempDir.toAbsolutePath().toString(), (HoodieTableType)this.getTableType(), (String)BOOTSTRAP_SOURCE_PATH, (boolean)testBootstrap, null, (String)"datestr", (Option)(preTableVersion8 ? Option.of((Object)HoodieTableVersion.SIX) : Option.of((Object)HoodieTableVersion.current())));
        }
        this.metaClient.getTableConfig().setTableVersion(preTableVersion8 ? HoodieTableVersion.SIX : HoodieTableVersion.current());
        String partitionPath = "2016/05/01";
        new File(this.basePath + "/" + partitionPath).mkdirs();
        String fileId = UUID.randomUUID().toString();
        String srcName = "part_0000" + this.metaClient.getTableConfig().getBaseFileFormat().getFileExtension();
        HoodieFileStatus srcFileStatus = HoodieFileStatus.newBuilder().setPath(HoodiePath.newBuilder().setUri(BOOTSTRAP_SOURCE_PATH + partitionPath + "/" + srcName).build()).setLength(Long.valueOf(0x10000000L)).setAccessTime(Long.valueOf(new Date().getTime())).setModificationTime(Long.valueOf(new Date().getTime() + 99999L)).setBlockReplication(Integer.valueOf(2)).setOwner("hudi").setGroup("hudi").setBlockSize(Long.valueOf(0x8000000L)).setPermission(HoodieFSPermission.newBuilder().setUserAction(FsAction.ALL.name()).setGroupAction(FsAction.READ.name()).setOtherAction(FsAction.NONE.name()).setStickyBit(Boolean.valueOf(true)).build()).build();
        String instantTime1 = testBootstrap && !skipCreatingDataFile ? "00000000000001" : "1";
        String deltaInstantTime1 = "2";
        String deltaInstantTime2 = "3";
        String dataFileName = null;
        if (!skipCreatingDataFile) {
            dataFileName = FSUtils.makeBaseFileName((String)instantTime1, (String)TEST_WRITE_TOKEN, (String)fileId, (String)BASE_FILE_EXTENSION);
            new File(this.basePath + "/" + partitionPath + "/" + dataFileName).createNewFile();
        }
        String string = preTableVersion8 ? (skipCreatingDataFile ? deltaInstantTime1 : instantTime1) : (logTime1 = deltaInstantTime1);
        String logTime2 = preTableVersion8 ? (skipCreatingDataFile ? deltaInstantTime1 : instantTime1) : deltaInstantTime2;
        String fileName1 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)logTime1, (int)0, (String)TEST_WRITE_TOKEN);
        String fileName2 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)logTime2, (int)1, (String)TEST_WRITE_TOKEN);
        new File(this.basePath + "/" + partitionPath + "/" + fileName1).createNewFile();
        new File(this.basePath + "/" + partitionPath + "/" + fileName2).createNewFile();
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", instantTime1);
        HoodieInstant deltaInstant2 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", deltaInstantTime1);
        HoodieInstant deltaInstant3 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", deltaInstantTime2);
        if (testBootstrap && !skipCreatingDataFile) {
            try (BootstrapIndex.IndexWriter writer = new HFileBootstrapIndex(this.metaClient).createWriter(BOOTSTRAP_SOURCE_PATH);){
                writer.begin();
                BootstrapFileMapping mapping = new BootstrapFileMapping(BOOTSTRAP_SOURCE_PATH, partitionPath, partitionPath, srcFileStatus, fileId);
                ArrayList<BootstrapFileMapping> b = new ArrayList<BootstrapFileMapping>();
                b.add(mapping);
                writer.appendNextPartition(partitionPath, b);
                writer.finish();
            }
        }
        this.saveAsComplete(commitTimeline, instant1, new HoodieCommitMetadata());
        this.saveAsComplete(commitTimeline, deltaInstant2, new HoodieCommitMetadata());
        this.saveAsComplete(commitTimeline, deltaInstant3, new HoodieCommitMetadata());
        this.refreshFsView(preTableVersion8);
        List fileSlices = this.rtView.getLatestFileSlices(partitionPath).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)fileSlices.size());
        FileSlice fileSlice = (FileSlice)fileSlices.get(0);
        Assertions.assertEquals((Object)(!skipCreatingDataFile ? instantTime1 : deltaInstantTime1), (Object)fileSlice.getBaseInstantTime());
        if (!skipCreatingDataFile) {
            Assertions.assertTrue((boolean)fileSlice.getBaseFile().isPresent());
            this.checkExternalFile(srcFileStatus, (Option<BaseFile>)((HoodieBaseFile)fileSlice.getBaseFile().get()).getBootstrapBaseFile(), testBootstrap);
        }
        String compactionRequestedTime = "4";
        String compactDataFileName = FSUtils.makeBaseFileName((String)compactionRequestedTime, (String)TEST_WRITE_TOKEN, (String)fileId, (String)BASE_FILE_EXTENSION);
        ArrayList<Pair> partitionFileSlicesPairs = new ArrayList<Pair>();
        partitionFileSlicesPairs.add(Pair.of((Object)partitionPath, fileSlices.get(0)));
        HoodieCompactionPlan compactionPlan = CompactionUtils.buildFromFileSlices(partitionFileSlicesPairs, (Option)Option.empty(), (Option)Option.empty());
        if (isCompactionInFlight) {
            new File(this.basePath + "/" + partitionPath + "/" + compactDataFileName).createNewFile();
            compactionInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "compaction", compactionRequestedTime);
            HoodieInstant requested = HoodieTestUtils.INSTANT_GENERATOR.getCompactionRequestedInstant(compactionInstant.requestedTime());
            commitTimeline.saveToCompactionRequested(requested, compactionPlan);
            commitTimeline.transitionCompactionRequestedToInflight(requested);
        } else {
            compactionInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "compaction", compactionRequestedTime);
            commitTimeline.saveToCompactionRequested(compactionInstant, compactionPlan);
        }
        this.refreshFsView(preTableVersion8);
        List slices = this.rtView.getLatestFileSlices(partitionPath).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)slices.size(), (String)"Expected latest file-slices");
        Assertions.assertEquals((Object)compactionRequestedTime, (Object)((FileSlice)slices.get(0)).getBaseInstantTime(), (String)"Base-Instant must be compaction Instant");
        Assertions.assertFalse((boolean)((FileSlice)slices.get(0)).getBaseFile().isPresent(), (String)"Latest File Slice must not have data-file");
        Assertions.assertEquals((long)0L, (long)((FileSlice)slices.get(0)).getLogFiles().count(), (String)"Latest File Slice must not have any log-files");
        String deltaInstantTime4 = "5";
        String deltaInstantTime5 = "6";
        List<String> allInstantTimes = Arrays.asList(instantTime1, deltaInstantTime1, deltaInstantTime2, compactionRequestedTime, deltaInstantTime4, deltaInstantTime5);
        String logTime4 = preTableVersion8 ? compactionRequestedTime : deltaInstantTime4;
        String logTime5 = preTableVersion8 ? compactionRequestedTime : deltaInstantTime5;
        String fileName3 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)logTime4, (int)(preTableVersion8 ? 2 : 0), (String)TEST_WRITE_TOKEN);
        String fileName4 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)logTime5, (int)(preTableVersion8 ? 3 : 1), (String)TEST_WRITE_TOKEN);
        new File(this.basePath + "/" + partitionPath + "/" + fileName3).createNewFile();
        new File(this.basePath + "/" + partitionPath + "/" + fileName4).createNewFile();
        HoodieInstant deltaInstant4 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", deltaInstantTime4);
        HoodieInstant deltaInstant5 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", deltaInstantTime5);
        this.saveAsComplete(commitTimeline, deltaInstant4, new HoodieCommitMetadata());
        this.saveAsComplete(commitTimeline, deltaInstant5, new HoodieCommitMetadata());
        this.refreshFsView(preTableVersion8);
        List<HoodieBaseFile> dataFiles = this.roView.getAllBaseFiles(partitionPath).collect(Collectors.toList());
        if (skipCreatingDataFile) {
            Assertions.assertTrue((boolean)dataFiles.isEmpty(), (String)"No data file expected");
        } else {
            Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"One data-file is expected as there is only one file-group");
            Assertions.assertEquals((Object)dataFileName, (Object)((HoodieBaseFile)dataFiles.get(0)).getFileName(), (String)"Expect only valid data-file");
        }
        List fileSliceList = this.rtView.getLatestMergedFileSlicesBeforeOrOn(partitionPath, deltaInstantTime5).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)fileSliceList.size(), (String)"Expect file-slice to be merged");
        fileSlice = (FileSlice)fileSliceList.get(0);
        Assertions.assertEquals((Object)fileId, (Object)fileSlice.getFileId());
        if (!skipCreatingDataFile) {
            Assertions.assertEquals((Object)dataFileName, (Object)((HoodieBaseFile)fileSlice.getBaseFile().get()).getFileName(), (String)"Data file must be present");
            this.checkExternalFile(srcFileStatus, (Option<BaseFile>)((HoodieBaseFile)fileSlice.getBaseFile().get()).getBootstrapBaseFile(), testBootstrap);
        } else {
            Assertions.assertFalse((boolean)fileSlice.getBaseFile().isPresent(), (String)"No data-file expected as it was not created");
        }
        Assertions.assertEquals((Object)(!skipCreatingDataFile ? instantTime1 : deltaInstantTime1), (Object)fileSlice.getBaseInstantTime(), (String)"Base Instant of penultimate file-slice must be base instant");
        List logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)4, (int)logFiles.size(), (String)"Log files must include those after compaction request");
        Assertions.assertEquals((Object)fileName4, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((Object)fileName3, (Object)((HoodieLogFile)logFiles.get(1)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((Object)fileName2, (Object)((HoodieLogFile)logFiles.get(2)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((Object)fileName1, (Object)((HoodieLogFile)logFiles.get(3)).getFileName(), (String)"Log File Order check");
        fileSliceList = this.rtView.getLatestFileSlicesBeforeOrOn(partitionPath, deltaInstantTime5, true).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)fileSliceList.size(), (String)"Expect only one file-id");
        fileSlice = (FileSlice)fileSliceList.get(0);
        Assertions.assertEquals((Object)fileId, (Object)fileSlice.getFileId());
        Assertions.assertFalse((boolean)fileSlice.getBaseFile().isPresent(), (String)"No data-file expected in latest file-slice");
        Assertions.assertEquals((Object)compactionRequestedTime, (Object)fileSlice.getBaseInstantTime(), (String)"Compaction requested instant must be base instant");
        logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)logFiles.size(), (String)"Log files must include only those after compaction request");
        Assertions.assertEquals((Object)fileName4, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((Object)fileName3, (Object)((HoodieLogFile)logFiles.get(1)).getFileName(), (String)"Log File Order check");
        dataFiles = this.roView.getLatestBaseFiles().collect(Collectors.toList());
        if (skipCreatingDataFile) {
            Assertions.assertEquals((int)0, (int)dataFiles.size(), (String)"Expect no data file to be returned");
        } else {
            Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"Expect only one data-file to be sent");
            dataFiles.forEach(df -> Assertions.assertEquals((Object)df.getCommitTime(), (Object)instantTime1, (String)"Expect data-file for instant 1 be returned"));
            this.checkExternalFile(srcFileStatus, (Option<BaseFile>)((HoodieBaseFile)dataFiles.get(0)).getBootstrapBaseFile(), testBootstrap);
        }
        dataFiles = this.roView.getLatestBaseFiles(partitionPath).collect(Collectors.toList());
        if (skipCreatingDataFile) {
            Assertions.assertEquals((int)0, (int)dataFiles.size(), (String)"Expect no data file to be returned");
        } else {
            Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"Expect only one data-file to be sent");
            dataFiles.forEach(df -> Assertions.assertEquals((Object)df.getCommitTime(), (Object)instantTime1, (String)"Expect data-file for instant 1 be returned"));
            this.checkExternalFile(srcFileStatus, (Option<BaseFile>)((HoodieBaseFile)dataFiles.get(0)).getBootstrapBaseFile(), testBootstrap);
        }
        dataFiles = this.roView.getLatestBaseFilesBeforeOrOn(partitionPath, deltaInstantTime5).collect(Collectors.toList());
        if (skipCreatingDataFile) {
            Assertions.assertEquals((int)0, (int)dataFiles.size(), (String)"Expect no data file to be returned");
        } else {
            Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"Expect only one data-file to be sent");
            dataFiles.forEach(df -> Assertions.assertEquals((Object)df.getCommitTime(), (Object)instantTime1, (String)"Expect data-file for instant 1 be returned"));
            this.checkExternalFile(srcFileStatus, (Option<BaseFile>)((HoodieBaseFile)dataFiles.get(0)).getBootstrapBaseFile(), testBootstrap);
        }
        dataFiles = this.roView.getLatestBaseFilesInRange(allInstantTimes).collect(Collectors.toList());
        if (skipCreatingDataFile) {
            Assertions.assertEquals((int)0, (int)dataFiles.size(), (String)"Expect no data file to be returned");
        } else {
            Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"Expect only one data-file to be sent");
            dataFiles.forEach(df -> Assertions.assertEquals((Object)df.getCommitTime(), (Object)instantTime1, (String)"Expect data-file for instant 1 be returned"));
            this.checkExternalFile(srcFileStatus, (Option<BaseFile>)((HoodieBaseFile)dataFiles.get(0)).getBootstrapBaseFile(), testBootstrap);
        }
        String inflightFileId1 = UUID.randomUUID().toString();
        String inflightFileId2 = UUID.randomUUID().toString();
        String orphanFileId1 = UUID.randomUUID().toString();
        String orphanFileId2 = UUID.randomUUID().toString();
        String invalidInstantId = "INVALIDTIME";
        String inflightDeltaInstantTime = "7";
        String orphanDataFileName = FSUtils.makeBaseFileName((String)"INVALIDTIME", (String)TEST_WRITE_TOKEN, (String)orphanFileId1, (String)BASE_FILE_EXTENSION);
        new File(this.basePath + "/" + partitionPath + "/" + orphanDataFileName).createNewFile();
        String orphanLogFileName = FSUtils.makeLogFileName((String)orphanFileId2, (String)".log", (String)"INVALIDTIME", (int)0, (String)TEST_WRITE_TOKEN);
        new File(this.basePath + "/" + partitionPath + "/" + orphanLogFileName).createNewFile();
        String inflightDataFileName = FSUtils.makeBaseFileName((String)inflightDeltaInstantTime, (String)TEST_WRITE_TOKEN, (String)inflightFileId1, (String)BASE_FILE_EXTENSION);
        new File(this.basePath + "/" + partitionPath + "/" + inflightDataFileName).createNewFile();
        String inflightLogFileName = FSUtils.makeLogFileName((String)inflightFileId2, (String)".log", (String)inflightDeltaInstantTime, (int)0, (String)TEST_WRITE_TOKEN);
        new File(this.basePath + "/" + partitionPath + "/" + inflightLogFileName).createNewFile();
        commitTimeline.createNewInstant(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "deltacommit", inflightDeltaInstantTime));
        commitTimeline.transitionRequestedToInflight(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "deltacommit", inflightDeltaInstantTime), Option.empty());
        this.refreshFsView(preTableVersion8);
        List allRawFileSlices = this.getAllRawFileSlices(partitionPath).collect(Collectors.toList());
        dataFiles = allRawFileSlices.stream().flatMap(slice -> {
            if (slice.getBaseFile().isPresent()) {
                return Stream.of(slice.getBaseFile().get());
            }
            return Stream.empty();
        }).collect(Collectors.toList());
        if (includeInvalidAndInflight) {
            Assertions.assertEquals((int)(2 + (isCompactionInFlight ? 1 : 0) + (skipCreatingDataFile ? 0 : 1)), (int)dataFiles.size(), (String)"Inflight/Orphan data-file is also expected");
            Set fileNames = dataFiles.stream().map(BaseFile::getFileName).collect(Collectors.toSet());
            Assertions.assertTrue((boolean)fileNames.contains(orphanDataFileName), (String)"Expect orphan data-file to be present");
            Assertions.assertTrue((boolean)fileNames.contains(inflightDataFileName), (String)"Expect inflight data-file to be present");
            if (!skipCreatingDataFile) {
                Assertions.assertTrue((boolean)fileNames.contains(dataFileName), (String)"Expect old committed data-file");
            }
            if (isCompactionInFlight) {
                Assertions.assertTrue((boolean)fileNames.contains(compactDataFileName), (String)"Expect inflight compacted data file to be present");
            }
            fileSliceList = this.getLatestRawFileSlices(partitionPath).collect(Collectors.toList());
            Assertions.assertEquals((int)(includeInvalidAndInflight ? 5 : 1), (int)fileSliceList.size(), (String)"Expect both inflight and orphan file-slice to be included");
            Map<String, FileSlice> fileSliceMap = fileSliceList.stream().collect(Collectors.toMap(FileSlice::getFileId, r -> r));
            FileSlice orphanFileSliceWithDataFile = fileSliceMap.get(orphanFileId1);
            FileSlice orphanFileSliceWithLogFile = fileSliceMap.get(orphanFileId2);
            FileSlice inflightFileSliceWithDataFile = fileSliceMap.get(inflightFileId1);
            FileSlice inflightFileSliceWithLogFile = fileSliceMap.get(inflightFileId2);
            Assertions.assertEquals((Object)"INVALIDTIME", (Object)orphanFileSliceWithDataFile.getBaseInstantTime(), (String)"Orphan File Slice with data-file check base-commit");
            Assertions.assertEquals((Object)orphanDataFileName, (Object)((HoodieBaseFile)orphanFileSliceWithDataFile.getBaseFile().get()).getFileName(), (String)"Orphan File Slice with data-file check data-file");
            Assertions.assertEquals((long)0L, (long)orphanFileSliceWithDataFile.getLogFiles().count(), (String)"Orphan File Slice with data-file check data-file");
            Assertions.assertEquals((Object)inflightDeltaInstantTime, (Object)inflightFileSliceWithDataFile.getBaseInstantTime(), (String)"Inflight File Slice with data-file check base-commit");
            Assertions.assertEquals((Object)inflightDataFileName, (Object)((HoodieBaseFile)inflightFileSliceWithDataFile.getBaseFile().get()).getFileName(), (String)"Inflight File Slice with data-file check data-file");
            Assertions.assertEquals((long)0L, (long)inflightFileSliceWithDataFile.getLogFiles().count(), (String)"Inflight File Slice with data-file check data-file");
            Assertions.assertEquals((Object)"INVALIDTIME", (Object)orphanFileSliceWithLogFile.getBaseInstantTime(), (String)"Orphan File Slice with log-file check base-commit");
            Assertions.assertFalse((boolean)orphanFileSliceWithLogFile.getBaseFile().isPresent(), (String)"Orphan File Slice with log-file check data-file");
            logFiles = orphanFileSliceWithLogFile.getLogFiles().collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)logFiles.size(), (String)"Orphan File Slice with log-file check data-file");
            Assertions.assertEquals((Object)orphanLogFileName, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Orphan File Slice with log-file check data-file");
            Assertions.assertEquals((Object)inflightDeltaInstantTime, (Object)inflightFileSliceWithLogFile.getBaseInstantTime(), (String)"Inflight File Slice with log-file check base-commit");
            Assertions.assertFalse((boolean)inflightFileSliceWithLogFile.getBaseFile().isPresent(), (String)"Inflight File Slice with log-file check data-file");
            logFiles = inflightFileSliceWithLogFile.getLogFiles().collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)logFiles.size(), (String)"Inflight File Slice with log-file check data-file");
            Assertions.assertEquals((Object)inflightLogFileName, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Inflight File Slice with log-file check data-file");
        }
        compactionInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "compaction", compactionRequestedTime);
        if (!isCompactionInFlight) {
            new File(this.basePath + "/" + partitionPath + "/" + compactDataFileName).createNewFile();
            commitTimeline.createNewInstant(compactionInstant);
        }
        commitTimeline.saveAsComplete(compactionInstant, Option.empty());
        this.refreshFsView(preTableVersion8);
        this.roView.getAllBaseFiles(partitionPath);
        fileSliceList = this.rtView.getLatestFileSlices(partitionPath).collect(Collectors.toList());
        LOG.info("FILESLICE LIST=" + fileSliceList);
        dataFiles = fileSliceList.stream().map(FileSlice::getBaseFile).filter(Option::isPresent).map(Option::get).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"Expect only one data-files in latest view as there is only one file-group");
        Assertions.assertEquals((Object)compactDataFileName, (Object)((HoodieBaseFile)dataFiles.get(0)).getFileName(), (String)"Data Filename must match");
        Assertions.assertEquals((int)1, (int)fileSliceList.size(), (String)"Only one latest file-slice in the partition");
        Assertions.assertFalse((boolean)((HoodieBaseFile)dataFiles.get(0)).getBootstrapBaseFile().isPresent(), (String)"No external data file must be present");
        fileSlice = (FileSlice)fileSliceList.get(0);
        Assertions.assertEquals((Object)fileId, (Object)fileSlice.getFileId(), (String)"Check file-Id is set correctly");
        Assertions.assertEquals((Object)compactDataFileName, (Object)((HoodieBaseFile)fileSlice.getBaseFile().get()).getFileName(), (String)"Check data-filename is set correctly");
        Assertions.assertEquals((Object)compactionRequestedTime, (Object)fileSlice.getBaseInstantTime(), (String)"Ensure base-instant is now compaction request instant");
        logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)logFiles.size(), (String)"Only log-files after compaction request shows up");
        Assertions.assertEquals((Object)fileName4, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((Object)fileName3, (Object)((HoodieLogFile)logFiles.get(1)).getFileName(), (String)"Log File Order check");
        dataFiles = this.roView.getLatestBaseFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"Expect only one data-file to be sent");
        Assertions.assertFalse((boolean)((HoodieBaseFile)dataFiles.get(0)).getBootstrapBaseFile().isPresent(), (String)"No external data file must be present");
        dataFiles.forEach(df -> {
            Assertions.assertEquals((Object)df.getCommitTime(), (Object)compactionRequestedTime, (String)"Expect data-file created by compaction be returned");
            Assertions.assertFalse((boolean)df.getBootstrapBaseFile().isPresent(), (String)"No external data file must be present");
        });
        dataFiles = this.roView.getLatestBaseFiles(partitionPath).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"Expect only one data-file to be sent");
        dataFiles.forEach(df -> {
            Assertions.assertEquals((Object)df.getCommitTime(), (Object)compactionRequestedTime, (String)"Expect data-file created by compaction be returned");
            Assertions.assertFalse((boolean)df.getBootstrapBaseFile().isPresent(), (String)"No external data file must be present");
        });
        dataFiles = this.roView.getLatestBaseFilesBeforeOrOn(partitionPath, deltaInstantTime5).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"Expect only one data-file to be sent");
        dataFiles.forEach(df -> {
            Assertions.assertEquals((Object)df.getCommitTime(), (Object)compactionRequestedTime, (String)"Expect data-file created by compaction be returned");
            Assertions.assertFalse((boolean)df.getBootstrapBaseFile().isPresent(), (String)"No external data file must be present");
        });
        dataFiles = this.roView.getLatestBaseFilesInRange(allInstantTimes).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"Expect only one data-file to be sent");
        dataFiles.forEach(df -> {
            Assertions.assertEquals((Object)df.getCommitTime(), (Object)compactionRequestedTime, (String)"Expect data-file created by compaction be returned");
            Assertions.assertFalse((boolean)df.getBootstrapBaseFile().isPresent(), (String)"No external data file must be present");
        });
        Assertions.assertEquals((long)expTotalFileSlices, (long)this.rtView.getAllFileSlices(partitionPath).count(), (String)"Total number of file-slices in partitions matches expected");
        Assertions.assertEquals((long)expTotalDataFiles, (long)this.roView.getAllBaseFiles(partitionPath).count(), (String)"Total number of data-files in partitions matches expected");
        Assertions.assertEquals((long)5L, (long)this.fsView.getAllFileGroups(partitionPath).count(), (String)"Total number of file-groups in partitions matches expected");
    }

    @Test
    public void testGetLatestDataFilesForFileId() throws IOException {
        String partitionPath = "2016/05/01";
        new File(this.basePath + "/" + partitionPath).mkdirs();
        String fileId = UUID.randomUUID().toString();
        Assertions.assertFalse((boolean)this.roView.getLatestBaseFiles(partitionPath).anyMatch(dfile -> dfile.getFileId().equals(fileId)), (String)"No commit, should not find any data file");
        String commitTime1 = "1";
        String fileName1 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId, (String)BASE_FILE_EXTENSION);
        new File(this.basePath + "/" + partitionPath + "/" + fileName1).createNewFile();
        this.refreshFsView();
        Assertions.assertFalse((boolean)this.roView.getLatestBaseFiles(partitionPath).anyMatch(dfile -> dfile.getFileId().equals(fileId)), (String)"No commit, should not find any data file");
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", commitTime1);
        this.saveAsComplete(commitTimeline, instant1, new HoodieCommitMetadata());
        this.refreshFsView();
        Assertions.assertEquals((Object)fileName1, (Object)this.roView.getLatestBaseFiles(partitionPath).filter(dfile -> dfile.getFileId().equals(fileId)).findFirst().get().getFileName());
        String commitTime2 = "2";
        String fileName2 = FSUtils.makeBaseFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileId, (String)BASE_FILE_EXTENSION);
        new File(this.basePath + "/" + partitionPath + "/" + fileName2).createNewFile();
        this.refreshFsView();
        Assertions.assertEquals((Object)fileName1, (Object)this.roView.getLatestBaseFiles(partitionPath).filter(dfile -> dfile.getFileId().equals(fileId)).findFirst().get().getFileName());
        HoodieInstant instant2 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", commitTime2);
        this.saveAsComplete(commitTimeline, instant2, new HoodieCommitMetadata());
        this.refreshFsView();
        Assertions.assertEquals((Object)fileName2, (Object)this.roView.getLatestBaseFiles(partitionPath).filter(dfile -> dfile.getFileId().equals(fileId)).findFirst().get().getFileName());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testStreamLatestVersionInPartition(boolean preTableVersion8) throws IOException {
        this.testStreamLatestVersionInPartition(false, preTableVersion8);
    }

    public void testStreamLatestVersionInPartition(boolean isLatestFileSliceOnly, boolean preTableVersion8) throws IOException {
        String fullPartitionPath = this.basePath + "/2016/05/01/";
        new File(fullPartitionPath).mkdirs();
        String cleanTime1 = "1";
        String commitTime2 = "2";
        String commitTime3 = "3";
        String commitTime4 = "4";
        String commitTime5 = "5";
        String fileId1 = "fg-A";
        String fileId2 = "fg-B";
        String fileId3 = "fg-C";
        String fileId4 = "fg-D";
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileId1, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId1, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeLogFileName((String)fileId1, (String)".log", (String)(preTableVersion8 ? commitTime3 : commitTime4), (int)0, (String)TEST_WRITE_TOKEN)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeLogFileName((String)fileId1, (String)".log", (String)(preTableVersion8 ? commitTime3 : commitTime5), (int)1, (String)TEST_WRITE_TOKEN)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileId2, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId2, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId2, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeLogFileName((String)fileId2, (String)".log", (String)(preTableVersion8 ? commitTime4 : commitTime5), (int)0, (String)TEST_WRITE_TOKEN)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId3, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId3, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeLogFileName((String)fileId4, (String)".log", (String)(preTableVersion8 ? commitTime4 : commitTime5), (int)0, (String)TEST_WRITE_TOKEN)).createNewFile();
        String relativeTimelinePath = preTableVersion8 ? "/.hoodie/" : "/.hoodie/timeline/";
        new File(this.basePath + relativeTimelinePath + cleanTime1 + ".clean").createNewFile();
        new File(this.basePath + relativeTimelinePath + commitTime2 + ".commit").createNewFile();
        new File(this.basePath + relativeTimelinePath + commitTime3 + ".commit").createNewFile();
        new File(this.basePath + relativeTimelinePath + commitTime4 + ".commit").createNewFile();
        new File(this.basePath + relativeTimelinePath + commitTime5 + ".commit").createNewFile();
        this.assertStreamLatestVersionInPartition(isLatestFileSliceOnly, fullPartitionPath, commitTime2, commitTime3, commitTime4, commitTime5, fileId1, fileId2, fileId3, fileId4, preTableVersion8);
        new File(this.basePath + relativeTimelinePath + commitTime2 + ".commit").delete();
        new File(this.basePath + relativeTimelinePath + commitTime3 + ".commit").delete();
        new File(this.basePath + relativeTimelinePath + commitTime4 + ".commit").delete();
        this.assertStreamLatestVersionInPartition(isLatestFileSliceOnly, fullPartitionPath, commitTime2, commitTime3, commitTime4, commitTime5, fileId1, fileId2, fileId3, fileId4, preTableVersion8);
    }

    private void assertStreamLatestVersionInPartition(boolean isLatestFileSliceOnly, String fullPartitionPath, String commitTime2, String commitTime3, String commitTime4, String commitTime5, String fileId1, String fileId2, String fileId3, String fileId4, boolean preTableVersion8) throws IOException {
        List partitionFileList = this.metaClient.getStorage().listDirectEntries(new StoragePath(fullPartitionPath));
        Assertions.assertEquals((int)11, (int)partitionFileList.size());
        this.refreshFsView(preTableVersion8);
        List allSlices = this.rtView.getAllFileSlices("2016/05/01").collect(Collectors.toList());
        Assertions.assertEquals((int)(isLatestFileSliceOnly ? 4 : 8), (int)allSlices.size());
        Map<String, Long> fileSliceMap = allSlices.stream().collect(Collectors.groupingBy(FileSlice::getFileId, Collectors.counting()));
        Assertions.assertEquals((long)(isLatestFileSliceOnly ? 1L : 2L), (long)fileSliceMap.get(fileId1));
        Assertions.assertEquals((long)(isLatestFileSliceOnly ? 1L : 3L), (long)fileSliceMap.get(fileId2));
        Assertions.assertEquals((long)(isLatestFileSliceOnly ? 1L : 2L), (long)fileSliceMap.get(fileId3));
        Assertions.assertEquals((long)1L, (long)fileSliceMap.get(fileId4));
        List dataFileList = this.roView.getLatestBaseFilesBeforeOrOn("2016/05/01", commitTime5).collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)dataFileList.size());
        HashSet<String> filenames = new HashSet<String>();
        for (Object status : dataFileList) {
            filenames.add(status.getFileName());
        }
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeBaseFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId1, (String)BASE_FILE_EXTENSION)));
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeBaseFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId2, (String)BASE_FILE_EXTENSION)));
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeBaseFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId3, (String)BASE_FILE_EXTENSION)));
        filenames = new HashSet();
        List logFilesList = this.rtView.getLatestFileSlicesBeforeOrOn("2016/05/01", commitTime5, true).flatMap(FileSlice::getLogFiles).collect(Collectors.toList());
        Assertions.assertEquals((int)4, (int)logFilesList.size());
        for (HoodieLogFile logFile : logFilesList) {
            filenames.add(logFile.getFileName());
        }
        String l = FSUtils.makeLogFileName((String)fileId1, (String)".log", (String)(preTableVersion8 ? commitTime3 : commitTime5), (int)0, (String)TEST_WRITE_TOKEN);
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeLogFileName((String)fileId1, (String)".log", (String)(preTableVersion8 ? commitTime3 : commitTime4), (int)0, (String)TEST_WRITE_TOKEN)));
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeLogFileName((String)fileId1, (String)".log", (String)(preTableVersion8 ? commitTime3 : commitTime5), (int)1, (String)TEST_WRITE_TOKEN)));
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeLogFileName((String)fileId2, (String)".log", (String)(preTableVersion8 ? commitTime4 : commitTime5), (int)0, (String)TEST_WRITE_TOKEN)));
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeLogFileName((String)fileId4, (String)".log", (String)(preTableVersion8 ? commitTime4 : commitTime5), (int)0, (String)TEST_WRITE_TOKEN)));
        List dataFiles = this.roView.getLatestBaseFilesBeforeOrOn("2016/05/01", commitTime4).collect(Collectors.toList());
        filenames = new HashSet();
        for (HoodieBaseFile status : dataFiles) {
            filenames.add(status.getFileName());
        }
        if (!isLatestFileSliceOnly) {
            Assertions.assertEquals((int)3, (int)dataFiles.size());
            Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeBaseFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId1, (String)BASE_FILE_EXTENSION)));
            Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeBaseFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId2, (String)BASE_FILE_EXTENSION)));
            Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeBaseFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId3, (String)BASE_FILE_EXTENSION)));
        } else {
            Assertions.assertEquals((int)1, (int)dataFiles.size());
            Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeBaseFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId2, (String)BASE_FILE_EXTENSION)));
        }
        List logFilesNames = this.rtView.getLatestFileSlicesBeforeOrOn("2016/05/01", commitTime4, true).flatMap(FileSlice::getLogFiles).map(HoodieLogFile::getFileName).collect(Collectors.toList());
        Assertions.assertEquals((int)(preTableVersion8 ? 4 : 3), (int)logFilesNames.size());
        Assertions.assertTrue((boolean)logFilesNames.contains(FSUtils.makeLogFileName((String)fileId2, (String)".log", (String)(preTableVersion8 ? commitTime4 : commitTime5), (int)0, (String)TEST_WRITE_TOKEN)));
    }

    @Test
    public void testStreamEveryVersionInPartition() throws IOException {
        this.testStreamEveryVersionInPartition(false);
    }

    protected void testStreamEveryVersionInPartition(boolean isLatestFileSliceOnly) throws IOException {
        String fullPartitionPath = this.basePath + "/2016/05/01/";
        new File(fullPartitionPath).mkdirs();
        String commitTime1 = "1";
        String commitTime2 = "2";
        String commitTime3 = "3";
        String commitTime4 = "4";
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        String fileId3 = UUID.randomUUID().toString();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId1, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId1, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId2, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileId2, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId2, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId3, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId3, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(this.basePath + "/.hoodie/timeline/" + commitTime1 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/timeline/" + commitTime2 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/timeline/" + commitTime3 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/timeline/" + commitTime4 + ".commit").createNewFile();
        List partitionFileList = this.metaClient.getStorage().listDirectEntries(new StoragePath(fullPartitionPath));
        Assertions.assertEquals((int)7, (int)partitionFileList.size());
        this.refreshFsView();
        List fileGroups = this.fsView.getAllFileGroups("2016/05/01").collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)fileGroups.size());
        for (HoodieFileGroup fileGroup : fileGroups) {
            String fileId = fileGroup.getFileGroupId().getFileId();
            HashSet filenames = new HashSet();
            fileGroup.getAllBaseFiles().forEach(dataFile -> {
                Assertions.assertEquals((Object)fileId, (Object)dataFile.getFileId(), (String)"All same fileId should be grouped");
                filenames.add(dataFile.getFileName());
            });
            HashSet<String> expFileNames = new HashSet<String>();
            if (fileId.equals(fileId1)) {
                if (!isLatestFileSliceOnly) {
                    expFileNames.add(FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId1, (String)BASE_FILE_EXTENSION));
                }
                expFileNames.add(FSUtils.makeBaseFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId1, (String)BASE_FILE_EXTENSION));
                Assertions.assertEquals(expFileNames, filenames);
                continue;
            }
            if (fileId.equals(fileId2)) {
                if (!isLatestFileSliceOnly) {
                    expFileNames.add(FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId2, (String)BASE_FILE_EXTENSION));
                    expFileNames.add(FSUtils.makeBaseFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileId2, (String)BASE_FILE_EXTENSION));
                }
                expFileNames.add(FSUtils.makeBaseFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId2, (String)BASE_FILE_EXTENSION));
                Assertions.assertEquals(expFileNames, filenames);
                continue;
            }
            if (!isLatestFileSliceOnly) {
                expFileNames.add(FSUtils.makeBaseFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId3, (String)BASE_FILE_EXTENSION));
            }
            expFileNames.add(FSUtils.makeBaseFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId3, (String)BASE_FILE_EXTENSION));
            Assertions.assertEquals(expFileNames, filenames);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testStreamLatestVersionInRange(boolean preTableVersion8) throws IOException {
        String fullPartitionPath = this.basePath + "/2016/05/01/";
        new File(fullPartitionPath).mkdirs();
        String commitTime1 = "1";
        String commitTime2 = "2";
        String commitTime3 = "3";
        String commitTime4 = "4";
        String fileIdA = "fg-A";
        String fileIdB = "fg-B";
        String fileIdC = "fg-C";
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileIdA, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeLogFileName((String)fileIdA, (String)".log", (String)(preTableVersion8 ? commitTime1 : commitTime2), (int)0, (String)TEST_WRITE_TOKEN)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileIdA, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileIdB, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileIdB, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileIdB, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeLogFileName((String)fileIdB, (String)".log", (String)(preTableVersion8 ? commitTime3 : commitTime4), (int)0, (String)TEST_WRITE_TOKEN)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileIdC, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileIdC, (String)BASE_FILE_EXTENSION)).createNewFile();
        String relativeTimelinePath = preTableVersion8 ? "/.hoodie/" : "/.hoodie/timeline/";
        new File(this.basePath + relativeTimelinePath + commitTime1 + ".commit").createNewFile();
        new File(this.basePath + relativeTimelinePath + commitTime2 + ".commit").createNewFile();
        new File(this.basePath + relativeTimelinePath + commitTime3 + ".commit").createNewFile();
        new File(this.basePath + relativeTimelinePath + commitTime4 + ".commit").createNewFile();
        List partitionFileList = this.metaClient.getStorage().listDirectEntries(new StoragePath(fullPartitionPath));
        Assertions.assertEquals((int)9, (int)partitionFileList.size());
        this.refreshFsView(preTableVersion8);
        this.roView.getAllBaseFiles("2016/05/01/");
        List dataFiles = this.roView.getLatestBaseFilesInRange(Arrays.asList(commitTime2, commitTime3)).collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)dataFiles.size());
        HashSet<String> filenames = new HashSet<String>();
        for (HoodieBaseFile status : dataFiles) {
            filenames.add(status.getFileName());
        }
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeBaseFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileIdA, (String)BASE_FILE_EXTENSION)));
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeBaseFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileIdB, (String)BASE_FILE_EXTENSION)));
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeBaseFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileIdC, (String)BASE_FILE_EXTENSION)));
        List slices = this.rtView.getLatestFileSliceInRange(Arrays.asList(commitTime3, commitTime4)).collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)slices.size());
        for (FileSlice slice : slices) {
            if (slice.getFileId().equals(fileIdA)) {
                Assertions.assertEquals((Object)slice.getBaseInstantTime(), (Object)commitTime3);
                Assertions.assertTrue((boolean)slice.getBaseFile().isPresent());
                Assertions.assertEquals((long)slice.getLogFiles().count(), (long)0L);
                continue;
            }
            if (slice.getFileId().equals(fileIdB)) {
                Assertions.assertEquals((Object)slice.getBaseInstantTime(), (Object)commitTime3);
                Assertions.assertTrue((boolean)slice.getBaseFile().isPresent());
                Assertions.assertEquals((long)slice.getLogFiles().count(), (long)1L);
                continue;
            }
            if (!slice.getFileId().equals(fileIdC)) continue;
            Assertions.assertEquals((Object)slice.getBaseInstantTime(), (Object)commitTime4);
            Assertions.assertTrue((boolean)slice.getBaseFile().isPresent());
            Assertions.assertEquals((long)slice.getLogFiles().count(), (long)0L);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testStreamLatestVersionsBefore(boolean preTableVersion8) throws IOException {
        String partitionPath = "2016/05/01/";
        String fullPartitionPath = this.basePath + "/" + partitionPath;
        new File(fullPartitionPath).mkdirs();
        String commitTime1 = "1";
        String commitTime2 = "2";
        String commitTime3 = "3";
        String commitTime4 = "4";
        String fileIdA = "fg-A";
        String fileIdB = "fg-B";
        String fileIdC = "fg-C";
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileIdA, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileIdA, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileIdB, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileIdB, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileIdB, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileIdC, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeBaseFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileIdC, (String)BASE_FILE_EXTENSION)).createNewFile();
        String relativeTimelinePath = preTableVersion8 ? "/.hoodie/" : "/.hoodie/timeline/";
        new File(this.basePath + relativeTimelinePath + commitTime1 + ".commit").createNewFile();
        new File(this.basePath + relativeTimelinePath + commitTime2 + ".commit").createNewFile();
        new File(this.basePath + relativeTimelinePath + commitTime3 + ".commit").createNewFile();
        new File(this.basePath + relativeTimelinePath + commitTime4 + ".commit").createNewFile();
        List partitionFileList = this.metaClient.getStorage().listDirectEntries(new StoragePath(fullPartitionPath));
        Assertions.assertEquals((int)7, (int)partitionFileList.size());
        this.refreshFsView(preTableVersion8);
        List dataFiles = this.roView.getLatestBaseFilesBeforeOrOn(partitionPath, commitTime2).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)dataFiles.size());
        HashSet<String> filenames = new HashSet<String>();
        for (HoodieBaseFile status : dataFiles) {
            filenames.add(status.getFileName());
        }
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileIdA, (String)BASE_FILE_EXTENSION)));
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeBaseFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileIdB, (String)BASE_FILE_EXTENSION)));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testStreamLatestVersions(boolean preTableVersion8) throws IOException {
        String partitionPath = "2016/05/01";
        String fullPartitionPath = this.basePath + "/" + partitionPath;
        new File(fullPartitionPath).mkdirs();
        String commitTime1 = "1";
        String commitTime2 = "2";
        String commitTime3 = "3";
        String commitTime4 = "4";
        String fileIdA = "fg-A";
        String fileIdB = "fg-B";
        String fileIdC = "fg-C";
        new File(fullPartitionPath + "/" + FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileIdA, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + "/" + FSUtils.makeLogFileName((String)fileIdA, (String)".log", (String)(preTableVersion8 ? commitTime1 : commitTime2), (int)0, (String)TEST_WRITE_TOKEN)).createNewFile();
        new File(fullPartitionPath + "/" + FSUtils.makeBaseFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileIdA, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + "/" + FSUtils.makeLogFileName((String)fileIdA, (String)".log", (String)(preTableVersion8 ? commitTime3 : commitTime4), (int)0, (String)TEST_WRITE_TOKEN)).createNewFile();
        new File(fullPartitionPath + "/" + FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileIdB, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + "/" + FSUtils.makeBaseFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileIdB, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + "/" + FSUtils.makeLogFileName((String)fileIdB, (String)".log", (String)(preTableVersion8 ? commitTime2 : commitTime3), (int)0, (String)TEST_WRITE_TOKEN)).createNewFile();
        new File(fullPartitionPath + "/" + FSUtils.makeBaseFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileIdB, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + "/" + FSUtils.makeBaseFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileIdC, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath + "/" + FSUtils.makeBaseFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileIdC, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(this.basePath + "/.hoodie/timeline/" + commitTime1 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/timeline/" + commitTime2 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/timeline/" + commitTime3 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/timeline/" + commitTime4 + ".commit").createNewFile();
        List partitionFileList = this.metaClient.getStorage().listDirectEntries(new StoragePath(fullPartitionPath));
        Assertions.assertEquals((int)10, (int)partitionFileList.size());
        this.refreshFsView();
        this.fsView.getAllBaseFiles(partitionPath);
        List fileGroups = this.fsView.getAllFileGroups(partitionPath).collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)fileGroups.size());
        for (HoodieFileGroup fileGroup : fileGroups) {
            List slices = fileGroup.getAllFileSlices().collect(Collectors.toList());
            String fileId = fileGroup.getFileGroupId().getFileId();
            if (fileId.equals(fileIdA)) {
                Assertions.assertEquals((int)2, (int)slices.size());
                Assertions.assertEquals((Object)commitTime3, (Object)((FileSlice)slices.get(0)).getBaseInstantTime());
                Assertions.assertEquals((Object)commitTime1, (Object)((FileSlice)slices.get(1)).getBaseInstantTime());
                continue;
            }
            if (fileId.equals(fileIdB)) {
                Assertions.assertEquals((int)3, (int)slices.size());
                Assertions.assertEquals((Object)commitTime4, (Object)((FileSlice)slices.get(0)).getBaseInstantTime());
                Assertions.assertEquals((Object)commitTime2, (Object)((FileSlice)slices.get(1)).getBaseInstantTime());
                Assertions.assertEquals((Object)commitTime1, (Object)((FileSlice)slices.get(2)).getBaseInstantTime());
                continue;
            }
            if (!fileId.equals(fileIdC)) continue;
            Assertions.assertEquals((int)2, (int)slices.size());
            Assertions.assertEquals((Object)commitTime4, (Object)((FileSlice)slices.get(0)).getBaseInstantTime());
            Assertions.assertEquals((Object)commitTime3, (Object)((FileSlice)slices.get(1)).getBaseInstantTime());
        }
        List statuses1 = this.roView.getLatestBaseFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)statuses1.size());
        HashSet<String> filenames = new HashSet<String>();
        for (HoodieBaseFile status : statuses1) {
            filenames.add(status.getFileName());
        }
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeBaseFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileIdA, (String)BASE_FILE_EXTENSION)));
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeBaseFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileIdB, (String)BASE_FILE_EXTENSION)));
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeBaseFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileIdC, (String)BASE_FILE_EXTENSION)));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPendingCompactionWithDuplicateFileIdsAcrossPartitions(boolean preTableVersion8) throws Exception {
        this.initMetaClient(preTableVersion8);
        String partitionPath1 = "2016/05/01";
        String partitionPath2 = "2016/05/02";
        String partitionPath3 = "2016/05/03";
        String fullPartitionPath1 = this.basePath + "/" + partitionPath1 + "/";
        new File(fullPartitionPath1).mkdirs();
        String fullPartitionPath2 = this.basePath + "/" + partitionPath2 + "/";
        new File(fullPartitionPath2).mkdirs();
        String fullPartitionPath3 = this.basePath + "/" + partitionPath3 + "/";
        new File(fullPartitionPath3).mkdirs();
        String instantTime1 = "1";
        String deltaInstantTime3 = "3";
        String deltaInstantTime4 = "4";
        String fileId = "fg-X";
        String baseFileName = FSUtils.makeBaseFileName((String)instantTime1, (String)TEST_WRITE_TOKEN, (String)fileId, (String)BASE_FILE_EXTENSION);
        String logFileName1 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)(preTableVersion8 ? instantTime1 : deltaInstantTime3), (int)0, (String)TEST_WRITE_TOKEN);
        new File(fullPartitionPath1 + baseFileName).createNewFile();
        new File(fullPartitionPath1 + logFileName1).createNewFile();
        new File(fullPartitionPath2 + FSUtils.makeBaseFileName((String)instantTime1, (String)TEST_WRITE_TOKEN, (String)fileId, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath2 + logFileName1).createNewFile();
        new File(fullPartitionPath3 + FSUtils.makeBaseFileName((String)instantTime1, (String)TEST_WRITE_TOKEN, (String)fileId, (String)BASE_FILE_EXTENSION)).createNewFile();
        new File(fullPartitionPath3 + logFileName1).createNewFile();
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", instantTime1);
        HoodieInstant deltaInstant3 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", deltaInstantTime3);
        HoodieInstant deltaInstant4 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", deltaInstantTime4);
        this.saveAsComplete(commitTimeline, instant1, new HoodieCommitMetadata());
        this.saveAsComplete(commitTimeline, deltaInstant3, new HoodieCommitMetadata());
        this.saveAsComplete(commitTimeline, deltaInstant4, new HoodieCommitMetadata());
        ArrayList<StoragePath> list = new ArrayList<StoragePath>();
        list.add(new StoragePath(fullPartitionPath1));
        list.add(new StoragePath(fullPartitionPath2));
        list.add(new StoragePath(fullPartitionPath3));
        List fileList = this.metaClient.getStorage().listDirectEntries(list);
        Assertions.assertEquals((int)6, (int)fileList.size());
        this.refreshFsView();
        Arrays.asList(partitionPath1, partitionPath2, partitionPath3).forEach(p -> this.fsView.getAllFileGroups(p).count());
        List groups = Stream.of(partitionPath1, partitionPath2, partitionPath3).flatMap(p -> this.fsView.getAllFileGroups(p)).collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)groups.size(), (String)"Expected number of file-groups");
        Assertions.assertEquals((int)3, (int)groups.stream().map(HoodieFileGroup::getPartitionPath).collect(Collectors.toSet()).size(), (String)"Partitions must be different for file-groups");
        Set fileIds = groups.stream().map(HoodieFileGroup::getFileGroupId).map(HoodieFileGroupId::getFileId).collect(Collectors.toSet());
        Assertions.assertEquals((int)1, (int)fileIds.size(), (String)"File Id must be same");
        Assertions.assertTrue((boolean)fileIds.contains(fileId), (String)"Expected FileId");
        ArrayList<Pair> partitionFileSlicesPairs = new ArrayList<Pair>();
        List fileSlices = this.rtView.getLatestFileSlices(partitionPath1).collect(Collectors.toList());
        partitionFileSlicesPairs.add(Pair.of((Object)partitionPath1, fileSlices.get(0)));
        fileSlices = this.rtView.getLatestFileSlices(partitionPath2).collect(Collectors.toList());
        partitionFileSlicesPairs.add(Pair.of((Object)partitionPath2, fileSlices.get(0)));
        fileSlices = this.rtView.getLatestFileSlices(partitionPath3).collect(Collectors.toList());
        partitionFileSlicesPairs.add(Pair.of((Object)partitionPath3, fileSlices.get(0)));
        String compactionRequestedTime = "2";
        String compactDataFileName = FSUtils.makeBaseFileName((String)compactionRequestedTime, (String)TEST_WRITE_TOKEN, (String)fileId, (String)BASE_FILE_EXTENSION);
        HoodieCompactionPlan compactionPlan = CompactionUtils.buildFromFileSlices(partitionFileSlicesPairs, (Option)Option.empty(), (Option)Option.empty());
        new File(this.basePath + "/" + partitionPath1 + "/" + compactDataFileName).createNewFile();
        new File(this.basePath + "/" + partitionPath2 + "/" + compactDataFileName).createNewFile();
        HoodieInstant compactionInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "compaction", compactionRequestedTime);
        HoodieInstant requested = HoodieTestUtils.INSTANT_GENERATOR.getCompactionRequestedInstant(compactionInstant.requestedTime());
        this.metaClient.getActiveTimeline().saveToCompactionRequested(requested, compactionPlan);
        this.metaClient.getActiveTimeline().transitionCompactionRequestedToInflight(requested);
        String deltaInstantTime5 = "5";
        String deltaInstantTime7 = "7";
        String fileName3 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)(preTableVersion8 ? compactionRequestedTime : deltaInstantTime5), (int)0, (String)TEST_WRITE_TOKEN);
        String fileName4 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)(preTableVersion8 ? compactionRequestedTime : deltaInstantTime7), (int)1, (String)TEST_WRITE_TOKEN);
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName3).createNewFile();
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName4).createNewFile();
        new File(this.basePath + "/" + partitionPath2 + "/" + fileName3).createNewFile();
        new File(this.basePath + "/" + partitionPath2 + "/" + fileName4).createNewFile();
        new File(this.basePath + "/" + partitionPath3 + "/" + fileName3).createNewFile();
        new File(this.basePath + "/" + partitionPath3 + "/" + fileName4).createNewFile();
        HoodieInstant deltaInstant5 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", deltaInstantTime5);
        HoodieInstant deltaInstant7 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", deltaInstantTime7);
        this.saveAsComplete(commitTimeline, deltaInstant5, new HoodieCommitMetadata());
        this.saveAsComplete(commitTimeline, deltaInstant7, new HoodieCommitMetadata());
        this.refreshFsView(preTableVersion8);
        List dataFiles = this.roView.getAllBaseFiles(partitionPath1).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"One data-file is expected as there is only one file-group");
        Assertions.assertEquals((Object)instantTime1, (Object)((HoodieBaseFile)dataFiles.get(0)).getCommitTime(), (String)"Expect only valid commit");
        dataFiles = this.roView.getAllBaseFiles(partitionPath2).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"One data-file is expected as there is only one file-group");
        Assertions.assertEquals((Object)instantTime1, (Object)((HoodieBaseFile)dataFiles.get(0)).getCommitTime(), (String)"Expect only valid commit");
        Arrays.asList(partitionPath1, partitionPath2, partitionPath3).forEach(partitionPath -> {
            List fileSliceList = this.rtView.getLatestMergedFileSlicesBeforeOrOn(partitionPath, deltaInstantTime7).collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)fileSliceList.size(), (String)"Expect file-slice to be merged");
            FileSlice fileSlice = (FileSlice)fileSliceList.get(0);
            Assertions.assertEquals((Object)fileId, (Object)fileSlice.getFileId());
            Assertions.assertEquals((Object)baseFileName, (Object)((HoodieBaseFile)fileSlice.getBaseFile().get()).getFileName(), (String)"Data file must be present");
            Assertions.assertEquals((Object)instantTime1, (Object)fileSlice.getBaseInstantTime(), (String)"Base Instant of penultimate file-slice must be base instant");
            List logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
            Assertions.assertEquals((int)3, (int)logFiles.size(), (String)"Log files must include those after compaction request");
            Assertions.assertEquals((Object)fileName4, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
            Assertions.assertEquals((Object)fileName3, (Object)((HoodieLogFile)logFiles.get(1)).getFileName(), (String)"Log File Order check");
            Assertions.assertEquals((Object)logFileName1, (Object)((HoodieLogFile)logFiles.get(2)).getFileName(), (String)"Log File Order check");
            fileSliceList = this.rtView.getLatestFileSlicesBeforeOrOn(partitionPath, deltaInstantTime7, true).collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)fileSliceList.size(), (String)"Expect only one file-id");
            fileSlice = (FileSlice)fileSliceList.get(0);
            Assertions.assertEquals((Object)fileId, (Object)fileSlice.getFileId());
            Assertions.assertFalse((boolean)fileSlice.getBaseFile().isPresent(), (String)"No data-file expected in latest file-slice");
            Assertions.assertEquals((Object)compactionRequestedTime, (Object)fileSlice.getBaseInstantTime(), (String)"Compaction requested instant must be base instant");
            logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
            if (preTableVersion8) {
                Assertions.assertEquals((int)2, (int)logFiles.size(), (String)"Log files must include only those after compaction request");
            } else {
                Assertions.assertEquals((int)3, (int)logFiles.size(), (String)"All log files > compaction requested time to be included.");
            }
            Assertions.assertEquals((Object)fileName4, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
            Assertions.assertEquals((Object)fileName3, (Object)((HoodieLogFile)logFiles.get(1)).getFileName(), (String)"Log File Order check");
            fileSliceList = this.rtView.getLatestFileSlicesBeforeOrOn(partitionPath, deltaInstantTime7, false).collect(Collectors.toList());
            Assertions.assertEquals((int)0, (int)fileSliceList.size(), (String)"Expect empty list as file-id is in pending compaction");
        });
        Assertions.assertEquals((long)3L, (long)this.fsView.getPendingCompactionOperations().count());
        Set partitionsInCompaction = this.fsView.getPendingCompactionOperations().map(Pair::getValue).map(CompactionOperation::getPartitionPath).collect(Collectors.toSet());
        Assertions.assertEquals((int)3, (int)partitionsInCompaction.size());
        Assertions.assertTrue((boolean)partitionsInCompaction.contains(partitionPath1));
        Assertions.assertTrue((boolean)partitionsInCompaction.contains(partitionPath2));
        Assertions.assertTrue((boolean)partitionsInCompaction.contains(partitionPath3));
        Set fileIdsInCompaction = this.fsView.getPendingCompactionOperations().map(Pair::getValue).map(CompactionOperation::getFileId).collect(Collectors.toSet());
        Assertions.assertEquals((int)1, (int)fileIdsInCompaction.size());
        Assertions.assertTrue((boolean)fileIdsInCompaction.contains(fileId));
    }

    private void saveAsComplete(HoodieActiveTimeline timeline, HoodieInstant inflight, HoodieCommitMetadata metadata) {
        if (inflight.getAction().equals("compaction")) {
            timeline.transitionCompactionInflightToComplete(true, inflight, metadata);
        } else {
            HoodieInstant requested = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, inflight.getAction(), inflight.requestedTime());
            timeline.createNewInstant(requested);
            timeline.transitionRequestedToInflight(requested, Option.empty());
            timeline.saveAsComplete(inflight, Option.of((Object)metadata));
        }
    }

    private void saveAsCompleteCluster(HoodieActiveTimeline timeline, HoodieInstant inflight, HoodieCommitMetadata metadata) {
        Assertions.assertEquals((Object)"clustering", (Object)inflight.getAction());
        HoodieInstant clusteringInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, inflight.getAction(), inflight.requestedTime());
        HoodieClusteringPlan plan = new HoodieClusteringPlan();
        plan.setExtraMetadata(new HashMap());
        plan.setInputGroups(Collections.emptyList());
        plan.setStrategy(HoodieClusteringStrategy.newBuilder().build());
        plan.setVersion(Integer.valueOf(1));
        plan.setPreserveHoodieMetadata(Boolean.valueOf(false));
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = HoodieRequestedReplaceMetadata.newBuilder().setOperationType(WriteOperationType.CLUSTER.name()).setExtraMetadata(Collections.emptyMap()).setClusteringPlan(plan).build();
        timeline.saveToPendingClusterCommit(clusteringInstant, requestedReplaceMetadata);
        timeline.transitionRequestedToInflight(clusteringInstant, Option.empty());
        timeline.transitionClusterInflightToComplete(true, inflight, (HoodieReplaceCommitMetadata)metadata);
    }

    @Test
    public void testReplaceWithTimeTravel() throws IOException {
        String partitionPath1 = "2020/06/27";
        new File(this.basePath + "/" + partitionPath1).mkdirs();
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        Assertions.assertFalse((boolean)this.roView.getLatestBaseFiles(partitionPath1).anyMatch(dfile -> dfile.getFileId().equals(fileId1) || dfile.getFileId().equals(fileId2)), (String)"No commit, should not find any data file");
        String commitTime1 = "1";
        String fileName1 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId1, (String)BASE_FILE_EXTENSION);
        String fileName2 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId2, (String)BASE_FILE_EXTENSION);
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName1).createNewFile();
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName2).createNewFile();
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", commitTime1);
        this.saveAsComplete(commitTimeline, instant1, new HoodieCommitMetadata());
        this.refreshFsView();
        Assertions.assertEquals((long)1L, (long)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId1)).count());
        Assertions.assertEquals((long)1L, (long)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId2)).count());
        String fileId3 = UUID.randomUUID().toString();
        String fileId4 = UUID.randomUUID().toString();
        String fileName3 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId3, (String)BASE_FILE_EXTENSION);
        String fileName4 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId4, (String)BASE_FILE_EXTENSION);
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName3).createNewFile();
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName4).createNewFile();
        String commitTime2 = "2";
        HashMap partitionToReplaceFileIds = new HashMap();
        ArrayList<String> replacedFileIds = new ArrayList<String>();
        replacedFileIds.add(fileId1);
        partitionToReplaceFileIds.put(partitionPath1, replacedFileIds);
        HoodieCommitMetadata commitMetadata = CommitUtils.buildMetadata(Collections.emptyList(), partitionToReplaceFileIds, (Option)Option.empty(), (WriteOperationType)WriteOperationType.INSERT_OVERWRITE, (String)"", (String)"replacecommit");
        commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant2 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "replacecommit", commitTime2);
        this.saveAsComplete(commitTimeline, instant2, commitMetadata);
        this.refreshFsView();
        Assertions.assertEquals((long)0L, (long)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId1)).count());
        Assertions.assertEquals((long)1L, (long)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId2)).count());
        Assertions.assertEquals((long)1L, (long)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId3)).count());
        Assertions.assertEquals((long)1L, (long)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId4)).count());
        SyncableFileSystemView filteredView = this.getFileSystemView(this.metaClient.getActiveTimeline().findInstantsBefore("2"), false);
        Assertions.assertEquals((long)1L, (long)filteredView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId1)).count());
        Assertions.assertEquals((long)1L, (long)filteredView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId2)).count());
        Assertions.assertEquals((long)1L, (long)filteredView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId3)).count());
        Assertions.assertEquals((long)1L, (long)filteredView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId4)).count());
        filteredView.close();
        List replacedOnInstant1 = this.fsView.getReplacedFileGroupsBeforeOrOn("1", partitionPath1).collect(Collectors.toList());
        Assertions.assertEquals((int)0, (int)replacedOnInstant1.size());
        List allReplaced = this.fsView.getReplacedFileGroupsBeforeOrOn("2", partitionPath1).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)allReplaced.size());
        Assertions.assertEquals((Object)fileId1, (Object)((HoodieFileGroup)allReplaced.get(0)).getFileGroupId().getFileId());
        allReplaced = this.fsView.getReplacedFileGroupsBefore("2", partitionPath1).collect(Collectors.toList());
        Assertions.assertEquals((int)0, (int)allReplaced.size());
        allReplaced = this.fsView.getAllReplacedFileGroups(partitionPath1).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)allReplaced.size());
        Assertions.assertEquals((Object)fileId1, (Object)((HoodieFileGroup)allReplaced.get(0)).getFileGroupId().getFileId());
    }

    @Test
    public void testReplaceFileIdIsExcludedInView() throws IOException {
        String partitionPath1 = "2020/06/27";
        String partitionPath2 = "2020/07/14";
        new File(this.basePath + "/" + partitionPath1).mkdirs();
        new File(this.basePath + "/" + partitionPath2).mkdirs();
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        String fileId3 = UUID.randomUUID().toString();
        String fileId4 = UUID.randomUUID().toString();
        Assertions.assertFalse((boolean)this.roView.getLatestBaseFiles(partitionPath1).anyMatch(dfile -> dfile.getFileId().equals(fileId1) || dfile.getFileId().equals(fileId2)), (String)"No commit, should not find any data file");
        Assertions.assertFalse((boolean)this.roView.getLatestBaseFiles(partitionPath2).anyMatch(dfile -> dfile.getFileId().equals(fileId3) || dfile.getFileId().equals(fileId4)), (String)"No commit, should not find any data file");
        String commitTime1 = "1";
        String fileName1 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId1, (String)BASE_FILE_EXTENSION);
        String fileName2 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId2, (String)BASE_FILE_EXTENSION);
        String fileName3 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId3, (String)BASE_FILE_EXTENSION);
        String fileName4 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId4, (String)BASE_FILE_EXTENSION);
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName1).createNewFile();
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName2).createNewFile();
        new File(this.basePath + "/" + partitionPath2 + "/" + fileName3).createNewFile();
        new File(this.basePath + "/" + partitionPath2 + "/" + fileName4).createNewFile();
        HashMap partitionToReplaceFileIds = new HashMap();
        ArrayList<String> replacedFileIdsP1 = new ArrayList<String>();
        replacedFileIdsP1.add(fileId1);
        partitionToReplaceFileIds.put(partitionPath1, replacedFileIdsP1);
        ArrayList<String> replacedFileIdsP2 = new ArrayList<String>();
        replacedFileIdsP2.add(fileId3);
        replacedFileIdsP2.add(fileId4);
        partitionToReplaceFileIds.put(partitionPath2, replacedFileIdsP2);
        HoodieCommitMetadata commitMetadata = CommitUtils.buildMetadata(Collections.emptyList(), partitionToReplaceFileIds, (Option)Option.empty(), (WriteOperationType)WriteOperationType.INSERT_OVERWRITE, (String)"", (String)"replacecommit");
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "replacecommit", commitTime1);
        this.saveAsComplete(commitTimeline, instant1, commitMetadata);
        this.refreshFsView();
        Assertions.assertEquals((long)0L, (long)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId1)).count());
        Assertions.assertEquals((Object)fileName2, (Object)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId2)).findFirst().get().getFileName());
        Assertions.assertEquals((long)0L, (long)this.roView.getLatestBaseFiles(partitionPath2).filter(dfile -> dfile.getFileId().equals(fileId3)).count());
        Assertions.assertEquals((long)0L, (long)this.roView.getLatestBaseFiles(partitionPath2).filter(dfile -> dfile.getFileId().equals(fileId4)).count());
        List replacedOnInstant1 = this.fsView.getReplacedFileGroupsBeforeOrOn("0", partitionPath1).collect(Collectors.toList());
        Assertions.assertEquals((int)0, (int)replacedOnInstant1.size());
        List allReplaced = this.fsView.getReplacedFileGroupsBeforeOrOn("2", partitionPath1).collect(Collectors.toList());
        allReplaced.addAll(this.fsView.getReplacedFileGroupsBeforeOrOn("2", partitionPath2).collect(Collectors.toList()));
        Assertions.assertEquals((int)3, (int)allReplaced.size());
        Set allReplacedFileIds = allReplaced.stream().map(fg -> fg.getFileGroupId().getFileId()).collect(Collectors.toSet());
        Set actualReplacedFileIds = Stream.of(fileId1, fileId3, fileId4).collect(Collectors.toSet());
        Assertions.assertEquals(actualReplacedFileIds, allReplacedFileIds);
    }

    @Test
    public void testPendingClusteringOperations() throws IOException {
        String partitionPath1 = "2020/06/27";
        new File(this.basePath + "/" + partitionPath1).mkdirs();
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        String fileId3 = UUID.randomUUID().toString();
        Assertions.assertFalse((boolean)this.roView.getLatestBaseFiles(partitionPath1).anyMatch(dfile -> dfile.getFileId().equals(fileId1) || dfile.getFileId().equals(fileId2) || dfile.getFileId().equals(fileId3)), (String)"No commit, should not find any data file");
        String commitTime1 = "1";
        String fileName1 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId1, (String)BASE_FILE_EXTENSION);
        String fileName2 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId2, (String)BASE_FILE_EXTENSION);
        String fileName3 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId3, (String)BASE_FILE_EXTENSION);
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName1).createNewFile();
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName2).createNewFile();
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName3).createNewFile();
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", commitTime1);
        this.saveAsComplete(commitTimeline, instant1, new HoodieCommitMetadata());
        this.refreshFsView();
        Assertions.assertEquals((long)1L, (long)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId1)).count());
        Assertions.assertEquals((long)1L, (long)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId2)).count());
        Assertions.assertEquals((long)1L, (long)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId3)).count());
        List[] fileSliceGroups = new List[]{Collections.singletonList(this.fsView.getLatestFileSlice(partitionPath1, fileId1).get()), Collections.singletonList(this.fsView.getLatestFileSlice(partitionPath1, fileId2).get())};
        HoodieClusteringPlan plan = ClusteringUtils.createClusteringPlan((String)"strategy", new HashMap(), (List[])fileSliceGroups, Collections.emptyMap());
        String clusterTime = "2";
        HoodieInstant instant2 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "clustering", clusterTime);
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = HoodieRequestedReplaceMetadata.newBuilder().setClusteringPlan(plan).setOperationType(WriteOperationType.CLUSTER.name()).build();
        this.metaClient.getActiveTimeline().saveToPendingClusterCommit(instant2, requestedReplaceMetadata);
        this.refreshFsView();
        Set fileIds = this.fsView.getFileGroupsInPendingClustering().map(e -> ((HoodieFileGroupId)e.getLeft()).getFileId()).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)fileIds.contains(fileId1));
        Assertions.assertTrue((boolean)fileIds.contains(fileId2));
        Assertions.assertFalse((boolean)fileIds.contains(fileId3));
    }

    @Test
    public void testHoodieTableFileSystemViewWithPendingClustering() throws IOException {
        String partitionPath = "2020/06/27";
        new File(this.basePath + "/" + partitionPath).mkdirs();
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        String fileId3 = UUID.randomUUID().toString();
        String fileId4 = UUID.randomUUID().toString();
        String fileId5 = UUID.randomUUID().toString();
        Assertions.assertFalse((boolean)this.roView.getLatestBaseFiles(partitionPath).anyMatch(dfile -> dfile.getFileId().equals(fileId1) || dfile.getFileId().equals(fileId2) || dfile.getFileId().equals(fileId3) || dfile.getFileId().equals(fileId4) || dfile.getFileId().equals(fileId5)), (String)"No commit, should not find any data file");
        String commitTime1 = "1";
        String fileName1 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId1, (String)BASE_FILE_EXTENSION);
        String fileName2 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId2, (String)BASE_FILE_EXTENSION);
        new File(this.basePath + "/" + partitionPath + "/" + fileName1).createNewFile();
        new File(this.basePath + "/" + partitionPath + "/" + fileName2).createNewFile();
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", commitTime1);
        HashMap<String, List<String>> partitionToFile1 = new HashMap<String, List<String>>();
        ArrayList<String> files1 = new ArrayList<String>();
        files1.add(fileId1);
        files1.add(fileId2);
        partitionToFile1.put(partitionPath, files1);
        List<HoodieWriteStat> writeStats1 = this.buildWriteStats(partitionToFile1, commitTime1);
        HoodieCommitMetadata commitMetadata1 = CommitUtils.buildMetadata(writeStats1, new HashMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.INSERT, (String)"", (String)"commit");
        this.saveAsComplete(commitTimeline, instant1, commitMetadata1);
        commitTimeline.reload();
        String commitTime2 = "2";
        String fileName3 = FSUtils.makeBaseFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileId3, (String)BASE_FILE_EXTENSION);
        new File(this.basePath + "/" + partitionPath + "/" + fileName3).createNewFile();
        HoodieInstant instant2 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "clustering", commitTime2);
        HashMap partitionToReplaceFileIds = new HashMap();
        ArrayList<String> replacedFileIds = new ArrayList<String>();
        replacedFileIds.add(fileId1);
        replacedFileIds.add(fileId2);
        partitionToReplaceFileIds.put(partitionPath, replacedFileIds);
        HashMap<String, List<String>> partitionToFile2 = new HashMap<String, List<String>>();
        ArrayList<String> files2 = new ArrayList<String>();
        files2.add(fileId3);
        partitionToFile2.put(partitionPath, files2);
        List<HoodieWriteStat> writeStats2 = this.buildWriteStats(partitionToFile2, commitTime2);
        HoodieCommitMetadata commitMetadata2 = CommitUtils.buildMetadata(writeStats2, partitionToReplaceFileIds, (Option)Option.empty(), (WriteOperationType)WriteOperationType.CLUSTER, (String)"", (String)"replacecommit");
        this.saveAsCompleteCluster(commitTimeline, instant2, commitMetadata2);
        String commitTime3 = "3";
        String fileName4 = FSUtils.makeBaseFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId4, (String)BASE_FILE_EXTENSION);
        new File(this.basePath + "/" + partitionPath + "/" + fileName4).createNewFile();
        HoodieInstant instant3 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", commitTime3);
        HashMap<String, List<String>> partitionToFile3 = new HashMap<String, List<String>>();
        ArrayList<String> files3 = new ArrayList<String>();
        files3.add(fileId4);
        partitionToFile3.put(partitionPath, files3);
        List<HoodieWriteStat> writeStats3 = this.buildWriteStats(partitionToFile3, commitTime3);
        HoodieCommitMetadata commitMetadata3 = CommitUtils.buildMetadata(writeStats3, new HashMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.INSERT, (String)"", (String)"commit");
        this.saveAsComplete(commitTimeline, instant3, commitMetadata3);
        this.metaClient.reloadActiveTimeline();
        this.refreshFsView();
        ArrayList<String> commits = new ArrayList<String>();
        commits.add(commitTime1);
        commits.add(commitTime2);
        commits.add(commitTime3);
        List latestBaseFilesBeforeOrOn = this.fsView.getLatestBaseFilesBeforeOrOn(partitionPath, commitTime3).map(HoodieBaseFile::getFileId).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)latestBaseFilesBeforeOrOn.size());
        Assertions.assertTrue((boolean)latestBaseFilesBeforeOrOn.contains(fileId3));
        Assertions.assertTrue((boolean)latestBaseFilesBeforeOrOn.contains(fileId4));
        Option baseFileOn = this.fsView.getBaseFileOn(partitionPath, commitTime2, fileId3);
        Assertions.assertTrue((boolean)baseFileOn.isPresent());
        Assertions.assertEquals((Object)((HoodieBaseFile)baseFileOn.get()).getFileId(), (Object)fileId3);
        List latestBaseFilesInRange = this.fsView.getLatestBaseFilesInRange(commits).map(HoodieBaseFile::getFileId).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)latestBaseFilesInRange.size());
        Assertions.assertTrue((boolean)latestBaseFilesInRange.contains(fileId3));
        Assertions.assertTrue((boolean)latestBaseFilesInRange.contains(fileId4));
        List allBaseFiles = this.fsView.getAllBaseFiles(partitionPath).map(HoodieBaseFile::getFileId).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)allBaseFiles.size());
        Assertions.assertTrue((boolean)allBaseFiles.contains(fileId3));
        Assertions.assertTrue((boolean)allBaseFiles.contains(fileId4));
        List latestBaseFiles = this.fsView.getLatestBaseFiles().map(HoodieBaseFile::getFileId).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)latestBaseFiles.size());
        Assertions.assertTrue((boolean)allBaseFiles.contains(fileId3));
        Assertions.assertTrue((boolean)allBaseFiles.contains(fileId4));
        List latestBaseFilesPerPartition = this.fsView.getLatestBaseFiles(partitionPath).map(HoodieBaseFile::getFileId).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)latestBaseFiles.size());
        Assertions.assertTrue((boolean)latestBaseFilesPerPartition.contains(fileId3));
        Assertions.assertTrue((boolean)latestBaseFilesPerPartition.contains(fileId4));
        HoodieStorage storage = this.metaClient.getStorage();
        StoragePath instantPath1 = HoodieTestUtils.getCompleteInstantPath((HoodieStorage)storage, (StoragePath)this.metaClient.getTimelinePath(), (String)"1", (String)"commit");
        storage.deleteFile(instantPath1);
        storage.deleteFile(new StoragePath(this.basePath + "/.hoodie/timeline/", "1.inflight"));
        storage.deleteFile(new StoragePath(this.basePath + "/.hoodie/timeline/", "1.commit.requested"));
        StoragePath instantPath2 = HoodieTestUtils.getCompleteInstantPath((HoodieStorage)storage, (StoragePath)this.metaClient.getTimelinePath(), (String)"2", (String)"replacecommit");
        storage.deleteFile(instantPath2);
        this.metaClient.reloadActiveTimeline();
        this.refreshFsView();
        latestBaseFilesBeforeOrOn = this.fsView.getLatestBaseFilesBeforeOrOn(partitionPath, commitTime3).map(HoodieBaseFile::getFileId).collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)latestBaseFilesBeforeOrOn.size());
        Assertions.assertTrue((boolean)latestBaseFilesBeforeOrOn.contains(fileId1));
        Assertions.assertTrue((boolean)latestBaseFilesBeforeOrOn.contains(fileId2));
        Assertions.assertTrue((boolean)latestBaseFilesBeforeOrOn.contains(fileId4));
        baseFileOn = this.fsView.getBaseFileOn(partitionPath, commitTime2, fileId3);
        Assertions.assertFalse((boolean)baseFileOn.isPresent());
        latestBaseFilesInRange = this.fsView.getLatestBaseFilesInRange(commits).map(HoodieBaseFile::getFileId).collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)latestBaseFilesInRange.size());
        Assertions.assertTrue((boolean)latestBaseFilesInRange.contains(fileId1));
        Assertions.assertTrue((boolean)latestBaseFilesInRange.contains(fileId2));
        Assertions.assertTrue((boolean)latestBaseFilesInRange.contains(fileId4));
        allBaseFiles = this.fsView.getAllBaseFiles(partitionPath).map(HoodieBaseFile::getFileId).collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)allBaseFiles.size());
        Assertions.assertTrue((boolean)allBaseFiles.contains(fileId1));
        Assertions.assertTrue((boolean)allBaseFiles.contains(fileId2));
        Assertions.assertTrue((boolean)allBaseFiles.contains(fileId4));
        latestBaseFiles = this.fsView.getLatestBaseFiles().map(HoodieBaseFile::getFileId).collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)latestBaseFiles.size());
        Assertions.assertTrue((boolean)allBaseFiles.contains(fileId1));
        Assertions.assertTrue((boolean)allBaseFiles.contains(fileId2));
        Assertions.assertTrue((boolean)allBaseFiles.contains(fileId4));
        latestBaseFilesPerPartition = this.fsView.getLatestBaseFiles(partitionPath).map(HoodieBaseFile::getFileId).collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)latestBaseFiles.size());
        Assertions.assertTrue((boolean)latestBaseFilesPerPartition.contains(fileId1));
        Assertions.assertTrue((boolean)latestBaseFilesPerPartition.contains(fileId2));
        Assertions.assertTrue((boolean)latestBaseFilesPerPartition.contains(fileId4));
    }

    private List<HoodieWriteStat> buildWriteStats(HashMap<String, List<String>> partitionToFileIds, String commitTime) {
        HashMap<String, List<Pair<String, Integer>>> maps = new HashMap<String, List<Pair<String, Integer>>>();
        for (String partition : partitionToFileIds.keySet()) {
            List list = partitionToFileIds.get(partition).stream().map(fileId -> new ImmutablePair(fileId, (Object)0)).collect(Collectors.toList());
            maps.put(partition, list);
        }
        return HoodieTestTable.generateHoodieWriteStatForPartition(maps, commitTime, false);
    }

    @Test
    public void testPendingMajorAndMinorCompactionOperations() throws Exception {
        String partitionPath = "2020/06/27";
        new File(this.basePath + "/" + partitionPath).mkdirs();
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        FileSystemViewExpectedState expectedState = new FileSystemViewExpectedState();
        String commitTime1 = "001";
        String logFileName1 = FSUtils.makeLogFileName((String)fileId1, (String)HoodieFileFormat.HOODIE_LOG.getFileExtension(), (String)commitTime1, (int)1, (String)TEST_WRITE_TOKEN);
        String logFileName2 = FSUtils.makeLogFileName((String)fileId2, (String)HoodieFileFormat.HOODIE_LOG.getFileExtension(), (String)commitTime1, (int)1, (String)TEST_WRITE_TOKEN);
        new File(this.basePath + "/" + partitionPath + "/" + logFileName1).createNewFile();
        new File(this.basePath + "/" + partitionPath + "/" + logFileName2).createNewFile();
        expectedState.logFilesCurrentlyPresent.add(logFileName1);
        expectedState.logFilesCurrentlyPresent.add(logFileName2);
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        commitMetadata.addWriteStat(partitionPath, this.getHoodieWriteStat(partitionPath, fileId1, logFileName1));
        commitMetadata.addWriteStat(partitionPath, this.getHoodieWriteStat(partitionPath, fileId2, logFileName2));
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", commitTime1);
        this.saveAsComplete(commitTimeline, instant1, commitMetadata);
        SyncableFileSystemView fileSystemView = this.getFileSystemView((HoodieTimeline)this.metaClient.reloadActiveTimeline(), true);
        this.verifyFileSystemView(partitionPath, expectedState, fileSystemView);
        String commitTime2 = "002";
        String logFileName3 = FSUtils.makeLogFileName((String)fileId1, (String)HoodieFileFormat.HOODIE_LOG.getFileExtension(), (String)commitTime2, (int)2, (String)TEST_WRITE_TOKEN);
        new File(this.basePath + "/" + partitionPath + "/" + logFileName3).createNewFile();
        expectedState.logFilesCurrentlyPresent.add(logFileName3);
        commitTimeline = this.metaClient.getActiveTimeline();
        commitMetadata = new HoodieCommitMetadata();
        commitMetadata.addWriteStat(partitionPath, this.getHoodieWriteStat(partitionPath, fileId1, logFileName3));
        HoodieInstant instant2 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", commitTime2);
        this.saveAsComplete(commitTimeline, instant2, commitMetadata);
        this.verifyFileSystemView(partitionPath, expectedState, fileSystemView);
        List<Object> logFiles = Stream.of(this.basePath + "/" + partitionPath + "/" + logFileName1, this.basePath + "/" + partitionPath + "/" + logFileName3).map(HoodieLogFile::new).collect(Collectors.toList());
        CompactionOperation compactionOperation = new CompactionOperation(Option.empty(), partitionPath, logFiles, Collections.emptyMap());
        HoodieCompactionPlan compactionPlan = this.getHoodieCompactionPlan(Collections.singletonList(compactionOperation));
        expectedState.pendingCompactionFgIdsCurrentlyPresent.add(fileId1);
        String commitTime3 = "003";
        HoodieInstant compactionInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "compaction", commitTime3);
        HoodieInstant compactionRequested = HoodieTestUtils.INSTANT_GENERATOR.getCompactionRequestedInstant(compactionInstant.requestedTime());
        this.metaClient.getActiveTimeline().saveToCompactionRequested(compactionRequested, compactionPlan);
        this.metaClient.getActiveTimeline().transitionCompactionRequestedToInflight(compactionRequested);
        this.verifyFileSystemView(partitionPath, expectedState, fileSystemView);
        logFiles = Collections.singletonList(new HoodieLogFile(this.basePath + "/" + partitionPath + "/" + logFileName2));
        CompactionOperation logCompactionOperation = new CompactionOperation(Option.empty(), partitionPath, logFiles, Collections.emptyMap());
        HoodieCompactionPlan logCompactionPlan = this.getHoodieCompactionPlan(Collections.singletonList(logCompactionOperation));
        expectedState.pendingLogCompactionFgIdsCurrentlyPresent.add(fileId2);
        String commitTime4 = "004";
        HoodieInstant logCompactionInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "logcompaction", commitTime4);
        HoodieInstant logCompactionRequested = HoodieTestUtils.INSTANT_GENERATOR.getLogCompactionRequestedInstant(logCompactionInstant.requestedTime());
        this.metaClient.getActiveTimeline().saveToLogCompactionRequested(logCompactionRequested, logCompactionPlan);
        this.metaClient.getActiveTimeline().transitionLogCompactionRequestedToInflight(logCompactionRequested);
        this.verifyFileSystemView(partitionPath, expectedState, fileSystemView);
        fileSystemView.close();
    }

    private HoodieCompactionPlan getHoodieCompactionPlan(List<CompactionOperation> operations) {
        return HoodieCompactionPlan.newBuilder().setOperations(operations.stream().map(CompactionUtils::buildHoodieCompactionOperation).collect(Collectors.toList())).setVersion(CompactionUtils.LATEST_COMPACTION_METADATA_VERSION).build();
    }

    private HoodieWriteStat getHoodieWriteStat(String partitionPath, String fileId, String relativeFilePath) {
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId(fileId);
        writeStat.setPath(partitionPath + "/" + relativeFilePath);
        writeStat.setPartitionPath(partitionPath);
        return writeStat;
    }

    @Test
    public void testGetLatestMergedFileSlicesBeforeOrOnIncludingInflight() throws IOException {
        String partitionPath = "2023/01/01";
        String fileId = UUID.randomUUID().toString();
        String instantTime1 = "001";
        String instantTime2 = "002";
        String compactionInstant = "003";
        String instantTime4 = "004";
        String instantTime5 = "005";
        String instantTime6 = "006";
        new File(this.basePath + "/" + partitionPath).mkdirs();
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        String baseFileName = FSUtils.makeBaseFileName((String)instantTime1, (String)TEST_WRITE_TOKEN, (String)fileId, (String)BASE_FILE_EXTENSION);
        new File(this.basePath + "/" + partitionPath + "/" + baseFileName).createNewFile();
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", instantTime1);
        this.saveAsComplete(commitTimeline, instant1, new HoodieCommitMetadata());
        HoodieInstant instant2 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", instantTime2);
        String logFileName2 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)instantTime2, (int)1, (String)TEST_WRITE_TOKEN);
        new File(this.basePath + "/" + partitionPath + "/" + logFileName2).createNewFile();
        this.saveAsComplete(commitTimeline, instant2, new HoodieCommitMetadata());
        this.refreshFsView();
        List actual = this.fsView.getLatestMergedFileSlicesBeforeOrOn(partitionPath, instantTime2).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)actual.size());
        FileSlice fileSlice = (FileSlice)actual.get(0);
        Assertions.assertTrue((boolean)fileSlice.getBaseFile().isPresent());
        Assertions.assertEquals((Object)baseFileName, (Object)((HoodieBaseFile)fileSlice.getBaseFile().get()).getFileName());
        Assertions.assertEquals((long)1L, (long)fileSlice.getLogFiles().count());
        Assertions.assertEquals((Object)logFileName2, (Object)((HoodieLogFile)fileSlice.getLogFiles().collect(Collectors.toList()).get(0)).getFileName());
        actual = this.fsView.getLatestMergedFileSlicesBeforeOrOnIncludingInflight(partitionPath, instantTime2, instantTime2).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)actual.size());
        fileSlice = (FileSlice)actual.get(0);
        Assertions.assertTrue((boolean)fileSlice.getBaseFile().isPresent());
        Assertions.assertEquals((Object)baseFileName, (Object)((HoodieBaseFile)fileSlice.getBaseFile().get()).getFileName());
        Assertions.assertEquals((long)1L, (long)fileSlice.getLogFiles().count());
        Assertions.assertEquals((Object)logFileName2, (Object)((HoodieLogFile)fileSlice.getLogFiles().collect(Collectors.toList()).get(0)).getFileName());
        List fileSlices = this.rtView.getLatestFileSlices(partitionPath).collect(Collectors.toList());
        ArrayList<Pair> partitionFileSlicesPairs = new ArrayList<Pair>();
        partitionFileSlicesPairs.add(Pair.of((Object)partitionPath, fileSlices.get(0)));
        HoodieCompactionPlan compactionPlan = CompactionUtils.buildFromFileSlices(partitionFileSlicesPairs, (Option)Option.empty(), (Option)Option.empty());
        HoodieInstant compactionRequestedInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "compaction", compactionInstant);
        commitTimeline.createNewInstant(compactionRequestedInstant);
        commitTimeline.saveToCompactionRequested(compactionRequestedInstant, compactionPlan);
        commitTimeline.transitionRequestedToInflight(compactionRequestedInstant, Option.empty());
        String baseFileName2 = FSUtils.makeBaseFileName((String)compactionInstant, (String)TEST_WRITE_TOKEN, (String)fileId, (String)BASE_FILE_EXTENSION);
        new File(this.basePath + "/" + partitionPath + "/" + baseFileName2).createNewFile();
        HoodieInstant instant4 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", instantTime4);
        String logFileName4 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)instantTime4, (int)1, (String)TEST_WRITE_TOKEN);
        new File(this.basePath + "/" + partitionPath + "/" + logFileName4).createNewFile();
        this.saveAsComplete(commitTimeline, instant4, new HoodieCommitMetadata());
        String logFileName5 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)instantTime5, (int)1, (String)TEST_WRITE_TOKEN);
        new File(this.basePath + "/" + partitionPath + "/" + logFileName5).createNewFile();
        commitTimeline.createNewInstant(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "deltacommit", instantTime5));
        commitTimeline.createNewInstant(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", instantTime5));
        String logFileName6 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)instantTime5, (int)1, (String)TEST_WRITE_TOKEN);
        new File(this.basePath + "/" + partitionPath + "/" + logFileName6).createNewFile();
        commitTimeline.createNewInstant(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "deltacommit", instantTime6));
        commitTimeline.createNewInstant(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", instantTime6));
        this.refreshFsView();
        actual = this.fsView.getLatestMergedFileSlicesBeforeOrOn(partitionPath, instantTime5).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)actual.size());
        fileSlice = (FileSlice)actual.get(0);
        Assertions.assertTrue((boolean)fileSlice.getBaseFile().isPresent());
        Assertions.assertEquals((Object)baseFileName, (Object)((HoodieBaseFile)fileSlice.getBaseFile().get()).getFileName());
        Assertions.assertEquals((long)2L, (long)fileSlice.getLogFiles().count());
        Assertions.assertEquals(Arrays.asList(logFileName2, logFileName4), fileSlice.getLogFiles().map(HoodieLogFile::getFileName).sorted().collect(Collectors.toList()));
        actual = this.fsView.getLatestMergedFileSlicesBeforeOrOnIncludingInflight(partitionPath, instantTime5, instantTime5).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)actual.size());
        fileSlice = (FileSlice)actual.get(0);
        Assertions.assertTrue((boolean)fileSlice.getBaseFile().isPresent());
        Assertions.assertEquals((Object)baseFileName, (Object)((HoodieBaseFile)fileSlice.getBaseFile().get()).getFileName());
        Assertions.assertEquals((long)3L, (long)fileSlice.getLogFiles().count());
        Assertions.assertEquals(Arrays.asList(logFileName2, logFileName4, logFileName5), fileSlice.getLogFiles().map(HoodieLogFile::getFileName).sorted().collect(Collectors.toList()));
        actual = this.fsView.getLatestMergedFileSlicesBeforeOrOnIncludingInflight(partitionPath, instantTime5, compactionInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)actual.size());
        fileSlice = (FileSlice)actual.get(0);
        Assertions.assertTrue((boolean)fileSlice.getBaseFile().isPresent());
        Assertions.assertEquals((Object)baseFileName2, (Object)((HoodieBaseFile)fileSlice.getBaseFile().get()).getFileName());
        Assertions.assertEquals((long)2L, (long)fileSlice.getLogFiles().count());
        Assertions.assertEquals(Arrays.asList(logFileName4, logFileName5), fileSlice.getLogFiles().map(HoodieLogFile::getFileName).sorted().collect(Collectors.toList()));
        commitTimeline.saveAsComplete(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "compaction", compactionInstant), Option.empty());
        this.refreshFsView();
        actual = this.fsView.getLatestMergedFileSlicesBeforeOrOn(partitionPath, instantTime5).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)actual.size());
        fileSlice = (FileSlice)actual.get(0);
        Assertions.assertTrue((boolean)fileSlice.getBaseFile().isPresent());
        Assertions.assertEquals((Object)baseFileName2, (Object)((HoodieBaseFile)fileSlice.getBaseFile().get()).getFileName());
        Assertions.assertEquals((long)1L, (long)fileSlice.getLogFiles().count());
        Assertions.assertEquals((Object)logFileName4, (Object)((HoodieLogFile)fileSlice.getLogFiles().collect(Collectors.toList()).get(0)).getFileName());
        actual = this.fsView.getLatestMergedFileSlicesBeforeOrOnIncludingInflight(partitionPath, instantTime5, instantTime5).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)actual.size());
        fileSlice = (FileSlice)actual.get(0);
        Assertions.assertTrue((boolean)fileSlice.getBaseFile().isPresent());
        Assertions.assertEquals((Object)baseFileName2, (Object)((HoodieBaseFile)fileSlice.getBaseFile().get()).getFileName());
        Assertions.assertEquals((long)2L, (long)fileSlice.getLogFiles().count());
        Assertions.assertEquals(Arrays.asList(logFileName4, logFileName5), fileSlice.getLogFiles().map(HoodieLogFile::getFileName).sorted().collect(Collectors.toList()));
    }

    protected void verifyFileSystemView(String partitionPath, FileSystemViewExpectedState expectedState, SyncableFileSystemView tableFileSystemView) {
        tableFileSystemView.sync();
        Assertions.assertEquals(expectedState.baseFilesCurrentlyPresent, tableFileSystemView.getLatestBaseFiles(partitionPath).map(BaseFile::getFileName).collect(Collectors.toSet()));
        Assertions.assertEquals(expectedState.logFilesCurrentlyPresent, tableFileSystemView.getAllFileSlices(partitionPath).flatMap(FileSlice::getLogFiles).map(logFile -> logFile.getPath().getName()).collect(Collectors.toSet()));
        Assertions.assertEquals(expectedState.pendingCompactionFgIdsCurrentlyPresent, tableFileSystemView.getPendingCompactionOperations().map(pair -> ((CompactionOperation)pair.getValue()).getFileGroupId().getFileId()).collect(Collectors.toSet()));
        Assertions.assertEquals(expectedState.pendingLogCompactionFgIdsCurrentlyPresent, tableFileSystemView.getPendingLogCompactionOperations().map(pair -> ((CompactionOperation)pair.getValue()).getFileGroupId().getFileId()).collect(Collectors.toSet()));
    }

    @Override
    protected HoodieTableType getTableType() {
        return HoodieTableType.MERGE_ON_READ;
    }

    static class FileSystemViewExpectedState {
        Set<String> logFilesCurrentlyPresent = new HashSet<String>();
        Set<String> baseFilesCurrentlyPresent = new HashSet<String>();
        Set<String> pendingCompactionFgIdsCurrentlyPresent = new HashSet<String>();
        Set<String> pendingLogCompactionFgIdsCurrentlyPresent = new HashSet<String>();

        FileSystemViewExpectedState() {
        }
    }
}

