/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.HoodieLogFormatWriter;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieCDCDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieHFileDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.log.block.HoodieParquetDataBlock;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieCommonTestHarness {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieCommonTestHarness.class);
    protected static final String BASE_FILE_EXTENSION = ((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension();
    protected static ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = null;
    protected static final HoodieLogBlock.HoodieLogBlockType DEFAULT_DATA_BLOCK_TYPE = HoodieLogBlock.HoodieLogBlockType.AVRO_DATA_BLOCK;
    protected String tableName;
    protected String basePath;
    protected URI baseUri;
    protected HoodieTestDataGenerator dataGen;
    protected HoodieTableMetaClient metaClient;
    private HoodieEngineContext engineContext;
    @TempDir
    public Path tempDir;
    protected StorageConfiguration<Configuration> storageConf;
    protected HoodieStorage storage;

    protected void setTableName(String tableName) {
        this.tableName = tableName;
    }

    protected void initPath() {
        this.initPath("dataset");
    }

    protected void initPath(String folderName) {
        try {
            Path basePath = this.tempDir.resolve(folderName);
            Files.createDirectories(basePath, new FileAttribute[0]);
            this.basePath = basePath.toAbsolutePath().toString();
            this.baseUri = basePath.toUri();
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    protected static String padWithLeadingZeros(String number, int length) {
        if (number == null) {
            throw new IllegalArgumentException("Input number cannot be null");
        }
        if (number.length() > length) {
            throw new IllegalArgumentException("Input number length " + number.length() + " is greater than desired length " + length);
        }
        return String.format("%0" + length + "d", Long.parseLong(number));
    }

    public static String incTimestampStrByOne(String timestamp) {
        return HoodieCommonTestHarness.padWithLeadingZeros(Integer.toString(Integer.parseInt(timestamp) + 1), timestamp.length());
    }

    protected void initTestDataGenerator() {
        this.dataGen = new HoodieTestDataGenerator();
    }

    protected void initTestDataGenerator(String[] partitionPaths) {
        this.dataGen = new HoodieTestDataGenerator(partitionPaths);
    }

    protected void cleanupTestDataGenerator() {
        if (this.dataGen != null) {
            this.dataGen = null;
        }
    }

    protected void initMetaClient() throws IOException {
        if (this.basePath == null) {
            this.initPath();
        }
        this.metaClient = HoodieTestUtils.init((String)this.basePath, (HoodieTableType)this.getTableType());
    }

    protected void initMetaClient(boolean preTableVersion8) throws IOException {
        this.initMetaClient(preTableVersion8, this.getTableType());
    }

    protected void initMetaClient(boolean preTableVersion8, HoodieTableType tableType) throws IOException {
        if (this.basePath == null) {
            this.initPath();
        }
        this.metaClient = HoodieTestUtils.init((String)this.basePath, (HoodieTableType)tableType, (String)"", (boolean)false, null, (String)"datestr", (Option)(preTableVersion8 ? Option.of((Object)HoodieTableVersion.SIX) : Option.of((Object)HoodieTableVersion.current())));
    }

    protected void cleanMetaClient() {
        if (this.metaClient != null) {
            this.metaClient = null;
        }
    }

    protected void refreshFsView() throws IOException {
        this.metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)this.metaClient.getStorageConf(), (String)this.basePath);
    }

    protected SyncableFileSystemView getFileSystemView(HoodieTimeline timeline) throws IOException {
        return this.getFileSystemView(timeline, false);
    }

    protected SyncableFileSystemView getFileSystemView(HoodieTimeline timeline, boolean enableIncrementalTimelineSync) {
        return HoodieTableFileSystemView.fileListingBasedFileSystemView((HoodieEngineContext)this.getEngineContext(), (HoodieTableMetaClient)this.metaClient, (HoodieTimeline)timeline, (boolean)enableIncrementalTimelineSync);
    }

    protected SyncableFileSystemView getFileSystemView(HoodieTableMetaClient metaClient) throws IOException {
        return this.getFileSystemView(metaClient, metaClient.getActiveTimeline().filterCompletedOrMajorOrMinorCompactionInstants());
    }

    protected SyncableFileSystemView getFileSystemView(HoodieTableMetaClient metaClient, HoodieTimeline timeline) throws IOException {
        return this.getFileSystemView(timeline, true);
    }

    protected SyncableFileSystemView getFileSystemViewWithUnCommittedSlices(HoodieTableMetaClient metaClient) {
        try {
            return new HoodieTableFileSystemView(metaClient, (HoodieTimeline)metaClient.getActiveTimeline(), HoodieTestTable.of(metaClient).listAllBaseAndLogFiles());
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Error getting file system view", ioe);
        }
    }

    protected HoodieTableType getTableType() {
        return HoodieTableType.COPY_ON_WRITE;
    }

    public void pollTimelineForAction(String tablePath, StorageConfiguration<?> conf, int numCommits, String action) throws InterruptedException {
        this.pollForTimeline(tablePath, conf, numCommits, instant -> instant.getAction().equals(action), true);
    }

    public void pollForTimeline(String tablePath, StorageConfiguration<?> conf, int commits) throws InterruptedException {
        this.pollForTimeline(tablePath, conf, commits, instant -> true, false);
    }

    private void pollForTimeline(String tablePath, StorageConfiguration<?> conf, int commits, Predicate<HoodieInstant> filter, boolean pullAllCommits) throws InterruptedException {
        Semaphore semaphore = new Semaphore(1);
        semaphore.acquire();
        ScheduledFuture<?> scheduledFuture = this.getScheduledExecutorService().scheduleWithFixedDelay(() -> {
            try {
                HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(conf).setBasePath(tablePath).build();
                HoodieTimeline timeline = pullAllCommits ? metaClient.getActiveTimeline().getAllCommitsTimeline() : metaClient.getActiveTimeline().getCommitsTimeline();
                List instants = timeline.filterCompletedInstants().getInstants().stream().filter(filter::test).collect(Collectors.toList());
                if (instants.size() >= commits) {
                    semaphore.release();
                }
            }
            catch (Exception e) {
                LOG.warn("Error in polling for timeline", (Throwable)e);
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        int maxWaitInMinutes = 10;
        boolean timelineFound = semaphore.tryAcquire(maxWaitInMinutes, TimeUnit.MINUTES);
        scheduledFuture.cancel(true);
        if (!timelineFound) {
            throw new RuntimeException(String.format("Failed to create timeline in %d minutes", maxWaitInMinutes));
        }
    }

    protected ScheduledThreadPoolExecutor getScheduledExecutorService() {
        if (scheduledThreadPoolExecutor == null || scheduledThreadPoolExecutor.isShutdown()) {
            scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(2);
            scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
        }
        return scheduledThreadPoolExecutor;
    }

    protected HoodieActiveTimeline getActiveTimeline() {
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        return this.metaClient.getActiveTimeline();
    }

    protected Boolean hasPendingCommitsOrRollbacks() {
        HoodieActiveTimeline timeline = this.getActiveTimeline();
        if (timeline.getRollbackTimeline().empty()) {
            HoodieTimeline completedTimeline = timeline.filterCompletedInstants();
            Set completedInstants = completedTimeline.getInstants().stream().map(HoodieInstant::requestedTime).collect(Collectors.toSet());
            List pendingInstants = timeline.getInstants().stream().map(HoodieInstant::requestedTime).filter(t -> !completedInstants.contains(t)).collect(Collectors.toList());
            return !pendingInstants.isEmpty();
        }
        return true;
    }

    protected HoodieEngineContext getEngineContext() {
        if (this.engineContext == null) {
            this.engineContext = new HoodieLocalEngineContext((StorageConfiguration)new HadoopStorageConfiguration(Boolean.valueOf(false)));
        }
        return this.engineContext;
    }

    protected static List<HoodieLogFile> writeLogFiles(StoragePath partitionPath, Schema recordSchema, Schema writerSchema, List<HoodieRecord> records, int numFiles, HoodieStorage storage, Properties props, String fileId, String commitTime) throws IOException, InterruptedException {
        List<IndexedRecord> indexedRecords = records.stream().map(record -> (IndexedRecord)record.rewriteRecordWithNewSchema(recordSchema, props, writerSchema).getData()).collect(Collectors.toList());
        return HoodieCommonTestHarness.writeLogFiles(partitionPath, writerSchema, indexedRecords, numFiles, storage, fileId, commitTime, "100");
    }

    protected static List<HoodieLogFile> writeLogFiles(StoragePath partitionPath, Schema schema, List<IndexedRecord> records, int numFiles, HoodieStorage storage) throws IOException, InterruptedException {
        return HoodieCommonTestHarness.writeLogFiles(partitionPath, schema, records, numFiles, storage, "test-fileid1", "100", "100");
    }

    protected static List<HoodieLogFile> writeLogFiles(StoragePath partitionPath, Schema schema, List<IndexedRecord> records, int numFiles, HoodieStorage storage, String fileId, String commitTime, String logBlockInstantTime) throws IOException, InterruptedException {
        HoodieLogFormat.Writer writer = HoodieLogFormat.newWriterBuilder().onParentPath(partitionPath).withFileExtension(".log").withSizeThreshold(1024L).withFileId(fileId).withInstantTime(commitTime).withStorage(storage).build();
        if (storage.exists(writer.getLogFile().getPath())) {
            ((HoodieLogFormatWriter)writer).withOutputStream((FSDataOutputStream)storage.append(writer.getLogFile().getPath()));
        }
        HashMap<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>();
        header.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, logBlockInstantTime);
        header.put(HoodieLogBlock.HeaderMetadataType.SCHEMA, schema.toString());
        ArrayList<HoodieLogFile> logFiles = new ArrayList<HoodieLogFile>();
        int recordsPerFile = records.size() / numFiles;
        for (int filesWritten = 0; filesWritten < numFiles; ++filesWritten) {
            int targetRecordsCount = filesWritten == numFiles - 1 ? recordsPerFile + records.size() % recordsPerFile : recordsPerFile;
            int offset = filesWritten * recordsPerFile;
            List<IndexedRecord> targetRecords = records.subList(offset, offset + targetRecordsCount);
            logFiles.add(writer.getLogFile());
            writer.appendBlock((HoodieLogBlock)HoodieCommonTestHarness.getDataBlock(DEFAULT_DATA_BLOCK_TYPE, targetRecords, header));
        }
        writer.close();
        return logFiles;
    }

    public static HoodieDataBlock getDataBlock(HoodieLogBlock.HoodieLogBlockType dataBlockType, List<IndexedRecord> records, Map<HoodieLogBlock.HeaderMetadataType, String> header) {
        return HoodieCommonTestHarness.getDataBlock(dataBlockType, records.stream().map(HoodieAvroIndexedRecord::new).collect(Collectors.toList()), header, new StoragePath("dummy_path"));
    }

    private static HoodieDataBlock getDataBlock(HoodieLogBlock.HoodieLogBlockType dataBlockType, List<HoodieRecord> records, Map<HoodieLogBlock.HeaderMetadataType, String> header, StoragePath pathForReader) {
        switch (dataBlockType) {
            case CDC_DATA_BLOCK: {
                return new HoodieCDCDataBlock(records, header, HoodieRecord.RECORD_KEY_METADATA_FIELD);
            }
            case AVRO_DATA_BLOCK: {
                return new HoodieAvroDataBlock(records, header, HoodieRecord.RECORD_KEY_METADATA_FIELD);
            }
            case HFILE_DATA_BLOCK: {
                return new HoodieHFileDataBlock(records, header, (String)HoodieStorageConfig.HFILE_COMPRESSION_ALGORITHM_NAME.defaultValue(), pathForReader);
            }
            case PARQUET_DATA_BLOCK: {
                return new HoodieParquetDataBlock(records, header, HoodieRecord.RECORD_KEY_METADATA_FIELD, (String)HoodieStorageConfig.PARQUET_COMPRESSION_CODEC_NAME.defaultValue(), 0.1, true);
            }
        }
        throw new RuntimeException("Unknown data block type " + dataBlockType);
    }

    public Option<HoodieCommitMetadata> getCommitMetadata(String basePath, String partition, String commitTs, int count, Map<String, String> extraMetadata) throws IOException {
        return HoodieCommonTestHarness.getCommitMetadata(this.metaClient, basePath, partition, commitTs, count, extraMetadata);
    }

    public static Option<HoodieCommitMetadata> getCommitMetadata(HoodieTableMetaClient metaClient, String basePath, String partition, String commitTs, int count, Map<String, String> extraMetadata) throws IOException {
        HoodieCommitMetadata commit = new HoodieCommitMetadata();
        for (int i = 1; i <= count; ++i) {
            HoodieWriteStat stat = new HoodieWriteStat();
            stat.setFileId(i + "");
            stat.setPartitionPath(Paths.get(basePath, partition).toString());
            stat.setPath(commitTs + "." + i + metaClient.getTableConfig().getBaseFileFormat().getFileExtension());
            commit.addWriteStat(partition, stat);
        }
        for (Map.Entry<String, String> extraEntries : extraMetadata.entrySet()) {
            commit.addMetadata(extraEntries.getKey(), extraEntries.getValue());
        }
        return Option.of((Object)commit);
    }
}

