/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils.reader;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.read.HoodieFileGroupReader;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.reader.DataGenerationPlan;
import org.apache.hudi.common.testutils.reader.HoodieFileSliceTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.junit.jupiter.api.AfterAll;

public class HoodieFileGroupReaderTestHarness
extends HoodieCommonTestHarness {
    protected static final String PARTITION_PATH = "any-partition-path";
    protected static final String FILE_ID = "any-file-1";
    protected static List<HoodieFileSliceTestUtils.KeyRange> keyRanges;
    protected static List<Long> timestamps;
    protected static List<DataGenerationPlan.OperationType> operationTypes;
    protected static List<String> instantTimes;
    protected List<Boolean> shouldWritePositions;
    protected static StorageConfiguration<?> storageConf;
    protected static HoodieTestTable testTable;
    protected static TypedProperties properties;
    protected HoodieReaderContext<IndexedRecord> readerContext;

    @AfterAll
    public static void tearDown() throws IOException {
        FileSystem.closeAll();
    }

    @Override
    protected HoodieTableType getTableType() {
        return HoodieTableType.MERGE_ON_READ;
    }

    protected Properties getMetaProps() {
        return new Properties();
    }

    @Override
    protected void initMetaClient() throws IOException {
        Properties metaProps = this.getMetaProps();
        metaProps.setProperty(HoodieTableConfig.POPULATE_META_FIELDS.key(), "false");
        metaProps.setProperty(HoodieTableConfig.RECORDKEY_FIELDS.key(), "_row_key");
        if (this.basePath == null) {
            this.initPath();
        }
        this.metaClient = HoodieTestUtils.init((StorageConfiguration)HoodieTestUtils.getDefaultStorageConf(), (String)this.basePath, (HoodieTableType)this.getTableType(), (Properties)metaProps);
    }

    protected void setUpMockCommits() throws Exception {
        for (String instantTime : instantTimes) {
            testTable.addDeltaCommit(instantTime);
        }
    }

    protected ClosableIterator<IndexedRecord> getFileGroupIterator(int numFiles) throws IOException, InterruptedException {
        return this.getFileGroupIterator(numFiles, false);
    }

    protected ClosableIterator<IndexedRecord> getFileGroupIterator(int numFiles, boolean shouldReadPositions) throws IOException, InterruptedException {
        return this.getFileGroupIterator(numFiles, shouldReadPositions, false);
    }

    protected ClosableIterator<IndexedRecord> getFileGroupIterator(int numFiles, boolean shouldReadPositions, boolean allowInflightCommits) throws IOException, InterruptedException {
        assert (numFiles >= 1 && numFiles <= keyRanges.size());
        HoodieHadoopStorage hoodieStorage = new HoodieHadoopStorage(this.basePath, storageConf);
        Option fileSliceOpt = HoodieFileSliceTestUtils.getFileSlice((HoodieStorage)hoodieStorage, keyRanges.subList(0, numFiles), timestamps.subList(0, numFiles), operationTypes.subList(0, numFiles), instantTimes.subList(0, numFiles), this.shouldWritePositions.subList(0, numFiles), (String)this.basePath, (String)PARTITION_PATH, (String)FILE_ID);
        properties.setProperty(HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE.key(), String.valueOf(1048576000));
        properties.setProperty(HoodieMemoryConfig.SPILLABLE_MAP_BASE_PATH.key(), this.basePath + "/" + ".hoodie/.temp");
        properties.setProperty(HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.key(), ExternalSpillableMap.DiskMapType.ROCKS_DB.name());
        properties.setProperty(HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.key(), "false");
        HoodieFileGroupReader fileGroupReader = HoodieFileGroupReader.newBuilder().withReaderContext(this.readerContext).withHoodieTableMetaClient(this.metaClient).withLatestCommitTime("1000").withFileSlice((FileSlice)fileSliceOpt.orElseThrow(() -> new IllegalArgumentException("FileSlice is not present"))).withDataSchema(HoodieTestDataGenerator.AVRO_SCHEMA).withRequestedSchema(HoodieTestDataGenerator.AVRO_SCHEMA).withProps(properties).withShouldUseRecordPosition(shouldReadPositions).withAllowInflightInstants(allowInflightCommits).build();
        return fileGroupReader.getClosableIterator();
    }

    static {
        storageConf = HoodieTestUtils.getDefaultStorageConf();
        properties = new TypedProperties();
    }
}

