/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.minicluster.HdfsTestService;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.StoragePath;
import org.junit.Rule;
import org.junit.contrib.java.lang.system.EnvironmentVariables;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestDFSPropertiesConfiguration {
    private static String dfsBasePath;
    private static HdfsTestService hdfsTestService;
    private static MiniDFSCluster dfsCluster;
    private static DistributedFileSystem dfs;
    @Rule
    public static final EnvironmentVariables ENVIRONMENT_VARIABLES;

    @BeforeAll
    public static void initClass() throws Exception {
        if (HoodieTestUtils.shouldUseExternalHdfs()) {
            dfs = HoodieTestUtils.useExternalHdfs();
        } else {
            hdfsTestService = new HdfsTestService();
            dfsCluster = hdfsTestService.start(true);
            dfs = dfsCluster.getFileSystem();
        }
        dfsBasePath = dfs.getWorkingDirectory().toString();
        dfs.mkdirs(new Path(dfsBasePath));
        Path filePath = new Path(dfsBasePath + "/t1.props");
        TestDFSPropertiesConfiguration.writePropertiesFile(filePath, new String[]{"", "#comment", "abc", "int.prop=123", "double.prop=113.4", "string.prop=str", "boolean.prop=true", "long.prop=1354354354"});
        filePath = new Path(dfsBasePath + "/t2.props");
        TestDFSPropertiesConfiguration.writePropertiesFile(filePath, new String[]{"string.prop=ignored", "include=" + dfsBasePath + "/t1.props"});
        filePath = new Path(dfsBasePath + "/t3.props");
        TestDFSPropertiesConfiguration.writePropertiesFile(filePath, new String[]{"double.prop=838.3", "include=t2.props", "double.prop=243.4", "string.prop=t3.value"});
        filePath = new Path(dfsBasePath + "/t4.props");
        TestDFSPropertiesConfiguration.writePropertiesFile(filePath, new String[]{"double.prop=838.3", "include = t4.props"});
    }

    @AfterAll
    public static void cleanupClass() {
        if (hdfsTestService != null) {
            hdfsTestService.stop();
        }
    }

    @AfterEach
    public void cleanupGlobalConfig() {
        DFSPropertiesConfiguration.clearGlobalProps();
    }

    private static void writePropertiesFile(Path path, String[] lines) throws IOException {
        PrintStream out = new PrintStream((OutputStream)dfs.create(path, true));
        for (String line : lines) {
            out.println(line);
        }
        out.flush();
        out.close();
    }

    @Test
    public void testParsing() {
        DFSPropertiesConfiguration cfg = new DFSPropertiesConfiguration(dfs.getConf(), new StoragePath(dfsBasePath + "/t1.props"));
        TypedProperties props = cfg.getProps();
        Assertions.assertEquals((int)5, (int)props.size());
        Assertions.assertThrows(IllegalArgumentException.class, () -> props.getString("invalid.key"), (String)"Should error out here.");
        Assertions.assertEquals((int)123, (int)props.getInteger("int.prop"));
        Assertions.assertEquals((double)113.4, (double)props.getDouble("double.prop"), (double)0.001);
        Assertions.assertTrue((boolean)props.getBoolean("boolean.prop"));
        Assertions.assertEquals((Object)"str", (Object)props.getString("string.prop"));
        Assertions.assertEquals((long)1354354354L, (long)props.getLong("long.prop"));
        Assertions.assertEquals((int)123, (int)props.getInteger("int.prop", 456));
        Assertions.assertEquals((double)113.4, (double)props.getDouble("double.prop", 223.4), (double)0.001);
        Assertions.assertTrue((boolean)props.getBoolean("boolean.prop", false));
        Assertions.assertEquals((Object)"str", (Object)props.getString("string.prop", "default"));
        Assertions.assertEquals((long)1354354354L, (long)props.getLong("long.prop", 8578494434L));
        Assertions.assertEquals((int)456, (int)props.getInteger("bad.int.prop", 456));
        Assertions.assertEquals((double)223.4, (double)props.getDouble("bad.double.prop", 223.4), (double)0.001);
        Assertions.assertFalse((boolean)props.getBoolean("bad.boolean.prop", false));
        Assertions.assertEquals((Object)"default", (Object)props.getString("bad.string.prop", "default"));
        Assertions.assertEquals((long)8578494434L, (long)props.getLong("bad.long.prop", 8578494434L));
    }

    @Test
    public void testIncludes() {
        DFSPropertiesConfiguration cfg = new DFSPropertiesConfiguration(dfs.getConf(), new StoragePath(dfsBasePath + "/t3.props"));
        TypedProperties props = cfg.getProps();
        Assertions.assertEquals((int)123, (int)props.getInteger("int.prop"));
        Assertions.assertEquals((double)243.4, (double)props.getDouble("double.prop"), (double)0.001);
        Assertions.assertTrue((boolean)props.getBoolean("boolean.prop"));
        Assertions.assertEquals((Object)"t3.value", (Object)props.getString("string.prop"));
        Assertions.assertEquals((long)1354354354L, (long)props.getLong("long.prop"));
        Assertions.assertThrows(IllegalStateException.class, () -> cfg.addPropsFromFile(new StoragePath(dfsBasePath + "/t4.props")), (String)"Should error out on a self-included file.");
    }

    @Test
    public void testLocalFileSystemLoading() throws IOException {
        DFSPropertiesConfiguration cfg = new DFSPropertiesConfiguration(dfs.getConf(), new StoragePath(dfsBasePath + "/t1.props"));
        cfg.addPropsFromFile(new StoragePath(String.format("file:%s", this.getClass().getClassLoader().getResource("props/testdfs.properties").getPath())));
        TypedProperties props = cfg.getProps();
        Assertions.assertEquals((int)123, (int)props.getInteger("int.prop"));
        Assertions.assertEquals((double)113.4, (double)props.getDouble("double.prop"), (double)0.001);
        Assertions.assertTrue((boolean)props.getBoolean("boolean.prop"));
        Assertions.assertEquals((Object)"str", (Object)props.getString("string.prop"));
        Assertions.assertEquals((long)1354354354L, (long)props.getLong("long.prop"));
        Assertions.assertEquals((int)123, (int)props.getInteger("some.random.prop"));
    }

    @Test
    public void testNoGlobalConfFileConfigured() {
        ENVIRONMENT_VARIABLES.clear(new String[]{"HUDI_CONF_DIR"});
        DFSPropertiesConfiguration.refreshGlobalProps();
        try {
            if (!HoodieTestUtils.getStorage((StoragePath)DFSPropertiesConfiguration.DEFAULT_PATH).exists(DFSPropertiesConfiguration.DEFAULT_PATH)) {
                Assertions.assertEquals((int)0, (int)DFSPropertiesConfiguration.getGlobalProps().size());
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Cannot check if the default config file exist: " + DFSPropertiesConfiguration.DEFAULT_PATH);
        }
    }

    @Test
    public void testLoadGlobalConfFile() {
        String testPropsFilePath = new File("src/test/resources/external-config").getAbsolutePath();
        ENVIRONMENT_VARIABLES.set("HUDI_CONF_DIR", testPropsFilePath);
        DFSPropertiesConfiguration.refreshGlobalProps();
        Assertions.assertEquals((int)5, (int)DFSPropertiesConfiguration.getGlobalProps().size());
        Assertions.assertEquals((Object)"jdbc:hive2://localhost:10000", (Object)DFSPropertiesConfiguration.getGlobalProps().get((Object)"hoodie.datasource.hive_sync.jdbcurl"));
        Assertions.assertEquals((Object)"true", (Object)DFSPropertiesConfiguration.getGlobalProps().get((Object)"hoodie.datasource.hive_sync.use_jdbc"));
        Assertions.assertEquals((Object)"false", (Object)DFSPropertiesConfiguration.getGlobalProps().get((Object)"hoodie.datasource.hive_sync.support_timestamp"));
        Assertions.assertEquals((Object)"BLOOM", (Object)DFSPropertiesConfiguration.getGlobalProps().get((Object)"hoodie.index.type"));
        Assertions.assertEquals((Object)"true", (Object)DFSPropertiesConfiguration.getGlobalProps().get((Object)"hoodie.metadata.enable"));
    }

    @Test
    public void testDefaultConstructorHandlesIncludes() {
        DFSPropertiesConfiguration cfg = new DFSPropertiesConfiguration();
        cfg.addPropsFromFile(new StoragePath(dfsBasePath + "/t3.props"));
        TypedProperties props = cfg.getProps();
        Assertions.assertEquals((int)123, (int)props.getInteger("int.prop"));
        Assertions.assertEquals((double)243.4, (double)props.getDouble("double.prop"), (double)0.001);
        Assertions.assertTrue((boolean)props.getBoolean("boolean.prop"));
        Assertions.assertEquals((Object)"t3.value", (Object)props.getString("string.prop"));
        Assertions.assertEquals((long)1354354354L, (long)props.getLong("long.prop"));
        Assertions.assertThrows(IllegalStateException.class, () -> cfg.addPropsFromFile(new StoragePath(dfsBasePath + "/t4.props")));
    }

    static {
        ENVIRONMENT_VARIABLES = new EnvironmentVariables();
    }
}

