/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.MarkerUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestMarkerUtils
extends HoodieCommonTestHarness {
    private HoodieStorage storage;

    TestMarkerUtils() {
    }

    @BeforeEach
    public void setup() {
        this.initPath();
        this.storage = HoodieStorageUtils.getStorage((String)this.basePath, (StorageConfiguration)HoodieTestUtils.getDefaultStorageConfWithDefaults());
    }

    @Test
    public void testReadMarkerType() throws IOException {
        String markerDir = this.basePath + "/.hoodie/.temp/testReadMarkerType/";
        if (MarkerUtils.doesMarkerTypeFileExist((HoodieStorage)this.storage, (StoragePath)new StoragePath(markerDir))) {
            MarkerUtils.deleteMarkerTypeFile((HoodieStorage)this.storage, (String)markerDir);
        }
        try {
            Assertions.assertEquals((Object)Option.empty(), (Object)MarkerUtils.readMarkerType((HoodieStorage)this.storage, (String)markerDir), (String)"File does not exist, should be empty");
            Assertions.assertTrue((boolean)this.writeEmptyMarkerTypeToFile(this.storage, markerDir), (String)"Failed to create empty marker type file");
            Assertions.assertEquals((Object)Option.empty(), (Object)MarkerUtils.readMarkerType((HoodieStorage)this.storage, (String)markerDir), (String)"File exists but empty, should be empty");
            MarkerUtils.deleteMarkerTypeFile((HoodieStorage)this.storage, (String)markerDir);
            MarkerUtils.writeMarkerTypeToFile((MarkerType)MarkerType.DIRECT, (HoodieStorage)this.storage, (StoragePath)new StoragePath(markerDir));
            Assertions.assertEquals((Object)Option.of((Object)MarkerType.DIRECT), (Object)MarkerUtils.readMarkerType((HoodieStorage)this.storage, (String)markerDir), (String)"File exists and contains DIRECT, should be DIRECT");
            MarkerUtils.deleteMarkerTypeFile((HoodieStorage)this.storage, (String)markerDir);
            MarkerUtils.writeMarkerTypeToFile((MarkerType)MarkerType.TIMELINE_SERVER_BASED, (HoodieStorage)this.storage, (StoragePath)new StoragePath(markerDir));
            Assertions.assertEquals((Object)Option.of((Object)MarkerType.TIMELINE_SERVER_BASED), (Object)MarkerUtils.readMarkerType((HoodieStorage)this.storage, (String)markerDir), (String)"File exists and contains TIMELINE_SERVER_BASED, should be TIMELINE_SERVER_BASED");
        }
        finally {
            MarkerUtils.deleteMarkerTypeFile((HoodieStorage)this.storage, (String)markerDir);
        }
    }

    private boolean writeEmptyMarkerTypeToFile(HoodieStorage storage, String markerDir) {
        StoragePath markerTypeFilePath = new StoragePath(markerDir, "MARKERS.type");
        try {
            return storage.createNewFile(markerTypeFilePath);
        }
        catch (IOException e) {
            throw new HoodieException("Failed to create marker type file " + markerTypeFilePath, (Throwable)e);
        }
    }
}

