/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import org.apache.hudi.common.util.OrderingValues;
import org.apache.hudi.common.util.collection.ArrayComparable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestArrayComparables {
    @Test
    void testApply() {
        ArrayComparable original = new ArrayComparable(new Comparable[]{Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)});
        ArrayComparable transformed = original.apply(val -> Integer.valueOf((Integer)val * 2));
        ArrayComparable expected = new ArrayComparable(new Comparable[]{Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(6)});
        Assertions.assertEquals((Object)expected, (Object)transformed, (String)"The new instance should have the transformed values.");
        Assertions.assertNotEquals((Object)original, (Object)transformed, (String)"The original instance should not be mutated.");
    }

    @Test
    void testIsValueSameClass() {
        ArrayComparable a = new ArrayComparable(new Comparable[]{Integer.valueOf(1), "a"});
        ArrayComparable b = new ArrayComparable(new Comparable[]{Integer.valueOf(2), "b"});
        Assertions.assertTrue((boolean)a.isValueSameClass(b));
    }

    @Test
    void testCompareTo() {
        ArrayComparable arrayComparable = new ArrayComparable(new Comparable[]{"a", Integer.valueOf(1), Double.valueOf(3.0)});
        ArrayComparable arrayComparableCopy = new ArrayComparable(new Comparable[]{"a", Integer.valueOf(1), Double.valueOf(3.0)});
        Assertions.assertEquals((int)0, (int)arrayComparable.compareTo(arrayComparableCopy));
        Assertions.assertTrue((arrayComparable.compareTo(new ArrayComparable(new Comparable[]{"b", Integer.valueOf(2), Double.valueOf(4.0)})) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((arrayComparable.compareTo(new ArrayComparable(new Comparable[]{"a", Integer.valueOf(1), Double.valueOf(5.0)})) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((arrayComparable.compareTo(new ArrayComparable(new Comparable[]{"a", Integer.valueOf(0), Double.valueOf(3.0)})) > 0 ? 1 : 0) != 0);
    }

    @Test
    void testEquals() {
        ArrayComparable arrayComparable = new ArrayComparable(new Comparable[]{"a", null, Double.valueOf(3.0)});
        ArrayComparable arrayComparableCopy = new ArrayComparable(new Comparable[]{"a", null, Double.valueOf(3.0)});
        Assertions.assertEquals((Object)arrayComparable, (Object)arrayComparableCopy);
        Assertions.assertNotEquals((Object)arrayComparable, (Object)new ArrayComparable(new Comparable[]{"a", null}));
        Assertions.assertNotEquals((Object)OrderingValues.create((Comparable[])new Comparable[]{Integer.valueOf(1)}), (Object)new ArrayComparable(new Comparable[]{Integer.valueOf(1)}));
        Assertions.assertNotEquals((Object)new ArrayComparable(new Comparable[]{"a", Integer.valueOf(1), Double.valueOf(3.0)}), (Object)arrayComparable);
    }
}

