/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.serialization.CustomSerializer;
import org.apache.hudi.common.serialization.DefaultSerializer;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.InProcessTimeGenerator;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.testutils.SpillableMapTestUtils;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.HoodieRecordSizeEstimator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;

@TestMethodOrder(value=MethodOrderer.Alphanumeric.class)
public class TestExternalSpillableMap
extends HoodieCommonTestHarness {
    private static final String TEST_LOGGING_CONTEXT = "test_logging_context";
    private static String failureOutputPath;

    @BeforeEach
    public void setUp() {
        this.initPath();
        failureOutputPath = this.basePath + "/test_fail";
    }

    @ParameterizedTest
    @MethodSource(value={"testArguments"})
    public void simpleInsertTest(ExternalSpillableMap.DiskMapType diskMapType, boolean isCompressionEnabled) throws IOException, URISyntaxException {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        try (ExternalSpillableMap records = new ExternalSpillableMap(16L, this.basePath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(schema), diskMapType, (CustomSerializer)new DefaultSerializer(), isCompressionEnabled, TEST_LOGGING_CONTEXT);){
            SchemaTestUtil testUtil = new SchemaTestUtil();
            List iRecords = testUtil.generateHoodieTestRecords(0, 100);
            List recordKeys = SpillableMapTestUtils.upsertRecords((List)iRecords, (Map)records);
            assert (recordKeys.size() == 100);
            Iterator itr = records.iterator();
            int cntSize = 0;
            while (itr.hasNext()) {
                HoodieRecord rec = (HoodieRecord)itr.next();
                ++cntSize;
                assert (recordKeys.contains(rec.getRecordKey()));
            }
            Assertions.assertEquals((int)recordKeys.size(), (int)cntSize);
            List values = records.valueStream().collect(Collectors.toList());
            cntSize = 0;
            for (HoodieRecord value : values) {
                assert (recordKeys.contains(value.getRecordKey()));
                ++cntSize;
            }
            Assertions.assertEquals((int)recordKeys.size(), (int)cntSize);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"testArguments"})
    public void testSimpleUpsert(ExternalSpillableMap.DiskMapType diskMapType, boolean isCompressionEnabled) throws IOException, URISyntaxException {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        try (ExternalSpillableMap records = new ExternalSpillableMap(16L, this.basePath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(schema), diskMapType, (CustomSerializer)new DefaultSerializer(), isCompressionEnabled, TEST_LOGGING_CONTEXT);){
            SchemaTestUtil testUtil = new SchemaTestUtil();
            List iRecords = testUtil.generateHoodieTestRecords(0, 100);
            List recordKeys = SpillableMapTestUtils.upsertRecords((List)iRecords, (Map)records);
            assert (recordKeys.size() == 100);
            for (HoodieRecord rec : records) {
                assert (recordKeys.contains(rec.getRecordKey()));
            }
            List updatedRecords = SchemaTestUtil.updateHoodieTestRecords((List)recordKeys, (List)testUtil.generateHoodieTestRecords(0, 100), (String)InProcessTimeGenerator.createNewInstantTime());
            SpillableMapTestUtils.upsertRecords((List)updatedRecords, (Map)records);
            Assertions.assertTrue((records.getDiskBasedMapNumEntries() > 0 ? 1 : 0) != 0);
            updatedRecords.forEach(record -> {
                HoodieRecord rec = (HoodieRecord)records.get(((GenericRecord)record).get(HoodieRecord.RECORD_KEY_METADATA_FIELD));
                try {
                    Assertions.assertEquals((Object)((HoodieAvroRecord)rec).getData().getInsertValue(schema).get(), (Object)record);
                }
                catch (IOException io) {
                    throw new UncheckedIOException(io);
                }
            });
        }
    }

    @ParameterizedTest
    @MethodSource(value={"testArguments"})
    public void testAllMapOperations(ExternalSpillableMap.DiskMapType diskMapType, boolean isCompressionEnabled) throws IOException, URISyntaxException {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        String payloadClazz = HoodieAvroPayload.class.getName();
        try (ExternalSpillableMap records = new ExternalSpillableMap(16L, this.basePath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(schema), diskMapType, (CustomSerializer)new DefaultSerializer(), isCompressionEnabled, TEST_LOGGING_CONTEXT);){
            SchemaTestUtil testUtil = new SchemaTestUtil();
            List iRecords = testUtil.generateHoodieTestRecords(0, 100);
            List recordKeys = SpillableMapTestUtils.upsertRecords((List)iRecords, (Map)records);
            IndexedRecord inMemoryRecord = (IndexedRecord)iRecords.get(0);
            String ikey = ((GenericRecord)inMemoryRecord).get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
            String iPartitionPath = ((GenericRecord)inMemoryRecord).get(HoodieRecord.PARTITION_PATH_METADATA_FIELD).toString();
            HoodieAvroRecord inMemoryHoodieRecord = new HoodieAvroRecord(new HoodieKey(ikey, iPartitionPath), (HoodieRecordPayload)new HoodieAvroPayload(Option.of((Object)((GenericRecord)inMemoryRecord))));
            IndexedRecord onDiskRecord = (IndexedRecord)iRecords.get(99);
            String dkey = ((GenericRecord)onDiskRecord).get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
            String dPartitionPath = ((GenericRecord)onDiskRecord).get(HoodieRecord.PARTITION_PATH_METADATA_FIELD).toString();
            HoodieAvroRecord onDiskHoodieRecord = new HoodieAvroRecord(new HoodieKey(dkey, dPartitionPath), (HoodieRecordPayload)new HoodieAvroPayload(Option.of((Object)((GenericRecord)onDiskRecord))));
            assert (records.size() == 100);
            assert (inMemoryHoodieRecord.getKey().equals((Object)((HoodieRecord)records.get((Object)ikey)).getKey()));
            assert (onDiskHoodieRecord.getKey().equals((Object)((HoodieRecord)records.get((Object)dkey)).getKey()));
            assert (((HoodieRecord)records.get((Object)ikey)).getCurrentLocation().getFileId().equals("DUMMY_FILE_ID"));
            assert (((HoodieRecord)records.get((Object)ikey)).getCurrentLocation().getInstantTime().equals("DUMMY_COMMIT_TIME"));
            Assertions.assertTrue((boolean)records.containsKey((Object)ikey));
            Assertions.assertTrue((boolean)records.containsKey((Object)dkey));
            Assertions.assertFalse((boolean)records.isEmpty());
            Assertions.assertTrue((boolean)records.keySet().containsAll(recordKeys));
            HoodieRecord removedRecord = (HoodieRecord)records.remove((Object)ikey);
            Assertions.assertTrue((removedRecord != null ? 1 : 0) != 0);
            Assertions.assertFalse((boolean)records.containsKey((Object)ikey));
            removedRecord = (HoodieRecord)records.remove((Object)dkey);
            Assertions.assertTrue((removedRecord != null ? 1 : 0) != 0);
            Assertions.assertFalse((boolean)records.containsKey((Object)dkey));
            records.clear();
            Assertions.assertTrue((records.size() == 0 ? 1 : 0) != 0);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"testArguments"})
    public void simpleTestWithException(ExternalSpillableMap.DiskMapType diskMapType, boolean isCompressionEnabled) throws IOException, URISyntaxException {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        try (ExternalSpillableMap records = new ExternalSpillableMap(16L, failureOutputPath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(schema), diskMapType, (CustomSerializer)new DefaultSerializer(), isCompressionEnabled, TEST_LOGGING_CONTEXT);){
            SchemaTestUtil testUtil = new SchemaTestUtil();
            List iRecords = testUtil.generateHoodieTestRecords(0, 100);
            List recordKeys = SpillableMapTestUtils.upsertRecords((List)iRecords, (Map)records);
            assert (recordKeys.size() == 100);
            Iterator itr = records.iterator();
            Assertions.assertThrows(IOException.class, () -> {
                if (itr.hasNext()) {
                    throw new IOException("Testing failures...");
                }
            });
        }
    }

    @ParameterizedTest
    @MethodSource(value={"testArguments"})
    public void testDataCorrectnessWithUpsertsToDataInMapAndOnDisk(ExternalSpillableMap.DiskMapType diskMapType, boolean isCompressionEnabled) throws IOException, URISyntaxException {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        try (ExternalSpillableMap records = new ExternalSpillableMap(16L, this.basePath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(schema), diskMapType, (CustomSerializer)new DefaultSerializer(), isCompressionEnabled, TEST_LOGGING_CONTEXT);){
            ArrayList recordKeys = new ArrayList();
            while (records.getDiskBasedMapNumEntries() < 1) {
                SchemaTestUtil testUtil = new SchemaTestUtil();
                List iRecords = testUtil.generateHoodieTestRecords(0, 100);
                recordKeys.addAll(SpillableMapTestUtils.upsertRecords((List)iRecords, (Map)records));
            }
            String key = (String)recordKeys.get(0);
            HoodieAvroRecord record = (HoodieAvroRecord)records.get((Object)key);
            ArrayList<IndexedRecord> recordsToUpdate = new ArrayList<IndexedRecord>();
            recordsToUpdate.add((IndexedRecord)record.getData().getInsertValue(schema).get());
            String newCommitTime = InProcessTimeGenerator.createNewInstantTime();
            ArrayList<String> keysToBeUpdated = new ArrayList<String>();
            keysToBeUpdated.add(key);
            List updatedRecords = SchemaTestUtil.updateHoodieTestRecords(keysToBeUpdated, recordsToUpdate, (String)newCommitTime);
            SpillableMapTestUtils.upsertRecords((List)updatedRecords, (Map)records);
            GenericRecord gRecord = (GenericRecord)((HoodieRecordPayload)((HoodieRecord)records.get((Object)key)).getData()).getInsertValue(schema).get();
            assert (newCommitTime.contentEquals(gRecord.get(HoodieRecord.COMMIT_TIME_METADATA_FIELD).toString()));
            key = (String)recordKeys.get(recordKeys.size() - 1);
            record = (HoodieAvroRecord)records.get((Object)key);
            recordsToUpdate = new ArrayList();
            recordsToUpdate.add((IndexedRecord)record.getData().getInsertValue(schema).get());
            newCommitTime = InProcessTimeGenerator.createNewInstantTime();
            keysToBeUpdated = new ArrayList();
            keysToBeUpdated.add(key);
            updatedRecords = SchemaTestUtil.updateHoodieTestRecords(keysToBeUpdated, recordsToUpdate, (String)newCommitTime);
            SpillableMapTestUtils.upsertRecords((List)updatedRecords, (Map)records);
            gRecord = (GenericRecord)((HoodieRecordPayload)((HoodieRecord)records.get((Object)key)).getData()).getInsertValue(schema).get();
            assert (newCommitTime.contentEquals(gRecord.get(HoodieRecord.COMMIT_TIME_METADATA_FIELD).toString()));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"testArguments"})
    public void testDataCorrectnessWithoutHoodieMetadata(ExternalSpillableMap.DiskMapType diskMapType, boolean isCompressionEnabled) throws IOException, URISyntaxException {
        Schema schema = SchemaTestUtil.getSimpleSchema();
        try (ExternalSpillableMap records = new ExternalSpillableMap(16L, this.basePath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(schema), diskMapType, (CustomSerializer)new DefaultSerializer(), isCompressionEnabled, TEST_LOGGING_CONTEXT);){
            SchemaTestUtil testUtil = new SchemaTestUtil();
            ArrayList recordKeys = new ArrayList();
            while (records.getDiskBasedMapNumEntries() < 1) {
                List hoodieRecords = testUtil.generateHoodieTestRecordsWithoutHoodieMetadata(0, 100);
                hoodieRecords.stream().forEach(r -> {
                    records.put((Serializable)((Object)r.getRecordKey()), r);
                    recordKeys.add(r.getRecordKey());
                });
            }
            String key = (String)recordKeys.get(0);
            HoodieRecord record = (HoodieRecord)records.get((Object)key);
            String fieldName = schema.getFields().stream().filter(field -> field.schema().getType() == Schema.Type.STRING).findAny().get().name();
            String newValue = "update1";
            ArrayList<HoodieRecord> recordsToUpdate = new ArrayList<HoodieRecord>();
            recordsToUpdate.add(record);
            List updatedRecords = SchemaTestUtil.updateHoodieTestRecordsWithoutHoodieMetadata(recordsToUpdate, (Schema)schema, (String)fieldName, (String)newValue);
            updatedRecords.forEach(r -> records.put((Serializable)((Object)r.getRecordKey()), r));
            GenericRecord gRecord = (GenericRecord)((HoodieRecordPayload)((HoodieRecord)records.get((Object)key)).getData()).getInsertValue(schema).get();
            Assertions.assertEquals((Object)gRecord.get(fieldName).toString(), (Object)newValue);
            key = (String)recordKeys.get(recordKeys.size() - 1);
            record = (HoodieRecord)records.get((Object)key);
            fieldName = schema.getFields().stream().filter(field -> field.schema().getType() == Schema.Type.STRING).findAny().get().name();
            newValue = "update2";
            recordsToUpdate = new ArrayList();
            recordsToUpdate.add(record);
            updatedRecords = SchemaTestUtil.updateHoodieTestRecordsWithoutHoodieMetadata(recordsToUpdate, (Schema)schema, (String)fieldName, (String)newValue);
            updatedRecords.forEach(r -> records.put((Serializable)((Object)r.getRecordKey()), r));
            gRecord = (GenericRecord)((HoodieRecordPayload)((HoodieRecord)records.get((Object)key)).getData()).getInsertValue(schema).get();
            Assertions.assertEquals((Object)gRecord.get(fieldName).toString(), (Object)newValue);
        }
    }

    @Test
    public void testEstimationWithEmptyMap() throws IOException, URISyntaxException {
        ExternalSpillableMap.DiskMapType diskMapType = ExternalSpillableMap.DiskMapType.BITCASK;
        boolean isCompressionEnabled = false;
        Schema schema = SchemaTestUtil.getSimpleSchema();
        try (ExternalSpillableMap records = new ExternalSpillableMap(16L, this.basePath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(schema), diskMapType, (CustomSerializer)new DefaultSerializer(), false, TEST_LOGGING_CONTEXT);){
            ArrayList recordKeys = new ArrayList();
            SchemaTestUtil testUtil = new SchemaTestUtil();
            HoodieRecord seedRecord = (HoodieRecord)testUtil.generateHoodieTestRecordsWithoutHoodieMetadata(0, 1).get(0);
            records.put((Serializable)((Object)seedRecord.getRecordKey()), (Object)seedRecord);
            records.remove((Object)seedRecord.getRecordKey());
            SchemaTestUtil testUtilx = new SchemaTestUtil();
            List hoodieRecords = testUtil.generateHoodieTestRecordsWithoutHoodieMetadata(0, 250);
            hoodieRecords.stream().forEach(hoodieRecord -> {
                Assertions.assertDoesNotThrow(() -> records.put((Serializable)((Object)hoodieRecord.getRecordKey()), hoodieRecord), (String)"ExternalSpillableMap put() should not throw exception!");
                recordKeys.add(hoodieRecord.getRecordKey());
            });
        }
    }

    @ParameterizedTest
    @MethodSource(value={"testArguments"})
    public void testDataCorrectnessWithRecordExistsInDiskMapAndThenUpsertToMem(ExternalSpillableMap.DiskMapType diskMapType, boolean isCompressionEnabled) throws IOException, URISyntaxException {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        DefaultSizeEstimator keyEstimator = new DefaultSizeEstimator();
        HoodieRecordSizeEstimator valEstimator = new HoodieRecordSizeEstimator(schema);
        SchemaTestUtil testUtil = new SchemaTestUtil();
        List iRecords = testUtil.generateHoodieTestRecords(0, 100);
        IndexedRecord firstRecord = (IndexedRecord)iRecords.get(0);
        String key = ((GenericRecord)firstRecord).get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
        String partitionPath = ((GenericRecord)firstRecord).get(HoodieRecord.PARTITION_PATH_METADATA_FIELD).toString();
        HoodieAvroRecord record = new HoodieAvroRecord(new HoodieKey(key, partitionPath), (HoodieRecordPayload)new HoodieAvroPayload(Option.of((Object)((GenericRecord)firstRecord))));
        record.setCurrentLocation(new HoodieRecordLocation("DUMMY_COMMIT_TIME", "DUMMY_FILE_ID"));
        record.seal();
        long estimatedPayloadSize = keyEstimator.sizeEstimate((Object)key) + valEstimator.sizeEstimate((Object)record);
        long totalEstimatedSizeWith100Records = (long)((double)(estimatedPayloadSize * 100L) / 0.8);
        try (ExternalSpillableMap records = new ExternalSpillableMap(totalEstimatedSizeWith100Records, this.basePath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(schema), diskMapType, (CustomSerializer)new DefaultSerializer(), isCompressionEnabled, TEST_LOGGING_CONTEXT);){
            SpillableMapTestUtils.upsertRecords((List)iRecords, (Map)records);
            List singleRecord = testUtil.generateHoodieTestRecords(0, 1);
            List singleRecordKey = SpillableMapTestUtils.upsertRecords((List)singleRecord, (Map)records);
            String fieldName = schema.getFields().stream().filter(field -> field.schema().getType() == Schema.Type.STRING).findAny().get().name();
            HoodieRecord hoodieRecord = (HoodieRecord)records.get(singleRecordKey.get(0));
            String newValue = "";
            HoodieRecord updatedRecord = (HoodieRecord)SchemaTestUtil.updateHoodieTestRecordsWithoutHoodieMetadata(Arrays.asList(hoodieRecord), (Schema)schema, (String)fieldName, (String)newValue).get(0);
            records.put((Serializable)((Object)updatedRecord.getRecordKey()), (Object)updatedRecord);
            Assertions.assertEquals((int)records.size(), (int)101);
        }
    }

    @ParameterizedTest
    @EnumSource(value=ExternalSpillableMap.DiskMapType.class)
    void assertEmptyMapOperations(ExternalSpillableMap.DiskMapType diskMapType) throws IOException {
        try (ExternalSpillableMap records = new ExternalSpillableMap(10L, this.basePath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new DefaultSizeEstimator(), diskMapType, (CustomSerializer)new DefaultSerializer(), false, TEST_LOGGING_CONTEXT);){
            Assertions.assertTrue((boolean)records.isEmpty());
            Assertions.assertFalse((boolean)records.containsKey((Object)"key"));
            Assertions.assertFalse((boolean)records.containsValue((Object)"value"));
            Assertions.assertTrue((boolean)records.keySet().isEmpty());
            Assertions.assertTrue((boolean)records.values().isEmpty());
            Assertions.assertTrue((boolean)records.entrySet().isEmpty());
            Assertions.assertEquals((long)0L, (long)records.valueStream().count());
            Assertions.assertEquals((int)0, (int)records.size());
            Assertions.assertFalse((boolean)records.iterator().hasNext());
        }
    }

    private static Stream<Arguments> testArguments() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{ExternalSpillableMap.DiskMapType.BITCASK, false}), Arguments.arguments((Object[])new Object[]{ExternalSpillableMap.DiskMapType.ROCKS_DB, false}), Arguments.arguments((Object[])new Object[]{ExternalSpillableMap.DiskMapType.UNKNOWN, false}), Arguments.arguments((Object[])new Object[]{ExternalSpillableMap.DiskMapType.BITCASK, true}));
    }
}

