/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.serialization.CustomSerializer;
import org.apache.hudi.common.serialization.DefaultSerializer;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.InProcessTimeGenerator;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.testutils.SpillableMapTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.RocksDbDiskMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRocksDbDiskMap
extends HoodieCommonTestHarness {
    @BeforeEach
    public void setUp() {
        this.initPath();
    }

    @Test
    public void testSimpleInsertSequential() throws IOException, URISyntaxException {
        try (RocksDbDiskMap rocksDBBasedMap = new RocksDbDiskMap(this.basePath, (CustomSerializer)new DefaultSerializer());){
            List<String> recordKeys = this.setupMapWithRecords(rocksDBBasedMap, 100);
            Iterator itr = rocksDBBasedMap.iterator();
            int cntSize = 0;
            while (itr.hasNext()) {
                HoodieRecord rec = (HoodieRecord)itr.next();
                ++cntSize;
                assert (recordKeys.contains(rec.getRecordKey()));
            }
            Assertions.assertEquals((int)recordKeys.size(), (int)cntSize);
            long currentTimeMs = System.currentTimeMillis();
            List values = rocksDBBasedMap.valueStream().collect(Collectors.toList());
            cntSize = 0;
            for (HoodieRecord value : values) {
                assert (recordKeys.contains(value.getRecordKey()));
                ++cntSize;
            }
            Assertions.assertEquals((int)recordKeys.size(), (int)cntSize);
        }
    }

    @Test
    public void testSimpleInsertRandomAccess() throws IOException, URISyntaxException {
        try (RocksDbDiskMap rocksDBBasedMap = new RocksDbDiskMap(this.basePath, (CustomSerializer)new DefaultSerializer());){
            List<String> recordKeys = this.setupMapWithRecords(rocksDBBasedMap, 100);
            Random random = new Random();
            for (int i = 0; i < recordKeys.size(); ++i) {
                String key = recordKeys.get(random.nextInt(recordKeys.size()));
                assert (rocksDBBasedMap.get((Object)key) != null);
            }
        }
    }

    @Test
    public void testSimpleInsertWithoutHoodieMetadata() throws IOException, URISyntaxException {
        try (RocksDbDiskMap rocksDBBasedMap = new RocksDbDiskMap(this.basePath, (CustomSerializer)new DefaultSerializer());){
            SchemaTestUtil testUtil = new SchemaTestUtil();
            List hoodieRecords = testUtil.generateHoodieTestRecordsWithoutHoodieMetadata(0, 1000);
            HashSet recordKeys = new HashSet();
            hoodieRecords.forEach(r -> {
                rocksDBBasedMap.put((Serializable)((Object)r.getRecordKey()), r);
                recordKeys.add(r.getRecordKey());
            });
            Assertions.assertTrue((rocksDBBasedMap.sizeOfFileOnDiskInBytes() > 0L ? 1 : 0) != 0);
            Iterator itr = rocksDBBasedMap.iterator();
            int cntSize = 0;
            while (itr.hasNext()) {
                HoodieRecord rec = (HoodieRecord)itr.next();
                ++cntSize;
                assert (recordKeys.contains(rec.getRecordKey()));
            }
            Assertions.assertEquals((int)recordKeys.size(), (int)cntSize);
            String firstKey = (String)recordKeys.stream().findFirst().get();
            recordKeys.remove(firstKey);
            itr = rocksDBBasedMap.iterator(key -> !key.equals(firstKey));
            cntSize = 0;
            while (itr.hasNext()) {
                HoodieRecord rec = (HoodieRecord)itr.next();
                ++cntSize;
                assert (recordKeys.contains(rec.getRecordKey()));
            }
            Assertions.assertEquals((int)recordKeys.size(), (int)cntSize);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testSimpleUpsert() throws IOException, URISyntaxException {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        try (RocksDbDiskMap rocksDBBasedMap = new RocksDbDiskMap(this.basePath, (CustomSerializer)new DefaultSerializer());){
            SchemaTestUtil testUtil = new SchemaTestUtil();
            List insertedRecords = testUtil.generateHoodieTestRecords(0, 100);
            List recordKeys = SpillableMapTestUtils.upsertRecords((List)insertedRecords, (Map)rocksDBBasedMap);
            String oldCommitTime = ((GenericRecord)insertedRecords.get(0)).get(HoodieRecord.COMMIT_TIME_METADATA_FIELD).toString();
            List updatedRecords = SchemaTestUtil.updateHoodieTestRecords(recordKeys.subList(0, 50), (List)testUtil.generateHoodieTestRecords(0, 50), (String)InProcessTimeGenerator.createNewInstantTime());
            String newCommitTime = ((GenericRecord)updatedRecords.get(0)).get(HoodieRecord.COMMIT_TIME_METADATA_FIELD).toString();
            List updatedRecordKeys = SpillableMapTestUtils.upsertRecords((List)updatedRecords, (Map)rocksDBBasedMap);
            for (HoodieRecord rec : rocksDBBasedMap) {
                try {
                    IndexedRecord indexedRecord = (IndexedRecord)((HoodieRecordPayload)rec.getData()).getInsertValue(schema).get();
                    String latestCommitTime = ((GenericRecord)indexedRecord).get(HoodieRecord.COMMIT_TIME_METADATA_FIELD).toString();
                    assert (recordKeys.contains(rec.getRecordKey()) || updatedRecordKeys.contains(rec.getRecordKey()));
                    Assertions.assertEquals((Object)latestCommitTime, (Object)(updatedRecordKeys.contains(rec.getRecordKey()) ? newCommitTime : oldCommitTime));
                }
                catch (IOException io) {
                    throw new UncheckedIOException(io);
                    return;
                }
            }
        }
    }

    @Test
    public void testPutAll() throws IOException, URISyntaxException {
        try (RocksDbDiskMap rocksDBBasedMap = new RocksDbDiskMap(this.basePath, (CustomSerializer)new DefaultSerializer());){
            SchemaTestUtil testUtil = new SchemaTestUtil();
            List iRecords = testUtil.generateHoodieTestRecords(0, 100);
            HashMap recordMap = new HashMap();
            iRecords.forEach(r -> {
                String key = ((GenericRecord)r).get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
                String partitionPath = ((GenericRecord)r).get(HoodieRecord.PARTITION_PATH_METADATA_FIELD).toString();
                HoodieAvroRecord value = new HoodieAvroRecord(new HoodieKey(key, partitionPath), (HoodieRecordPayload)new HoodieAvroPayload(Option.of((Object)((GenericRecord)r))));
                recordMap.put(key, value);
            });
            rocksDBBasedMap.putAll(recordMap);
            Assertions.assertTrue((rocksDBBasedMap.sizeOfFileOnDiskInBytes() > 0L ? 1 : 0) != 0);
            for (Map.Entry entry : rocksDBBasedMap.entrySet()) {
                Assertions.assertTrue((boolean)recordMap.containsKey(entry.getKey()));
            }
        }
    }

    @Test
    public void testSimpleRemove() throws IOException, URISyntaxException {
        try (RocksDbDiskMap rocksDBBasedMap = new RocksDbDiskMap(this.basePath, (CustomSerializer)new DefaultSerializer());){
            List<String> recordKeys = this.setupMapWithRecords(rocksDBBasedMap, 100);
            List<String> deleteKeys = recordKeys.subList(0, 10);
            for (String deleteKey : deleteKeys) {
                assert (rocksDBBasedMap.remove((Object)deleteKey) != null);
                assert (rocksDBBasedMap.get((Object)deleteKey) == null);
            }
        }
    }

    private List<String> setupMapWithRecords(RocksDbDiskMap rocksDBBasedMap, int numRecords) throws IOException, URISyntaxException {
        SchemaTestUtil testUtil = new SchemaTestUtil();
        List iRecords = testUtil.generateHoodieTestRecords(0, numRecords);
        List recordKeys = SpillableMapTestUtils.upsertRecords((List)iRecords, (Map)rocksDBBasedMap);
        Assertions.assertEquals((int)rocksDBBasedMap.size(), (int)recordKeys.size());
        Assertions.assertTrue((rocksDBBasedMap.sizeOfFileOnDiskInBytes() > 0L ? 1 : 0) != 0);
        return recordKeys;
    }
}

