/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.io.hadoop.HoodieBaseParquetWriter;
import org.apache.hudi.io.storage.HoodieParquetConfig;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestHoodieBaseParquetWriter {
    @TempDir
    public Path tempDir;

    @Test
    public void testCanWrite() throws IOException {
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)1000, (double)1.0E-4, (int)10000, (String)BloomFilterTypeCode.DYNAMIC_V0.name());
        StorageConfiguration conf = HoodieTestUtils.getDefaultStorageConfWithDefaults();
        Schema schema = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
        HoodieAvroWriteSupport writeSupport = new HoodieAvroWriteSupport(new AvroSchemaConverter().convert(schema), schema, Option.of((Object)filter), new Properties());
        long maxFileSize = 0x200000L;
        HoodieParquetConfig parquetConfig = new HoodieParquetConfig((Object)writeSupport, CompressionCodecName.GZIP, 0x8000000, 0x100000, maxFileSize, conf, 0.0, true);
        StoragePath filePath = new StoragePath(new StoragePath(this.tempDir.toUri()), "test_fileSize.parquet");
        try (MockHoodieParquetWriter writer = new MockHoodieParquetWriter(filePath, (HoodieParquetConfig<HoodieAvroWriteSupport>)parquetConfig);){
            Assertions.assertTrue((boolean)writer.canWrite());
            Assertions.assertEquals((long)writer.getRecordCountForNextSizeCheck(), (long)100L);
            writer.setCurrentDataSize(1000L);
            writer.setWrittenRecordCount(writer.getRecordCountForNextSizeCheck());
            Assertions.assertTrue((boolean)writer.canWrite());
            Assertions.assertEquals((long)writer.getRecordCountForNextSizeCheck(), (long)(writer.getWrittenRecordCount() + 10000L));
            writer.setCurrentDataSize(808000L);
            writer.setWrittenRecordCount(writer.getRecordCountForNextSizeCheck());
            Assertions.assertTrue((boolean)writer.canWrite());
            long avgRecordSize = writer.getDataSize() / writer.getWrittenRecordCount();
            long recordsDelta = (maxFileSize / avgRecordSize - writer.getWrittenRecordCount()) / 2L;
            Assertions.assertEquals((long)writer.getRecordCountForNextSizeCheck(), (long)(writer.getWrittenRecordCount() + recordsDelta));
            writer.setCurrentDataSize(maxFileSize);
            writer.setWrittenRecordCount(writer.getRecordCountForNextSizeCheck());
            Assertions.assertFalse((boolean)writer.canWrite(), (String)"The writer stops write new records while the file doesn't reach the max file size limit");
        }
    }

    private static class MockHoodieParquetWriter
    extends HoodieBaseParquetWriter<IndexedRecord> {
        long writtenRecordCount = 0L;
        long currentDataSize = 0L;

        public MockHoodieParquetWriter(StoragePath file, HoodieParquetConfig<HoodieAvroWriteSupport> parquetConfig) throws IOException {
            super(file, parquetConfig);
        }

        public long getDataSize() {
            return this.currentDataSize;
        }

        public long getWrittenRecordCount() {
            return this.writtenRecordCount;
        }

        public void setWrittenRecordCount(long writtenCount) {
            this.writtenRecordCount = writtenCount;
        }

        public void setCurrentDataSize(long currentDataSize) {
            this.currentDataSize = currentDataSize;
        }
    }
}

