/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.testutils.FileSystemTestUtils;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.io.hadoop.HoodieAvroHFileWriter;
import org.apache.hudi.io.hadoop.TestHoodieOrcReaderWriter;
import org.apache.hudi.io.hadoop.TestHoodieReaderWriterBase;
import org.apache.hudi.io.hfile.HFileReader;
import org.apache.hudi.io.hfile.TestHFileReader;
import org.apache.hudi.io.hfile.UTF8StringKey;
import org.apache.hudi.io.storage.HFileReaderFactory;
import org.apache.hudi.io.storage.HoodieAvroFileReader;
import org.apache.hudi.io.storage.HoodieAvroHFileReaderImplBase;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.io.storage.HoodieNativeAvroHFileReader;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHoodieHFileReaderWriter
extends TestHoodieReaderWriterBase {
    protected static final int NUM_RECORDS_FIXTURE = 50;
    protected static final TypedProperties DEFAULT_PROPS = new TypedProperties();

    protected static Stream<Arguments> populateMetaFieldsAndTestAvroWithMeta() {
        return Arrays.stream(new Boolean[][]{{true, true}, {false, true}, {true, false}, {false, false}}).map(Arguments::of);
    }

    @Override
    protected HoodieAvroFileReader createReader(HoodieStorage storage) throws Exception {
        return this.createReader(storage, true);
    }

    protected HoodieAvroHFileReaderImplBase createReader(HoodieStorage storage, boolean useBloomFilter) throws Exception {
        HFileReaderFactory readerFactory = HFileReaderFactory.builder().withStorage(storage).withProps(DEFAULT_PROPS).withPath(this.getFilePath()).build();
        return HoodieNativeAvroHFileReader.builder().readerFactory(readerFactory).path(this.getFilePath()).useBloomFilter(useBloomFilter).build();
    }

    protected HoodieAvroHFileReaderImplBase createHFileReader(HoodieStorage storage, byte[] content, boolean useBloomFilter) throws IOException {
        HFileReaderFactory readerFactory = HFileReaderFactory.builder().withStorage(storage).withProps(DEFAULT_PROPS).withContent(content).build();
        return HoodieNativeAvroHFileReader.builder().readerFactory(readerFactory).path(this.getFilePath()).useBloomFilter(useBloomFilter).build();
    }

    protected void verifyHFileReader(byte[] content, String hfileName, boolean mayUseDefaultComparator, boolean useBloomFilter, int count) throws IOException {
        try (HoodieAvroHFileReaderImplBase hfileReader = this.createHFileReader(HoodieTestUtils.getStorage((String)hfileName), content, useBloomFilter);){
            Assertions.assertEquals((long)count, (long)hfileReader.getTotalRecords());
        }
    }

    protected HoodieAvroHFileWriter createWriter(Schema avroSchema, boolean populateMetaFields) throws Exception {
        String instantTime = "000";
        HoodieStorage storage = HoodieTestUtils.getStorage((StoragePath)this.getFilePath());
        Properties props = new Properties();
        props.setProperty(HoodieTableConfig.POPULATE_META_FIELDS.key(), Boolean.toString(populateMetaFields));
        TaskContextSupplier mockTaskContextSupplier = (TaskContextSupplier)Mockito.mock(TaskContextSupplier.class);
        Supplier partitionSupplier = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when((Object)mockTaskContextSupplier.getPartitionIdSupplier()).thenReturn((Object)partitionSupplier);
        Mockito.when(partitionSupplier.get()).thenReturn((Object)10);
        return (HoodieAvroHFileWriter)HoodieFileWriterFactory.getFileWriter((String)instantTime, (StoragePath)this.getFilePath(), (HoodieStorage)storage, (HoodieConfig)HoodieStorageConfig.newBuilder().fromProperties(props).build(), (Schema)avroSchema, (TaskContextSupplier)mockTaskContextSupplier, (HoodieRecord.HoodieRecordType)HoodieRecord.HoodieRecordType.AVRO);
    }

    @Override
    protected StoragePath getFilePath() {
        return new StoragePath(this.tempDir.toString() + "/f1_1-0-1_000.hfile");
    }

    @Override
    protected void verifyMetadata(HoodieStorage storage) throws IOException {
        try (HoodieAvroFileReader reader = this.createReader(storage);){
            Assertions.assertEquals((long)50L, (long)reader.getTotalRecords());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void verifySchema(HoodieStorage storage, String schemaPath) throws IOException {
        try (HoodieAvroFileReader reader = this.createReader(storage);){
            Assertions.assertEquals((Object)SchemaTestUtil.getSchemaFromResource(TestHoodieHFileReaderWriter.class, (String)schemaPath), (Object)reader.getSchema());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"populateMetaFieldsAndTestAvroWithMeta"})
    public void testWriteReadHFileWithMetaFields(boolean populateMetaFields, boolean testAvroWithMeta) throws Exception {
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieOrcReaderWriter.class, (String)"/exampleSchemaWithMetaFields.avsc");
        HoodieAvroHFileWriter writer = this.createWriter(avroSchema, populateMetaFields);
        ArrayList<String> keys = new ArrayList<String>();
        TreeMap<String, GenericData.Record> recordMap = new TreeMap<String, GenericData.Record>();
        for (int i = 0; i < 100; ++i) {
            GenericData.Record record = new GenericData.Record(avroSchema);
            String key = String.format("%s%04d", "key", i);
            record.put("_row_key", (Object)key);
            keys.add(key);
            record.put("time", (Object)Integer.toString(FileSystemTestUtils.RANDOM.nextInt()));
            record.put("number", (Object)i);
            if (testAvroWithMeta) {
                writer.writeAvroWithMetadata(new HoodieAvroRecord(new HoodieKey((String)record.get("_row_key"), Integer.toString((Integer)record.get("number"))), (HoodieRecordPayload)new EmptyHoodieRecordPayload()).getKey(), (IndexedRecord)record);
            } else {
                writer.writeAvro(key, (IndexedRecord)record);
            }
            recordMap.put(key, record);
        }
        writer.close();
        HoodieStorage storage = HoodieTestUtils.getStorage((StoragePath)this.getFilePath());
        HoodieAvroHFileReaderImplBase hoodieHFileReader = (HoodieAvroHFileReaderImplBase)this.createReader(storage);
        List records = HoodieAvroHFileReaderImplBase.readAllRecords((HoodieAvroFileReader)hoodieHFileReader);
        Assertions.assertEquals(new ArrayList(recordMap.values()), (Object)records);
        hoodieHFileReader.close();
        for (int i = 0; i < 2; ++i) {
            int randomRowstoFetch = 5 + FileSystemTestUtils.RANDOM.nextInt(10);
            Set<String> rowsToFetch = this.getRandomKeys(randomRowstoFetch, keys);
            ArrayList<String> rowsList = new ArrayList<String>(rowsToFetch);
            Collections.sort(rowsList);
            List expectedRecords = rowsList.stream().map(recordMap::get).collect(Collectors.toList());
            hoodieHFileReader = (HoodieAvroHFileReaderImplBase)this.createReader(storage);
            List<GenericRecord> result = HoodieAvroHFileReaderImplBase.readRecords((HoodieAvroHFileReaderImplBase)hoodieHFileReader, rowsList).stream().map(r -> (GenericRecord)r).collect(Collectors.toList());
            Assertions.assertEquals(expectedRecords, result);
            result.forEach(entry -> {
                if (populateMetaFields && testAvroWithMeta) {
                    Assertions.assertNotNull((Object)entry.get(HoodieRecord.RECORD_KEY_METADATA_FIELD));
                } else {
                    Assertions.assertNull((Object)entry.get(HoodieRecord.RECORD_KEY_METADATA_FIELD));
                }
            });
            hoodieHFileReader.close();
        }
    }

    @Override
    @Disabled(value="Disable the test with evolved schema for HFile since it's not supported")
    @ParameterizedTest
    public void testWriteReadWithEvolvedSchema(String evolvedSchemaPath) throws Exception {
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testReadHFileFormatRecords(boolean useBloomFilter) throws Exception {
        this.writeFileWithSimpleSchema();
        HoodieStorage storage = HoodieTestUtils.getStorage((StoragePath)this.getFilePath());
        byte[] content = FileIOUtils.readAsByteArray((InputStream)storage.open(this.getFilePath()), (int)((int)storage.getPathInfo(this.getFilePath()).getLength()));
        try (HoodieAvroHFileReaderImplBase hfileReader = this.createHFileReader(storage, content, useBloomFilter);){
            Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)"/exampleSchema.avsc");
            Assertions.assertEquals((long)50L, (long)hfileReader.getTotalRecords());
            this.verifySimpleRecords((Iterator<HoodieRecord<IndexedRecord>>)hfileReader.getRecordIterator(avroSchema));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testBloomFilterInitializationInRecordIterator(boolean useBloomFilter) throws IOException {
        HFileReaderFactory readerFactory = (HFileReaderFactory)Mockito.mock(HFileReaderFactory.class);
        HFileReader hfileReader = (HFileReader)Mockito.mock(HFileReader.class);
        Mockito.when((Object)readerFactory.createHFileReader()).thenReturn((Object)hfileReader);
        Mockito.when((Object)hfileReader.getMetaInfo(new UTF8StringKey("minRecordKey"))).thenReturn((Object)Option.of((Object)StringUtils.getUTF8Bytes((String)"key00")));
        Mockito.when((Object)hfileReader.getMetaInfo(new UTF8StringKey("maxRecordKey"))).thenReturn((Object)Option.of((Object)StringUtils.getUTF8Bytes((String)"key99")));
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        Mockito.when((Object)hfileReader.getMetaInfo(new UTF8StringKey("schema"))).thenReturn((Object)Option.of((Object)StringUtils.getUTF8Bytes((String)schema.toString())));
        BloomFilter bloomFilter = BloomFilterFactory.createBloomFilter((int)100, (double)0.001, (int)1000, (String)BloomFilterTypeCode.DYNAMIC_V0.name());
        Mockito.when((Object)hfileReader.getMetaBlock("bloomFilter")).thenReturn((Object)Option.of((Object)ByteBuffer.wrap(StringUtils.getUTF8Bytes((String)bloomFilter.serializeToString()))));
        Mockito.when((Object)hfileReader.getMetaInfo(new UTF8StringKey("bloomFilterTypeCode"))).thenReturn((Object)Option.of((Object)StringUtils.getUTF8Bytes((String)bloomFilter.getBloomFilterTypeCode().toString())));
        List<String> filterKeys = Collections.singletonList("key");
        try (HoodieNativeAvroHFileReader reader = HoodieNativeAvroHFileReader.builder().readerFactory(readerFactory).path(new StoragePath("dummy")).useBloomFilter(useBloomFilter).build();){
            reader.getRecordIterator();
            ((HFileReader)Mockito.verify((Object)hfileReader, (VerificationMode)Mockito.never())).getMetaBlock("bloomFilter");
            reader.getRecordIterator(schema);
            ((HFileReader)Mockito.verify((Object)hfileReader, (VerificationMode)Mockito.never())).getMetaBlock("bloomFilter");
            reader.getRecordIterator(schema, schema);
            ((HFileReader)Mockito.verify((Object)hfileReader, (VerificationMode)Mockito.never())).getMetaBlock("bloomFilter");
            reader.getRecordKeyIterator();
            ((HFileReader)Mockito.verify((Object)hfileReader, (VerificationMode)Mockito.never())).getMetaBlock("bloomFilter");
            reader.getIndexedRecordIterator(schema, schema);
            ((HFileReader)Mockito.verify((Object)hfileReader, (VerificationMode)Mockito.never())).getMetaBlock("bloomFilter");
            reader.getRecordsByKeyPrefixIterator(filterKeys);
            ((HFileReader)Mockito.verify((Object)hfileReader, (VerificationMode)Mockito.never())).getMetaBlock("bloomFilter");
            reader.getRecordsByKeyPrefixIterator(filterKeys, schema);
            ((HFileReader)Mockito.verify((Object)hfileReader, (VerificationMode)Mockito.never())).getMetaBlock("bloomFilter");
            reader.getIndexedRecordsByKeyPrefixIterator(filterKeys, schema);
            ((HFileReader)Mockito.verify((Object)hfileReader, (VerificationMode)Mockito.never())).getMetaBlock("bloomFilter");
            reader.getRecordsByKeysIterator(filterKeys);
            ((HFileReader)Mockito.verify((Object)hfileReader, (VerificationMode)(useBloomFilter ? Mockito.times((int)1) : Mockito.never()))).getMetaBlock("bloomFilter");
            reader.getRecordsByKeysIterator(filterKeys, schema);
            ((HFileReader)Mockito.verify((Object)hfileReader, (VerificationMode)(useBloomFilter ? Mockito.times((int)2) : Mockito.never()))).getMetaBlock("bloomFilter");
            reader.getIndexedRecordsByKeysIterator(filterKeys, schema);
            ((HFileReader)Mockito.verify((Object)hfileReader, (VerificationMode)(useBloomFilter ? Mockito.times((int)3) : Mockito.never()))).getMetaBlock("bloomFilter");
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testReaderGetRecordIterator(boolean useBloomFilter) throws Exception {
        this.writeFileWithSimpleSchema();
        try (HoodieAvroHFileReaderImplBase hfileReader = this.createReader(HoodieTestUtils.getStorage((StoragePath)this.getFilePath()), useBloomFilter);){
            List keys = IntStream.concat(IntStream.range(10, 20), IntStream.range(40, 100)).mapToObj(i -> "key" + String.format("%02d", i)).collect(Collectors.toList());
            Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)"/exampleSchema.avsc");
            ClosableIterator iterator = hfileReader.getRecordsByKeysIterator(keys, avroSchema);
            List expectedIds = IntStream.concat(IntStream.range(10, 20), IntStream.range(40, 50)).boxed().collect(Collectors.toList());
            int index = 0;
            while (iterator.hasNext()) {
                GenericRecord record = (GenericRecord)((HoodieRecord)iterator.next()).getData();
                String key = "key" + String.format("%02d", expectedIds.get(index));
                Assertions.assertEquals((Object)key, (Object)record.get("_row_key").toString());
                Assertions.assertEquals((Object)Integer.toString((Integer)expectedIds.get(index)), (Object)record.get("time").toString());
                Assertions.assertEquals(expectedIds.get(index), (Object)record.get("number"));
                ++index;
            }
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testReaderGetRecordIteratorByKeys(boolean useBloomFilter) throws Exception {
        ClosableIterator iterator;
        this.writeFileWithSimpleSchema();
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)"/exampleSchema.avsc");
        try (HoodieAvroHFileReaderImplBase hfileReader = this.createReader(HoodieTestUtils.getStorage((StoragePath)this.getFilePath()), useBloomFilter);){
            List<String> keys = Collections.singletonList("key");
            iterator = hfileReader.getIndexedRecordsByKeysIterator(keys, avroSchema);
            List recordsByKeys = CollectionUtils.toStream((Iterator)iterator).map(r -> (GenericRecord)r).collect(Collectors.toList());
            List allRecords = CollectionUtils.toStream((Iterator)hfileReader.getRecordIterator()).map(r -> (GenericRecord)r.getData()).collect(Collectors.toList());
            Assertions.assertEquals(Collections.emptyList(), recordsByKeys);
            iterator = hfileReader.getEngineRecordsByKeysIterator(keys, avroSchema);
            recordsByKeys = CollectionUtils.toStream((Iterator)iterator).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Assertions.assertEquals(Collections.emptyList(), recordsByKeys);
            List expectedKey1s = allRecords.stream().filter(entry -> entry.get("_row_key").toString().contains("key05") || entry.get("_row_key").toString().contains("key12") || entry.get("_row_key").toString().contains("key24") || entry.get("_row_key").toString().contains("key31") || entry.get("_row_key").toString().contains("key49")).collect(Collectors.toList());
            iterator = hfileReader.getIndexedRecordsByKeysIterator(Arrays.asList("key00001", "key05", "key12", "key24", "key31", "key49", "key61", "key50"), avroSchema);
            recordsByKeys = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Assertions.assertEquals(expectedKey1s, recordsByKeys);
            iterator = hfileReader.getEngineRecordsByKeysIterator(Arrays.asList("key00001", "key05", "key12", "key24", "key31", "key49", "key61", "key50"), avroSchema);
            recordsByKeys = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Assertions.assertEquals(expectedKey1s, recordsByKeys);
        }
        hfileReader = this.getHFileReaderFromFixture(useBloomFilter);
        var4_4 = null;
        try {
            List allRecords = CollectionUtils.toStream((Iterator)hfileReader.getRecordIterator()).map(r -> (GenericRecord)r.getData()).collect(Collectors.toList());
            iterator = hfileReader.getIndexedRecordsByKeysIterator(Arrays.asList("key000000", "key000066-abcdefghij", "key001424-aa", "key001424-aaa", "key004958-abcdefghij", "key010769", "key019889-abcdefghij", "key030000"), avroSchema);
            List actual = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            List expected = allRecords.stream().filter(entry -> entry.get("_row_key").toString().equals("key000066-abcdefghij") || entry.get("_row_key").toString().equals("key004958-abcdefghij") || entry.get("_row_key").toString().equals("key019889-abcdefghij")).collect(Collectors.toList());
            Assertions.assertEquals(expected, actual);
            iterator = hfileReader.getEngineRecordsByKeysIterator(Arrays.asList("key000000", "key000066-abcdefghij", "key001424-aa", "key001424-aaa", "key004958-abcdefghij", "key010769", "key019889-abcdefghij", "key030000"), avroSchema);
            actual = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Assertions.assertEquals(expected, actual);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (hfileReader != null) {
                if (var4_4 != null) {
                    try {
                        hfileReader.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    hfileReader.close();
                }
            }
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testReaderGetRecordIteratorByKeyPrefixes(boolean useBloomFilter) throws Exception {
        ClosableIterator iterator;
        this.writeFileWithSimpleSchema();
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)"/exampleSchema.avsc");
        try (HoodieAvroHFileReaderImplBase hfileReader = this.createReader(HoodieTestUtils.getStorage((StoragePath)this.getFilePath()), useBloomFilter);){
            List<String> keyPrefixes = Collections.singletonList("key");
            iterator = hfileReader.getIndexedRecordsByKeyPrefixIterator(keyPrefixes, avroSchema);
            List recordsByPrefix = CollectionUtils.toStream((Iterator)iterator).map(r -> (GenericRecord)r).collect(Collectors.toList());
            List allRecords = CollectionUtils.toStream((Iterator)hfileReader.getRecordIterator()).map(r -> (GenericRecord)r.getData()).collect(Collectors.toList());
            Assertions.assertEquals(allRecords, recordsByPrefix);
            iterator = hfileReader.getEngineRecordsByKeyPrefixIterator(keyPrefixes, avroSchema);
            recordsByPrefix = CollectionUtils.toStream((Iterator)iterator).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Assertions.assertEquals(allRecords, recordsByPrefix);
            List expectedKey1s = allRecords.stream().filter(entry -> entry.get("_row_key").toString().contains("key1")).collect(Collectors.toList());
            iterator = hfileReader.getIndexedRecordsByKeyPrefixIterator(Collections.singletonList("key1"), avroSchema);
            recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Assertions.assertEquals(expectedKey1s, recordsByPrefix);
            iterator = hfileReader.getEngineRecordsByKeyPrefixIterator(Collections.singletonList("key1"), avroSchema);
            recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Assertions.assertEquals(expectedKey1s, recordsByPrefix);
            List expectedKey25 = allRecords.stream().filter(entry -> entry.get("_row_key").toString().contains("key25")).collect(Collectors.toList());
            iterator = hfileReader.getIndexedRecordsByKeyPrefixIterator(Collections.singletonList("key25"), avroSchema);
            recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Assertions.assertEquals(expectedKey25, recordsByPrefix);
            iterator = hfileReader.getEngineRecordsByKeyPrefixIterator(Collections.singletonList("key25"), avroSchema);
            recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Assertions.assertEquals(expectedKey25, recordsByPrefix);
            iterator = hfileReader.getIndexedRecordsByKeyPrefixIterator(Collections.singletonList("key99"), avroSchema);
            recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Assertions.assertEquals(Collections.emptyList(), recordsByPrefix);
            iterator = hfileReader.getEngineRecordsByKeyPrefixIterator(Collections.singletonList("key99"), avroSchema);
            recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Assertions.assertEquals(Collections.emptyList(), recordsByPrefix);
            iterator = hfileReader.getIndexedRecordsByKeyPrefixIterator(Collections.singletonList("key1234"), avroSchema);
            recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Assertions.assertEquals(Collections.emptyList(), recordsByPrefix);
            iterator = hfileReader.getEngineRecordsByKeysIterator(Collections.singletonList("key1234"), avroSchema);
            recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Assertions.assertEquals(Collections.emptyList(), recordsByPrefix);
            List expectedKey50and1s = allRecords.stream().filter(entry -> entry.get("_row_key").toString().contains("key1") || entry.get("_row_key").toString().contains("key30")).collect(Collectors.toList());
            iterator = hfileReader.getIndexedRecordsByKeyPrefixIterator(Arrays.asList("key1", "key30", "key6"), avroSchema);
            recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Assertions.assertEquals(expectedKey50and1s, recordsByPrefix);
            iterator = hfileReader.getEngineRecordsByKeyPrefixIterator(Arrays.asList("key1", "key30", "key6"), avroSchema);
            recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Assertions.assertEquals(expectedKey50and1s, recordsByPrefix);
            List expectedKey50and0s = allRecords.stream().filter(entry -> entry.get("_row_key").toString().contains("key0") || entry.get("_row_key").toString().contains("key50")).collect(Collectors.toList());
            iterator = hfileReader.getIndexedRecordsByKeyPrefixIterator(Arrays.asList("key0", "key50"), avroSchema);
            recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Assertions.assertEquals(expectedKey50and0s, recordsByPrefix);
            iterator = hfileReader.getEngineRecordsByKeyPrefixIterator(Arrays.asList("key0", "key50"), avroSchema);
            recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Assertions.assertEquals(expectedKey50and0s, recordsByPrefix);
            List expectedKey1sand0s = allRecords.stream().filter(entry -> entry.get("_row_key").toString().contains("key1") || entry.get("_row_key").toString().contains("key0")).collect(Collectors.toList());
            iterator = hfileReader.getIndexedRecordsByKeyPrefixIterator(Arrays.asList("key0", "key1"), avroSchema);
            recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Collections.sort(recordsByPrefix, new Comparator<GenericRecord>(){

                @Override
                public int compare(GenericRecord o1, GenericRecord o2) {
                    return o1.get("_row_key").toString().compareTo(o2.get("_row_key").toString());
                }
            });
            Assertions.assertEquals(expectedKey1sand0s, recordsByPrefix);
            iterator = hfileReader.getEngineRecordsByKeyPrefixIterator(Arrays.asList("key0", "key1"), avroSchema);
            recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Collections.sort(recordsByPrefix, new Comparator<GenericRecord>(){

                @Override
                public int compare(GenericRecord o1, GenericRecord o2) {
                    return o1.get("_row_key").toString().compareTo(o2.get("_row_key").toString());
                }
            });
            Assertions.assertEquals(expectedKey1sand0s, recordsByPrefix);
            iterator = hfileReader.getIndexedRecordsByKeyPrefixIterator(Arrays.asList("key1", "key0"), avroSchema);
            recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Collections.sort(recordsByPrefix, new Comparator<GenericRecord>(){

                @Override
                public int compare(GenericRecord o1, GenericRecord o2) {
                    return o1.get("_row_key").toString().compareTo(o2.get("_row_key").toString());
                }
            });
            Assertions.assertEquals(expectedKey1s, recordsByPrefix);
            iterator = hfileReader.getEngineRecordsByKeyPrefixIterator(Arrays.asList("key1", "key0"), avroSchema);
            recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Collections.sort(recordsByPrefix, new Comparator<GenericRecord>(){

                @Override
                public int compare(GenericRecord o1, GenericRecord o2) {
                    return o1.get("_row_key").toString().compareTo(o2.get("_row_key").toString());
                }
            });
        }
        hfileReader = this.getHFileReaderFromFixture(useBloomFilter);
        var4_4 = null;
        try {
            List allRecords = CollectionUtils.toStream((Iterator)hfileReader.getRecordIterator()).map(r -> (GenericRecord)r.getData()).collect(Collectors.toList());
            iterator = hfileReader.getIndexedRecordsByKeyPrefixIterator(Arrays.asList("key000000", "key000066-abcdefghij", "key001424-aa", "key001424-aaa", "key004958", "key010769", "key01988", "key030000"), avroSchema);
            List actual = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            List expected = allRecords.stream().filter(entry -> entry.get("_row_key").toString().contains("key000000") || entry.get("_row_key").toString().contains("key000066-abcdefghij") || entry.get("_row_key").toString().contains("key004958") || entry.get("_row_key").toString().contains("key010769") || entry.get("_row_key").toString().contains("key01988")).collect(Collectors.toList());
            Assertions.assertEquals(expected, actual);
            iterator = hfileReader.getEngineRecordsByKeyPrefixIterator(Arrays.asList("key000000", "key000066-abcdefghij", "key001424-aa", "key001424-aaa", "key004958", "key010769", "key01988", "key030000"), avroSchema);
            actual = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Assertions.assertEquals(expected, actual);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (hfileReader != null) {
                if (var4_4 != null) {
                    try {
                        hfileReader.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    hfileReader.close();
                }
            }
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testReaderGetRecordIteratorByKeysWithBackwardSeek(boolean useBloomFilter) throws Exception {
        this.writeFileWithSimpleSchema();
        try (HoodieAvroHFileReaderImplBase hfileReader = this.createReader(HoodieTestUtils.getStorage((StoragePath)this.getFilePath()), useBloomFilter);){
            Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)"/exampleSchema.avsc");
            try (ClosableIterator iterator = hfileReader.getIndexedRecordsByKeysIterator(Arrays.asList("key00001", "key05", "key24", "key16", "key31", "key61"), avroSchema);){
                Assertions.assertThrows(IllegalStateException.class, () -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).collect(Collectors.toList()));
            }
            iterator = hfileReader.getEngineRecordsByKeysIterator(Arrays.asList("key00001", "key05", "key24", "key16", "key31", "key61"), avroSchema);
            var6_8 = null;
            try {
                Assertions.assertThrows(IllegalStateException.class, () -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).collect(Collectors.toList()));
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            finally {
                if (iterator != null) {
                    if (var6_8 != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        iterator.close();
                    }
                }
            }
        }
    }

    @ParameterizedTest
    @CsvSource(value={"/hfile/hudi_0_9_hbase_1_2_3,true", "/hfile/hudi_0_9_hbase_1_2_3,false", "/hfile/hudi_0_10_hbase_1_2_3,true", "/hfile/hudi_0_10_hbase_1_2_3,false", "/hfile/hudi_0_11_hbase_2_4_9,true", "/hfile/hudi_0_11_hbase_2_4_9,false"})
    public void testHoodieHFileCompatibility(String hfilePrefix, boolean useBloomFilter) throws IOException {
        Schema avroSchema;
        String simpleHFile = hfilePrefix + "_simple.hfile";
        String complexHFile = hfilePrefix + "_complex.hfile";
        String bootstrapIndexFile = hfilePrefix + "_bootstrap_index_partitions.hfile";
        FileSystem fs = HadoopFSUtils.getFs((String)this.getFilePath().toString(), (Configuration)new Configuration());
        byte[] content = TestHFileReader.readHFileFromResources((String)simpleHFile);
        this.verifyHFileReader(content, hfilePrefix, true, useBloomFilter, 50);
        HoodieStorage storage = HoodieTestUtils.getStorage((StoragePath)this.getFilePath());
        try (HoodieAvroHFileReaderImplBase hfileReader = this.createHFileReader(storage, content, useBloomFilter);){
            avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)"/exampleSchema.avsc");
            Assertions.assertEquals((long)50L, (long)hfileReader.getTotalRecords());
            this.verifySimpleRecords((Iterator<HoodieRecord<IndexedRecord>>)hfileReader.getRecordIterator(avroSchema));
        }
        content = TestHFileReader.readHFileFromResources((String)complexHFile);
        this.verifyHFileReader(content, hfilePrefix, true, useBloomFilter, 50);
        hfileReader = this.createHFileReader(storage, content, useBloomFilter);
        var10_10 = null;
        try {
            avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)"/exampleSchemaWithUDT.avsc");
            Assertions.assertEquals((long)50L, (long)hfileReader.getTotalRecords());
            this.verifySimpleRecords((Iterator<HoodieRecord<IndexedRecord>>)hfileReader.getRecordIterator(avroSchema));
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        finally {
            if (hfileReader != null) {
                if (var10_10 != null) {
                    try {
                        hfileReader.close();
                    }
                    catch (Throwable throwable) {
                        var10_10.addSuppressed(throwable);
                    }
                } else {
                    hfileReader.close();
                }
            }
        }
        content = TestHFileReader.readHFileFromResources((String)bootstrapIndexFile);
        this.verifyHFileReader(content, hfilePrefix, false, useBloomFilter, 4);
    }

    private Set<String> getRandomKeys(int count, List<String> keys) {
        HashSet<String> rowKeys = new HashSet<String>();
        int totalKeys = keys.size();
        while (rowKeys.size() < count) {
            int index = FileSystemTestUtils.RANDOM.nextInt(totalKeys);
            if (rowKeys.contains(index)) continue;
            rowKeys.add(keys.get(index));
        }
        return rowKeys;
    }

    private HoodieAvroHFileReaderImplBase getHFileReaderFromFixture(boolean useBloomFilter) throws IOException {
        return this.createHFileReader(HoodieTestUtils.getStorage((StoragePath)this.getFilePath()), TestHFileReader.readHFileFromResources((String)"/hfile/hudi_1_0_hbase_2_4_13_avro_simple_schema_fake_first_key.hfile"), useBloomFilter);
    }
}

