/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.io.hadoop.HoodieAvroHFileWriter;
import org.apache.hudi.io.hadoop.TestHoodieOrcReaderWriter;
import org.apache.hudi.io.storage.HFileReaderFactory;
import org.apache.hudi.io.storage.HoodieAvroHFileReaderImplBase;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.io.storage.HoodieNativeAvroHFileReader;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;

public class TestHoodieNativeAvroHFileReaderCaching {
    @TempDir
    public static Path tempDir;
    private static final Random RANDOM;
    private static final int KEYS_TO_LOOKUP = 10000;
    private static final List<String> EXISTING_KEYS;
    private static final List<String> MISSING_KEYS;
    private static HoodieStorage storage;

    @BeforeAll
    public static void setup() throws Exception {
        int i;
        storage = HoodieTestUtils.getStorage((StoragePath)TestHoodieNativeAvroHFileReaderCaching.getFilePath());
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieOrcReaderWriter.class, (String)"/exampleSchemaWithMetaFields.avsc");
        HoodieAvroHFileWriter writer = TestHoodieNativeAvroHFileReaderCaching.createWriter(avroSchema, true);
        int numRecords = 50000;
        System.out.println("Creating HFile with 50000 records...");
        for (i = 0; i < 50000; ++i) {
            String key = String.format("key_%08d", i);
            EXISTING_KEYS.add(key);
            GenericData.Record record = new GenericData.Record(avroSchema);
            record.put("_row_key", (Object)key);
            record.put("time", (Object)Integer.toString(RANDOM.nextInt()));
            record.put("number", (Object)i);
            writer.writeAvroWithMetadata(new HoodieAvroRecord(new HoodieKey(key, "partition_" + i % 10), (HoodieRecordPayload)new EmptyHoodieRecordPayload()).getKey(), (IndexedRecord)record);
        }
        writer.close();
        for (i = 0; i < 10000; ++i) {
            String missingKey = String.format("missing_key_%08d", i + 50000);
            MISSING_KEYS.add(missingKey);
        }
        System.out.println("HFile created with " + EXISTING_KEYS.size() + " existing keys");
        System.out.println("Generated " + MISSING_KEYS.size() + " missing keys for testing");
    }

    @Test
    @Disabled(value="Enable this for local performance tests")
    public void testBlockCachePerformanceOnRecordLevelIndex() throws Exception {
        System.out.println("\n=== HFile BlockCache Performance Test ===");
        this.testExistingKeysLookup();
        this.testMissingKeysLookup();
        System.out.println("================================================================\n");
    }

    private void testExistingKeysLookup() throws Exception {
        System.out.println("\n--- Testing 10000 Existing Key Lookups ---");
        Collections.shuffle(EXISTING_KEYS, RANDOM);
        List<String> testKeys = EXISTING_KEYS.subList(0, 10000);
        testKeys.sort(String::compareTo);
        this.warmupReads(testKeys.subList(0, 1000));
        long cacheTime = this.measureLookupTime(testKeys, true);
        long noCacheTime = this.measureLookupTime(testKeys, false);
        double speedup = (double)noCacheTime / (double)cacheTime;
        System.out.printf("10000 Existing Key Lookups:\n", new Object[0]);
        System.out.printf("  - Without BlockCache: %d ms\n", noCacheTime);
        System.out.printf("  - With BlockCache: %d ms\n", cacheTime);
        System.out.printf("  - Speedup: %.2fx\n", speedup);
        System.out.printf("  - Performance Improvement: %.1f%%\n", (speedup - 1.0) * 100.0);
        Assertions.assertTrue((speedup > 1.0 ? 1 : 0) != 0, (String)"BlockCache should provide speedup for existing key lookups");
    }

    private void testMissingKeysLookup() throws Exception {
        System.out.println("\n--- Testing 10000 Missing Key Lookups ---");
        ArrayList<String> testKeys = new ArrayList<String>(MISSING_KEYS);
        this.warmupReads(testKeys.subList(0, 1000));
        long noCacheTime = this.measureLookupTime(testKeys, false, false);
        long cacheTime = this.measureLookupTime(testKeys, true, false);
        double speedup = (double)noCacheTime / (double)cacheTime;
        System.out.printf("10000 Missing Key Lookups:\n", new Object[0]);
        System.out.printf("  - Without BlockCache: %d ms\n", noCacheTime);
        System.out.printf("  - With BlockCache: %d ms\n", cacheTime);
        System.out.printf("  - Speedup: %.2fx\n", speedup);
        System.out.printf("  - Performance Improvement: %.1f%%\n", (speedup - 1.0) * 100.0);
        Assertions.assertTrue((speedup >= 0.8 ? 1 : 0) != 0, (String)"BlockCache should not significantly slow down missing key lookups");
    }

    private void warmupReads(List<String> keys) throws Exception {
        try (HoodieAvroHFileReaderImplBase reader = this.createReader(storage, true, true);){
            ClosableIterator iter = reader.getIndexedRecordsByKeysIterator(keys, reader.getSchema());
            CollectionUtils.toStream((Iterator)iter).forEach(record -> {});
        }
    }

    private long measureLookupTime(List<String> keys, boolean enableCache) throws Exception {
        return this.measureLookupTime(keys, enableCache, false);
    }

    private long measureLookupTime(List<String> keys, boolean enableCache, boolean useBloomFilter) throws Exception {
        boolean isExistingKeysTest;
        System.gc();
        Thread.sleep(100L);
        long startTime = System.nanoTime();
        int totalRecordCount = 0;
        for (String key : keys) {
            HoodieAvroHFileReaderImplBase reader = this.createReader(storage, useBloomFilter, enableCache);
            Throwable throwable = null;
            try {
                List<String> singleKey = Collections.singletonList(key);
                ClosableIterator iter = reader.getIndexedRecordsByKeysIterator(singleKey, reader.getSchema());
                while (iter.hasNext()) {
                    iter.next();
                    ++totalRecordCount;
                }
                iter.close();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
        long endTime = System.nanoTime();
        boolean bl = isExistingKeysTest = keys.size() <= EXISTING_KEYS.size() && EXISTING_KEYS.containsAll(keys);
        if (isExistingKeysTest) {
            Assertions.assertTrue((totalRecordCount > 0 ? 1 : 0) != 0, (String)"Should find existing records");
        }
        return (endTime - startTime) / 1000000L;
    }

    private static HoodieAvroHFileWriter createWriter(Schema avroSchema, boolean populateMetaFields) throws Exception {
        String instantTime = "000";
        HoodieStorage storage = HoodieTestUtils.getStorage((StoragePath)TestHoodieNativeAvroHFileReaderCaching.getFilePath());
        Properties props = new Properties();
        props.setProperty(HoodieTableConfig.POPULATE_META_FIELDS.key(), Boolean.toString(populateMetaFields));
        TaskContextSupplier mockTaskContextSupplier = (TaskContextSupplier)Mockito.mock(TaskContextSupplier.class);
        Supplier partitionSupplier = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when((Object)mockTaskContextSupplier.getPartitionIdSupplier()).thenReturn((Object)partitionSupplier);
        Mockito.when(partitionSupplier.get()).thenReturn((Object)10);
        return (HoodieAvroHFileWriter)HoodieFileWriterFactory.getFileWriter((String)instantTime, (StoragePath)TestHoodieNativeAvroHFileReaderCaching.getFilePath(), (HoodieStorage)storage, (HoodieConfig)HoodieStorageConfig.newBuilder().fromProperties(props).build(), (Schema)avroSchema, (TaskContextSupplier)mockTaskContextSupplier, (HoodieRecord.HoodieRecordType)HoodieRecord.HoodieRecordType.AVRO);
    }

    private static StoragePath getFilePath() {
        return new StoragePath(tempDir.toString() + "/perf_test.hfile");
    }

    private HoodieAvroHFileReaderImplBase createReader(HoodieStorage storage, boolean useBloomFilter, boolean enableCache) throws Exception {
        TypedProperties props = new TypedProperties();
        props.setProperty(HoodieReaderConfig.HFILE_BLOCK_CACHE_ENABLED.key(), String.valueOf(enableCache));
        props.setProperty(HoodieReaderConfig.HFILE_BLOCK_CACHE_SIZE.key(), String.valueOf(100));
        HFileReaderFactory readerFactory = HFileReaderFactory.builder().withStorage(storage).withPath(TestHoodieNativeAvroHFileReaderCaching.getFilePath()).withProps(props).build();
        return HoodieNativeAvroHFileReader.builder().readerFactory(readerFactory).path(TestHoodieNativeAvroHFileReaderCaching.getFilePath()).useBloomFilter(useBloomFilter).build();
    }

    static {
        RANDOM = new Random(42L);
        EXISTING_KEYS = new ArrayList<String>();
        MISSING_KEYS = new ArrayList<String>();
    }
}

