/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.parquet.io;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.parquet.io.HoodieParquetBinaryCopyBase;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.CompressionConverter;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TestHoodieParquetBinaryCopyBaseSchemaEvolution {
    @Mock
    private CompressionConverter.TransParquetFileReader reader;
    @Mock
    private ParquetMetadata parquetMetadata;
    @Mock
    private FileMetaData fileMetaData;
    @Mock
    private BlockMetaData blockMetaData;
    @Mock
    private ColumnChunkMetaData columnChunkMetaData;
    @Mock
    private EncodingStats encodingStats;
    private TestableHoodieParquetBinaryCopyBase copyBase;
    private MessageType requiredSchema;
    private MessageType fileSchema;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        this.requiredSchema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().addField((Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).named("field1"))).addField((Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.OPTIONAL).named("field2"))).addField((Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.OPTIONAL).named("field3"))).named("TestRecord");
        this.fileSchema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().addField((Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).named("field1"))).addField((Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.OPTIONAL).named("field2"))).named("TestRecord");
        this.copyBase = (TestableHoodieParquetBinaryCopyBase)((Object)Mockito.spy((Object)((Object)new TestableHoodieParquetBinaryCopyBase(new Configuration()))));
        this.copyBase.requiredSchema = this.requiredSchema;
        Mockito.when((Object)this.reader.getFooter()).thenReturn((Object)this.parquetMetadata);
        Mockito.when((Object)this.parquetMetadata.getFileMetaData()).thenReturn((Object)this.fileMetaData);
        Mockito.when((Object)this.fileMetaData.getSchema()).thenReturn((Object)this.fileSchema);
        Mockito.when((Object)this.columnChunkMetaData.getEncodingStats()).thenReturn((Object)this.encodingStats);
        ((TestableHoodieParquetBinaryCopyBase)((Object)Mockito.doNothing().when((Object)this.copyBase))).addNullColumn((ColumnDescriptor)ArgumentMatchers.any(ColumnDescriptor.class), ArgumentMatchers.anyLong(), (EncodingStats)ArgumentMatchers.any(EncodingStats.class), ArgumentMatchers.any(), (MessageType)ArgumentMatchers.any(MessageType.class), (CompressionCodecName)ArgumentMatchers.any(CompressionCodecName.class));
    }

    @Test
    public void testSchemaEvolutionEnabled_AllowsMissingColumns() throws Exception {
        this.copyBase.setSchemaEvolutionEnabled(true);
        List<ColumnChunkMetaData> columnsInOrder = Arrays.asList(this.columnChunkMetaData);
        Mockito.when((Object)this.blockMetaData.getColumns()).thenReturn(columnsInOrder);
        this.copyBase.setupForTesting(this.reader, this.blockMetaData, columnsInOrder);
        Assertions.assertDoesNotThrow(() -> this.copyBase.testProcessMissedColumns());
        ((TestableHoodieParquetBinaryCopyBase)((Object)Mockito.verify((Object)((Object)this.copyBase), (VerificationMode)Mockito.times((int)1)))).addNullColumn((ColumnDescriptor)ArgumentMatchers.any(ColumnDescriptor.class), ArgumentMatchers.anyLong(), (EncodingStats)ArgumentMatchers.any(EncodingStats.class), ArgumentMatchers.any(), (MessageType)ArgumentMatchers.eq((Object)this.requiredSchema), (CompressionCodecName)ArgumentMatchers.any(CompressionCodecName.class));
    }

    @Test
    public void testSchemaEvolutionDisabled_ThrowsExceptionOnMissingColumns() throws Exception {
        this.copyBase.setSchemaEvolutionEnabled(false);
        List<ColumnChunkMetaData> columnsInOrder = Arrays.asList(this.columnChunkMetaData);
        Mockito.when((Object)this.blockMetaData.getColumns()).thenReturn(columnsInOrder);
        this.copyBase.setupForTesting(this.reader, this.blockMetaData, columnsInOrder);
        HoodieException exception = (HoodieException)Assertions.assertThrows(HoodieException.class, () -> this.copyBase.testProcessMissedColumns());
        Assertions.assertEquals((Object)"Schema evolution is disabled but found missing columns in input file: field3. All input files must have the same schema when schema evolution is disabled.", (Object)exception.getMessage());
        ((TestableHoodieParquetBinaryCopyBase)((Object)Mockito.verify((Object)((Object)this.copyBase), (VerificationMode)Mockito.never()))).addNullColumn((ColumnDescriptor)ArgumentMatchers.any(ColumnDescriptor.class), ArgumentMatchers.anyLong(), (EncodingStats)ArgumentMatchers.any(EncodingStats.class), ArgumentMatchers.any(), (MessageType)ArgumentMatchers.any(MessageType.class), (CompressionCodecName)ArgumentMatchers.any(CompressionCodecName.class));
    }

    @Test
    public void testSchemaEvolutionDisabled_NoMissingColumns_DoesNotThrow() throws Exception {
        this.copyBase.setSchemaEvolutionEnabled(false);
        MessageType completeFileSchema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().addField((Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).named("field1"))).addField((Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.OPTIONAL).named("field2"))).addField((Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.OPTIONAL).named("field3"))).named("TestRecord");
        Mockito.when((Object)this.fileMetaData.getSchema()).thenReturn((Object)completeFileSchema);
        List<ColumnChunkMetaData> columnsInOrder = Arrays.asList(this.columnChunkMetaData);
        Mockito.when((Object)this.blockMetaData.getColumns()).thenReturn(columnsInOrder);
        this.copyBase.setupForTesting(this.reader, this.blockMetaData, columnsInOrder);
        Assertions.assertDoesNotThrow(() -> this.copyBase.testProcessMissedColumns());
        ((TestableHoodieParquetBinaryCopyBase)((Object)Mockito.verify((Object)((Object)this.copyBase), (VerificationMode)Mockito.never()))).addNullColumn((ColumnDescriptor)ArgumentMatchers.any(ColumnDescriptor.class), ArgumentMatchers.anyLong(), (EncodingStats)ArgumentMatchers.any(EncodingStats.class), ArgumentMatchers.any(), (MessageType)ArgumentMatchers.any(MessageType.class), (CompressionCodecName)ArgumentMatchers.any(CompressionCodecName.class));
    }

    @Test
    public void testSchemaEvolutionDisabled_SkipsLegacyConversion() throws Exception {
        this.copyBase.setSchemaEvolutionEnabled(false);
        ColumnChunkMetaData legacyColumn = (ColumnChunkMetaData)Mockito.mock(ColumnChunkMetaData.class);
        ColumnPath legacyPath = ColumnPath.fromDotString((String)"testArray.bag.array_element");
        Mockito.when((Object)legacyColumn.getPath()).thenReturn((Object)legacyPath);
        List<ColumnChunkMetaData> columnsInOrder = Arrays.asList(legacyColumn);
        Mockito.when((Object)this.blockMetaData.getColumns()).thenReturn(columnsInOrder);
        HashMap<ColumnPath, ColumnDescriptor> descriptorsMap = new HashMap<ColumnPath, ColumnDescriptor>();
        this.copyBase.setupForTesting(this.reader, this.blockMetaData, columnsInOrder);
        boolean legacyConversionAttempted = this.copyBase.testLegacyConversionLogic(legacyPath, descriptorsMap);
        Assertions.assertEquals((Object)false, (Object)legacyConversionAttempted, (String)"Legacy conversion should be skipped when schema evolution is disabled");
    }

    @Test
    public void testSchemaEvolutionEnabled_AllowsLegacyConversion() throws Exception {
        this.copyBase.setSchemaEvolutionEnabled(true);
        ColumnChunkMetaData legacyColumn = (ColumnChunkMetaData)Mockito.mock(ColumnChunkMetaData.class);
        ColumnPath legacyPath = ColumnPath.fromDotString((String)"testArray.bag.array_element");
        Mockito.when((Object)legacyColumn.getPath()).thenReturn((Object)legacyPath);
        List<ColumnChunkMetaData> columnsInOrder = Arrays.asList(legacyColumn);
        Mockito.when((Object)this.blockMetaData.getColumns()).thenReturn(columnsInOrder);
        HashMap<ColumnPath, ColumnDescriptor> descriptorsMap = new HashMap<ColumnPath, ColumnDescriptor>();
        this.copyBase.setupForTesting(this.reader, this.blockMetaData, columnsInOrder);
        boolean legacyConversionAttempted = this.copyBase.testLegacyConversionLogic(legacyPath, descriptorsMap);
        Assertions.assertEquals((Object)true, (Object)legacyConversionAttempted, (String)"Legacy conversion should be attempted when schema evolution is enabled");
    }

    private static class TestableHoodieParquetBinaryCopyBase
    extends HoodieParquetBinaryCopyBase {
        private CompressionConverter.TransParquetFileReader testReader;
        private BlockMetaData testBlock;
        private List<ColumnChunkMetaData> testColumnsInOrder;

        public TestableHoodieParquetBinaryCopyBase(Configuration conf) {
            super(conf);
        }

        public void setupForTesting(CompressionConverter.TransParquetFileReader reader, BlockMetaData block, List<ColumnChunkMetaData> columnsInOrder) {
            this.testReader = reader;
            this.testBlock = block;
            this.testColumnsInOrder = columnsInOrder;
        }

        public void testProcessMissedColumns() throws Exception {
            ParquetMetadata meta = this.testReader.getFooter();
            ColumnChunkMetaData columnChunkMetaData = this.testColumnsInOrder.get(0);
            EncodingStats encodingStats = columnChunkMetaData.getEncodingStats();
            List missedColumns = this.missedColumns(this.requiredSchema, meta.getFileMetaData().getSchema()).stream().collect(Collectors.toList());
            if (!this.schemaEvolutionEnabled.booleanValue() && !missedColumns.isEmpty()) {
                String missingColumnsStr = missedColumns.stream().map(c -> String.join((CharSequence)".", c.getPath())).collect(Collectors.joining(", "));
                throw new HoodieException("Schema evolution is disabled but found missing columns in input file: " + missingColumnsStr + ". All input files must have the same schema when schema evolution is disabled.");
            }
            for (ColumnDescriptor descriptor : missedColumns) {
                this.addNullColumn(descriptor, 100L, encodingStats, null, this.requiredSchema, CompressionCodecName.SNAPPY);
            }
        }

        public boolean testLegacyConversionLogic(ColumnPath columnPath, Map<ColumnPath, ColumnDescriptor> descriptorsMap) {
            ColumnDescriptor descriptor = descriptorsMap.get(columnPath);
            if (descriptor == null && this.schemaEvolutionEnabled.booleanValue()) {
                String[] path = columnPath.toArray();
                if (this.convertLegacy3LevelArray(path = Arrays.copyOf(path, path.length)) || this.convertLegacyMap(path)) {
                    return true;
                }
            }
            return false;
        }

        private List<ColumnDescriptor> missedColumns(MessageType requiredSchema, MessageType fileSchema) {
            return requiredSchema.getColumns().stream().filter(col -> !fileSchema.containsPath(col.getPath())).collect(Collectors.toList());
        }

        protected void addNullColumn(ColumnDescriptor descriptor, long totalChunkValues, EncodingStats encodingStats, Object writer, MessageType schema, CompressionCodecName newCodecName) {
        }

        protected Map<String, String> finalizeMetadata() {
            return new HashMap<String, String>();
        }
    }
}

