/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.parquet.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.parquet.io.HoodieParquetFileBinaryCopier;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.util.HoodieFileMetadataMerger;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.crypto.ParquetCipher;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.format.DataPageHeader;
import org.apache.parquet.format.DataPageHeaderV2;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.CompressionConverter;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.internal.column.columnindex.BoundaryOrder;
import org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHoodieParquetFileBinaryCopier {
    private final int numRecord = 1000;
    private Configuration conf = new Configuration();
    private List<TestFile> inputFiles = null;
    private String outputFile = null;
    private HoodieParquetFileBinaryCopier writer = null;

    @BeforeEach
    public void setUp() {
        this.outputFile = TestFileBuilder.createTempFile("test");
    }

    @AfterEach
    public void after() {
        if (this.outputFile != null) {
            TestFileBuilder.deleteTempFile(this.outputFile);
        }
        if (this.inputFiles != null) {
            this.inputFiles.stream().map(TestFile::getFileName).forEach(TestFileBuilder::deleteTempFile);
        }
    }

    @Test
    public void testBasic() throws Exception {
        MessageType schema = this.createSchema();
        this.inputFiles = new ArrayList<TestFile>();
        this.inputFiles.add(this.makeTestFile(schema, "GZIP"));
        this.inputFiles.add(this.makeTestFile(schema, "GZIP"));
        this.writer = this.parquetFileBinaryCopier(schema, "GZIP");
        List inputPaths = this.inputFiles.stream().map(TestFile::getFileName).map(StoragePath::new).collect(Collectors.toList());
        StoragePath outputPath = new StoragePath(this.outputFile);
        this.writer.binaryCopy(inputPaths, Collections.singletonList(outputPath), schema, true);
        this.writer.close();
        this.verify(schema, CompressionCodecName.GZIP);
    }

    @Test
    public void testTranslateCodec() throws Exception {
        MessageType schema = this.createSchema();
        this.inputFiles = new ArrayList<TestFile>();
        this.inputFiles.add(this.makeTestFile(schema, "GZIP"));
        this.inputFiles.add(this.makeTestFile(schema, "UNCOMPRESSED"));
        this.writer = this.parquetFileBinaryCopier(schema, "ZSTD");
        List inputPaths = this.inputFiles.stream().map(TestFile::getFileName).map(StoragePath::new).collect(Collectors.toList());
        StoragePath outputPath = new StoragePath(this.outputFile);
        this.writer.binaryCopy(inputPaths, Collections.singletonList(outputPath), schema, true);
        this.writer.close();
        this.verify(schema, CompressionCodecName.ZSTD);
    }

    @Test
    public void testDifferentSchema() throws Exception {
        MessageType schema1 = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "Gender"), new GroupType(Type.Repetition.OPTIONAL, "Links", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Backward"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Forward")})});
        MessageType schema2 = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "Gender")});
        this.inputFiles = new ArrayList<TestFile>();
        this.inputFiles.add(this.makeTestFile(schema1, "UNCOMPRESSED"));
        this.inputFiles.add(this.makeTestFile(schema2, "UNCOMPRESSED"));
        this.writer = this.parquetFileBinaryCopier(schema1, "UNCOMPRESSED");
        List inputPaths = this.inputFiles.stream().map(TestFile::getFileName).map(StoragePath::new).collect(Collectors.toList());
        StoragePath outputPath = new StoragePath(this.outputFile);
        this.writer.binaryCopy(inputPaths, Collections.singletonList(outputPath), schema1, true);
        this.writer.close();
        this.verify(schema1, CompressionCodecName.UNCOMPRESSED);
    }

    @Test
    public void testConvertLegacy3LevelArrayType() throws Exception {
        MessageType requiredSchema = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new GroupType(Type.Repetition.OPTIONAL, "Links", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "element")})})});
        MessageType inputSchema = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new GroupType(Type.Repetition.OPTIONAL, "Links", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.OPTIONAL, "bag", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "array")})})});
        this.inputFiles = new ArrayList<TestFile>();
        this.inputFiles.add(this.makeTestFile(requiredSchema, "GZIP"));
        this.inputFiles.add(this.makeTestFile(inputSchema, "GZIP"));
        List inputPaths = this.inputFiles.stream().map(TestFile::getFileName).map(StoragePath::new).collect(Collectors.toList());
        this.writer = this.parquetFileBinaryCopier(requiredSchema, "GZIP");
        StoragePath outputPath = new StoragePath(this.outputFile);
        this.writer.binaryCopy(inputPaths, Collections.singletonList(outputPath), requiredSchema, true);
        this.writer.close();
        List columns = inputSchema.getColumns();
        Assertions.assertEquals((int)2, (int)columns.size());
        this.verifyColumnConvert((ColumnDescriptor)columns.get(0), arg_0 -> ((HoodieParquetFileBinaryCopier)this.writer).convertLegacy3LevelArray(arg_0), false, "Name", "Name");
        this.verifyColumnConvert((ColumnDescriptor)columns.get(1), arg_0 -> ((HoodieParquetFileBinaryCopier)this.writer).convertLegacy3LevelArray(arg_0), true, "Links.bag.array", "Links.list.element");
        this.verify(requiredSchema, CompressionCodecName.GZIP);
    }

    @Test
    public void testConvertLegacy3LevelArrayTypeInNestedField() throws Exception {
        MessageType requiredSchema = new MessageType("schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "Links", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "element", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "element")})})})}), new GroupType(Type.Repetition.OPTIONAL, "Map", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "key"), new GroupType(Type.Repetition.OPTIONAL, "value", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "element")})})})})});
        MessageType inputSchema = new MessageType("schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "Links", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.OPTIONAL, "bag", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "array", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.OPTIONAL, "bag", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "array")})})})}), new GroupType(Type.Repetition.OPTIONAL, "Map", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "key"), new GroupType(Type.Repetition.OPTIONAL, "value", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "bag", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "array")})})})})});
        this.inputFiles = new ArrayList<TestFile>();
        this.inputFiles.add(this.makeTestFile(requiredSchema, "GZIP"));
        this.inputFiles.add(this.makeTestFile(inputSchema, "GZIP"));
        List inputPaths = this.inputFiles.stream().map(TestFile::getFileName).map(StoragePath::new).collect(Collectors.toList());
        this.writer = this.parquetFileBinaryCopier(requiredSchema, "GZIP");
        StoragePath outputPath = new StoragePath(this.outputFile);
        this.writer.binaryCopy(inputPaths, Collections.singletonList(outputPath), requiredSchema, true);
        this.writer.close();
        List columns = inputSchema.getColumns();
        Assertions.assertEquals((int)3, (int)columns.size());
        this.verifyColumnConvert((ColumnDescriptor)columns.get(0), arg_0 -> ((HoodieParquetFileBinaryCopier)this.writer).convertLegacy3LevelArray(arg_0), true, "Links.bag.array.bag.array", "Links.list.element.list.element");
        this.verifyColumnConvert((ColumnDescriptor)columns.get(1), arg_0 -> ((HoodieParquetFileBinaryCopier)this.writer).convertLegacy3LevelArray(arg_0), false, "Map.key_value.key", "Map.key_value.key");
        this.verifyColumnConvert((ColumnDescriptor)columns.get(2), arg_0 -> ((HoodieParquetFileBinaryCopier)this.writer).convertLegacy3LevelArray(arg_0), true, "Map.key_value.value.bag.array", "Map.key_value.value.list.element");
        this.verify(requiredSchema, CompressionCodecName.GZIP);
    }

    @Test
    public void testConvertLegacyMapType() throws Exception {
        MessageType requiredSchema = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new GroupType(Type.Repetition.OPTIONAL, "Map", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", OriginalType.MAP_KEY_VALUE, new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "key"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "value")})})});
        MessageType inputSchema = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new GroupType(Type.Repetition.OPTIONAL, "Map", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "map", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "key"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "value")})})});
        this.inputFiles = new ArrayList<TestFile>();
        this.inputFiles.add(this.makeTestFile(requiredSchema, "GZIP"));
        this.inputFiles.add(this.makeTestFile(inputSchema, "GZIP"));
        List inputPaths = this.inputFiles.stream().map(TestFile::getFileName).map(StoragePath::new).collect(Collectors.toList());
        this.writer = this.parquetFileBinaryCopier(requiredSchema, "GZIP");
        StoragePath outputPath = new StoragePath(this.outputFile);
        this.writer.binaryCopy(inputPaths, Collections.singletonList(outputPath), requiredSchema, true);
        this.writer.close();
        List columns = inputSchema.getColumns();
        Assertions.assertEquals((int)3, (int)columns.size());
        this.verifyColumnConvert((ColumnDescriptor)columns.get(0), arg_0 -> ((HoodieParquetFileBinaryCopier)this.writer).convertLegacyMap(arg_0), false, "Name", "Name");
        this.verifyColumnConvert((ColumnDescriptor)columns.get(1), arg_0 -> ((HoodieParquetFileBinaryCopier)this.writer).convertLegacyMap(arg_0), true, "Map.map.key", "Map.key_value.key");
        this.verifyColumnConvert((ColumnDescriptor)columns.get(2), arg_0 -> ((HoodieParquetFileBinaryCopier)this.writer).convertLegacyMap(arg_0), true, "Map.map.value", "Map.key_value.value");
        this.verify(requiredSchema, CompressionCodecName.GZIP);
    }

    @Test
    public void testConvertLegacyMapTypeInNestedField() throws Exception {
        MessageType requiredSchema = new MessageType("schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "Links", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "element", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "key"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "value")})})})}), new GroupType(Type.Repetition.OPTIONAL, "Map", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "key"), new GroupType(Type.Repetition.OPTIONAL, "value", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "key"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "value")})})})})});
        MessageType inputSchema = new MessageType("schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "Links", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "element", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "map", OriginalType.MAP_KEY_VALUE, new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "key"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "value")})})})}), new GroupType(Type.Repetition.OPTIONAL, "Map", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "map", OriginalType.MAP_KEY_VALUE, new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "key"), new GroupType(Type.Repetition.OPTIONAL, "value", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "map", OriginalType.MAP_KEY_VALUE, new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "key"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "value")})})})})});
        this.inputFiles = new ArrayList<TestFile>();
        this.inputFiles.add(this.makeTestFile(requiredSchema, "GZIP"));
        this.inputFiles.add(this.makeTestFile(inputSchema, "GZIP"));
        List inputPaths = this.inputFiles.stream().map(TestFile::getFileName).map(StoragePath::new).collect(Collectors.toList());
        this.writer = this.parquetFileBinaryCopier(requiredSchema, "GZIP");
        StoragePath outputPath = new StoragePath(this.outputFile);
        this.writer.binaryCopy(inputPaths, Collections.singletonList(outputPath), requiredSchema, true);
        this.writer.close();
        List columns = inputSchema.getColumns();
        Assertions.assertEquals((int)5, (int)columns.size());
        this.verifyColumnConvert((ColumnDescriptor)columns.get(0), arg_0 -> ((HoodieParquetFileBinaryCopier)this.writer).convertLegacyMap(arg_0), true, "Links.list.element.map.key", "Links.list.element.key_value.key");
        this.verifyColumnConvert((ColumnDescriptor)columns.get(1), arg_0 -> ((HoodieParquetFileBinaryCopier)this.writer).convertLegacyMap(arg_0), true, "Links.list.element.map.value", "Links.list.element.key_value.value");
        this.verifyColumnConvert((ColumnDescriptor)columns.get(2), arg_0 -> ((HoodieParquetFileBinaryCopier)this.writer).convertLegacyMap(arg_0), true, "Map.map.key", "Map.key_value.key");
        this.verifyColumnConvert((ColumnDescriptor)columns.get(3), arg_0 -> ((HoodieParquetFileBinaryCopier)this.writer).convertLegacyMap(arg_0), true, "Map.map.value.map.key", "Map.key_value.value.key_value.key");
        this.verifyColumnConvert((ColumnDescriptor)columns.get(4), arg_0 -> ((HoodieParquetFileBinaryCopier)this.writer).convertLegacyMap(arg_0), true, "Map.map.value.map.value", "Map.key_value.value.key_value.value");
        this.verify(requiredSchema, CompressionCodecName.GZIP);
    }

    @Test
    public void testHoodieMetaColumn() throws Exception {
        MessageType schema = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, HoodieRecord.FILENAME_METADATA_FIELD), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "Gender"), new GroupType(Type.Repetition.OPTIONAL, "Links", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Backward"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Forward")})});
        this.inputFiles = new ArrayList<TestFile>();
        this.inputFiles.add(this.makeTestFile(schema, "GZIP"));
        this.inputFiles.add(this.makeTestFile(schema, "GZIP"));
        this.writer = this.parquetFileBinaryCopier(schema, "GZIP");
        List inputPaths = this.inputFiles.stream().map(TestFile::getFileName).map(StoragePath::new).collect(Collectors.toList());
        StoragePath outputPath = new StoragePath(this.outputFile);
        this.writer.binaryCopy(inputPaths, Collections.singletonList(outputPath), schema, true);
        this.writer.close();
        this.verify(schema, CompressionCodecName.GZIP);
    }

    private TestFile makeTestFile(MessageType schema, String codec) throws IOException {
        return new TestFileBuilder(this.conf, schema).withNumRecord(1000).withCodec(codec).withPageSize(0x100000).build();
    }

    private HoodieParquetFileBinaryCopier parquetFileBinaryCopier(MessageType schema, String codec) {
        CompressionCodecName codecName = CompressionCodecName.fromConf((String)codec);
        HoodieFileMetadataMerger metadataMerger = new HoodieFileMetadataMerger();
        return new HoodieParquetFileBinaryCopier(this.conf, codecName, metadataMerger);
    }

    private MessageType createSchema() {
        return new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "Gender"), new GroupType(Type.Repetition.OPTIONAL, "Links", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Backward"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Forward")})});
    }

    private void validateColumnData(MessageType requiredSchema) throws IOException {
        Path outputFilePath = new Path(this.outputFile);
        ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)outputFilePath).withConf(this.conf).build();
        int totalRows = 0;
        for (TestFile inputFile : this.inputFiles) {
            totalRows += inputFile.getFileContent().length;
        }
        for (int i = 0; i < totalRows; ++i) {
            Group group = (Group)reader.read();
            Assertions.assertNotNull((Object)group);
            SimpleGroup expectGroup = this.inputFiles.get(i / 1000).getFileContent()[i % 1000];
            this.checkField((GroupType)requiredSchema, (Group)expectGroup, group);
        }
        reader.close();
    }

    private void checkField(GroupType schema, Group expectGroup, Group actualGroup) {
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            if (expectGroup.getType().getFieldCount() - 1 < i) {
                Assertions.assertEquals((int)0, (int)actualGroup.getFieldRepetitionCount(i));
                continue;
            }
            Type type = schema.getType(i);
            if (HoodieRecord.FILENAME_METADATA_FIELD.equals(type.getName())) {
                Path outputFilePath = new Path(this.outputFile);
                Assertions.assertEquals((Object)outputFilePath.getName(), (Object)actualGroup.getString(HoodieRecord.FILENAME_METADATA_FIELD, 0));
                Assertions.assertNotEquals((Object)actualGroup.getString(HoodieRecord.FILENAME_METADATA_FIELD, 0), (Object)expectGroup.getString(HoodieRecord.FILENAME_METADATA_FIELD, 0));
                continue;
            }
            if (type.isPrimitive()) {
                PrimitiveType primitiveType = (PrimitiveType)type;
                if (primitiveType.getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.INT32)) {
                    Assertions.assertEquals((int)expectGroup.getInteger(i, 0), (int)actualGroup.getInteger(i, 0));
                    continue;
                }
                if (primitiveType.getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.INT64)) {
                    Assertions.assertEquals((long)expectGroup.getLong(i, 0), (long)actualGroup.getLong(i, 0));
                    continue;
                }
                if (!primitiveType.getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.BINARY)) continue;
                Assertions.assertEquals((Object)expectGroup.getString(i, 0), (Object)actualGroup.getString(i, 0));
                continue;
            }
            GroupType groupType = (GroupType)type;
            this.checkField(groupType, expectGroup.getGroup(i, 0), actualGroup.getGroup(i, 0));
        }
    }

    private ParquetMetadata getFileMetaData(String file) throws IOException {
        return ParquetFileReader.readFooter((Configuration)this.conf, (Path)new Path(file));
    }

    private void verify(MessageType requiredSchema, CompressionCodecName expectedCodec) throws Exception {
        ParquetMetadata pmd = ParquetFileReader.readFooter((Configuration)this.conf, (Path)new Path(this.outputFile), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        MessageType fileSchema = pmd.getFileMetaData().getSchema();
        Assertions.assertEquals((Object)requiredSchema, (Object)fileSchema);
        this.verifyCodec(this.outputFile, expectedCodec);
        this.validateColumnData(requiredSchema);
        this.validatePageIndex(requiredSchema);
        this.validateCreatedBy();
    }

    private void verifyCodec(String file, final CompressionCodecName expectedCodecs) throws IOException {
        HashSet<CompressionCodecName> codecs = new HashSet<CompressionCodecName>();
        ParquetMetadata pmd = this.getFileMetaData(file);
        for (int i = 0; i < pmd.getBlocks().size(); ++i) {
            BlockMetaData block = (BlockMetaData)pmd.getBlocks().get(i);
            for (int j = 0; j < block.getColumns().size(); ++j) {
                ColumnChunkMetaData columnChunkMetaData = (ColumnChunkMetaData)block.getColumns().get(j);
                codecs.add(columnChunkMetaData.getCodec());
            }
        }
        Assertions.assertEquals((Object)new HashSet<CompressionCodecName>(){
            {
                this.add(expectedCodecs);
            }
        }, codecs);
    }

    private void validatePageIndex(MessageType requiredSchema) throws Exception {
        ParquetMetadata outMetaData = this.getFileMetaData(this.outputFile);
        int inputFileIndex = 0;
        CompressionConverter.TransParquetFileReader inReader = new CompressionConverter.TransParquetFileReader((InputFile)HadoopInputFile.fromPath((Path)new Path(this.inputFiles.get(inputFileIndex).getFileName()), (Configuration)this.conf), HadoopReadOptions.builder((Configuration)this.conf).build());
        ParquetMetadata inMetaData = inReader.getFooter();
        Path outputFilePath = new Path(this.outputFile);
        try (CompressionConverter.TransParquetFileReader outReader = new CompressionConverter.TransParquetFileReader((InputFile)HadoopInputFile.fromPath((Path)outputFilePath, (Configuration)this.conf), HadoopReadOptions.builder((Configuration)this.conf).build());){
            int outBlockId = 0;
            int inBlockId = 0;
            while (outBlockId < outMetaData.getBlocks().size()) {
                if (inBlockId == inMetaData.getBlocks().size()) {
                    inReader = new CompressionConverter.TransParquetFileReader((InputFile)HadoopInputFile.fromPath((Path)new Path(this.inputFiles.get(++inputFileIndex).getFileName()), (Configuration)this.conf), HadoopReadOptions.builder((Configuration)this.conf).build());
                    inMetaData = inReader.getFooter();
                    inBlockId = 0;
                }
                BlockMetaData inBlockMetaData = (BlockMetaData)inMetaData.getBlocks().get(inBlockId);
                BlockMetaData outBlockMetaData = (BlockMetaData)outMetaData.getBlocks().get(outBlockId);
                int inputColumns = inBlockMetaData.getColumns().size();
                List fields = requiredSchema.getFields();
                for (int i = 0; i < fields.size(); ++i) {
                    ColumnChunkMetaData outChunk = (ColumnChunkMetaData)outBlockMetaData.getColumns().get(i);
                    ColumnIndex outColumnIndex = outReader.readColumnIndex(outChunk);
                    OffsetIndex outOffsetIndex = outReader.readOffsetIndex(outChunk);
                    if (inputColumns - 1 < i) {
                        Assertions.assertEquals((Object)BoundaryOrder.ASCENDING, (Object)outColumnIndex.getBoundaryOrder());
                        Assertions.assertEquals((int)1, (int)outColumnIndex.getNullCounts().size());
                        Assertions.assertEquals((long)outChunk.getValueCount(), (Long)((Long)outColumnIndex.getNullCounts().get(0)));
                        List<Long> outOffsets = this.getOffsets(outReader, outChunk);
                        Assertions.assertEquals((int)outOffsetIndex.getPageCount(), (int)outOffsets.size());
                        for (int k = 0; k < outOffsetIndex.getPageCount(); ++k) {
                            Assertions.assertEquals((long)outOffsetIndex.getOffset(k), (long)outOffsets.get(k));
                        }
                        continue;
                    }
                    ColumnChunkMetaData inChunk = (ColumnChunkMetaData)inBlockMetaData.getColumns().get(i);
                    ColumnIndex inColumnIndex = inReader.readColumnIndex(inChunk);
                    OffsetIndex inOffsetIndex = inReader.readOffsetIndex(inChunk);
                    if (outChunk.getPath().toDotString().equals(HoodieRecord.FILENAME_METADATA_FIELD)) {
                        Assertions.assertEquals((Object)BoundaryOrder.ASCENDING, (Object)outColumnIndex.getBoundaryOrder());
                        Assertions.assertEquals((int)1, (int)outColumnIndex.getNullCounts().size());
                        Assertions.assertEquals((long)0L, (Long)((Long)outColumnIndex.getNullCounts().get(0)));
                        Assertions.assertEquals((Object)outputFilePath.getName(), (Object)Binary.fromReusedByteBuffer((ByteBuffer)((ByteBuffer)outColumnIndex.getMaxValues().get(0))).toStringUsingUTF8());
                        Assertions.assertEquals((Object)outputFilePath.getName(), (Object)Binary.fromReusedByteBuffer((ByteBuffer)((ByteBuffer)outColumnIndex.getMinValues().get(0))).toStringUsingUTF8());
                        List<Long> outOffsets = this.getOffsets(outReader, outChunk);
                        Assertions.assertEquals((int)outOffsetIndex.getPageCount(), (int)outOffsets.size());
                        for (int k = 0; k < outOffsetIndex.getPageCount(); ++k) {
                            Assertions.assertEquals((long)outOffsetIndex.getOffset(k), (long)outOffsets.get(k));
                        }
                        continue;
                    }
                    if (inColumnIndex != null) {
                        Assertions.assertEquals((Object)inColumnIndex.getBoundaryOrder(), (Object)outColumnIndex.getBoundaryOrder());
                        Assertions.assertEquals((Object)inColumnIndex.getMaxValues(), (Object)outColumnIndex.getMaxValues());
                        Assertions.assertEquals((Object)inColumnIndex.getMinValues(), (Object)outColumnIndex.getMinValues());
                        Assertions.assertEquals((Object)inColumnIndex.getNullCounts(), (Object)outColumnIndex.getNullCounts());
                    }
                    if (inOffsetIndex == null) continue;
                    List<Long> inOffsets = this.getOffsets(inReader, inChunk);
                    List<Long> outOffsets = this.getOffsets(outReader, outChunk);
                    Assertions.assertEquals((int)inOffsets.size(), (int)outOffsets.size());
                    Assertions.assertEquals((int)inOffsets.size(), (int)inOffsetIndex.getPageCount());
                    Assertions.assertEquals((int)inOffsetIndex.getPageCount(), (int)outOffsetIndex.getPageCount());
                    for (int k = 0; k < inOffsetIndex.getPageCount(); ++k) {
                        Assertions.assertEquals((long)inOffsetIndex.getFirstRowIndex(k), (long)outOffsetIndex.getFirstRowIndex(k));
                        Assertions.assertEquals((long)inOffsetIndex.getLastRowIndex(k, inChunk.getValueCount()), (long)outOffsetIndex.getLastRowIndex(k, outChunk.getValueCount()));
                        Assertions.assertEquals((long)inOffsetIndex.getOffset(k), (long)inOffsets.get(k));
                        Assertions.assertEquals((long)outOffsetIndex.getOffset(k), (long)outOffsets.get(k));
                    }
                }
                ++outBlockId;
                ++inBlockId;
            }
        }
    }

    private List<Long> getOffsets(CompressionConverter.TransParquetFileReader reader, ColumnChunkMetaData chunk) throws IOException {
        ArrayList<Long> offsets = new ArrayList<Long>();
        reader.setStreamPosition(chunk.getStartingPos());
        long readValues = 0L;
        long totalChunkValues = chunk.getValueCount();
        block5: while (readValues < totalChunkValues) {
            long curOffset = reader.getPos();
            PageHeader pageHeader = reader.readPageHeader();
            switch (pageHeader.type) {
                case DICTIONARY_PAGE: {
                    this.writer.readBlock(pageHeader.getCompressed_page_size(), reader);
                    continue block5;
                }
                case DATA_PAGE: {
                    DataPageHeader headerV1 = pageHeader.data_page_header;
                    offsets.add(curOffset);
                    this.writer.readBlock(pageHeader.getCompressed_page_size(), reader);
                    readValues += (long)headerV1.getNum_values();
                    continue block5;
                }
                case DATA_PAGE_V2: {
                    DataPageHeaderV2 headerV2 = pageHeader.data_page_header_v2;
                    offsets.add(curOffset);
                    int rlLength = headerV2.getRepetition_levels_byte_length();
                    this.writer.readBlock(rlLength, reader);
                    int dlLength = headerV2.getDefinition_levels_byte_length();
                    this.writer.readBlock(dlLength, reader);
                    int payLoadLength = pageHeader.getCompressed_page_size() - rlLength - dlLength;
                    this.writer.readBlock(payLoadLength, reader);
                    readValues += (long)headerV2.getNum_values();
                    continue block5;
                }
            }
            throw new IOException("Not recognized page type");
        }
        return offsets;
    }

    private void validateCreatedBy() throws Exception {
        HashSet<String> createdBySet = new HashSet<String>();
        for (TestFile inputFile : this.inputFiles) {
            ParquetMetadata pmd = this.getFileMetaData(inputFile.getFileName());
            createdBySet.add(pmd.getFileMetaData().getCreatedBy());
            Assertions.assertNull(pmd.getFileMetaData().getKeyValueMetaData().get("original.created.by"));
        }
        Object[] inputCreatedBys = createdBySet.toArray();
        Assertions.assertEquals((int)1, (int)inputCreatedBys.length);
        FileMetaData outFMD = this.getFileMetaData(this.outputFile).getFileMetaData();
        String createdBy = outFMD.getCreatedBy();
        Assertions.assertNotNull((Object)createdBy);
        Assertions.assertEquals((Object)createdBy, (Object)"parquet-mr version 1.13.1 (build db4183109d5b734ec5930d870cdae161e408ddba)");
        String inputCreatedBy = (String)inputCreatedBys[0];
        String originalCreatedBy = (String)outFMD.getKeyValueMetaData().get("original.created.by");
        Assertions.assertEquals((Object)inputCreatedBy, (Object)originalCreatedBy);
    }

    private void verifyColumnConvert(ColumnDescriptor column, Function<String[], Boolean> converter, Boolean changed, String originalPathStr, String convertedPathStr) {
        String[] path = column.getPath();
        String[] originalPath = Arrays.copyOf(path, path.length);
        Assertions.assertEquals((Object)changed, (Object)converter.apply(path));
        Assertions.assertEquals((Object)originalPathStr, (Object)this.pathToString(originalPath));
        Assertions.assertEquals((Object)convertedPathStr, (Object)this.pathToString(path));
    }

    private String pathToString(String[] path) {
        return Arrays.stream(path).collect(Collectors.joining("."));
    }

    public static class TestFile {
        private final String fileName;
        private final SimpleGroup[] fileContent;

        public TestFile(String fileName, SimpleGroup[] fileContent) {
            this.fileName = fileName;
            this.fileContent = fileContent;
        }

        public String getFileName() {
            return this.fileName;
        }

        public SimpleGroup[] getFileContent() {
            return this.fileContent;
        }
    }

    public static class TestFileBuilder {
        private MessageType schema;
        private Configuration conf;
        private Map<String, String> extraMeta = new HashMap<String, String>();
        private int numRecord = 100000;
        private ParquetProperties.WriterVersion writerVersion = ParquetProperties.WriterVersion.PARQUET_1_0;
        private int pageSize = 0x100000;
        private String codec = "ZSTD";
        private String[] encryptColumns = new String[0];
        private ParquetCipher cipher = ParquetCipher.AES_GCM_V1;
        private Boolean footerEncryption = false;

        public TestFileBuilder(Configuration conf, MessageType schema) {
            this.conf = conf;
            this.schema = schema;
            conf.set("parquet.example.schema", schema.toString());
        }

        public TestFileBuilder withNumRecord(int numRecord) {
            this.numRecord = numRecord;
            return this;
        }

        public TestFileBuilder withEncrytionAlgorithm(ParquetCipher cipher) {
            this.cipher = cipher;
            return this;
        }

        public TestFileBuilder withExtraMeta(Map<String, String> extraMeta) {
            this.extraMeta = extraMeta;
            return this;
        }

        public TestFileBuilder withWriterVersion(ParquetProperties.WriterVersion writerVersion) {
            this.writerVersion = writerVersion;
            return this;
        }

        public TestFileBuilder withPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public TestFileBuilder withCodec(String codec) {
            this.codec = codec;
            return this;
        }

        public TestFileBuilder withEncryptColumns(String[] encryptColumns) {
            this.encryptColumns = encryptColumns;
            return this;
        }

        public TestFileBuilder withFooterEncryption() {
            this.footerEncryption = true;
            return this;
        }

        public TestFile build() throws IOException {
            String fileName = TestFileBuilder.createTempFile("test");
            SimpleGroup[] fileContent = this.createFileContent(this.schema);
            ExampleParquetWriter.Builder builder = (ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)new Path(fileName)).withConf(this.conf)).withWriterVersion(this.writerVersion)).withExtraMetaData(this.extraMeta).withValidation(true)).withPageSize(this.pageSize)).withCompressionCodec(CompressionCodecName.valueOf((String)this.codec));
            try (ParquetWriter writer = builder.build();){
                for (int i = 0; i < fileContent.length; ++i) {
                    writer.write((Object)fileContent[i]);
                }
            }
            return new TestFile(fileName, fileContent);
        }

        private SimpleGroup[] createFileContent(MessageType schema) {
            SimpleGroup[] simpleGroups = new SimpleGroup[this.numRecord];
            for (int i = 0; i < simpleGroups.length; ++i) {
                SimpleGroup g = new SimpleGroup((GroupType)schema);
                for (Type type : schema.getFields()) {
                    this.addValueToSimpleGroup((Group)g, type);
                }
                simpleGroups[i] = g;
            }
            return simpleGroups;
        }

        private void addValueToSimpleGroup(Group g, Type type) {
            block3: {
                block1: {
                    PrimitiveType primitiveType;
                    block4: {
                        block2: {
                            if (!type.isPrimitive()) break block1;
                            primitiveType = (PrimitiveType)type;
                            if (!primitiveType.getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.INT32)) break block2;
                            g.add(type.getName(), TestFileBuilder.getInt());
                            break block3;
                        }
                        if (!primitiveType.getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.INT64)) break block4;
                        g.add(type.getName(), TestFileBuilder.getLong());
                        break block3;
                    }
                    if (!primitiveType.getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.BINARY)) break block3;
                    g.add(type.getName(), TestFileBuilder.getString());
                    break block3;
                }
                GroupType groupType = (GroupType)type;
                Group parentGroup = g.addGroup(groupType.getName());
                for (Type field : groupType.getFields()) {
                    this.addValueToSimpleGroup(parentGroup, field);
                }
            }
        }

        private static long getInt() {
            return ThreadLocalRandom.current().nextInt(10000);
        }

        private static long getLong() {
            return ThreadLocalRandom.current().nextLong(100000L);
        }

        private static String getString() {
            char[] chars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'x', 'z', 'y'};
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 100; ++i) {
                sb.append(chars[ThreadLocalRandom.current().nextInt(10)]);
            }
            return sb.toString();
        }

        public static String createTempFile(String prefix) {
            try {
                return Files.createTempDirectory(prefix, new FileAttribute[0]).toAbsolutePath().toString() + "/test.parquet";
            }
            catch (IOException e) {
                throw new AssertionError("Unable to create temporary file", e);
            }
        }

        public static void deleteTempFile(String file) {
            try {
                Files.delete(Paths.get(file, new String[0]));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

