/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.parquet.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.parquet.io.ParquetBinaryCopyChecker;
import org.apache.hudi.parquet.io.TestHoodieParquetFileBinaryCopier;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestParquetBinaryCopyChecker {
    private Configuration conf = new Configuration();
    private final int numRecord = 0;
    private static final PrimitiveType BINARY_TYPE = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("Binary");
    private static final PrimitiveType INT32_TYPE = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("Int32");
    private static final PrimitiveType INT64_TYPE = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("Int64");
    private static final PrimitiveType INT96_TYPE = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96).named("Int96");
    private static final PrimitiveType FLOAT_TYPE = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT).named("Float");
    private static final PrimitiveType DOUBLE_TYPE = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE).named("DOUBLE");
    private static final PrimitiveType BOOLEAN_TYPE = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN).named("BOOLEAN");
    private static final PrimitiveType FIXED_LEN_BYTE_ARRAY_TYPE = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(20)).named("FIXED_LEN_BYTE_ARRAY_TYPE");
    private static final GroupType LEGACY_TWO_LEVEL_ARRAY_TYPE = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)Types.optionalGroup().as(OriginalType.LIST)).addField((Type)Types.repeated((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("array"))).named("LEGACY_TWO_LEVEL_ARRAY_TYPE");
    private static final GroupType LEGACY_TREE_LEVEL_ARRAY_TYPE = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.optionalGroup().as(OriginalType.LIST)).optionalGroup().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("array"))).named("bag")).named("LEGACY_TREE_LEVEL_ARRAY_TYPE");
    private static final GroupType STANDARD_THREE_LEVEL_ARRAY_TYPE = (GroupType)Types.optionalList().element(PrimitiveType.PrimitiveTypeName.BINARY, Type.Repetition.OPTIONAL).named("STANDARD_THREE_LEVEL_ARRAY_TYPE");
    private static final GroupType LEGACY_MAP_TYPE = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.optionalGroup().as(OriginalType.MAP)).optionalGroup().addField((Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("key"))).addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("value"))).named("map")).named("LEGACY_MAP_TYPE");
    private static final GroupType STANDARD_MAP_TYPE = (GroupType)Types.optionalMap().key(PrimitiveType.PrimitiveTypeName.BINARY).value(PrimitiveType.PrimitiveTypeName.BINARY, Type.Repetition.OPTIONAL).named("STANDARD_MAP_TYPE");
    private static final PrimitiveType INT32_DECIMAL_TYPE = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)5))).named("INT32_DECIMAL_TYPE");
    private static final PrimitiveType INT64_DECIMAL_TYPE = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)15))).named("INT64_DECIMAL_TYPE");
    private static final PrimitiveType FIXED_LEN_BYTE_ARRAY_DECIMAL_TYPE = (PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(25)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)25))).named("FIXED_LEN_BYTE_ARRAY_DECIMAL_TYPE");

    @Test
    public void testVerifyFilesBySupport() {
        ParquetBinaryCopyChecker.ParquetFileInfo file = this.makeSchemaNotSupportFileInfo();
        List<ParquetBinaryCopyChecker.ParquetFileInfo> files = this.makeFileInfos(file);
        Assertions.assertFalse((boolean)ParquetBinaryCopyChecker.verifyFiles(files));
    }

    @Test
    public void testVerifyFilesByFilterCode() {
        String schema = ((MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().addField((Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("field1"))).addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("field2"))).addField((Type)Types.repeated((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("field3"))).named("schema")).toString();
        ParquetBinaryCopyChecker.ParquetFileInfo file1 = this.makeFileInfo(true, null, null);
        ParquetBinaryCopyChecker.ParquetFileInfo file2 = this.makeFileInfo(true, "simple", schema);
        ParquetBinaryCopyChecker.ParquetFileInfo file3 = this.makeFileInfo(true, "dynamic", schema);
        List<ParquetBinaryCopyChecker.ParquetFileInfo> files = this.makeFileInfos(file1, file2);
        Assertions.assertFalse((boolean)ParquetBinaryCopyChecker.verifyFiles(files));
        files = this.makeFileInfos(file2, file3);
        Assertions.assertFalse((boolean)ParquetBinaryCopyChecker.verifyFiles(files));
    }

    @Test
    public void testVerifyFilesByRepetition() {
        String schema = ((MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().addField((Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("field1"))).addField((Type)Types.optionalList().requiredElement(PrimitiveType.PrimitiveTypeName.BINARY).named("list-simple"))).addField((Type)((Types.BaseListBuilder.GroupElementBuilder)Types.optionalList().optionalGroupElement().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("ele"))).named("list-nested"))).addField((Type)((Types.MapBuilder)((Types.MapBuilder)Types.optionalMap().key((Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("key"))).value((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("value"))).named("map-simple"))).addField((Type)((Types.MapBuilder)((Types.MapBuilder)Types.optionalMap().key((Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("key"))).value((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("map-ele"))).named("value"))).named("map-nested"))).addField((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("struct-field1"))).named("struct-simple"))).addField((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("struct-field2-int"))).named("struct-field2"))).named("struct-nested"))).named("schema")).toString();
        ParquetBinaryCopyChecker.ParquetFileInfo file1 = this.makeFileInfo(true, "dynamic", schema);
        schema = ((MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("field1"))).addField((Type)Types.optionalList().requiredElement(PrimitiveType.PrimitiveTypeName.BINARY).named("list-simple"))).addField((Type)((Types.BaseListBuilder.GroupElementBuilder)Types.optionalList().optionalGroupElement().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("ele"))).named("list-nested"))).addField((Type)((Types.MapBuilder)((Types.MapBuilder)Types.optionalMap().key((Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("key"))).value((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("value"))).named("map-simple"))).addField((Type)((Types.MapBuilder)((Types.MapBuilder)Types.optionalMap().key((Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("key"))).value((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("map-ele"))).named("value"))).named("map-nested"))).addField((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("struct-field1"))).named("struct-simple"))).addField((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("struct-field2-int"))).named("struct-field2"))).named("struct-nested"))).named("schema")).toString();
        ParquetBinaryCopyChecker.ParquetFileInfo file2 = this.makeFileInfo(true, "dynamic", schema);
        schema = ((MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().addField((Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("field1"))).addField((Type)Types.optionalList().requiredElement(PrimitiveType.PrimitiveTypeName.BINARY).named("list-simple"))).addField((Type)((Types.BaseListBuilder.GroupElementBuilder)Types.optionalList().requiredGroupElement().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("ele"))).named("list-nested"))).addField((Type)((Types.MapBuilder)((Types.MapBuilder)Types.optionalMap().key((Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("key"))).value((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("value"))).named("map-simple"))).addField((Type)((Types.MapBuilder)((Types.MapBuilder)Types.optionalMap().key((Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("key"))).value((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("map-ele"))).named("value"))).named("map-nested"))).addField((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("struct-field1"))).named("struct-simple"))).addField((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("struct-field2-int"))).named("struct-field2"))).named("struct-nested"))).named("schema")).toString();
        ParquetBinaryCopyChecker.ParquetFileInfo file3 = this.makeFileInfo(true, "dynamic", schema);
        schema = ((MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().addField((Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("field1"))).addField((Type)Types.optionalList().requiredElement(PrimitiveType.PrimitiveTypeName.BINARY).named("list-simple"))).addField((Type)((Types.BaseListBuilder.GroupElementBuilder)Types.optionalList().optionalGroupElement().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("ele"))).named("list-nested"))).addField((Type)((Types.MapBuilder)((Types.MapBuilder)Types.optionalMap().key((Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("key"))).value((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("value"))).named("map-simple"))).addField((Type)((Types.MapBuilder)((Types.MapBuilder)Types.optionalMap().key((Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("key"))).value((Type)((Types.GroupBuilder)Types.requiredGroup().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("map-ele"))).named("value"))).named("map-nested"))).addField((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("struct-field1"))).named("struct-simple"))).addField((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("struct-field2-int"))).named("struct-field2"))).named("struct-nested"))).named("schema")).toString();
        ParquetBinaryCopyChecker.ParquetFileInfo file4 = this.makeFileInfo(true, "dynamic", schema);
        schema = ((MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().addField((Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("field1"))).addField((Type)Types.optionalList().requiredElement(PrimitiveType.PrimitiveTypeName.BINARY).named("list-simple"))).addField((Type)((Types.BaseListBuilder.GroupElementBuilder)Types.optionalList().optionalGroupElement().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("ele"))).named("list-nested"))).addField((Type)((Types.MapBuilder)((Types.MapBuilder)Types.optionalMap().key((Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("key"))).value((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("value"))).named("map-simple"))).addField((Type)((Types.MapBuilder)((Types.MapBuilder)Types.optionalMap().key((Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("key"))).value((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("map-ele"))).named("value"))).named("map-nested"))).addField((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("struct-field1"))).named("struct-simple"))).addField((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("struct-field2-int"))).named("struct-field2"))).named("struct-nested"))).named("schema")).toString();
        ParquetBinaryCopyChecker.ParquetFileInfo file5 = this.makeFileInfo(true, "dynamic", schema);
        schema = ((MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().addField((Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("field1"))).addField((Type)Types.optionalList().requiredElement(PrimitiveType.PrimitiveTypeName.BINARY).named("list-simple"))).addField((Type)((Types.BaseListBuilder.GroupElementBuilder)Types.optionalList().optionalGroupElement().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("ele"))).named("list-nested"))).addField((Type)((Types.MapBuilder)((Types.MapBuilder)Types.optionalMap().key((Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("key"))).value((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("value"))).named("map-simple"))).addField((Type)((Types.MapBuilder)((Types.MapBuilder)Types.optionalMap().key((Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("key"))).value((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("map-ele"))).named("value"))).named("map-nested"))).addField((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("struct-field1"))).named("struct-simple"))).addField((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)((Types.GroupBuilder)Types.optionalGroup().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("struct-field2-int"))).named("struct-field2"))).named("struct-nested"))).addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("field-added"))).named("schema")).toString();
        ParquetBinaryCopyChecker.ParquetFileInfo file6 = this.makeFileInfo(true, "dynamic", schema);
        ParquetBinaryCopyChecker.ParquetFileInfo file7 = this.makeFileInfo(true, "dynamic", schema);
        List<ParquetBinaryCopyChecker.ParquetFileInfo> files = this.makeFileInfos(file1, file2);
        Assertions.assertFalse((boolean)ParquetBinaryCopyChecker.verifyFiles(files));
        files = this.makeFileInfos(file1, file3);
        Assertions.assertFalse((boolean)ParquetBinaryCopyChecker.verifyFiles(files));
        files = this.makeFileInfos(file1, file4);
        Assertions.assertFalse((boolean)ParquetBinaryCopyChecker.verifyFiles(files));
        files = this.makeFileInfos(file1, file5);
        Assertions.assertFalse((boolean)ParquetBinaryCopyChecker.verifyFiles(files));
        files = this.makeFileInfos(file1, file6);
        Assertions.assertTrue((boolean)ParquetBinaryCopyChecker.verifyFiles(files));
        files = this.makeFileInfos(file6, file7);
        Assertions.assertTrue((boolean)ParquetBinaryCopyChecker.verifyFiles(files));
    }

    @Test
    public void testVerifyFile() throws IOException {
        MessageType schema = new MessageType("schema", new Type[]{BINARY_TYPE, INT32_TYPE, INT64_TYPE, INT96_TYPE, FLOAT_TYPE, DOUBLE_TYPE, BOOLEAN_TYPE, FIXED_LEN_BYTE_ARRAY_TYPE});
        String testFile = this.makeTestFile(schema, "simple");
        ParquetBinaryCopyChecker.ParquetFileInfo info = ParquetBinaryCopyChecker.collectFileInfo((Configuration)this.conf, (String)testFile);
        Assertions.assertNotNull((Object)info);
        Assertions.assertTrue((boolean)info.canBinaryCopy());
        String schemaString = schema.toString();
        this.assertFileInfo(info, true, "simple", schemaString);
        TestHoodieParquetFileBinaryCopier.TestFileBuilder.deleteTempFile(testFile);
        schema = new MessageType("schema", new Type[]{LEGACY_TWO_LEVEL_ARRAY_TYPE});
        this.testSingleFile(schema, false);
        schema = new MessageType("schema", new Type[]{LEGACY_TREE_LEVEL_ARRAY_TYPE});
        this.testSingleFile(schema, true);
        schema = new MessageType("schema", new Type[]{STANDARD_THREE_LEVEL_ARRAY_TYPE});
        this.testSingleFile(schema, true);
        schema = new MessageType("schema", new Type[]{LEGACY_MAP_TYPE});
        this.testSingleFile(schema, true);
        schema = new MessageType("schema", new Type[]{STANDARD_MAP_TYPE});
        this.testSingleFile(schema, true);
        schema = new MessageType("schema", new Type[]{INT32_DECIMAL_TYPE});
        this.testSingleFile(schema, false);
        schema = new MessageType("schema", new Type[]{INT64_DECIMAL_TYPE});
        this.testSingleFile(schema, false);
        schema = new MessageType("schema", new Type[]{FIXED_LEN_BYTE_ARRAY_DECIMAL_TYPE});
        this.testSingleFile(schema, true);
    }

    private List<ParquetBinaryCopyChecker.ParquetFileInfo> makeFileInfos(ParquetBinaryCopyChecker.ParquetFileInfo ... infos) {
        return Arrays.stream(infos).collect(Collectors.toList());
    }

    private ParquetBinaryCopyChecker.ParquetFileInfo makeSchemaNotSupportFileInfo() {
        return this.makeFileInfo(false, null, null);
    }

    private ParquetBinaryCopyChecker.ParquetFileInfo makeFileInfo(boolean schemaSupport, String typeCode, String schema) {
        return new ParquetBinaryCopyChecker.ParquetFileInfo(schemaSupport, typeCode, schema);
    }

    private String makeTestFile(MessageType schema) throws IOException {
        return this.makeTestFile(schema, null);
    }

    private String makeTestFile(MessageType schema, String typeCode) throws IOException {
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put("hoodie_bloom_filter_type_code", typeCode);
        return new TestHoodieParquetFileBinaryCopier.TestFileBuilder(this.conf, schema).withNumRecord(0).withExtraMeta(meta).withPageSize(0x100000).build().getFileName();
    }

    private void testSingleFile(MessageType schema, String inputTypeCode, boolean support, String typeCode) throws IOException {
        this.withTempFile(this.makeTestFile(schema, inputTypeCode), file -> this.assertFileInfo(ParquetBinaryCopyChecker.collectFileInfo((Configuration)this.conf, (String)file), support, typeCode, schema.toString()));
    }

    private void testSingleFile(MessageType schema, boolean support) throws IOException {
        this.testSingleFile(schema, null, support, null);
    }

    private void withTempFile(String file, Consumer<String> run) {
        try {
            run.accept(file);
        }
        finally {
            TestHoodieParquetFileBinaryCopier.TestFileBuilder.deleteTempFile(file);
        }
    }

    private void assertFileInfo(ParquetBinaryCopyChecker.ParquetFileInfo info, boolean support, String codeType, String schema) {
        Assertions.assertNotNull((Object)info);
        Assertions.assertEquals((Object)support, (Object)info.canBinaryCopy());
        if (support) {
            Assertions.assertEquals((Object)codeType, (Object)info.getBloomFilterTypeCode());
            Assertions.assertEquals((Object)schema, (Object)info.getSchema().toString());
        }
    }
}

