/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.schema;

import org.apache.hudi.common.util.Option;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.SchemaRepair;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSchemaRepair {
    @Test
    public void testNoRepairNeededIdenticalSchemas() {
        MessageType requestedSchema = new MessageType("TestSchema", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named("timestamp")});
        MessageType tableSchema = new MessageType("TestSchema", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named("timestamp")});
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (MessageType)tableSchema);
        Assertions.assertSame((Object)requestedSchema, (Object)result, (String)"When schemas are identical, should return same instance");
    }

    @Test
    public void testNoRepairNeededDifferentPrimitiveTypes() {
        MessageType requestedSchema = new MessageType("TestSchema", new Type[]{(Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("name")});
        MessageType tableSchema = new MessageType("TestSchema", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named("id")});
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (MessageType)tableSchema);
        Assertions.assertSame((Object)requestedSchema, (Object)result, (String)"When field names differ, should return original schema");
    }

    @Test
    public void testRepairLongWithoutLogicalTypeToLocalTimestampMillis() {
        MessageType requestedSchema = new MessageType("TestSchema", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named("timestamp")});
        MessageType tableSchema = new MessageType("TestSchema", new Type[]{(Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("timestamp")});
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (MessageType)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create a new schema with logical type");
        PrimitiveType timestampField = result.getType("timestamp").asPrimitiveType();
        Assertions.assertEquals((Object)PrimitiveType.PrimitiveTypeName.INT64, (Object)timestampField.getPrimitiveTypeName());
        Assertions.assertEquals((Object)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS), (Object)timestampField.getLogicalTypeAnnotation());
    }

    @Test
    public void testRepairLongWithoutLogicalTypeToLocalTimestampMicros() {
        MessageType requestedSchema = new MessageType("TestSchema", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named("timestamp")});
        MessageType tableSchema = new MessageType("TestSchema", new Type[]{(Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named("timestamp")});
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (MessageType)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create a new schema with logical type");
        PrimitiveType timestampField = result.getType("timestamp").asPrimitiveType();
        Assertions.assertEquals((Object)PrimitiveType.PrimitiveTypeName.INT64, (Object)timestampField.getPrimitiveTypeName());
        Assertions.assertEquals((Object)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS), (Object)timestampField.getLogicalTypeAnnotation());
    }

    @Test
    public void testRepairTimestampMicrosToTimestampMillis() {
        MessageType requestedSchema = new MessageType("TestSchema", new Type[]{(Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named("timestamp")});
        MessageType tableSchema = new MessageType("TestSchema", new Type[]{(Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("timestamp")});
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (MessageType)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create a new schema with timestamp-millis");
        PrimitiveType timestampField = result.getType("timestamp").asPrimitiveType();
        Assertions.assertEquals((Object)PrimitiveType.PrimitiveTypeName.INT64, (Object)timestampField.getPrimitiveTypeName());
        Assertions.assertEquals((Object)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS), (Object)timestampField.getLogicalTypeAnnotation());
    }

    @Test
    public void testNoRepairNeededTimestampMillisToTimestampMicros() {
        MessageType requestedSchema = new MessageType("TestSchema", new Type[]{(Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("timestamp")});
        MessageType tableSchema = new MessageType("TestSchema", new Type[]{(Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named("timestamp")});
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (MessageType)tableSchema);
        Assertions.assertSame((Object)requestedSchema, (Object)result, (String)"Should not repair timestamp-millis to timestamp-micros");
    }

    @Test
    public void testNoRepairNeededNonLongTypes() {
        MessageType requestedSchema = new MessageType("TestSchema", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named("id")});
        MessageType tableSchema = new MessageType("TestSchema", new Type[]{(Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType())).named("id")});
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (MessageType)tableSchema);
        Assertions.assertSame((Object)requestedSchema, (Object)result, (String)"Should not repair non-LONG types");
    }

    @Test
    public void testRepairRecordSingleField() {
        MessageType requestedSchema = new MessageType("TestRecord", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named("timestamp")});
        MessageType tableSchema = new MessageType("TestRecord", new Type[]{(Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("timestamp")});
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (MessageType)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create new record schema");
        Assertions.assertEquals((int)1, (int)result.getFields().size());
        PrimitiveType field = result.getType("timestamp").asPrimitiveType();
        Assertions.assertEquals((Object)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS), (Object)field.getLogicalTypeAnnotation());
    }

    @Test
    public void testRepairRecordMultipleFieldsOnlyOneNeedsRepair() {
        MessageType requestedSchema = new MessageType("TestRecord", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named("id"), (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named("timestamp"), (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("name")});
        MessageType tableSchema = new MessageType("TestRecord", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named("id"), (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named("timestamp"), (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("name")});
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (MessageType)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create new record schema");
        Assertions.assertEquals((int)3, (int)result.getFields().size());
        Assertions.assertSame((Object)requestedSchema.getType("id"), (Object)result.getType("id"));
        PrimitiveType timestampField = result.getType("timestamp").asPrimitiveType();
        Assertions.assertEquals((Object)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS), (Object)timestampField.getLogicalTypeAnnotation());
        Assertions.assertSame((Object)requestedSchema.getType("name"), (Object)result.getType("name"));
    }

    @Test
    public void testRepairRecordNestedRecord() {
        GroupType nestedRequestedSchema = new GroupType(Type.Repetition.REQUIRED, "nested", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named("timestamp")});
        GroupType nestedTableSchema = new GroupType(Type.Repetition.REQUIRED, "nested", new Type[]{(Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("timestamp")});
        MessageType requestedSchema = new MessageType("OuterRecord", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named("id"), nestedRequestedSchema});
        MessageType tableSchema = new MessageType("OuterRecord", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named("id"), nestedTableSchema});
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (MessageType)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create new schema for nested record");
        Assertions.assertSame((Object)requestedSchema.getType("id"), (Object)result.getType("id"));
        GroupType nestedResult = result.getType("nested").asGroupType();
        PrimitiveType nestedTimestamp = nestedResult.getType("timestamp").asPrimitiveType();
        Assertions.assertEquals((Object)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS), (Object)nestedTimestamp.getLogicalTypeAnnotation());
    }

    @Test
    public void testRepairRecordMissingFieldInTableSchema() {
        MessageType requestedSchema = new MessageType("TestRecord", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named("id"), (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named("newField")});
        MessageType tableSchema = new MessageType("TestRecord", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named("id")});
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (MessageType)tableSchema);
        Assertions.assertSame((Object)requestedSchema, (Object)result, (String)"Should return original when field missing in table schema");
    }

    @Test
    public void testRepairRecordMultipleFieldsMissingInTableSchema() {
        MessageType requestedSchema = new MessageType("TestRecord", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named("id"), (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named("newField1"), (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("name"), (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named("newField2")});
        MessageType tableSchema = new MessageType("TestRecord", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named("id"), (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("name")});
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (MessageType)tableSchema);
        Assertions.assertSame((Object)requestedSchema, (Object)result, (String)"Should return original when multiple fields missing in table schema");
    }

    @Test
    public void testRepairRecordMixedMissingAndRepairableFields() {
        MessageType requestedSchema = new MessageType("TestRecord", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named("id"), (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named("timestamp"), (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named("newField"), (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("name")});
        MessageType tableSchema = new MessageType("TestRecord", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named("id"), (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("timestamp"), (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("name")});
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (MessageType)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create new schema");
        Assertions.assertEquals((int)4, (int)result.getFields().size());
        Assertions.assertSame((Object)requestedSchema.getType("id"), (Object)result.getType("id"));
        PrimitiveType timestampField = result.getType("timestamp").asPrimitiveType();
        Assertions.assertEquals((Object)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS), (Object)timestampField.getLogicalTypeAnnotation());
        Assertions.assertSame((Object)requestedSchema.getType("newField"), (Object)result.getType("newField"));
        Assertions.assertSame((Object)requestedSchema.getType("name"), (Object)result.getType("name"));
    }

    @Test
    public void testRepairNestedRecordFieldMissingInTableSchema() {
        GroupType nestedRequestedSchema = new GroupType(Type.Repetition.REQUIRED, "nested", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named("timestamp"), (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("extraField")});
        GroupType nestedTableSchema = new GroupType(Type.Repetition.REQUIRED, "nested", new Type[]{(Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("timestamp")});
        MessageType requestedSchema = new MessageType("OuterRecord", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named("id"), nestedRequestedSchema});
        MessageType tableSchema = new MessageType("OuterRecord", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named("id"), nestedTableSchema});
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (MessageType)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create new schema");
        Assertions.assertSame((Object)requestedSchema.getType("id"), (Object)result.getType("id"));
        GroupType nestedResult = result.getType("nested").asGroupType();
        Assertions.assertEquals((int)2, (int)nestedResult.getFieldCount());
        PrimitiveType timestampField = nestedResult.getType("timestamp").asPrimitiveType();
        Assertions.assertEquals((Object)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS), (Object)timestampField.getLogicalTypeAnnotation());
        Assertions.assertSame((Object)nestedRequestedSchema.getType("extraField"), (Object)nestedResult.getType("extraField"));
    }

    @Test
    public void testRepairRecordWholeNestedRecordMissingInTableSchema() {
        GroupType nestedRequestedSchema = new GroupType(Type.Repetition.REQUIRED, "newNested", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named("timestamp")});
        MessageType requestedSchema = new MessageType("OuterRecord", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named("id"), nestedRequestedSchema});
        MessageType tableSchema = new MessageType("OuterRecord", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named("id")});
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (MessageType)tableSchema);
        Assertions.assertSame((Object)requestedSchema, (Object)result, (String)"Should return original when nested field missing in table schema");
    }

    @Test
    public void testEdgeCaseEmptyRecord() {
        MessageType requestedSchema = new MessageType("EmptyRecord", new Type[0]);
        MessageType tableSchema = new MessageType("EmptyRecord", new Type[0]);
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (MessageType)tableSchema);
        Assertions.assertSame((Object)requestedSchema, (Object)result, (String)"Empty records should return same instance");
    }

    @Test
    public void testRepairRecordFirstFieldChanged() {
        MessageType requestedSchema = new MessageType("TestRecord", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named("timestamp1"), (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named("timestamp2")});
        MessageType tableSchema = new MessageType("TestRecord", new Type[]{(Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("timestamp1"), (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named("timestamp2")});
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (MessageType)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result);
        PrimitiveType timestamp1 = result.getType("timestamp1").asPrimitiveType();
        Assertions.assertEquals((Object)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS), (Object)timestamp1.getLogicalTypeAnnotation());
        PrimitiveType timestamp2 = result.getType("timestamp2").asPrimitiveType();
        Assertions.assertEquals((Object)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS), (Object)timestamp2.getLogicalTypeAnnotation());
    }

    @Test
    public void testRepairRecordLastFieldChanged() {
        MessageType requestedSchema = new MessageType("TestRecord", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named("id"), (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("name"), (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named("timestamp")});
        MessageType tableSchema = new MessageType("TestRecord", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named("id"), (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("name"), (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("timestamp")});
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (MessageType)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result);
        Assertions.assertSame((Object)requestedSchema.getType("id"), (Object)result.getType("id"));
        Assertions.assertSame((Object)requestedSchema.getType("name"), (Object)result.getType("name"));
        PrimitiveType timestampField = result.getType("timestamp").asPrimitiveType();
        Assertions.assertEquals((Object)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS), (Object)timestampField.getLogicalTypeAnnotation());
    }

    @Test
    public void testRepairLogicalTypesWithOptionEmpty() {
        MessageType requestedSchema = new MessageType("TestSchema", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named("timestamp")});
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (Option)Option.empty());
        Assertions.assertSame((Object)requestedSchema, (Object)result, (String)"Should return original when Option is empty");
    }

    @Test
    public void testRepairLogicalTypesWithOptionPresent() {
        MessageType requestedSchema = new MessageType("TestSchema", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named("timestamp")});
        MessageType tableSchema = new MessageType("TestSchema", new Type[]{(Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("timestamp")});
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (Option)Option.of((Object)tableSchema));
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should repair when Option is present");
        PrimitiveType timestampField = result.getType("timestamp").asPrimitiveType();
        Assertions.assertEquals((Object)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS), (Object)timestampField.getLogicalTypeAnnotation());
    }

    @Test
    public void testRepairOptionalFieldRepetition() {
        MessageType requestedSchema = new MessageType("TestSchema", new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.OPTIONAL).named("timestamp")});
        MessageType tableSchema = new MessageType("TestSchema", new Type[]{(Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("timestamp")});
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (MessageType)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result);
        PrimitiveType timestampField = result.getType("timestamp").asPrimitiveType();
        Assertions.assertEquals((Object)Type.Repetition.OPTIONAL, (Object)timestampField.getRepetition(), (String)"Should preserve requested field's repetition");
        Assertions.assertEquals((Object)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS), (Object)timestampField.getLogicalTypeAnnotation());
    }

    @Test
    public void testRepairNestedGroupPreservesLogicalType() {
        GroupType nestedRequestedSchema = new GroupType(Type.Repetition.REQUIRED, "nested", (LogicalTypeAnnotation)LogicalTypeAnnotation.listType(), new Type[]{(Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named("timestamp")});
        GroupType nestedTableSchema = new GroupType(Type.Repetition.REQUIRED, "nested", (LogicalTypeAnnotation)LogicalTypeAnnotation.listType(), new Type[]{(Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("timestamp")});
        MessageType requestedSchema = new MessageType("OuterRecord", new Type[]{nestedRequestedSchema});
        MessageType tableSchema = new MessageType("OuterRecord", new Type[]{nestedTableSchema});
        MessageType result = SchemaRepair.repairLogicalTypes((MessageType)requestedSchema, (MessageType)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result);
        GroupType nestedResult = result.getType("nested").asGroupType();
        Assertions.assertEquals((Object)LogicalTypeAnnotation.listType(), (Object)nestedResult.getLogicalTypeAnnotation(), (String)"Should preserve group's logical type annotation");
        PrimitiveType timestampField = nestedResult.getType("timestamp").asPrimitiveType();
        Assertions.assertEquals((Object)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS), (Object)timestampField.getLogicalTypeAnnotation());
    }
}

