/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.schema;

import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.avro.HoodieAvroParquetSchemaConverter;
import org.apache.parquet.schema.AvroSchemaRepair;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.SchemaRepair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSchemaRepairEquivalence {
    private HoodieAvroParquetSchemaConverter converter;

    @BeforeEach
    public void setUp() {
        this.converter = HoodieAvroParquetSchemaConverter.getAvroSchemaConverter((Configuration)new Configuration());
    }

    private void assertRepairEquivalence(Schema requestedAvro, Schema tableAvro) {
        Schema repairedAvro = AvroSchemaRepair.repairLogicalTypes((Schema)requestedAvro, (Schema)tableAvro);
        MessageType requestedParquet = this.converter.convert(requestedAvro);
        MessageType tableParquet = this.converter.convert(tableAvro);
        MessageType repairedParquet = SchemaRepair.repairLogicalTypes((MessageType)requestedParquet, (MessageType)tableParquet);
        Schema repairedParquetAsAvro = this.converter.convert(repairedParquet);
        Assertions.assertEquals((Object)repairedAvro, (Object)repairedParquetAsAvro, (String)"SchemaRepair and AvroSchemaRepair should produce equivalent results");
    }

    @Test
    public void testEquivalenceNoRepairNeeded() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("value").type().longType().noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("value").type().longType().noDefault().endRecord();
        this.assertRepairEquivalence(requestedSchema, tableSchema);
    }

    @Test
    public void testEquivalenceLongToLocalTimestampMillis() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("timestamp").type().longType().noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("timestamp").type(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        this.assertRepairEquivalence(requestedSchema, tableSchema);
    }

    @Test
    public void testEquivalenceLongToLocalTimestampMicros() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("timestamp").type().longType().noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("timestamp").type(LogicalTypes.localTimestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        this.assertRepairEquivalence(requestedSchema, tableSchema);
    }

    @Test
    public void testEquivalenceTimestampMicrosToMillis() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("timestamp").type(LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("timestamp").type(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        this.assertRepairEquivalence(requestedSchema, tableSchema);
    }

    @Test
    public void testEquivalenceNoRepairTimestampMillisToMicros() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("timestamp").type(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("timestamp").type(LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        this.assertRepairEquivalence(requestedSchema, tableSchema);
    }

    @Test
    public void testEquivalenceSimpleRecord() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("timestamp").type().longType().noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("timestamp").type(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        this.assertRepairEquivalence(requestedSchema, tableSchema);
    }

    @Test
    public void testEquivalenceRecordMultipleFields() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("id").type().intType().noDefault().name("timestamp").type().longType().noDefault().name("name").type().stringType().noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("id").type().intType().noDefault().name("timestamp").type(LogicalTypes.localTimestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().name("name").type().stringType().noDefault().endRecord();
        this.assertRepairEquivalence(requestedSchema, tableSchema);
    }

    @Test
    public void testEquivalenceNestedRecord() {
        Schema nestedRequestedSchema = (Schema)SchemaBuilder.record((String)"nestedrecord").fields().name("timestamp").type().longType().noDefault().endRecord();
        Schema nestedTableSchema = (Schema)SchemaBuilder.record((String)"nestedrecord").fields().name("timestamp").type(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"outerrecord").fields().name("id").type().intType().noDefault().name("nestedrecord").type(nestedRequestedSchema).noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"outerrecord").fields().name("id").type().intType().noDefault().name("nestedrecord").type(nestedTableSchema).noDefault().endRecord();
        this.assertRepairEquivalence(requestedSchema, tableSchema);
    }

    @Test
    public void testEquivalenceRecordWithExtraFieldInRequested() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("id").type().intType().noDefault().name("timestamp").type().longType().noDefault().name("newfield").type().longType().noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("id").type().intType().noDefault().name("timestamp").type(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        this.assertRepairEquivalence(requestedSchema, tableSchema);
    }

    @Test
    public void testEquivalenceRecordMixedFields() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("id").type().intType().noDefault().name("timestamp").type().longType().noDefault().name("newfield").type().stringType().noDefault().name("name").type().stringType().noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("id").type().intType().noDefault().name("timestamp").type(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().name("name").type().stringType().noDefault().endRecord();
        this.assertRepairEquivalence(requestedSchema, tableSchema);
    }

    @Test
    public void testEquivalenceNestedRecordWithExtraField() {
        Schema nestedRequestedSchema = (Schema)SchemaBuilder.record((String)"nestedrecord").fields().name("timestamp").type().longType().noDefault().name("extrafield").type().stringType().noDefault().endRecord();
        Schema nestedTableSchema = (Schema)SchemaBuilder.record((String)"nestedrecord").fields().name("timestamp").type(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"outerrecord").fields().name("id").type().intType().noDefault().name("nestedrecord").type(nestedRequestedSchema).noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"outerrecord").fields().name("id").type().intType().noDefault().name("nestedrecord").type(nestedTableSchema).noDefault().endRecord();
        this.assertRepairEquivalence(requestedSchema, tableSchema);
    }

    @Test
    public void testEquivalenceRecordFirstFieldChanged() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("timestamp1").type().longType().noDefault().name("timestamp2").type().longType().noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("timestamp1").type(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().name("timestamp2").type(LogicalTypes.localTimestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        this.assertRepairEquivalence(requestedSchema, tableSchema);
    }

    @Test
    public void testEquivalenceRecordLastFieldChanged() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("id").type().intType().noDefault().name("name").type().stringType().noDefault().name("timestamp").type().longType().noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("id").type().intType().noDefault().name("name").type().stringType().noDefault().name("timestamp").type(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        this.assertRepairEquivalence(requestedSchema, tableSchema);
    }

    @Test
    public void testEquivalenceComplexNestedStructure() {
        Schema innerRecordRequested = (Schema)SchemaBuilder.record((String)"inner").fields().name("timestamp").type().longType().noDefault().name("value").type().intType().noDefault().endRecord();
        Schema innerRecordTable = (Schema)SchemaBuilder.record((String)"inner").fields().name("timestamp").type(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().name("value").type().intType().noDefault().endRecord();
        Schema middleRecordRequested = (Schema)SchemaBuilder.record((String)"middle").fields().name("inner").type(innerRecordRequested).noDefault().name("middletimestamp").type().longType().noDefault().endRecord();
        Schema middleRecordTable = (Schema)SchemaBuilder.record((String)"middle").fields().name("inner").type(innerRecordTable).noDefault().name("middletimestamp").type(LogicalTypes.localTimestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"outer").fields().name("id").type().intType().noDefault().name("middle").type(middleRecordRequested).noDefault().name("outertimestamp").type().longType().noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"outer").fields().name("id").type().intType().noDefault().name("middle").type(middleRecordTable).noDefault().name("outertimestamp").type(LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        this.assertRepairEquivalence(requestedSchema, tableSchema);
    }

    @Test
    public void testEquivalenceEmptyRecord() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"emptyrecord").fields().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"emptyrecord").fields().endRecord();
        this.assertRepairEquivalence(requestedSchema, tableSchema);
    }

    @Test
    public void testEquivalenceRecordNoFieldsMatch() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("field1").type().longType().noDefault().name("field2").type().stringType().noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("field3").type().intType().noDefault().name("field4").type(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        this.assertRepairEquivalence(requestedSchema, tableSchema);
    }

    @Test
    public void testEquivalenceMultipleTimestampRepairs() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("ts1").type().longType().noDefault().name("ts2").type().longType().noDefault().name("ts3").type(LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().name("ts4").type().longType().noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"testrecord").fields().name("ts1").type(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().name("ts2").type(LogicalTypes.localTimestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().name("ts3").type(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().name("ts4").type().longType().noDefault().endRecord();
        this.assertRepairEquivalence(requestedSchema, tableSchema);
    }

    @Test
    public void testEquivalenceDeepNesting() {
        Schema level3Requested = (Schema)SchemaBuilder.record((String)"level3").fields().name("timestamp").type().longType().noDefault().endRecord();
        Schema level3Table = (Schema)SchemaBuilder.record((String)"level3").fields().name("timestamp").type(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Schema level2Requested = (Schema)SchemaBuilder.record((String)"level2").fields().name("level3").type(level3Requested).noDefault().endRecord();
        Schema level2Table = (Schema)SchemaBuilder.record((String)"level2").fields().name("level3").type(level3Table).noDefault().endRecord();
        Schema level1Requested = (Schema)SchemaBuilder.record((String)"level1").fields().name("level2").type(level2Requested).noDefault().endRecord();
        Schema level1Table = (Schema)SchemaBuilder.record((String)"level1").fields().name("level2").type(level2Table).noDefault().endRecord();
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"level0").fields().name("level1").type(level1Requested).noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"level0").fields().name("level1").type(level1Table).noDefault().endRecord();
        this.assertRepairEquivalence(requestedSchema, tableSchema);
    }
}

