/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.parquet.avro.HoodieAvroParquetSchemaConverter;
import org.apache.parquet.schema.MessageType;

public class ParquetTableSchemaResolver
extends TableSchemaResolver {
    public ParquetTableSchemaResolver(HoodieTableMetaClient metaClient) {
        super(metaClient);
    }

    public static MessageType convertAvroSchemaToParquet(Schema schema, Configuration hadoopConf) {
        return HoodieAvroParquetSchemaConverter.getAvroSchemaConverter(hadoopConf).convert(schema);
    }

    private Schema convertParquetSchemaToAvro(MessageType parquetSchema) {
        return HoodieAvroParquetSchemaConverter.getAvroSchemaConverter((Configuration)this.metaClient.getStorageConf().unwrapAs(Configuration.class)).convert(parquetSchema);
    }

    private MessageType convertAvroSchemaToParquet(Schema schema) {
        return HoodieAvroParquetSchemaConverter.getAvroSchemaConverter((Configuration)this.metaClient.getStorageConf().unwrapAs(Configuration.class)).convert(schema);
    }

    public MessageType getTableParquetSchema() throws Exception {
        return this.convertAvroSchemaToParquet(this.getTableAvroSchema(true));
    }

    public MessageType getTableParquetSchema(boolean includeMetadataField) throws Exception {
        return this.convertAvroSchemaToParquet(this.getTableAvroSchema(includeMetadataField));
    }
}

