/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.FileFormatUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ParquetReaderIterator;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.MetadataNotFoundException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.metadata.HoodieIndexVersion;
import org.apache.hudi.stats.HoodieColumnRangeMetadata;
import org.apache.hudi.stats.ValueMetadata;
import org.apache.hudi.stats.ValueType;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.avro.HoodieAvroParquetSchemaConverter;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveStringifier;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetUtils
extends FileFormatUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetUtils.class);

    public Set<Pair<String, Long>> filterRowKeys(HoodieStorage storage, StoragePath filePath, Set<String> filter) {
        return ParquetUtils.filterParquetRowKeys(storage, new Path(filePath.toUri()), filter, HoodieAvroUtils.getRecordKeySchema());
    }

    public static ParquetMetadata readMetadata(HoodieStorage storage, StoragePath parquetFilePath) {
        ParquetMetadata footer;
        Path parquetFileHadoopPath = new Path(parquetFilePath.toUri());
        try {
            footer = ParquetFileReader.readFooter((Configuration)((Configuration)storage.newInstance(parquetFilePath, storage.getConf()).getConf().unwrapAs(Configuration.class)), (Path)parquetFileHadoopPath);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to read footer for parquet " + parquetFileHadoopPath, e);
        }
        return footer;
    }

    private static Set<Pair<String, Long>> filterParquetRowKeys(HoodieStorage storage, Path filePath, Set<String> filter, Schema readSchema) {
        Option filterFunction = Option.empty();
        if (filter != null && !filter.isEmpty()) {
            filterFunction = Option.of((Object)new RecordKeysFilterFunction(filter));
        }
        Configuration conf = (Configuration)storage.getConf().unwrapCopyAs(Configuration.class);
        conf.addResource((Configuration)storage.newInstance(HadoopFSUtils.convertToStoragePath(filePath), storage.getConf()).getConf().unwrapAs(Configuration.class));
        AvroReadSupport.setAvroReadSchema((Configuration)conf, (Schema)readSchema);
        AvroReadSupport.setRequestedProjection((Configuration)conf, (Schema)readSchema);
        HashSet<Pair<String, Long>> rowKeys = new HashSet<Pair<String, Long>>();
        long rowPosition = 0L;
        try (ParquetReader reader = AvroParquetReader.builder((Path)filePath).withConf(conf).build();){
            Object obj = reader.read();
            while (obj != null) {
                if (!(obj instanceof GenericRecord)) continue;
                String recordKey = ((GenericRecord)obj).get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
                if (!filterFunction.isPresent() || ((RecordKeysFilterFunction)filterFunction.get()).apply(recordKey).booleanValue()) {
                    rowKeys.add((Pair<String, Long>)Pair.of((Object)recordKey, (Object)rowPosition));
                }
                obj = reader.read();
                ++rowPosition;
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to read row keys from Parquet " + filePath, e);
        }
        return rowKeys;
    }

    public static CompressionCodecName getCompressionCodecName(String codecName) {
        return CompressionCodecName.fromConf((String)(StringUtils.isNullOrEmpty((String)codecName) ? null : codecName));
    }

    public ClosableIterator<Pair<HoodieKey, Long>> fetchRecordKeysWithPositions(HoodieStorage storage, StoragePath filePath) {
        return this.fetchRecordKeysWithPositions(storage, filePath, (Option<BaseKeyGenerator>)Option.empty(), (Option<String>)Option.empty());
    }

    public ClosableIterator<HoodieKey> getHoodieKeyIterator(HoodieStorage storage, StoragePath filePath) {
        return this.getHoodieKeyIterator(storage, filePath, (Option<BaseKeyGenerator>)Option.empty(), (Option<String>)Option.empty());
    }

    public ClosableIterator<HoodieKey> getHoodieKeyIterator(HoodieStorage storage, StoragePath filePath, Option<BaseKeyGenerator> keyGeneratorOpt, Option<String> partitionPath) {
        try {
            Configuration conf = (Configuration)storage.getConf().unwrapCopyAs(Configuration.class);
            conf.addResource((Configuration)storage.newInstance(filePath, storage.getConf()).getConf().unwrapAs(Configuration.class));
            Schema readSchema = this.getKeyIteratorSchema(storage, filePath, keyGeneratorOpt, partitionPath);
            AvroReadSupport.setAvroReadSchema((Configuration)conf, (Schema)readSchema);
            AvroReadSupport.setRequestedProjection((Configuration)conf, (Schema)readSchema);
            ParquetReader reader = AvroParquetReader.builder((Path)new Path(filePath.toUri())).withConf(conf).build();
            return FileFormatUtils.HoodieKeyIterator.getInstance(new ParquetReaderIterator(reader), keyGeneratorOpt, partitionPath);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to read from Parquet file " + filePath, e);
        }
    }

    public ClosableIterator<Pair<HoodieKey, Long>> fetchRecordKeysWithPositions(HoodieStorage storage, StoragePath filePath, Option<BaseKeyGenerator> keyGeneratorOpt, Option<String> partitionPath) {
        AtomicLong position = new AtomicLong(0L);
        return new CloseableMappingIterator(this.getHoodieKeyIterator(storage, filePath, keyGeneratorOpt, partitionPath), key -> Pair.of((Object)key, (Object)position.getAndIncrement()));
    }

    public MessageType readSchema(HoodieStorage storage, StoragePath parquetFilePath) {
        return ParquetUtils.readMetadata(storage, parquetFilePath).getFileMetaData().getSchema();
    }

    public static Integer readSchemaHash(HoodieStorage storage, StoragePath parquetFilePath) {
        try {
            ParquetUtils parquetUtils = new ParquetUtils();
            MessageType schema = parquetUtils.readSchema(storage, parquetFilePath);
            return schema.hashCode();
        }
        catch (Exception e) {
            LOG.warn("Failed to read schema hash from file: {}", (Object)parquetFilePath, (Object)e);
            return 0;
        }
    }

    public Map<String, String> readFooter(HoodieStorage storage, boolean required, StoragePath filePath, String ... footerNames) {
        HashMap<String, String> footerVals = new HashMap<String, String>();
        ParquetMetadata footer = ParquetUtils.readMetadata(storage, filePath);
        Map metadata = footer.getFileMetaData().getKeyValueMetaData();
        for (String footerName : footerNames) {
            if (metadata.containsKey(footerName)) {
                footerVals.put(footerName, (String)metadata.get(footerName));
                continue;
            }
            if (!required) continue;
            throw new MetadataNotFoundException("Could not find index in Parquet footer. Looked for key " + footerName + " in " + filePath);
        }
        return footerVals;
    }

    public Schema readAvroSchema(HoodieStorage storage, StoragePath filePath) {
        MessageType parquetSchema = this.readSchema(storage, filePath);
        return HoodieAvroParquetSchemaConverter.getAvroSchemaConverter((Configuration)storage.getConf().unwrapAs(Configuration.class)).convert(parquetSchema);
    }

    public List<HoodieColumnRangeMetadata<Comparable>> readColumnStatsFromMetadata(HoodieStorage storage, StoragePath filePath, List<String> columnList, HoodieIndexVersion indexVersion) {
        ParquetMetadata metadata = ParquetUtils.readMetadata(storage, filePath);
        return this.readColumnStatsFromMetadata(metadata, filePath.getName(), (Option<List<String>>)Option.of(columnList), indexVersion);
    }

    public List<HoodieColumnRangeMetadata<Comparable>> readColumnStatsFromMetadata(ParquetMetadata metadata, String filePath, Option<List<String>> columnList, HoodieIndexVersion indexVersion) {
        Stream<HoodieColumnRangeMetadata<Comparable>> hoodieColumnRangeMetadataStream = ((Stream)metadata.getBlocks().stream().sequential()).flatMap(blockMetaData -> blockMetaData.getColumns().stream().filter(f -> !columnList.isPresent() || ((List)columnList.get()).contains(f.getPath().toDotString())).map(columnChunkMetaData -> {
            Statistics stats = columnChunkMetaData.getStatistics();
            ValueMetadata valueMetadata = ValueMetadata.getValueMetadata((PrimitiveType)columnChunkMetaData.getPrimitiveType(), (HoodieIndexVersion)indexVersion);
            return HoodieColumnRangeMetadata.create((String)filePath, (String)columnChunkMetaData.getPath().toDotString(), ParquetUtils.convertToNativeJavaType(columnChunkMetaData.getPrimitiveType(), stats.genericGetMin(), valueMetadata), ParquetUtils.convertToNativeJavaType(columnChunkMetaData.getPrimitiveType(), stats.genericGetMax(), valueMetadata), (long)(stats.isEmpty() ? columnChunkMetaData.getValueCount() : stats.getNumNulls()), (long)columnChunkMetaData.getValueCount(), (long)columnChunkMetaData.getTotalSize(), (long)columnChunkMetaData.getTotalUncompressedSize(), (ValueMetadata)valueMetadata);
        }));
        return this.mergeColumnStats(hoodieColumnRangeMetadataStream);
    }

    public List<HoodieColumnRangeMetadata<Comparable>> mergeColumnStats(Stream<HoodieColumnRangeMetadata<Comparable>> columnStats) {
        Map<String, List<HoodieColumnRangeMetadata>> columnToStatsListMap = columnStats.collect(Collectors.groupingBy(HoodieColumnRangeMetadata::getColumnName));
        Stream<HoodieColumnRangeMetadata> stream = columnToStatsListMap.values().stream().map(this::getColumnRangeInFile);
        return stream.collect(Collectors.toList());
    }

    public HoodieFileFormat getFormat() {
        return HoodieFileFormat.PARQUET;
    }

    public List<GenericRecord> readAvroRecords(HoodieStorage storage, StoragePath filePath) {
        ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
        try (ParquetReader reader = AvroParquetReader.builder((Path)new Path(filePath.toUri())).withConf((Configuration)storage.getConf().unwrapAs(Configuration.class)).build();){
            Object obj = reader.read();
            while (obj != null) {
                if (obj instanceof GenericRecord) {
                    records.add((GenericRecord)obj);
                }
                obj = reader.read();
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to read avro records from Parquet " + filePath, e);
        }
        return records;
    }

    public List<GenericRecord> readAvroRecords(HoodieStorage storage, StoragePath filePath, Schema schema) {
        AvroReadSupport.setAvroReadSchema((Configuration)((Configuration)storage.getConf().unwrapAs(Configuration.class)), (Schema)schema);
        return this.readAvroRecords(storage, filePath);
    }

    public long getRowCount(HoodieStorage storage, StoragePath filePath) {
        long rowCount = 0L;
        ParquetMetadata footer = ParquetUtils.readMetadata(storage, filePath);
        for (BlockMetaData b : footer.getBlocks()) {
            rowCount += b.getRowCount();
        }
        return rowCount;
    }

    public void writeMetaFile(HoodieStorage storage, StoragePath filePath, Properties props) throws IOException {
        Schema schema = HoodieAvroUtils.getRecordKeySchema();
        MessageType type = (MessageType)((Types.GroupBuilder)Types.buildMessage().optional(PrimitiveType.PrimitiveTypeName.INT64).named("dummyint")).named("dummy");
        HoodieAvroWriteSupport writeSupport = new HoodieAvroWriteSupport(type, schema, (Option<BloomFilter>)Option.empty(), new Properties());
        try (ParquetWriter writer = new ParquetWriter(new Path(filePath.toUri()), writeSupport, CompressionCodecName.UNCOMPRESSED, 1024, 1024);){
            for (String key : props.stringPropertyNames()) {
                writeSupport.addFooterMetadata(key, props.getProperty(key));
            }
        }
    }

    public ByteArrayOutputStream serializeRecordsToLogBlock(HoodieStorage storage, List<HoodieRecord> records, Schema writerSchema, Schema readerSchema, String keyFieldName, Map<String, String> paramsMap) throws IOException {
        if (records.size() == 0) {
            return new ByteArrayOutputStream(0);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        HoodieConfig config = new HoodieConfig();
        paramsMap.entrySet().stream().forEach(entry -> config.setValue((String)entry.getKey(), (String)entry.getValue()));
        config.setValue(HoodieStorageConfig.PARQUET_BLOCK_SIZE.key(), String.valueOf(0x8000000));
        config.setValue(HoodieStorageConfig.PARQUET_PAGE_SIZE.key(), String.valueOf(0x100000));
        config.setValue(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE.key(), String.valueOf(0x40000000));
        config.setValue("hoodie.avro.schema", writerSchema.toString());
        HoodieRecord.HoodieRecordType recordType = records.iterator().next().getRecordType();
        try (HoodieFileWriter parquetWriter = HoodieFileWriterFactory.getFileWriter((HoodieFileFormat)HoodieFileFormat.PARQUET, (OutputStream)outputStream, (HoodieStorage)storage, (HoodieConfig)config, (Schema)writerSchema, (HoodieRecord.HoodieRecordType)recordType);){
            for (HoodieRecord record : records) {
                String recordKey = record.getRecordKey(readerSchema, keyFieldName);
                parquetWriter.write(recordKey, record, writerSchema);
            }
            outputStream.flush();
        }
        return outputStream;
    }

    public Pair<ByteArrayOutputStream, Object> serializeRecordsToLogBlock(HoodieStorage storage, Iterator<HoodieRecord> recordItr, HoodieRecord.HoodieRecordType recordType, Schema writerSchema, Schema readerSchema, String keyFieldName, Map<String, String> paramsMap) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        HoodieConfig config = new HoodieConfig();
        paramsMap.entrySet().stream().forEach(entry -> config.setValue((String)entry.getKey(), (String)entry.getValue()));
        config.setValue(HoodieStorageConfig.PARQUET_BLOCK_SIZE.key(), String.valueOf(0x8000000));
        config.setValue(HoodieStorageConfig.PARQUET_PAGE_SIZE.key(), String.valueOf(0x100000));
        config.setValue(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE.key(), String.valueOf(0x40000000));
        HoodieFileWriter parquetWriter = HoodieFileWriterFactory.getFileWriter((HoodieFileFormat)HoodieFileFormat.PARQUET, (OutputStream)outputStream, (HoodieStorage)storage, (HoodieConfig)config, (Schema)writerSchema, (HoodieRecord.HoodieRecordType)recordType);
        while (recordItr.hasNext()) {
            HoodieRecord record = recordItr.next();
            String recordKey = record.getRecordKey(readerSchema, keyFieldName);
            parquetWriter.write(recordKey, record, writerSchema);
        }
        outputStream.flush();
        parquetWriter.close();
        return Pair.of((Object)outputStream, (Object)parquetWriter.getFileFormatMetadata());
    }

    private <T extends Comparable<T>> HoodieColumnRangeMetadata<T> getColumnRangeInFile(@Nonnull List<HoodieColumnRangeMetadata<T>> blockRanges) {
        if (blockRanges.size() == 1) {
            return blockRanges.get(0);
        }
        return (HoodieColumnRangeMetadata)((Stream)blockRanges.stream().sequential()).reduce(HoodieColumnRangeMetadata::merge).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Comparable<?> convertToNativeJavaType(PrimitiveType primitiveType, Comparable<?> val, ValueMetadata valueMetadata) {
        if (val == null) {
            return null;
        }
        if (valueMetadata.getValueType() != ValueType.V1) {
            return valueMetadata.standardizeJavaTypeAndPromote(val);
        }
        if (primitiveType.getOriginalType() == OriginalType.DECIMAL) {
            return ParquetUtils.extractDecimal(val, primitiveType.getDecimalMetadata());
        }
        if (primitiveType.getOriginalType() == OriginalType.DATE) {
            PrimitiveStringifier primitiveStringifier = primitiveType.stringifier();
            synchronized (primitiveStringifier) {
                return Date.valueOf(primitiveType.stringifier().stringify(((Integer)val).intValue()));
            }
        }
        if (primitiveType.getOriginalType() == OriginalType.UTF8) {
            return ((Binary)val).toStringUsingUTF8();
        }
        if (primitiveType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.BINARY) {
            return ((Binary)val).toByteBuffer();
        }
        return val;
    }

    @Nonnull
    private static BigDecimal extractDecimal(Object val, DecimalMetadata decimalMetadata) {
        int scale = decimalMetadata.getScale();
        if (val == null) {
            return null;
        }
        if (val instanceof Integer) {
            return BigDecimal.valueOf(((Integer)val).intValue(), scale);
        }
        if (val instanceof Long) {
            return BigDecimal.valueOf((Long)val, scale);
        }
        if (val instanceof Binary) {
            return new BigDecimal(new BigInteger(((Binary)val).getBytesUnsafe()), scale);
        }
        throw new UnsupportedOperationException(String.format("Unsupported value type (%s)", val.getClass().getName()));
    }

    static class RecordKeysFilterFunction
    implements Function<String, Boolean> {
        private final Set<String> candidateKeys;

        RecordKeysFilterFunction(Set<String> candidateKeys) {
            this.candidateKeys = candidateKeys;
        }

        @Override
        public Boolean apply(String recordKey) {
            return this.candidateKeys.contains(recordKey);
        }
    }
}

