/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.io.hadoop.HoodieAvroOrcReader;
import org.apache.hudi.io.hadoop.HoodieAvroParquetReader;
import org.apache.hudi.io.storage.HFileReaderFactory;
import org.apache.hudi.io.storage.HoodieAvroBootstrapFileReader;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.io.storage.HoodieNativeAvroHFileReader;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;

public class HoodieAvroFileReaderFactory
extends HoodieFileReaderFactory {
    public HoodieAvroFileReaderFactory(HoodieStorage storage) {
        super(storage);
    }

    protected HoodieFileReader newParquetFileReader(StoragePath path) {
        return new HoodieAvroParquetReader(this.storage, path);
    }

    protected HoodieFileReader newHFileFileReader(HoodieConfig hoodieConfig, StoragePath path, Option<Schema> schemaOption) throws IOException {
        HFileReaderFactory readerFactory = HFileReaderFactory.builder().withStorage(this.storage).withProps(hoodieConfig.getProps()).withPath(path).build();
        return HoodieNativeAvroHFileReader.builder().readerFactory(readerFactory).path(path).schema(schemaOption).build();
    }

    protected HoodieFileReader newHFileFileReader(HoodieConfig hoodieConfig, StoragePathInfo pathInfo, Option<Schema> schemaOption) {
        HFileReaderFactory readerFactory = HFileReaderFactory.builder().withStorage(this.storage).withProps(hoodieConfig.getProps()).withPath(pathInfo.getPath()).withFileSize(pathInfo.getLength()).build();
        return HoodieNativeAvroHFileReader.builder().readerFactory(readerFactory).path(pathInfo.getPath()).schema(schemaOption).build();
    }

    protected HoodieFileReader newHFileFileReader(HoodieConfig hoodieConfig, StoragePath path, HoodieStorage storage, byte[] content, Option<Schema> schemaOption) throws IOException {
        HFileReaderFactory readerFactory = HFileReaderFactory.builder().withStorage(storage).withProps(hoodieConfig.getProps()).withContent(content).build();
        return HoodieNativeAvroHFileReader.builder().readerFactory(readerFactory).path(path).schema(schemaOption).build();
    }

    protected HoodieFileReader newOrcFileReader(StoragePath path) {
        return new HoodieAvroOrcReader(this.storage, path);
    }

    public HoodieFileReader newBootstrapFileReader(HoodieFileReader skeletonFileReader, HoodieFileReader dataFileReader, Option<String[]> partitionFields, Object[] partitionValues) {
        return new HoodieAvroBootstrapFileReader(skeletonFileReader, dataFileReader, partitionFields, partitionValues);
    }
}

