/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieDuplicateKeyException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hadoop.fs.HoodieWrapperFileSystem;
import org.apache.hudi.io.hfile.HFileContext;
import org.apache.hudi.io.hfile.HFileWriter;
import org.apache.hudi.io.hfile.HFileWriterImpl;
import org.apache.hudi.io.storage.HoodieAvroFileWriter;
import org.apache.hudi.io.storage.HoodieHFileConfig;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;

public class HoodieAvroHFileWriter
implements HoodieAvroFileWriter {
    private static final AtomicLong RECORD_INDEX_COUNT = new AtomicLong(1L);
    private final Path file;
    private final HoodieHFileConfig hfileConfig;
    private final boolean isWrapperFileSystem;
    private final Option<HoodieWrapperFileSystem> wrapperFs;
    private final long maxFileSize;
    private final String instantTime;
    private final TaskContextSupplier taskContextSupplier;
    private final boolean populateMetaFields;
    private final Option<Schema.Field> keyFieldSchema;
    private HFileWriter writer;
    private String minRecordKey;
    private String maxRecordKey;
    private String prevRecordKey;

    public HoodieAvroHFileWriter(String instantTime, StoragePath file, HoodieHFileConfig hfileConfig, Schema schema, TaskContextSupplier taskContextSupplier, boolean populateMetaFields) throws IOException {
        Configuration conf = HadoopFSUtils.registerFileSystem(file, (Configuration)hfileConfig.getStorageConf().unwrap());
        this.file = HoodieWrapperFileSystem.convertToHoodiePath(file, conf);
        FileSystem fs = this.file.getFileSystem(conf);
        this.isWrapperFileSystem = fs instanceof HoodieWrapperFileSystem;
        this.wrapperFs = this.isWrapperFileSystem ? Option.of((Object)((Object)((HoodieWrapperFileSystem)fs))) : Option.empty();
        this.hfileConfig = hfileConfig;
        this.keyFieldSchema = Option.ofNullable((Object)schema.getField(hfileConfig.getKeyFieldName()));
        this.maxFileSize = hfileConfig.getMaxFileSize();
        this.instantTime = instantTime;
        this.taskContextSupplier = taskContextSupplier;
        this.populateMetaFields = populateMetaFields;
        HFileContext context = new HFileContext.Builder().blockSize(hfileConfig.getBlockSize()).compressionCodec(hfileConfig.getCompressionCodec()).build();
        HadoopStorageConfiguration storageConf = new HadoopStorageConfiguration(conf);
        StoragePath filePath = new StoragePath(this.file.toUri());
        OutputStream outputStream = HoodieStorageUtils.getStorage((StoragePath)filePath, (StorageConfiguration)storageConf).create(filePath);
        this.writer = new HFileWriterImpl(context, outputStream);
        this.prevRecordKey = "";
        this.writer.appendFileInfo("schema", StringUtils.getUTF8Bytes((String)schema.toString()));
    }

    public void writeAvroWithMetadata(HoodieKey key, IndexedRecord avroRecord) throws IOException {
        if (this.populateMetaFields) {
            this.prepRecordWithMetadata(key, avroRecord, this.instantTime, (Integer)this.taskContextSupplier.getPartitionIdSupplier().get(), RECORD_INDEX_COUNT.getAndIncrement(), this.file.getName());
            this.writeAvro(key.getRecordKey(), avroRecord);
        } else {
            this.writeAvro(key.getRecordKey(), avroRecord);
        }
    }

    public boolean canWrite() {
        return !this.isWrapperFileSystem || ((HoodieWrapperFileSystem)((Object)this.wrapperFs.get())).getBytesWritten(this.file) < this.maxFileSize;
    }

    public void writeAvro(String recordKey, IndexedRecord record) throws IOException {
        if (this.prevRecordKey.equals(recordKey)) {
            throw new HoodieDuplicateKeyException("Duplicate recordKey " + recordKey + " found while writing to HFile.Record payload: " + record);
        }
        byte[] value = null;
        boolean isRecordSerialized = false;
        if (this.keyFieldSchema.isPresent()) {
            boolean isKeyAvailable;
            IndexedRecord keyExcludedRecord = record;
            int keyFieldPos = ((Schema.Field)this.keyFieldSchema.get()).pos();
            boolean bl = isKeyAvailable = record.get(keyFieldPos) != null && !record.get(keyFieldPos).toString().isEmpty();
            if (isKeyAvailable) {
                Object originalKey = keyExcludedRecord.get(keyFieldPos);
                keyExcludedRecord.put(keyFieldPos, (Object)"");
                value = HoodieAvroUtils.avroToBytes((IndexedRecord)keyExcludedRecord);
                keyExcludedRecord.put(keyFieldPos, originalKey);
                isRecordSerialized = true;
            }
        }
        if (!isRecordSerialized) {
            value = HoodieAvroUtils.avroToBytes((IndexedRecord)record);
        }
        this.writer.append(recordKey, value);
        if (this.hfileConfig.useBloomFilter()) {
            this.hfileConfig.getBloomFilter().add(recordKey);
            if (this.minRecordKey == null) {
                this.minRecordKey = recordKey;
            }
            this.maxRecordKey = recordKey;
        }
        this.prevRecordKey = recordKey;
    }

    public void close() throws IOException {
        if (this.hfileConfig.useBloomFilter()) {
            BloomFilter bloomFilter = this.hfileConfig.getBloomFilter();
            if (this.minRecordKey == null) {
                this.minRecordKey = "";
            }
            if (this.maxRecordKey == null) {
                this.maxRecordKey = "";
            }
            this.writer.appendFileInfo("minRecordKey", StringUtils.getUTF8Bytes((String)this.minRecordKey));
            this.writer.appendFileInfo("maxRecordKey", StringUtils.getUTF8Bytes((String)this.maxRecordKey));
            this.writer.appendFileInfo("bloomFilterTypeCode", StringUtils.getUTF8Bytes((String)bloomFilter.getBloomFilterTypeCode().toString()));
            this.writer.appendMetaInfo("bloomFilter", StringUtils.getUTF8Bytes((String)bloomFilter.serializeToString()));
        }
        this.writer.close();
        this.writer = null;
    }
}

