/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.util.AvroOrcUtils;
import org.apache.hudi.common.util.FileFormatUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.hadoop.OrcReaderIterator;
import org.apache.hudi.io.storage.HoodieAvroFileReader;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;

public class HoodieAvroOrcReader
extends HoodieAvroFileReader {
    private final StoragePath path;
    private final HoodieStorage storage;
    private final FileFormatUtils orcUtils;

    public HoodieAvroOrcReader(HoodieStorage storage, StoragePath path) {
        this.storage = storage;
        this.path = path;
        this.orcUtils = HoodieIOFactory.getIOFactory((HoodieStorage)storage).getFileFormatUtils(HoodieFileFormat.ORC);
    }

    public String[] readMinMaxRecordKeys() {
        return this.orcUtils.readMinMaxRecordKeys(this.storage, this.path);
    }

    public BloomFilter readBloomFilter() {
        return this.orcUtils.readBloomFilterFromMetadata(this.storage, this.path);
    }

    public Set<Pair<String, Long>> filterRowKeys(Set candidateRowKeys) {
        return this.orcUtils.filterRowKeys(this.storage, this.path, candidateRowKeys);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClosableIterator<IndexedRecord> getIndexedRecordIterator(Schema readerSchema, Schema requestedSchema, Map<String, String> renamedColumns) {
        if (!Objects.equals(readerSchema, requestedSchema)) {
            throw new UnsupportedOperationException("Schema projections are not supported in HFile reader");
        }
        Configuration hadoopConf = (Configuration)this.storage.getConf().unwrapCopyAs(Configuration.class);
        try (Reader reader = OrcFile.createReader((Path)new Path(this.path.toUri()), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)hadoopConf));){
            Schema fileSchema = AvroOrcUtils.createAvroSchema(reader.getSchema());
            Set existingFields = fileSchema.getFields().stream().map(Schema.Field::name).collect(Collectors.toSet());
            Schema prunedFileSchema = HoodieAvroUtils.projectSchema((Schema)fileSchema, requestedSchema.getFields().stream().map(Schema.Field::name).filter(existingFields::contains).collect(Collectors.toList()));
            TypeDescription orcSchema = AvroOrcUtils.createOrcSchema(prunedFileSchema);
            RecordReader recordReader = reader.rows(new Reader.Options(hadoopConf).schema(orcSchema));
            OrcReaderIterator<IndexedRecord> recordIterator = new OrcReaderIterator<IndexedRecord>(recordReader, prunedFileSchema, orcSchema);
            if (renamedColumns.isEmpty() && readerSchema.equals((Object)fileSchema)) {
                OrcReaderIterator<IndexedRecord> orcReaderIterator = recordIterator;
                return orcReaderIterator;
            }
            CloseableMappingIterator closeableMappingIterator = new CloseableMappingIterator(recordIterator, data -> HoodieAvroUtils.rewriteRecordWithNewSchema((IndexedRecord)data, (Schema)requestedSchema, (Map)renamedColumns));
            return closeableMappingIterator;
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to create an ORC reader.", io);
        }
    }

    public ClosableIterator<String> getRecordKeyIterator() {
        final Iterator iterator = this.orcUtils.readRowKeys(this.storage, this.path).iterator();
        return new ClosableIterator<String>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public String next() {
                return (String)iterator.next();
            }

            public void close() {
            }
        };
    }

    public Schema getSchema() {
        return this.orcUtils.readAvroSchema(this.storage, this.path);
    }

    public void close() {
    }

    public long getTotalRecords() {
        return this.orcUtils.getRowCount(this.storage, this.path);
    }

    public ClosableIterator<IndexedRecord> getIndexedRecordsByKeysIterator(List<String> sortedKeys, Schema readerSchema) {
        throw new UnsupportedOperationException("Not supported operation: getIndexedRecordsByKeysIterator");
    }

    public ClosableIterator<IndexedRecord> getIndexedRecordsByKeyPrefixIterator(List<String> sortedKeyPrefixes, Schema readerSchema) {
        throw new UnsupportedOperationException("Not supported operation: getIndexedRecordsByKeyPrefixIterator");
    }
}

