/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hadoop.fs.HoodieWrapperFileSystem;
import org.apache.hudi.io.storage.HoodieParquetConfig;
import org.apache.hudi.storage.StoragePath;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;

public abstract class HoodieBaseParquetWriter<R>
implements Closeable {
    private final AtomicLong writtenRecordCount = new AtomicLong(0L);
    private final long maxFileSize;
    private long recordCountForNextSizeCheck;
    private final ParquetWriter parquetWriter;
    public static final String BLOOM_FILTER_EXPECTED_NDV = "parquet.bloom.filter.expected.ndv";
    public static final String BLOOM_FILTER_ENABLED = "parquet.bloom.filter.enabled";

    public HoodieBaseParquetWriter(StoragePath file, final HoodieParquetConfig<? extends WriteSupport<R>> parquetConfig) throws IOException {
        Configuration hadoopConf = (Configuration)parquetConfig.getStorageConf().unwrapAs(Configuration.class);
        ParquetWriter.Builder parquetWriterbuilder = new ParquetWriter.Builder(HoodieWrapperFileSystem.convertToHoodiePath(file, hadoopConf)){

            protected ParquetWriter.Builder self() {
                return this;
            }

            protected WriteSupport getWriteSupport(Configuration conf) {
                return (WriteSupport)parquetConfig.getWriteSupport();
            }
        };
        parquetWriterbuilder.withWriteMode(ParquetFileWriter.Mode.CREATE);
        parquetWriterbuilder.withCompressionCodec(parquetConfig.getCompressionCodecName());
        parquetWriterbuilder.withRowGroupSize(parquetConfig.getBlockSize());
        parquetWriterbuilder.withPageSize(parquetConfig.getPageSize());
        parquetWriterbuilder.withDictionaryPageSize(parquetConfig.getPageSize());
        parquetWriterbuilder.withDictionaryEncoding(parquetConfig.dictionaryEnabled());
        parquetWriterbuilder.withValidation(false);
        parquetWriterbuilder.withWriterVersion(ParquetWriter.DEFAULT_WRITER_VERSION);
        parquetWriterbuilder.withConf(HadoopFSUtils.registerFileSystem(file, hadoopConf));
        this.handleParquetBloomFilters(parquetWriterbuilder, hadoopConf);
        this.parquetWriter = parquetWriterbuilder.build();
        this.maxFileSize = parquetConfig.getMaxFileSize() + Math.round((double)parquetConfig.getMaxFileSize() * parquetConfig.getCompressionRatio());
        this.recordCountForNextSizeCheck = 100L;
    }

    protected void handleParquetBloomFilters(ParquetWriter.Builder parquetWriterbuilder, Configuration hadoopConf) {
        hadoopConf.forEach(conf -> {
            Method method2;
            String column;
            String key = (String)conf.getKey();
            if (key.startsWith(BLOOM_FILTER_ENABLED)) {
                column = key.substring(BLOOM_FILTER_ENABLED.length() + 1);
                try {
                    method2 = parquetWriterbuilder.getClass().getMethod("withBloomFilterEnabled", String.class, Boolean.TYPE);
                    method2.invoke((Object)parquetWriterbuilder, column, Boolean.valueOf((String)conf.getValue()));
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException method2) {
                    // empty catch block
                }
            }
            if (key.startsWith(BLOOM_FILTER_EXPECTED_NDV)) {
                column = key.substring(BLOOM_FILTER_EXPECTED_NDV.length() + 1);
                try {
                    method2 = parquetWriterbuilder.getClass().getMethod("withBloomFilterNDV", String.class, Long.TYPE);
                    method2.invoke((Object)parquetWriterbuilder, column, Long.valueOf((String)conf.getValue()));
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
        });
    }

    public boolean canWrite() {
        long writtenCount = this.getWrittenRecordCount();
        if (writtenCount >= this.recordCountForNextSizeCheck) {
            long avgRecordSize;
            long dataSize = this.getDataSize();
            if (dataSize > this.maxFileSize - (avgRecordSize = Math.max(dataSize / writtenCount, 1L)) * 2L) {
                return false;
            }
            this.recordCountForNextSizeCheck = writtenCount + Math.min(Math.max(100L, (this.maxFileSize / avgRecordSize - writtenCount) / 2L), 10000L);
        }
        return true;
    }

    public long getDataSize() {
        return this.parquetWriter.getDataSize();
    }

    public void write(R object) throws IOException {
        this.parquetWriter.write(object);
        this.writtenRecordCount.incrementAndGet();
    }

    private static boolean isRequiredFieldNullError(String errorMessage) {
        return errorMessage.contains("null") && errorMessage.contains("required");
    }

    protected long getWrittenRecordCount() {
        return this.writtenRecordCount.get();
    }

    @VisibleForTesting
    protected long getRecordCountForNextSizeCheck() {
        return this.recordCountForNextSizeCheck;
    }

    @Override
    public void close() throws IOException {
        this.parquetWriter.close();
    }
}

