/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.parquet.io;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.io.storage.HoodieFileBinaryCopier;
import org.apache.hudi.parquet.io.HoodieParquetBinaryCopyBase;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.util.HoodieFileMetadataMerger;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.Preconditions;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.CompressionConverter;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieParquetFileBinaryCopier
extends HoodieParquetBinaryCopyBase
implements HoodieFileBinaryCopier {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieParquetFileBinaryCopier.class);
    private final CompressionCodecName codecName;
    private Queue<CompressionConverter.TransParquetFileReader> inputFiles = new LinkedList<CompressionConverter.TransParquetFileReader>();
    private Map<String, String> extraMetaData = new HashMap<String, String>();
    private CompressionConverter.TransParquetFileReader reader = null;
    private HoodieFileMetadataMerger metadataMerger;

    public HoodieParquetFileBinaryCopier(Configuration conf, CompressionCodecName codecName, HoodieFileMetadataMerger metadataMerger) {
        super(conf);
        this.metadataMerger = metadataMerger;
        this.codecName = codecName;
    }

    @Override
    protected Map<String, String> finalizeMetadata() {
        return this.extraMetaData;
    }

    public long binaryCopy(List<StoragePath> inputFilePaths, List<StoragePath> outputFilePath, MessageType writeSchema, boolean schemaEvolutionEnabled) throws IOException {
        this.setSchemaEvolutionEnabled(schemaEvolutionEnabled);
        this.openInputFiles(inputFilePaths, this.conf);
        this.initFileWriter(new Path(outputFilePath.get(0).toUri()), this.codecName, writeSchema);
        this.initNextReader();
        HashSet<String> allOriginalCreatedBys = new HashSet<String>();
        while (this.reader != null) {
            List rowGroups = this.reader.getRowGroups();
            FileMetaData fileMetaData = this.reader.getFooter().getFileMetaData();
            String createdBy = fileMetaData.getCreatedBy();
            allOriginalCreatedBys.add(createdBy);
            Map metaMap = fileMetaData.getKeyValueMetaData();
            this.metadataMerger.mergeMetaData(metaMap);
            for (BlockMetaData block : rowGroups) {
                this.processBlocksFromReader(this.reader, this.reader.readNextRowGroup(), block, createdBy);
            }
            this.initNextReader();
        }
        this.extraMetaData.putAll(this.metadataMerger.getMergedMetaData());
        this.extraMetaData.put("original.created.by", String.join((CharSequence)"\n", allOriginalCreatedBys));
        return this.totalRecordsWritten;
    }

    private void openInputFiles(List<StoragePath> inputFiles, Configuration conf) {
        Preconditions.checkArgument((inputFiles != null && !inputFiles.isEmpty() ? 1 : 0) != 0, (String)"No input files");
        for (StoragePath inputFile : inputFiles) {
            try {
                CompressionConverter.TransParquetFileReader reader = new CompressionConverter.TransParquetFileReader((InputFile)HadoopInputFile.fromPath((Path)new Path(inputFile.toUri()), (Configuration)conf), HadoopReadOptions.builder((Configuration)conf).build());
                this.inputFiles.add(reader);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to open input file: " + inputFile, e);
            }
        }
    }

    private void initNextReader() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            LOG.info("Finish binary copy input file: {}", (Object)this.reader.getFile());
        }
        if (this.inputFiles.isEmpty()) {
            this.reader = null;
            return;
        }
        this.reader = this.inputFiles.poll();
        LOG.info("Merging input file: {}, remaining files: {}", (Object)this.reader.getFile(), (Object)this.inputFiles.size());
    }
}

