/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.parquet.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class ParquetBinaryCopyChecker {
    private ParquetBinaryCopyChecker() {
    }

    public static boolean verifyFiles(List<ParquetFileInfo> files) {
        boolean hasSameFilterCodeType;
        boolean schemaSupportBinaryCopy = files.stream().allMatch(ParquetFileInfo::canBinaryCopy);
        if (!schemaSupportBinaryCopy) {
            return false;
        }
        boolean bl = hasSameFilterCodeType = files.stream().map(ParquetFileInfo::getBloomFilterTypeCode).distinct().count() <= 1L;
        if (!hasSameFilterCodeType) {
            return false;
        }
        Map<String, Set<String>> fieldsMap = ParquetBinaryCopyChecker.collectRepetitions(files);
        return fieldsMap.values().stream().allMatch(reps -> reps.size() == 1);
    }

    private static Map<String, Set<String>> collectRepetitions(List<ParquetFileInfo> files) {
        HashMap<String, Set<String>> fieldsMap = new HashMap<String, Set<String>>();
        for (ParquetFileInfo file : files) {
            String schema = file.getSchema();
            MessageType messageType = MessageTypeParser.parseMessageType((String)schema);
            Map<String, String> map = ParquetBinaryCopyChecker.collectRepetitions("", (GroupType)messageType);
            map.forEach((field, repetition) -> {
                Set repetitions = fieldsMap.computeIfAbsent((String)field, f -> new HashSet());
                repetitions.add(repetition);
                fieldsMap.put((String)field, repetitions);
            });
        }
        return fieldsMap;
    }

    private static Map<String, String> collectRepetitions(String parentName, GroupType schema) {
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        List fields = schema.getFields();
        for (Type type : fields) {
            if (type.isPrimitive()) {
                fieldsMap.put(parentName + "." + type.getName(), type.getRepetition().name());
                continue;
            }
            fieldsMap.put(parentName + "." + type.getName(), type.getRepetition().name());
            GroupType groupType = type.asGroupType();
            if (groupType.getOriginalType() == OriginalType.LIST) {
                Type middleType = groupType.getType(0);
                Type elementType = middleType.asGroupType().getType(0);
                fieldsMap.put(parentName + ".list", middleType.getRepetition().name());
                fieldsMap.put(parentName + ".list.element", elementType.getRepetition().name());
                if (elementType.isPrimitive()) continue;
                fieldsMap.putAll(ParquetBinaryCopyChecker.collectRepetitions(parentName + ".list.element" + elementType.getName(), elementType.asGroupType()));
                continue;
            }
            if (groupType.getOriginalType() == OriginalType.MAP) {
                Type keyValueType = groupType.getType(0);
                fieldsMap.put(parentName + ".key_value", keyValueType.getRepetition().name());
                Type keyType = keyValueType.asGroupType().getType(0);
                Type valueType = keyValueType.asGroupType().getType(1);
                fieldsMap.put(parentName + ".key_value.key", keyType.getRepetition().name());
                fieldsMap.put(parentName + ".key_value.value", valueType.getRepetition().name());
                if (!keyType.isPrimitive()) {
                    fieldsMap.putAll(ParquetBinaryCopyChecker.collectRepetitions(parentName + ".key_value.key" + keyType.getName(), keyType.asGroupType()));
                }
                if (valueType.isPrimitive()) continue;
                fieldsMap.putAll(ParquetBinaryCopyChecker.collectRepetitions(parentName + ".key_value.value" + valueType.getName(), valueType.asGroupType()));
                continue;
            }
            fieldsMap.putAll(ParquetBinaryCopyChecker.collectRepetitions(parentName + "." + groupType.getName(), groupType));
        }
        return fieldsMap;
    }

    public static ParquetFileInfo collectFileInfo(Configuration conf, String file) {
        Path path = new Path(file);
        ParquetMetadata footer = ParquetBinaryCopyChecker.readMetadata(conf, path, ParquetMetadataConverter.SKIP_ROW_GROUPS);
        FileMetaData fileMetaData = footer.getFileMetaData();
        MessageType fileSchema = fileMetaData.getSchema();
        List fields = fileSchema.getFields();
        if (ParquetBinaryCopyChecker.schemaNotSupportBinaryCopy(fields)) {
            return new ParquetFileInfo(false, null, null);
        }
        Map keyValueMetaData = fileMetaData.getKeyValueMetaData();
        String bloomFileTypeCode = (String)keyValueMetaData.get("hoodie_bloom_filter_type_code");
        if (bloomFileTypeCode == null && keyValueMetaData.get("org.apache.hudi.bloomfilter") != null) {
            bloomFileTypeCode = BloomFilterTypeCode.SIMPLE.name();
        }
        return new ParquetFileInfo(true, bloomFileTypeCode, fileSchema.toString());
    }

    private static ParquetMetadata readMetadata(Configuration conf, Path parquetFilePath, ParquetMetadataConverter.MetadataFilter filter) {
        ParquetMetadata footer;
        try {
            footer = ParquetFileReader.readFooter((Configuration)conf, (Path)parquetFilePath, (ParquetMetadataConverter.MetadataFilter)filter);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to read footer for parquet " + parquetFilePath, e);
        }
        return footer;
    }

    private static boolean schemaNotSupportBinaryCopy(List<Type> parquetFields) {
        for (Type type : parquetFields) {
            PrimitiveType primitiveType;
            PrimitiveType.PrimitiveTypeName typeName;
            if (type.getOriginalType() == OriginalType.DECIMAL && ((typeName = (primitiveType = type.asPrimitiveType()).getPrimitiveTypeName()) == PrimitiveType.PrimitiveTypeName.INT32 || typeName == PrimitiveType.PrimitiveTypeName.INT64 || typeName == PrimitiveType.PrimitiveTypeName.INT96)) {
                return true;
            }
            if (type.isPrimitive()) continue;
            GroupType groupType = type.asGroupType();
            OriginalType originalType = groupType.getOriginalType();
            if (originalType == OriginalType.LIST && groupType.getType(0).getName().equals("array")) {
                return true;
            }
            if (!ParquetBinaryCopyChecker.schemaNotSupportBinaryCopy(groupType.getFields())) continue;
            return true;
        }
        return false;
    }

    public static class ParquetFileInfo
    implements Serializable {
        private final boolean canBinaryCopy;
        private final String bloomFilterTypeCode;
        private final String schema;

        public ParquetFileInfo(boolean canBinaryCopy, String hoodieBloomFilterTypeCode, String schema) {
            this.canBinaryCopy = canBinaryCopy;
            this.bloomFilterTypeCode = hoodieBloomFilterTypeCode;
            this.schema = schema;
        }

        public boolean canBinaryCopy() {
            return this.canBinaryCopy;
        }

        public String getBloomFilterTypeCode() {
            return this.bloomFilterTypeCode;
        }

        public String getSchema() {
            return this.schema;
        }
    }
}

