/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.storage.hadoop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hudi.common.fs.ConsistencyGuard;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hadoop.fs.HadoopSeekableDataInputStream;
import org.apache.hudi.hadoop.fs.HoodieRetryWrapperFileSystem;
import org.apache.hudi.hadoop.fs.HoodieWrapperFileSystem;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathFilter;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;

public class HoodieHadoopStorage
extends HoodieStorage {
    private final FileSystem fs;

    public HoodieHadoopStorage(StoragePath path, StorageConfiguration<?> conf) {
        super(conf);
        this.fs = HadoopFSUtils.getFs(path, (Configuration)conf.unwrapAs(Configuration.class));
    }

    public HoodieHadoopStorage(Path path, Configuration conf) {
        super(HadoopFSUtils.getStorageConf(conf));
        this.fs = HadoopFSUtils.getFs(path, conf);
    }

    public HoodieHadoopStorage(String path, Configuration conf) {
        super(HadoopFSUtils.getStorageConf(conf));
        this.fs = HadoopFSUtils.getFs(path, conf);
    }

    public HoodieHadoopStorage(String path, StorageConfiguration<?> conf) {
        super(conf);
        this.fs = HadoopFSUtils.getFs(path, conf);
    }

    public HoodieHadoopStorage(StoragePath path, StorageConfiguration<?> conf, boolean enableRetry, long maxRetryIntervalMs, int maxRetryNumbers, long initialRetryIntervalMs, String retryExceptions, ConsistencyGuard consistencyGuard) {
        super(conf);
        FileSystem fileSystem = HadoopFSUtils.getFs(path, (Configuration)conf.unwrapCopyAs(Configuration.class));
        if (enableRetry) {
            fileSystem = new HoodieRetryWrapperFileSystem(fileSystem, maxRetryIntervalMs, maxRetryNumbers, initialRetryIntervalMs, retryExceptions);
        }
        ValidationUtils.checkArgument((!(fileSystem instanceof HoodieWrapperFileSystem) ? 1 : 0) != 0, (String)"File System not expected to be that of HoodieWrapperFileSystem");
        this.fs = new HoodieWrapperFileSystem(fileSystem, consistencyGuard);
    }

    public HoodieHadoopStorage(FileSystem fs) {
        super((StorageConfiguration)new HadoopStorageConfiguration(fs.getConf()));
        this.fs = fs;
    }

    public HoodieStorage newInstance(StoragePath path, StorageConfiguration<?> storageConf) {
        return new HoodieHadoopStorage(path, storageConf);
    }

    public String getScheme() {
        return this.fs.getScheme();
    }

    public URI getUri() {
        return this.fs.getUri();
    }

    public int getDefaultBlockSize(StoragePath path) {
        return (int)this.fs.getDefaultBlockSize(HadoopFSUtils.convertToHadoopPath(path));
    }

    public OutputStream create(StoragePath path, boolean overwrite) throws IOException {
        return this.fs.create(HadoopFSUtils.convertToHadoopPath(path), overwrite);
    }

    public OutputStream create(StoragePath path, boolean overwrite, Integer bufferSize, Short replication, Long sizeThreshold) throws IOException {
        return this.fs.create(HadoopFSUtils.convertToHadoopPath(path), false, bufferSize.intValue(), replication.shortValue(), sizeThreshold.longValue(), null);
    }

    public int getDefaultBufferSize() {
        return this.fs.getConf().getInt("io.file.buffer.size", 4096);
    }

    public short getDefaultReplication(StoragePath path) {
        return this.fs.getDefaultReplication(HadoopFSUtils.convertToHadoopPath(path));
    }

    public InputStream open(StoragePath path) throws IOException {
        return this.fs.open(HadoopFSUtils.convertToHadoopPath(path));
    }

    public SeekableDataInputStream openSeekable(StoragePath path, int bufferSize, boolean wrapStream) throws IOException {
        return new HadoopSeekableDataInputStream(HadoopFSUtils.getFSDataInputStream(this.fs, path, bufferSize, wrapStream));
    }

    public OutputStream append(StoragePath path) throws IOException {
        return this.fs.append(HadoopFSUtils.convertToHadoopPath(path));
    }

    public boolean exists(StoragePath path) throws IOException {
        return this.fs.exists(HadoopFSUtils.convertToHadoopPath(path));
    }

    public StoragePathInfo getPathInfo(StoragePath path) throws IOException {
        return HadoopFSUtils.convertToStoragePathInfo(this.fs.getFileStatus(HadoopFSUtils.convertToHadoopPath(path)));
    }

    public boolean createDirectory(StoragePath path) throws IOException {
        return this.fs.mkdirs(HadoopFSUtils.convertToHadoopPath(path));
    }

    public List<StoragePathInfo> listDirectEntries(StoragePath path) throws IOException {
        return Arrays.stream(this.fs.listStatus(HadoopFSUtils.convertToHadoopPath(path))).map(HadoopFSUtils::convertToStoragePathInfo).collect(Collectors.toList());
    }

    public List<StoragePathInfo> listFiles(StoragePath path) throws IOException {
        ArrayList<StoragePathInfo> result = new ArrayList<StoragePathInfo>();
        RemoteIterator iterator = this.fs.listFiles(HadoopFSUtils.convertToHadoopPath(path), true);
        while (iterator.hasNext()) {
            result.add(HadoopFSUtils.convertToStoragePathInfo((FileStatus)iterator.next()));
        }
        return result;
    }

    public List<StoragePathInfo> listDirectEntries(List<StoragePath> pathList) throws IOException {
        return Arrays.stream(this.fs.listStatus((Path[])pathList.stream().map(HadoopFSUtils::convertToHadoopPath).toArray(Path[]::new))).map(HadoopFSUtils::convertToStoragePathInfo).collect(Collectors.toList());
    }

    public List<StoragePathInfo> listDirectEntries(StoragePath path, StoragePathFilter filter) throws IOException {
        return Arrays.stream(this.fs.listStatus(HadoopFSUtils.convertToHadoopPath(path), e -> filter.accept(HadoopFSUtils.convertToStoragePath(e)))).map(HadoopFSUtils::convertToStoragePathInfo).collect(Collectors.toList());
    }

    public void setModificationTime(StoragePath path, long modificationTimeInMillisEpoch) throws IOException {
        this.fs.setTimes(HadoopFSUtils.convertToHadoopPath(path), modificationTimeInMillisEpoch, modificationTimeInMillisEpoch);
    }

    public List<StoragePathInfo> listDirectEntries(List<StoragePath> pathList, StoragePathFilter filter) throws IOException {
        return Arrays.stream(this.fs.listStatus((Path[])pathList.stream().map(HadoopFSUtils::convertToHadoopPath).toArray(Path[]::new), e -> filter.accept(HadoopFSUtils.convertToStoragePath(e)))).map(HadoopFSUtils::convertToStoragePathInfo).collect(Collectors.toList());
    }

    public List<StoragePathInfo> globEntries(StoragePath pathPattern) throws IOException {
        return Arrays.stream(this.fs.globStatus(HadoopFSUtils.convertToHadoopPath(pathPattern))).map(HadoopFSUtils::convertToStoragePathInfo).collect(Collectors.toList());
    }

    public List<StoragePathInfo> globEntries(StoragePath pathPattern, StoragePathFilter filter) throws IOException {
        return Arrays.stream(this.fs.globStatus(HadoopFSUtils.convertToHadoopPath(pathPattern), path -> filter.accept(HadoopFSUtils.convertToStoragePath(path)))).map(HadoopFSUtils::convertToStoragePathInfo).collect(Collectors.toList());
    }

    public boolean rename(StoragePath oldPath, StoragePath newPath) throws IOException {
        return this.fs.rename(HadoopFSUtils.convertToHadoopPath(oldPath), HadoopFSUtils.convertToHadoopPath(newPath));
    }

    public boolean deleteDirectory(StoragePath path) throws IOException {
        return this.delete(path, true);
    }

    public boolean deleteFile(StoragePath path) throws IOException {
        return this.delete(path, false);
    }

    private boolean delete(StoragePath path, boolean recursive) throws IOException {
        Path hadoopPath = HadoopFSUtils.convertToHadoopPath(path);
        boolean success = this.fs.delete(hadoopPath, recursive);
        if (!success && this.fs.exists(hadoopPath)) {
            throw new HoodieIOException("Failed to delete invalid data file: " + path);
        }
        return success;
    }

    public Object getFileSystem() {
        return this.fs;
    }

    public HoodieStorage getRawStorage() {
        if (this.fs instanceof HoodieWrapperFileSystem) {
            return new HoodieHadoopStorage(((HoodieWrapperFileSystem)this.fs).getFileSystem());
        }
        return this;
    }

    public OutputStream create(StoragePath path) throws IOException {
        return this.fs.create(HadoopFSUtils.convertToHadoopPath(path));
    }

    public boolean createNewFile(StoragePath path) throws IOException {
        return this.fs.createNewFile(HadoopFSUtils.convertToHadoopPath(path));
    }

    public void close() throws IOException {
    }
}

