/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.util.Option;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.SchemaRepair;
import org.apache.parquet.schema.Type;

public class HoodieAvroReadSupport<T>
extends AvroReadSupport<T> {
    private Option<MessageType> tableSchema;

    public HoodieAvroReadSupport(GenericData model, Option<MessageType> tableSchema) {
        super(model);
        this.tableSchema = tableSchema;
    }

    public HoodieAvroReadSupport() {
        this.tableSchema = Option.empty();
    }

    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        boolean legacyMode = HoodieAvroReadSupport.checkLegacyMode(fileSchema.getFields());
        this.adjustConfToReadWithFileProduceMode(legacyMode, configuration);
        ReadSupport.ReadContext readContext = super.init(configuration, keyValueMetaData, fileSchema);
        MessageType requestedSchema = SchemaRepair.repairLogicalTypes(readContext.getRequestedSchema(), this.tableSchema);
        if (!legacyMode) {
            requestedSchema = new MessageType(requestedSchema.getName(), this.convertLegacyMap(requestedSchema.getFields()));
        }
        return new ReadSupport.ReadContext(requestedSchema, readContext.getReadSupportMetadata());
    }

    public ReadSupport.ReadContext init(ParquetConfiguration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        String avroReadSchema;
        boolean legacyMode = HoodieAvroReadSupport.checkLegacyMode(fileSchema.getFields());
        configuration.set("parquet.avro.write-old-list-structure", String.valueOf(legacyMode));
        MessageType projection = SchemaRepair.repairLogicalTypes(fileSchema, this.tableSchema);
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        String requestedProjectionString = configuration.get(AVRO_REQUESTED_PROJECTION);
        if (requestedProjectionString != null) {
            Schema avroRequestedProjection = new Schema.Parser().parse(requestedProjectionString);
            Configuration conf = new Configuration();
            configuration.forEach(entry -> conf.set((String)entry.getKey(), (String)entry.getValue()));
            projection = new AvroSchemaConverter(conf).convert(avroRequestedProjection);
        }
        if ((avroReadSchema = configuration.get("parquet.avro.read.schema")) != null) {
            metadata.put("avro.read.schema", avroReadSchema);
        }
        if (configuration.getBoolean("parquet.avro.compatible", true)) {
            metadata.put("parquet.avro.compatible", "true");
        }
        ReadSupport.ReadContext readContext = new ReadSupport.ReadContext(projection, metadata);
        MessageType requestedSchema = readContext.getRequestedSchema();
        if (!legacyMode) {
            requestedSchema = new MessageType(requestedSchema.getName(), this.convertLegacyMap(requestedSchema.getFields()));
        }
        return new ReadSupport.ReadContext(requestedSchema, readContext.getReadSupportMetadata());
    }

    private void adjustConfToReadWithFileProduceMode(boolean isLegacyModeWrittenFile, Configuration configuration) {
        if (isLegacyModeWrittenFile) {
            configuration.set("parquet.avro.write-old-list-structure", "true", "support reading avro from legacy map/list in parquet file");
        } else {
            configuration.set("parquet.avro.write-old-list-structure", "false", "support reading avro from non-legacy map/list in parquet file");
        }
    }

    private static boolean checkLegacyMode(List<Type> parquetFields) {
        return parquetFields.stream().anyMatch(type -> {
            if (!type.isPrimitive()) {
                GroupType groupType = type.asGroupType();
                OriginalType originalType = groupType.getOriginalType();
                if (originalType == OriginalType.MAP && !((Type)groupType.getFields().get(0)).getName().equals("key_value")) {
                    return true;
                }
                if (originalType == OriginalType.LIST && !groupType.getType(0).getName().equals("list")) {
                    return true;
                }
                return HoodieAvroReadSupport.checkLegacyMode(groupType.getFields());
            }
            return false;
        });
    }

    private List<Type> convertLegacyMap(List<Type> oldTypes) {
        ArrayList<Type> newTypes = new ArrayList<Type>(oldTypes.size());
        for (Type type : oldTypes) {
            if (!type.isPrimitive()) {
                GroupType parent = type.asGroupType();
                List<Type> types = this.convertLegacyMap(parent.getFields());
                if (type.getOriginalType() == OriginalType.MAP_KEY_VALUE) {
                    newTypes.add((Type)new GroupType(parent.getRepetition(), "key_value", types));
                    continue;
                }
                newTypes.add((Type)new GroupType(parent.getRepetition(), parent.getName(), parent.getOriginalType(), types));
                continue;
            }
            newTypes.add(type);
        }
        return newTypes;
    }
}

