/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.schema;

import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.common.util.Option;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class SchemaRepair {
    public static MessageType repairLogicalTypes(MessageType fileSchema, Option<MessageType> tableSchema) {
        if (tableSchema.isEmpty()) {
            return fileSchema;
        }
        return SchemaRepair.repairLogicalTypes(fileSchema, (MessageType)tableSchema.get());
    }

    static MessageType repairLogicalTypes(MessageType fileSchema, MessageType tableSchema) {
        List<Type> repairedFields = SchemaRepair.repairFields(fileSchema.getFields(), (GroupType)tableSchema);
        if (repairedFields == null) {
            return fileSchema;
        }
        return new MessageType(fileSchema.getName(), repairedFields);
    }

    private static List<Type> repairFields(List<Type> fileSchemaFields, GroupType tableSchema) {
        int i;
        Type repaired;
        int firstChangedIndex = -1;
        Type firstRepairedField = null;
        for (int i2 = 0; i2 < fileSchemaFields.size(); ++i2) {
            Type tableField;
            Type requestedField = fileSchemaFields.get(i2);
            if (!tableSchema.containsField(requestedField.getName()) || (repaired = SchemaRepair.repairField(requestedField, tableField = tableSchema.getType(requestedField.getName()))) == requestedField) continue;
            firstChangedIndex = i2;
            firstRepairedField = repaired;
            break;
        }
        if (firstChangedIndex == -1) {
            return null;
        }
        ArrayList<Type> repairedFields = new ArrayList<Type>(fileSchemaFields.size());
        for (i = 0; i < firstChangedIndex; ++i) {
            repairedFields.add(fileSchemaFields.get(i));
        }
        repairedFields.add(firstRepairedField);
        for (i = firstChangedIndex + 1; i < fileSchemaFields.size(); ++i) {
            Type fileSchemaField;
            repaired = fileSchemaField = fileSchemaFields.get(i);
            if (tableSchema.containsField(fileSchemaField.getName())) {
                Type tableSchemaField = tableSchema.getType(fileSchemaField.getName());
                repaired = SchemaRepair.repairField(fileSchemaField, tableSchemaField);
            }
            repairedFields.add(repaired);
        }
        return repairedFields;
    }

    private static Type repairField(Type fileSchemaFieldType, Type tableSchemaFieldType) {
        if (fileSchemaFieldType.isPrimitive() && tableSchemaFieldType.isPrimitive()) {
            return SchemaRepair.repairPrimitiveType(fileSchemaFieldType.asPrimitiveType(), tableSchemaFieldType.asPrimitiveType());
        }
        if (!fileSchemaFieldType.isPrimitive() && !tableSchemaFieldType.isPrimitive()) {
            GroupType reqGroup = fileSchemaFieldType.asGroupType();
            GroupType tblGroup = tableSchemaFieldType.asGroupType();
            List<Type> repairedFields = SchemaRepair.repairFields(reqGroup.getFields(), tblGroup);
            if (repairedFields == null) {
                return fileSchemaFieldType;
            }
            return new GroupType(reqGroup.getRepetition(), reqGroup.getName(), reqGroup.getLogicalTypeAnnotation(), repairedFields);
        }
        return fileSchemaFieldType;
    }

    private static PrimitiveType repairPrimitiveType(PrimitiveType fileSchemaPrimitiveType, PrimitiveType tableSchemaPrimitiveType) {
        if (SchemaRepair.needsLogicalTypeRepair(fileSchemaPrimitiveType, tableSchemaPrimitiveType)) {
            return (PrimitiveType)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)tableSchemaPrimitiveType.getPrimitiveTypeName(), (Type.Repetition)fileSchemaPrimitiveType.getRepetition()).as(tableSchemaPrimitiveType.getLogicalTypeAnnotation())).named(fileSchemaPrimitiveType.getName());
        }
        return fileSchemaPrimitiveType;
    }

    private static boolean needsLogicalTypeRepair(PrimitiveType fileSchemaPrimitiveType, PrimitiveType tableSchemaPrimitiveType) {
        if (fileSchemaPrimitiveType.getPrimitiveTypeName() != PrimitiveType.PrimitiveTypeName.INT64 || tableSchemaPrimitiveType.getPrimitiveTypeName() != PrimitiveType.PrimitiveTypeName.INT64) {
            return false;
        }
        LogicalTypeAnnotation fileLogicalTypeAnnotation = fileSchemaPrimitiveType.getLogicalTypeAnnotation();
        LogicalTypeAnnotation tableLogicalTypeAnnotation = tableSchemaPrimitiveType.getLogicalTypeAnnotation();
        if (fileLogicalTypeAnnotation == null) {
            return tableLogicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation && !((LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)tableLogicalTypeAnnotation).isAdjustedToUTC();
        }
        return fileLogicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation && tableLogicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation && ((LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)fileLogicalTypeAnnotation).getUnit() == LogicalTypeAnnotation.TimeUnit.MICROS && ((LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)tableLogicalTypeAnnotation).getUnit() == LogicalTypeAnnotation.TimeUnit.MILLIS && ((LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)fileLogicalTypeAnnotation).isAdjustedToUTC() && ((LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)tableLogicalTypeAnnotation).isAdjustedToUTC();
    }
}

