/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClientScanner;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.ScannerCallableWithReplicas;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.com.google.common.annotations.VisibleForTesting;

@InterfaceAudience.Private
public class ClientSmallScanner
extends ClientScanner {
    private static final Log LOG = LogFactory.getLog(ClientSmallScanner.class);
    private ScannerCallableWithReplicas smallScanCallable = null;
    private SmallScannerCallableFactory callableFactory;

    public ClientSmallScanner(Configuration conf, Scan scan, TableName tableName, ClusterConnection connection, RpcRetryingCallerFactory rpcFactory, RpcControllerFactory controllerFactory, ExecutorService pool, int primaryOperationTimeout) throws IOException {
        this(conf, scan, tableName, connection, rpcFactory, controllerFactory, pool, primaryOperationTimeout, new SmallScannerCallableFactory());
    }

    @VisibleForTesting
    ClientSmallScanner(Configuration conf, Scan scan, TableName tableName, ClusterConnection connection, RpcRetryingCallerFactory rpcFactory, RpcControllerFactory controllerFactory, ExecutorService pool, int primaryOperationTimeout, SmallScannerCallableFactory callableFactory) throws IOException {
        super(conf, scan, tableName, connection, rpcFactory, controllerFactory, pool, primaryOperationTimeout);
        this.callableFactory = callableFactory;
    }

    @Override
    protected void initializeScannerInConstruction() throws IOException {
    }

    private boolean nextScanner(int nbRows, boolean done, boolean currentRegionDone) throws IOException {
        byte[] localStartKey;
        int cacheNum = nbRows;
        boolean regionChanged = true;
        if (this.currentRegion != null && currentRegionDone) {
            byte[] endKey = this.currentRegion.getEndKey();
            if (endKey == null || Bytes.equals(endKey, HConstants.EMPTY_BYTE_ARRAY) || this.checkScanStopRow(endKey) || done) {
                this.close();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Finished with small scan at " + this.currentRegion));
                }
                return false;
            }
            localStartKey = endKey;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Finished with region " + this.currentRegion));
            }
        } else if (this.lastResult != null) {
            regionChanged = false;
            localStartKey = Bytes.add(this.lastResult.getRow(), new byte[1]);
        } else {
            localStartKey = this.scan.getStartRow();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Advancing internal small scanner to startKey at '" + Bytes.toStringBinary(localStartKey) + "'"));
        }
        this.smallScanCallable = this.callableFactory.getCallable(this.getConnection(), this.getTable(), this.scan, this.getScanMetrics(), localStartKey, cacheNum, this.rpcControllerFactory, this.getPool(), this.getPrimaryOperationTimeout(), this.getRetries(), this.getScannerTimeout(), this.getConf(), this.caller);
        if (this.scanMetrics != null && regionChanged) {
            this.scanMetrics.countOfRegions.incrementAndGet();
        }
        return true;
    }

    @Override
    public Result next() throws IOException {
        if (this.cache.size() == 0 && this.closed) {
            return null;
        }
        if (this.cache.size() == 0) {
            this.loadCache();
        }
        if (this.cache.size() > 0) {
            return (Result)this.cache.poll();
        }
        this.writeScanMetrics();
        return null;
    }

    @Override
    protected void loadCache() throws IOException {
        Result[] values = null;
        long remainingResultSize = this.maxScannerResultSize;
        int countdown = this.caching;
        boolean currentRegionDone = false;
        while (remainingResultSize > 0L && countdown > 0 && this.nextScanner(countdown, values == null, currentRegionDone)) {
            values = this.caller.callWithoutRetries(this.smallScanCallable, this.scannerTimeout);
            this.currentRegion = this.smallScanCallable.getHRegionInfo();
            long currentTime = System.currentTimeMillis();
            if (this.scanMetrics != null) {
                this.scanMetrics.sumOfMillisSecBetweenNexts.addAndGet(currentTime - this.lastNext);
            }
            this.lastNext = currentTime;
            if (values != null && values.length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    Result rs = values[i];
                    this.cache.add(rs);
                    for (Cell cell : rs.rawCells()) {
                        remainingResultSize -= CellUtil.estimatedHeapSizeOf(cell);
                    }
                    --countdown;
                    this.lastResult = rs;
                }
            }
            if (this.smallScanCallable.hasMoreResultsContext()) {
                currentRegionDone = !this.smallScanCallable.getServerHasMoreResults();
                continue;
            }
            currentRegionDone = countdown > 0;
        }
    }

    @Override
    public void close() {
        if (!this.scanMetricsPublished) {
            this.writeScanMetrics();
        }
        this.closed = true;
    }

    @VisibleForTesting
    protected void setScannerCallableFactory(SmallScannerCallableFactory callableFactory) {
        this.callableFactory = callableFactory;
    }

    @InterfaceAudience.Private
    protected static class SmallScannerCallableFactory {
        protected SmallScannerCallableFactory() {
        }

        public ScannerCallableWithReplicas getCallable(ClusterConnection connection, TableName table, Scan scan, ScanMetrics scanMetrics, byte[] localStartKey, int cacheNum, RpcControllerFactory controllerFactory, ExecutorService pool, int primaryOperationTimeout, int retries, int scannerTimeout, Configuration conf, RpcRetryingCaller<Result[]> caller) {
            scan.setStartRow(localStartKey);
            SmallScannerCallable s = new SmallScannerCallable(connection, table, scan, scanMetrics, controllerFactory, cacheNum, 0);
            ScannerCallableWithReplicas scannerCallableWithReplicas = new ScannerCallableWithReplicas(table, connection, s, pool, primaryOperationTimeout, scan, retries, scannerTimeout, cacheNum, conf, caller);
            return scannerCallableWithReplicas;
        }
    }

    static class SmallScannerCallable
    extends ScannerCallable {
        public SmallScannerCallable(ClusterConnection connection, TableName table, Scan scan, ScanMetrics scanMetrics, RpcControllerFactory controllerFactory, int caching, int id) {
            super(connection, table, scan, scanMetrics, controllerFactory, id);
            this.setCaching(caching);
        }

        @Override
        public Result[] call(int timeout) throws IOException {
            if (this.closed) {
                return null;
            }
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            ClientProtos.ScanRequest request = RequestConverter.buildScanRequest(this.getLocation().getRegionInfo().getRegionName(), this.getScan(), this.getCaching(), true);
            ClientProtos.ScanResponse response = null;
            this.controller = this.controllerFactory.newController();
            try {
                this.controller.setPriority(this.getTableName());
                this.controller.setCallTimeout(timeout);
                response = this.getStub().scan(this.controller, request);
                Result[] results = ResponseConverter.getResults(this.controller.cellScanner(), response);
                if (response.hasMoreResultsInRegion()) {
                    this.setHasMoreResultsContext(true);
                    this.setServerHasMoreResults(response.getMoreResultsInRegion());
                } else {
                    this.setHasMoreResultsContext(false);
                }
                this.updateResultsMetrics(results);
                return results;
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
        }

        @Override
        public ScannerCallable getScannerCallableForReplica(int id) {
            return new SmallScannerCallable((ClusterConnection)this.connection, this.tableName, this.getScan(), this.scanMetrics, this.controllerFactory, this.getCaching(), id);
        }
    }
}

