/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcController;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.ipc.TimeLimitedRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class RegionCoprocessorRpcChannel
extends CoprocessorRpcChannel {
    private static final Log LOG = LogFactory.getLog(RegionCoprocessorRpcChannel.class);
    private final ClusterConnection connection;
    private final TableName table;
    private final byte[] row;
    private byte[] lastRegion;
    private int operationTimeout;
    private RpcRetryingCallerFactory rpcCallerFactory;
    private RpcControllerFactory rpcControllerFactory;

    public RegionCoprocessorRpcChannel(ClusterConnection conn, TableName table, byte[] row) {
        this.connection = conn;
        this.table = table;
        this.row = row;
        this.rpcCallerFactory = conn.getRpcRetryingCallerFactory();
        this.rpcControllerFactory = conn.getRpcControllerFactory();
        this.operationTimeout = conn.getConnectionConfiguration().getOperationTimeout();
    }

    @Override
    protected Message callExecService(RpcController controller, Descriptors.MethodDescriptor method, Message request, Message responsePrototype) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Call: " + method.getName() + ", " + request.toString()));
        }
        if (this.row == null) {
            throw new IllegalArgumentException("Missing row property for remote region location");
        }
        final RpcController rpcController = controller == null ? this.rpcControllerFactory.newController() : controller;
        final ClientProtos.CoprocessorServiceCall call = ClientProtos.CoprocessorServiceCall.newBuilder().setRow(ByteStringer.wrap(this.row)).setServiceName(method.getService().getFullName()).setMethodName(method.getName()).setRequest(request.toByteString()).build();
        RegionServerCallable<ClientProtos.CoprocessorServiceResponse> callable = new RegionServerCallable<ClientProtos.CoprocessorServiceResponse>((Connection)this.connection, this.table, this.row){

            @Override
            public ClientProtos.CoprocessorServiceResponse call(int callTimeout) throws Exception {
                if (rpcController instanceof PayloadCarryingRpcController) {
                    ((PayloadCarryingRpcController)rpcController).setPriority(this.tableName);
                }
                if (rpcController instanceof TimeLimitedRpcController) {
                    ((TimeLimitedRpcController)rpcController).setCallTimeout(callTimeout);
                }
                byte[] regionName = this.getLocation().getRegionInfo().getRegionName();
                return ProtobufUtil.execService(rpcController, this.getStub(), call, regionName);
            }
        };
        ClientProtos.CoprocessorServiceResponse result = this.rpcCallerFactory.newCaller().callWithRetries(callable, this.operationTimeout);
        Message response = null;
        if (result.getValue().hasValue()) {
            Message.Builder builder = responsePrototype.newBuilderForType();
            ProtobufUtil.mergeFrom(builder, result.getValue().getValue());
            response = builder.build();
        } else {
            response = responsePrototype.getDefaultInstanceForType();
        }
        this.lastRegion = result.getRegion().getValue().toByteArray();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Result is region=" + Bytes.toStringBinary(this.lastRegion) + ", value=" + response));
        }
        return response;
    }

    public byte[] getLastRegion() {
        return this.lastRegion;
    }
}

