/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hudi.com.google.common.annotations.VisibleForTesting;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface WAL {
    public void registerWALActionsListener(WALActionsListener var1);

    public boolean unregisterWALActionsListener(WALActionsListener var1);

    public byte[][] rollWriter() throws FailedLogCloseException, IOException;

    public byte[][] rollWriter(boolean var1) throws FailedLogCloseException, IOException;

    public void shutdown() throws IOException;

    public void close() throws IOException;

    public long append(HTableDescriptor var1, HRegionInfo var2, WALKey var3, WALEdit var4, boolean var5) throws IOException;

    public void sync() throws IOException;

    public void sync(long var1) throws IOException;

    public Long startCacheFlush(byte[] var1, Set<byte[]> var2);

    public void completeCacheFlush(byte[] var1);

    public void abortCacheFlush(byte[] var1);

    public WALCoprocessorHost getCoprocessorHost();

    @Deprecated
    @VisibleForTesting
    public long getEarliestMemstoreSeqNum(byte[] var1);

    public long getEarliestMemstoreSeqNum(byte[] var1, byte[] var2);

    public String toString();

    public static class Entry {
        private WALEdit edit;
        private WALKey key;

        public Entry() {
            this.edit = new WALEdit();
            this.key = new HLogKey();
        }

        public Entry(WALKey key, WALEdit edit) {
            this.key = key;
            this.edit = edit;
        }

        public WALEdit getEdit() {
            return this.edit;
        }

        public WALKey getKey() {
            return this.key;
        }

        public void setCompressionContext(CompressionContext compressionContext) {
            this.edit.setCompressionContext(compressionContext);
            this.key.setCompressionContext(compressionContext);
        }

        public String toString() {
            return this.key + "=" + this.edit;
        }
    }

    public static interface Reader
    extends Closeable {
        public Entry next() throws IOException;

        public Entry next(Entry var1) throws IOException;

        public void seek(long var1) throws IOException;

        public long getPosition() throws IOException;

        public void reset() throws IOException;
    }
}

