/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import javax.annotation.Nullable;

public class StringUtils {
    public static final String EMPTY_STRING = "";

    public static <T> String join(String ... elements) {
        return StringUtils.join(elements, EMPTY_STRING);
    }

    public static <T> String joinUsingDelim(String delim, String ... elements) {
        return StringUtils.join(elements, delim);
    }

    public static String join(String[] array, String separator) {
        if (array == null) {
            return null;
        }
        return org.apache.hadoop.util.StringUtils.join((CharSequence)separator, (String[])array);
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String nullToEmpty(@Nullable String string) {
        return string == null ? EMPTY_STRING : string;
    }

    public static String objToString(@Nullable Object obj) {
        return obj == null ? null : obj.toString();
    }

    @Nullable
    public static String emptyToNull(@Nullable String string) {
        return StringUtils.stringIsNullOrEmpty(string) ? null : string;
    }

    private static boolean stringIsNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }
}

