/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.util.AvroOrcUtils;
import org.apache.hudi.common.util.BaseFileUtils;
import org.apache.hudi.common.util.OrcReaderIterator;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;

public class HoodieOrcReader<R extends IndexedRecord>
implements HoodieFileReader {
    private Path path;
    private Configuration conf;
    private final BaseFileUtils orcUtils;

    public HoodieOrcReader(Configuration configuration, Path path) {
        this.conf = configuration;
        this.path = path;
        this.orcUtils = BaseFileUtils.getInstance(HoodieFileFormat.ORC);
    }

    @Override
    public String[] readMinMaxRecordKeys() {
        return this.orcUtils.readMinMaxRecordKeys(this.conf, this.path);
    }

    @Override
    public BloomFilter readBloomFilter() {
        return this.orcUtils.readBloomFilterFromMetadata(this.conf, this.path);
    }

    public Set<String> filterRowKeys(Set candidateRowKeys) {
        return this.orcUtils.filterRowKeys(this.conf, this.path, candidateRowKeys);
    }

    @Override
    public Iterator<R> getRecordIterator(Schema schema) throws IOException {
        try {
            Reader reader = OrcFile.createReader((Path)this.path, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf));
            TypeDescription orcSchema = AvroOrcUtils.createOrcSchema(schema);
            RecordReader recordReader = reader.rows(new Reader.Options(this.conf).schema(orcSchema));
            return new OrcReaderIterator(recordReader, schema, orcSchema);
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to create an ORC reader.", io);
        }
    }

    @Override
    public Schema getSchema() {
        return this.orcUtils.readAvroSchema(this.conf, this.path);
    }

    @Override
    public void close() {
    }

    @Override
    public long getTotalRecords() {
        return this.orcUtils.getRowCount(this.conf, this.path);
    }
}

