/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.HoodieTableMetadata;

public class HoodieMetadataFileSystemView
extends HoodieTableFileSystemView {
    private final HoodieTableMetadata tableMetadata;

    public HoodieMetadataFileSystemView(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline, HoodieTableMetadata tableMetadata) {
        super(metaClient, visibleActiveTimeline);
        this.tableMetadata = tableMetadata;
    }

    public HoodieMetadataFileSystemView(HoodieEngineContext engineContext, HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline, HoodieMetadataConfig metadataConfig) {
        super(metaClient, visibleActiveTimeline);
        this.tableMetadata = HoodieTableMetadata.create(engineContext, metadataConfig, metaClient.getBasePath(), FileSystemViewStorageConfig.SPILLABLE_DIR.defaultValue());
    }

    @Override
    protected FileStatus[] listPartition(Path partitionPath) throws IOException {
        return this.tableMetadata.getAllFilesInPartition(partitionPath);
    }

    @Override
    public void close() {
        try {
            this.tableMetadata.close();
        }
        catch (Exception e) {
            throw new HoodieException("Error closing metadata file system view.", e);
        }
    }
}

