/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SpillableMapUtils;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieMetadataMergedLogRecordReader
extends HoodieMergedLogRecordScanner {
    private static final Logger LOG = LogManager.getLogger(HoodieMetadataMergedLogRecordReader.class);
    private Set<String> mergeKeyFilter;

    private HoodieMetadataMergedLogRecordReader(FileSystem fs, String basePath, String partitionName, List<String> logFilePaths, Schema readerSchema, String latestInstantTime, Long maxMemorySizeInBytes, int bufferSize, String spillableMapBasePath, Set<String> mergeKeyFilter, ExternalSpillableMap.DiskMapType diskMapType, boolean isBitCaskDiskMapCompressionEnabled, Option<InstantRange> instantRange, boolean enableFullScan) {
        super(fs, basePath, logFilePaths, readerSchema, latestInstantTime, maxMemorySizeInBytes, false, false, bufferSize, spillableMapBasePath, instantRange, false, diskMapType, isBitCaskDiskMapCompressionEnabled, false, enableFullScan, Option.of(partitionName));
        this.mergeKeyFilter = mergeKeyFilter;
        if (enableFullScan) {
            this.performScan();
        }
    }

    @Override
    protected void processNextRecord(HoodieRecord<? extends HoodieRecordPayload> hoodieRecord) throws IOException {
        if (this.mergeKeyFilter.isEmpty() || this.mergeKeyFilter.contains(hoodieRecord.getRecordKey())) {
            super.processNextRecord(hoodieRecord);
        }
    }

    @Override
    protected void processNextDeletedKey(HoodieKey hoodieKey) {
        if (this.mergeKeyFilter.isEmpty() || this.mergeKeyFilter.contains(hoodieKey.getRecordKey())) {
            super.processNextDeletedKey(hoodieKey);
        }
    }

    @Override
    protected HoodieRecord<?> createHoodieRecord(IndexedRecord rec, HoodieTableConfig hoodieTableConfig, String payloadClassFQN, String preCombineField, boolean withOperationField, Option<Pair<String, String>> simpleKeyGenFields, Option<String> partitionName) {
        if (hoodieTableConfig.populateMetaFields()) {
            return super.createHoodieRecord(rec, hoodieTableConfig, payloadClassFQN, preCombineField, withOperationField, simpleKeyGenFields, partitionName);
        }
        return (HoodieRecord)SpillableMapUtils.convertToHoodieRecordPayload((GenericRecord)rec, payloadClassFQN, preCombineField, simpleKeyGenFields.get(), withOperationField, partitionName);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public List<Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>>> getRecordByKey(String key) {
        return Collections.singletonList(Pair.of(key, Option.ofNullable((HoodieRecord)this.records.get(key))));
    }

    public List<Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>>> getRecordsByKeys(List<String> keys) {
        this.records.clear();
        this.scan(Option.of(keys));
        ArrayList<Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>>> metadataRecords = new ArrayList<Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>>>();
        keys.forEach(entry -> {
            if (this.records.containsKey(entry)) {
                metadataRecords.add(Pair.of(entry, Option.ofNullable((HoodieRecord)this.records.get(entry))));
            } else {
                metadataRecords.add(Pair.of(entry, Option.empty()));
            }
        });
        return metadataRecords;
    }

    @Override
    protected String getKeyField() {
        return "key";
    }

    private static class ExplicitMatchRange
    extends InstantRange {
        Set<String> instants;

        public ExplicitMatchRange(Set<String> instants) {
            super(Collections.min(instants), Collections.max(instants));
            this.instants = instants;
        }

        @Override
        public boolean isInRange(String instant) {
            return this.instants.contains(instant);
        }
    }

    public static class Builder
    extends HoodieMergedLogRecordScanner.Builder {
        private Set<String> mergeKeyFilter = Collections.emptySet();
        private boolean enableFullScan = HoodieMetadataConfig.ENABLE_FULL_SCAN_LOG_FILES.defaultValue();
        private boolean enableInlineReading;

        @Override
        public Builder withFileSystem(FileSystem fs) {
            this.fs = fs;
            return this;
        }

        @Override
        public Builder withBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Override
        public Builder withLogFilePaths(List<String> logFilePaths) {
            this.logFilePaths = logFilePaths;
            return this;
        }

        @Override
        public Builder withReaderSchema(Schema schema) {
            this.readerSchema = schema;
            return this;
        }

        @Override
        public Builder withLatestInstantTime(String latestInstantTime) {
            this.latestInstantTime = latestInstantTime;
            return this;
        }

        @Override
        public Builder withReadBlocksLazily(boolean readBlocksLazily) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder withReverseReader(boolean reverseReader) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        @Override
        public Builder withPartition(String partitionName) {
            this.partitionName = partitionName;
            return this;
        }

        @Override
        public Builder withMaxMemorySizeInBytes(Long maxMemorySizeInBytes) {
            this.maxMemorySizeInBytes = maxMemorySizeInBytes;
            return this;
        }

        @Override
        public Builder withSpillableMapBasePath(String spillableMapBasePath) {
            this.spillableMapBasePath = spillableMapBasePath;
            return this;
        }

        @Override
        public Builder withDiskMapType(ExternalSpillableMap.DiskMapType diskMapType) {
            this.diskMapType = diskMapType;
            return this;
        }

        @Override
        public Builder withBitCaskDiskMapCompressionEnabled(boolean isBitCaskDiskMapCompressionEnabled) {
            this.isBitCaskDiskMapCompressionEnabled = isBitCaskDiskMapCompressionEnabled;
            return this;
        }

        public Builder withMergeKeyFilter(Set<String> mergeKeyFilter) {
            this.mergeKeyFilter = mergeKeyFilter;
            return this;
        }

        public Builder withLogBlockTimestamps(Set<String> validLogBlockTimestamps) {
            this.withInstantRange(Option.of(new ExplicitMatchRange(validLogBlockTimestamps)));
            return this;
        }

        public Builder enableFullScan(boolean enableFullScan) {
            this.enableFullScan = enableFullScan;
            return this;
        }

        @Override
        public HoodieMetadataMergedLogRecordReader build() {
            return new HoodieMetadataMergedLogRecordReader(this.fs, this.basePath, this.partitionName, this.logFilePaths, this.readerSchema, this.latestInstantTime, this.maxMemorySizeInBytes, this.bufferSize, this.spillableMapBasePath, this.mergeKeyFilter, this.diskMapType, this.isBitCaskDiskMapCompressionEnabled, this.instantRange, this.enableFullScan);
        }
    }
}

