/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.com.google.common.collect.Lists;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class ConfigurationUtil {
    public static final char KVP_DELIMITER = '^';

    private ConfigurationUtil() {
    }

    public static void setKeyValues(Configuration conf, String key, Collection<Map.Entry<String, String>> keyValues) {
        ConfigurationUtil.setKeyValues(conf, key, keyValues, '^');
    }

    public static void setKeyValues(Configuration conf, String key, Collection<Map.Entry<String, String>> keyValues, char delimiter) {
        ArrayList<String> serializedKvps = Lists.newArrayList();
        for (Map.Entry<String, String> kvp : keyValues) {
            serializedKvps.add(kvp.getKey() + delimiter + kvp.getValue());
        }
        conf.setStrings(key, serializedKvps.toArray(new String[serializedKvps.size()]));
    }

    public static List<Map.Entry<String, String>> getKeyValues(Configuration conf, String key) {
        return ConfigurationUtil.getKeyValues(conf, key, '^');
    }

    public static List<Map.Entry<String, String>> getKeyValues(Configuration conf, String key, char delimiter) {
        String[] kvps = conf.getStrings(key);
        if (kvps == null) {
            return null;
        }
        ArrayList<Map.Entry<String, String>> rtn = Lists.newArrayList();
        for (String kvp : kvps) {
            String[] splitKvp = StringUtils.split((String)kvp, (char)delimiter);
            if (splitKvp.length != 2) {
                throw new IllegalArgumentException("Expected key value pair for configuration key '" + key + "'" + " to be of form '<key>" + delimiter + "<value>; was " + kvp + " instead");
            }
            rtn.add(new AbstractMap.SimpleImmutableEntry<String, String>(splitKvp[0], splitKvp[1]));
        }
        return rtn;
    }
}

