/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.hudi.common.config.SerializableSchema;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.SchemaCompatibilityException;
import org.apache.hudi.org.apache.avro.Conversions;
import org.apache.hudi.org.apache.avro.JsonProperties;
import org.apache.hudi.org.apache.avro.LogicalTypes;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericData;
import org.apache.hudi.org.apache.avro.generic.GenericDatumReader;
import org.apache.hudi.org.apache.avro.generic.GenericDatumWriter;
import org.apache.hudi.org.apache.avro.generic.GenericFixed;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.org.apache.avro.io.BinaryDecoder;
import org.apache.hudi.org.apache.avro.io.BinaryEncoder;
import org.apache.hudi.org.apache.avro.io.DecoderFactory;
import org.apache.hudi.org.apache.avro.io.EncoderFactory;
import org.apache.hudi.org.apache.avro.io.JsonDecoder;
import org.apache.hudi.org.apache.avro.io.JsonEncoder;
import org.apache.hudi.org.apache.avro.specific.SpecificRecordBase;

public class HoodieAvroUtils {
    private static ThreadLocal<BinaryEncoder> reuseEncoder = ThreadLocal.withInitial(() -> null);
    private static ThreadLocal<BinaryDecoder> reuseDecoder = ThreadLocal.withInitial(() -> null);
    private static String INVALID_AVRO_CHARS_IN_NAMES = "[^A-Za-z0-9_]";
    private static String INVALID_AVRO_FIRST_CHAR_IN_NAMES = "[^A-Za-z_]";
    private static String MASK_FOR_INVALID_CHARS_IN_NAMES = "__";
    public static final Schema METADATA_FIELD_SCHEMA = Schema.createUnion(Arrays.asList(Schema.create(Schema.Type.NULL), Schema.create(Schema.Type.STRING)));
    public static final Schema RECORD_KEY_SCHEMA = HoodieAvroUtils.initRecordKeySchema();

    public static byte[] avroToBytes(GenericRecord record) {
        return HoodieAvroUtils.indexedRecordToBytes(record);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends IndexedRecord> byte[] indexedRecordToBytes(T record) {
        GenericDatumWriter<T> writer = new GenericDatumWriter<T>(record.getSchema());
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder(out, reuseEncoder.get());
            reuseEncoder.set(encoder);
            writer.write(record, encoder);
            encoder.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new HoodieIOException("Cannot convert GenericRecord to bytes", e);
        }
    }

    public static byte[] avroToJson(GenericRecord record, boolean pretty) throws IOException {
        GenericDatumWriter<GenericRecord> writer = new GenericDatumWriter<GenericRecord>(record.getSchema());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonEncoder jsonEncoder = EncoderFactory.get().jsonEncoder(record.getSchema(), out, pretty);
        writer.write(record, jsonEncoder);
        jsonEncoder.flush();
        return out.toByteArray();
    }

    public static GenericRecord bytesToAvro(byte[] bytes, Schema schema) throws IOException {
        return HoodieAvroUtils.bytesToAvro(bytes, schema, schema);
    }

    public static GenericRecord bytesToAvro(byte[] bytes, Schema writerSchema, Schema readerSchema) throws IOException {
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(bytes, reuseDecoder.get());
        reuseDecoder.set(decoder);
        GenericDatumReader<Object> reader = new GenericDatumReader<Object>(writerSchema, readerSchema);
        return reader.read(null, decoder);
    }

    public static GenericRecord jsonBytesToAvro(byte[] bytes, Schema schema) throws IOException {
        ByteArrayInputStream bio = new ByteArrayInputStream(bytes);
        JsonDecoder jsonDecoder = DecoderFactory.get().jsonDecoder(schema, bio);
        GenericDatumReader<Object> reader = new GenericDatumReader<Object>(schema);
        return reader.read(null, jsonDecoder);
    }

    public static boolean isMetadataField(String fieldName) {
        return "_hoodie_commit_time".equals(fieldName) || "_hoodie_commit_seqno".equals(fieldName) || "_hoodie_record_key".equals(fieldName) || "_hoodie_partition_path".equals(fieldName) || "_hoodie_file_name".equals(fieldName) || "_hoodie_operation".equals(fieldName);
    }

    public static Schema createHoodieWriteSchema(Schema originalSchema) {
        return HoodieAvroUtils.addMetadataFields(originalSchema);
    }

    public static Schema createHoodieWriteSchema(String originalSchema) {
        return HoodieAvroUtils.createHoodieWriteSchema(new Schema.Parser().parse(originalSchema));
    }

    public static Schema addMetadataFields(Schema schema) {
        return HoodieAvroUtils.addMetadataFields(schema, false);
    }

    public static Schema addMetadataFields(Schema schema, boolean withOperationField) {
        ArrayList<Schema.Field> parentFields = new ArrayList<Schema.Field>();
        Schema.Field commitTimeField = new Schema.Field("_hoodie_commit_time", METADATA_FIELD_SCHEMA, "", JsonProperties.NULL_VALUE);
        Schema.Field commitSeqnoField = new Schema.Field("_hoodie_commit_seqno", METADATA_FIELD_SCHEMA, "", JsonProperties.NULL_VALUE);
        Schema.Field recordKeyField = new Schema.Field("_hoodie_record_key", METADATA_FIELD_SCHEMA, "", JsonProperties.NULL_VALUE);
        Schema.Field partitionPathField = new Schema.Field("_hoodie_partition_path", METADATA_FIELD_SCHEMA, "", JsonProperties.NULL_VALUE);
        Schema.Field fileNameField = new Schema.Field("_hoodie_file_name", METADATA_FIELD_SCHEMA, "", JsonProperties.NULL_VALUE);
        parentFields.add(commitTimeField);
        parentFields.add(commitSeqnoField);
        parentFields.add(recordKeyField);
        parentFields.add(partitionPathField);
        parentFields.add(fileNameField);
        if (withOperationField) {
            Schema.Field operationField = new Schema.Field("_hoodie_operation", METADATA_FIELD_SCHEMA, "", JsonProperties.NULL_VALUE);
            parentFields.add(operationField);
        }
        for (Schema.Field field : schema.getFields()) {
            if (HoodieAvroUtils.isMetadataField(field.name())) continue;
            Schema.Field newField = new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal());
            for (Map.Entry<String, Object> prop : field.getObjectProps().entrySet()) {
                newField.addProp(prop.getKey(), prop.getValue());
            }
            parentFields.add(newField);
        }
        Schema mergedSchema = Schema.createRecord(schema.getName(), schema.getDoc(), schema.getNamespace(), false);
        mergedSchema.setFields(parentFields);
        return mergedSchema;
    }

    public static Schema removeMetadataFields(Schema schema) {
        return HoodieAvroUtils.removeFields(schema, HoodieRecord.HOODIE_META_COLUMNS_WITH_OPERATION);
    }

    public static Schema removeFields(Schema schema, List<String> fieldsToRemove) {
        List<Schema.Field> filteredFields = schema.getFields().stream().filter(field -> !fieldsToRemove.contains(field.name())).map(field -> new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal())).collect(Collectors.toList());
        Schema filteredSchema = Schema.createRecord(schema.getName(), schema.getDoc(), schema.getNamespace(), false);
        filteredSchema.setFields(filteredFields);
        return filteredSchema;
    }

    public static String addMetadataColumnTypes(String hiveColumnTypes) {
        return "string,string,string,string,string," + hiveColumnTypes;
    }

    private static Schema initRecordKeySchema() {
        Schema.Field recordKeyField = new Schema.Field("_hoodie_record_key", METADATA_FIELD_SCHEMA, "", JsonProperties.NULL_VALUE);
        Schema recordKeySchema = Schema.createRecord("HoodieRecordKey", "", "", false);
        recordKeySchema.setFields(Collections.singletonList(recordKeyField));
        return recordKeySchema;
    }

    public static Schema getRecordKeySchema() {
        return RECORD_KEY_SCHEMA;
    }

    public static Schema getRecordKeyPartitionPathSchema() {
        ArrayList<Schema.Field> toBeAddedFields = new ArrayList<Schema.Field>();
        Schema recordSchema = Schema.createRecord("HoodieRecordKey", "", "", false);
        Schema.Field recordKeyField = new Schema.Field("_hoodie_record_key", METADATA_FIELD_SCHEMA, "", JsonProperties.NULL_VALUE);
        Schema.Field partitionPathField = new Schema.Field("_hoodie_partition_path", METADATA_FIELD_SCHEMA, "", JsonProperties.NULL_VALUE);
        toBeAddedFields.add(recordKeyField);
        toBeAddedFields.add(partitionPathField);
        recordSchema.setFields(toBeAddedFields);
        return recordSchema;
    }

    public static Schema getSchemaForFields(Schema fileSchema, List<String> fields) {
        ArrayList<Schema.Field> toBeAddedFields = new ArrayList<Schema.Field>();
        Schema recordSchema = Schema.createRecord("HoodieRecordKey", "", "", false);
        for (Schema.Field schemaField : fileSchema.getFields()) {
            if (!fields.contains(schemaField.name())) continue;
            toBeAddedFields.add(new Schema.Field(schemaField.name(), schemaField.schema(), schemaField.doc(), schemaField.defaultValue()));
        }
        recordSchema.setFields(toBeAddedFields);
        return recordSchema;
    }

    public static GenericRecord addHoodieKeyToRecord(GenericRecord record, String recordKey, String partitionPath, String fileName) {
        record.put("_hoodie_file_name", (Object)fileName);
        record.put("_hoodie_partition_path", (Object)partitionPath);
        record.put("_hoodie_record_key", (Object)recordKey);
        return record;
    }

    public static GenericRecord addOperationToRecord(GenericRecord record, HoodieOperation operation) {
        record.put("_hoodie_operation", (Object)operation.getName());
        return record;
    }

    public static Schema appendNullSchemaFields(Schema schema, List<String> newFieldNames) {
        List<Schema.Field> newFields = schema.getFields().stream().map(field -> new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal())).collect(Collectors.toList());
        for (String newField : newFieldNames) {
            newFields.add(new Schema.Field(newField, METADATA_FIELD_SCHEMA, "", JsonProperties.NULL_VALUE));
        }
        Schema newSchema = Schema.createRecord(schema.getName(), schema.getDoc(), schema.getNamespace(), schema.isError());
        newSchema.setFields(newFields);
        return newSchema;
    }

    public static GenericRecord addCommitMetadataToRecord(GenericRecord record, String instantTime, String commitSeqno) {
        record.put("_hoodie_commit_time", (Object)instantTime);
        record.put("_hoodie_commit_seqno", (Object)commitSeqno);
        return record;
    }

    public static GenericRecord stitchRecords(GenericRecord left, GenericRecord right, Schema stitchedSchema) {
        GenericData.Record result = new GenericData.Record(stitchedSchema);
        for (Schema.Field f : left.getSchema().getFields()) {
            result.put(f.name(), left.get(f.name()));
        }
        for (Schema.Field f : right.getSchema().getFields()) {
            result.put(f.name(), right.get(f.name()));
        }
        return result;
    }

    public static GenericRecord rewriteRecord(GenericRecord oldRecord, Schema newSchema) {
        GenericData.Record newRecord = new GenericData.Record(newSchema);
        boolean isSpecificRecord = oldRecord instanceof SpecificRecordBase;
        for (Schema.Field f : newSchema.getFields()) {
            if (!isSpecificRecord) {
                HoodieAvroUtils.copyOldValueOrSetDefault(oldRecord, newRecord, f);
                continue;
            }
            if (HoodieAvroUtils.isMetadataField(f.name())) continue;
            HoodieAvroUtils.copyOldValueOrSetDefault(oldRecord, newRecord, f);
        }
        if (!GenericData.get().validate(newSchema, newRecord)) {
            throw new SchemaCompatibilityException("Unable to validate the rewritten record " + oldRecord + " against schema " + newSchema);
        }
        return newRecord;
    }

    private static void copyOldValueOrSetDefault(GenericRecord oldRecord, GenericRecord newRecord, Schema.Field f) {
        Object fieldValue;
        Schema oldSchema = oldRecord.getSchema();
        Object object = fieldValue = oldSchema.getField(f.name()) == null ? null : oldRecord.get(f.name());
        if (fieldValue == null) {
            if (f.defaultVal() instanceof JsonProperties.Null) {
                newRecord.put(f.name(), null);
            } else {
                newRecord.put(f.name(), f.defaultVal());
            }
        } else {
            newRecord.put(f.name(), fieldValue);
        }
    }

    public static byte[] compress(String text) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DeflaterOutputStream out = new DeflaterOutputStream(baos);
            ((OutputStream)out).write(text.getBytes(StandardCharsets.UTF_8));
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            throw new HoodieIOException("IOException while compressing text " + text, e);
        }
        return baos.toByteArray();
    }

    public static String decompress(byte[] bytes) {
        InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(bytes));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buffer = new byte[8192];
            while ((len = ((InputStream)in).read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            return new String(baos.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new HoodieIOException("IOException while decompressing text", e);
        }
    }

    public static Schema generateProjectionSchema(Schema originalSchema, List<String> fieldNames) {
        Map<String, Schema.Field> schemaFieldsMap = originalSchema.getFields().stream().map(r -> Pair.of(r.name().toLowerCase(), r)).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        ArrayList<Schema.Field> projectedFields = new ArrayList<Schema.Field>();
        for (String fn : fieldNames) {
            Schema.Field field = schemaFieldsMap.get(fn.toLowerCase());
            if (field == null) {
                throw new HoodieException("Field " + fn + " not found in log schema. Query cannot proceed! Derived Schema Fields: " + new ArrayList<String>(schemaFieldsMap.keySet()));
            }
            projectedFields.add(new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal()));
        }
        Schema projectedSchema = Schema.createRecord(originalSchema.getName(), originalSchema.getDoc(), originalSchema.getNamespace(), originalSchema.isError());
        projectedSchema.setFields(projectedFields);
        return projectedSchema;
    }

    public static String getNestedFieldValAsString(GenericRecord record, String fieldName, boolean returnNullIfNotFound, boolean consistentLogicalTimestampEnabled) {
        Object obj = HoodieAvroUtils.getNestedFieldVal(record, fieldName, returnNullIfNotFound, consistentLogicalTimestampEnabled);
        return StringUtils.objToString(obj);
    }

    public static Object getNestedFieldVal(GenericRecord record, String fieldName, boolean returnNullIfNotFound, boolean consistentLogicalTimestampEnabled) {
        String part;
        Object val;
        int i;
        String[] parts = fieldName.split("\\.");
        GenericRecord valueNode = record;
        for (i = 0; i < parts.length && (val = valueNode.get(part = parts[i])) != null; ++i) {
            if (i == parts.length - 1) {
                Schema fieldSchema = valueNode.getSchema().getField(part).schema();
                return HoodieAvroUtils.convertValueForSpecificDataTypes(fieldSchema, val, consistentLogicalTimestampEnabled);
            }
            if (!(val instanceof GenericRecord)) {
                throw new HoodieException("Cannot find a record at part value :" + part);
            }
            valueNode = (GenericRecord)val;
        }
        if (returnNullIfNotFound) {
            return null;
        }
        if (valueNode.getSchema().getField(parts[i]) == null) {
            throw new HoodieException(fieldName + "(Part -" + parts[i] + ") field not found in record. Acceptable fields were :" + valueNode.getSchema().getFields().stream().map(Schema.Field::name).collect(Collectors.toList()));
        }
        throw new HoodieException("The value of " + parts[i] + " can not be null");
    }

    public static Option<String> getNullableValAsString(GenericRecord rec, String fieldName) {
        Schema.Field field = rec.getSchema().getField(fieldName);
        String fieldVal = field == null ? null : StringUtils.objToString(rec.get(field.pos()));
        return Option.ofNullable(fieldVal);
    }

    public static Object convertValueForSpecificDataTypes(Schema fieldSchema, Object fieldValue, boolean consistentLogicalTimestampEnabled) {
        if (fieldSchema == null) {
            return fieldValue;
        }
        if (fieldSchema.getType() == Schema.Type.UNION) {
            for (Schema schema : fieldSchema.getTypes()) {
                if (schema.getType() == Schema.Type.NULL) continue;
                return HoodieAvroUtils.convertValueForAvroLogicalTypes(schema, fieldValue, consistentLogicalTimestampEnabled);
            }
        }
        return HoodieAvroUtils.convertValueForAvroLogicalTypes(fieldSchema, fieldValue, consistentLogicalTimestampEnabled);
    }

    private static Object convertValueForAvroLogicalTypes(Schema fieldSchema, Object fieldValue, boolean consistentLogicalTimestampEnabled) {
        if (fieldSchema.getLogicalType() == LogicalTypes.date()) {
            return LocalDate.ofEpochDay(Long.parseLong(fieldValue.toString()));
        }
        if (fieldSchema.getLogicalType() == LogicalTypes.timestampMillis() && consistentLogicalTimestampEnabled) {
            return new Timestamp(Long.parseLong(fieldValue.toString()));
        }
        if (fieldSchema.getLogicalType() == LogicalTypes.timestampMicros() && consistentLogicalTimestampEnabled) {
            return new Timestamp(Long.parseLong(fieldValue.toString()) / 1000L);
        }
        if (fieldSchema.getLogicalType() instanceof LogicalTypes.Decimal) {
            LogicalTypes.Decimal dc = (LogicalTypes.Decimal)fieldSchema.getLogicalType();
            Conversions.DecimalConversion decimalConversion = new Conversions.DecimalConversion();
            if (fieldSchema.getType() == Schema.Type.FIXED) {
                return decimalConversion.fromFixed((GenericFixed)fieldValue, fieldSchema, LogicalTypes.decimal(dc.getPrecision(), dc.getScale()));
            }
            if (fieldSchema.getType() == Schema.Type.BYTES) {
                ByteBuffer byteBuffer = (ByteBuffer)fieldValue;
                BigDecimal convertedValue = decimalConversion.fromBytes(byteBuffer, fieldSchema, LogicalTypes.decimal(dc.getPrecision(), dc.getScale()));
                byteBuffer.rewind();
                return convertedValue;
            }
        }
        return fieldValue;
    }

    public static Schema getNullSchema() {
        return Schema.create(Schema.Type.NULL);
    }

    public static String sanitizeName(String name) {
        if (name.substring(0, 1).matches(INVALID_AVRO_FIRST_CHAR_IN_NAMES)) {
            name = name.replaceFirst(INVALID_AVRO_FIRST_CHAR_IN_NAMES, MASK_FOR_INVALID_CHARS_IN_NAMES);
        }
        return name.replaceAll(INVALID_AVRO_CHARS_IN_NAMES, MASK_FOR_INVALID_CHARS_IN_NAMES);
    }

    public static Object getRecordColumnValues(HoodieRecord<? extends HoodieRecordPayload> record, String[] columns, Schema schema, boolean consistentLogicalTimestampEnabled) {
        try {
            GenericRecord genericRecord = (GenericRecord)record.getData().getInsertValue(schema).get();
            if (columns.length == 1) {
                return HoodieAvroUtils.getNestedFieldVal(genericRecord, columns[0], true, consistentLogicalTimestampEnabled);
            }
            StringBuilder sb = new StringBuilder();
            for (String col : columns) {
                sb.append(HoodieAvroUtils.getNestedFieldValAsString(genericRecord, col, true, consistentLogicalTimestampEnabled));
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new HoodieIOException("Unable to read record with key:" + record.getKey(), e);
        }
    }

    public static Object getRecordColumnValues(HoodieRecord<? extends HoodieRecordPayload> record, String[] columns, SerializableSchema schema, boolean consistentLogicalTimestampEnabled) {
        return HoodieAvroUtils.getRecordColumnValues(record, columns, schema.get(), consistentLogicalTimestampEnabled);
    }
}

