/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DFSPropertiesConfiguration {
    private static final Logger LOG = LogManager.getLogger(DFSPropertiesConfiguration.class);
    public static final String DEFAULT_PROPERTIES_FILE = "hudi-defaults.conf";
    public static final String CONF_FILE_DIR_ENV_NAME = "HUDI_CONF_DIR";
    public static final String DEFAULT_CONF_FILE_DIR = "file:/etc/hudi/conf";
    public static final Path DEFAULT_PATH = new Path("file:/etc/hudi/conf/hudi-defaults.conf");
    private static TypedProperties GLOBAL_PROPS = DFSPropertiesConfiguration.loadGlobalProps();
    @Nullable
    private final Configuration hadoopConfig;
    private Path currentFilePath;
    private final HoodieConfig hoodieConfig;
    private final Set<String> visitedFilePaths;

    public DFSPropertiesConfiguration(@Nonnull Configuration hadoopConf, @Nonnull Path filePath) {
        this.hadoopConfig = hadoopConf;
        this.currentFilePath = filePath;
        this.hoodieConfig = new HoodieConfig();
        this.visitedFilePaths = new HashSet<String>();
        this.addPropsFromFile(filePath);
    }

    public DFSPropertiesConfiguration() {
        this.hadoopConfig = null;
        this.currentFilePath = null;
        this.hoodieConfig = new HoodieConfig();
        this.visitedFilePaths = new HashSet<String>();
    }

    public static TypedProperties loadGlobalProps() {
        DFSPropertiesConfiguration conf = new DFSPropertiesConfiguration();
        Option<Path> defaultConfPath = DFSPropertiesConfiguration.getConfPathFromEnv();
        if (defaultConfPath.isPresent()) {
            conf.addPropsFromFile(defaultConfPath.get());
        } else {
            conf.addPropsFromFile(DEFAULT_PATH);
        }
        return conf.getProps();
    }

    public static void refreshGlobalProps() {
        GLOBAL_PROPS = DFSPropertiesConfiguration.loadGlobalProps();
    }

    public static void clearGlobalProps() {
        GLOBAL_PROPS = new TypedProperties();
    }

    public void addPropsFromFile(Path filePath) {
        if (this.visitedFilePaths.contains(filePath.toString())) {
            throw new IllegalStateException("Loop detected; file " + filePath + " already referenced");
        }
        FileSystem fs = FSUtils.getFs(filePath.toString(), Option.ofNullable(this.hadoopConfig).orElseGet(Configuration::new));
        try {
            if (filePath.equals((Object)DEFAULT_PATH) && !fs.exists(filePath)) {
                LOG.warn((Object)("Properties file " + filePath + " not found. Ignoring to load props file"));
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fs.open(filePath)));
            this.visitedFilePaths.add(filePath.toString());
            this.currentFilePath = filePath;
            this.addPropsFromStream(reader);
        }
        catch (IOException ioe) {
            LOG.error((Object)("Error reading in properties from dfs from file " + filePath));
            throw new HoodieIOException("Cannot read properties from dfs from file " + filePath, ioe);
        }
    }

    public void addPropsFromStream(BufferedReader reader) throws IOException {
        try {
            reader.lines().forEach(line -> {
                if (!this.isValidLine((String)line)) {
                    return;
                }
                String[] split = this.splitProperty((String)line);
                if (line.startsWith("include=") || line.startsWith("include =")) {
                    Path includeFilePath = new Path(this.currentFilePath.getParent(), split[1]);
                    this.addPropsFromFile(includeFilePath);
                } else {
                    this.hoodieConfig.setValue(split[0], split[1]);
                }
            });
        }
        finally {
            reader.close();
        }
    }

    public static TypedProperties getGlobalProps() {
        TypedProperties globalProps = new TypedProperties();
        globalProps.putAll((Map<?, ?>)GLOBAL_PROPS);
        return globalProps;
    }

    public TypedProperties getProps() {
        return new TypedProperties(this.hoodieConfig.getProps());
    }

    public TypedProperties getProps(boolean includeGlobalProps) {
        return new TypedProperties(this.hoodieConfig.getProps(includeGlobalProps));
    }

    private static Option<Path> getConfPathFromEnv() {
        String confDir = System.getenv(CONF_FILE_DIR_ENV_NAME);
        if (confDir == null) {
            LOG.warn((Object)"Cannot find HUDI_CONF_DIR, please set it as the dir of hudi-defaults.conf");
            return Option.empty();
        }
        if (StringUtils.isNullOrEmpty(URI.create(confDir).getScheme())) {
            confDir = "file://" + confDir;
        }
        return Option.of(new Path(confDir + File.separator + DEFAULT_PROPERTIES_FILE));
    }

    private String[] splitProperty(String line) {
        String delimiter = (line = line.replaceAll("\\s+", " ")).contains("=") ? "=" : " ";
        int ind = line.indexOf(delimiter);
        String k = line.substring(0, ind).trim();
        String v = line.substring(ind + 1).trim();
        return new String[]{k, v};
    }

    private boolean isValidLine(String line) {
        ValidationUtils.checkArgument(line != null, "passed line is null");
        if (line.startsWith("#") || line.equals("")) {
            return false;
        }
        return line.contains("=") || line.matches(".*\\s.*");
    }
}

