/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.util.Objects;
import org.apache.parquet.schema.PrimitiveStringifier;

public class HoodieColumnRangeMetadata<T> {
    private final String filePath;
    private final String columnName;
    private final T minValue;
    private final T maxValue;
    private final long numNulls;
    private final PrimitiveStringifier stringifier;

    public HoodieColumnRangeMetadata(String filePath, String columnName, T minValue, T maxValue, long numNulls, PrimitiveStringifier stringifier) {
        this.filePath = filePath;
        this.columnName = columnName;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.numNulls = numNulls;
        this.stringifier = stringifier;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public T getMinValue() {
        return this.minValue;
    }

    public T getMaxValue() {
        return this.maxValue;
    }

    public PrimitiveStringifier getStringifier() {
        return this.stringifier;
    }

    public long getNumNulls() {
        return this.numNulls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieColumnRangeMetadata that = (HoodieColumnRangeMetadata)o;
        return Objects.equals(this.getFilePath(), that.getFilePath()) && Objects.equals(this.getColumnName(), that.getColumnName()) && Objects.equals(this.getMinValue(), that.getMinValue()) && Objects.equals(this.getMaxValue(), that.getMaxValue()) && Objects.equals(this.getNumNulls(), that.getNumNulls());
    }

    public int hashCode() {
        return Objects.hash(this.getColumnName(), this.getMinValue(), this.getMaxValue(), this.getNumNulls());
    }

    public String toString() {
        return "HoodieColumnRangeMetadata{filePath ='" + this.filePath + '\'' + "columnName='" + this.columnName + '\'' + ", minValue=" + this.minValue + ", maxValue=" + this.maxValue + ", numNulls=" + this.numNulls + '}';
    }
}

