/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.fs.SizeAwareDataInputStream;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlockVersion;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericDatumReader;
import org.apache.hudi.org.apache.avro.generic.GenericDatumWriter;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.org.apache.avro.io.BinaryDecoder;
import org.apache.hudi.org.apache.avro.io.BinaryEncoder;
import org.apache.hudi.org.apache.avro.io.DecoderFactory;
import org.apache.hudi.org.apache.avro.io.EncoderFactory;

public class HoodieAvroDataBlock
extends HoodieDataBlock {
    private ThreadLocal<BinaryEncoder> encoderCache = new ThreadLocal();
    private ThreadLocal<BinaryDecoder> decoderCache = new ThreadLocal();

    public HoodieAvroDataBlock(@Nonnull Map<HoodieLogBlock.HeaderMetadataType, String> logBlockHeader, @Nonnull Map<HoodieLogBlock.HeaderMetadataType, String> logBlockFooter, @Nonnull Option<HoodieLogBlock.HoodieLogBlockContentLocation> blockContentLocation, @Nonnull Option<byte[]> content, FSDataInputStream inputStream, boolean readBlockLazily) {
        super(logBlockHeader, logBlockFooter, blockContentLocation, content, inputStream, readBlockLazily);
    }

    public HoodieAvroDataBlock(HoodieLogFile logFile, FSDataInputStream inputStream, Option<byte[]> content, boolean readBlockLazily, long position, long blockSize, long blockEndpos, Schema readerSchema, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.HeaderMetadataType, String> footer, String keyField) {
        super(content, inputStream, readBlockLazily, Option.of(new HoodieLogBlock.HoodieLogBlockContentLocation(logFile, position, blockSize, blockEndpos)), readerSchema, header, footer, keyField);
    }

    public HoodieAvroDataBlock(@Nonnull List<IndexedRecord> records, @Nonnull Map<HoodieLogBlock.HeaderMetadataType, String> header, String keyField) {
        super(records, header, new HashMap<HoodieLogBlock.HeaderMetadataType, String>(), keyField);
    }

    public HoodieAvroDataBlock(@Nonnull List<IndexedRecord> records, @Nonnull Map<HoodieLogBlock.HeaderMetadataType, String> header) {
        super(records, header, new HashMap<HoodieLogBlock.HeaderMetadataType, String>(), "_hoodie_record_key");
    }

    @Override
    public HoodieLogBlock.HoodieLogBlockType getBlockType() {
        return HoodieLogBlock.HoodieLogBlockType.AVRO_DATA_BLOCK;
    }

    @Override
    protected byte[] serializeRecords() throws IOException {
        Schema schema = new Schema.Parser().parse(super.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
        GenericDatumWriter<IndexedRecord> writer = new GenericDatumWriter<IndexedRecord>(schema);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(baos);
        output.writeInt(HoodieLogBlock.version);
        output.writeInt(this.records.size());
        Iterator itr = this.records.iterator();
        while (itr.hasNext()) {
            IndexedRecord s = (IndexedRecord)itr.next();
            ByteArrayOutputStream temp = new ByteArrayOutputStream();
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder(temp, this.encoderCache.get());
            this.encoderCache.set(encoder);
            try {
                writer.write(s, encoder);
                encoder.flush();
                int size = temp.toByteArray().length;
                output.writeInt(size);
                output.write(temp.toByteArray());
                itr.remove();
            }
            catch (IOException e) {
                throw new HoodieIOException("IOException converting HoodieAvroDataBlock to bytes", e);
            }
        }
        output.close();
        return baos.toByteArray();
    }

    @Override
    protected void deserializeRecords() throws IOException {
        SizeAwareDataInputStream dis = new SizeAwareDataInputStream(new DataInputStream(new ByteArrayInputStream(this.getContent().get())));
        int version = dis.readInt();
        HoodieAvroDataBlockVersion logBlockVersion = new HoodieAvroDataBlockVersion(version);
        Schema writerSchema = new Schema.Parser().parse(super.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
        if (this.schema == null) {
            this.schema = writerSchema;
        }
        GenericDatumReader<Object> reader = new GenericDatumReader<Object>(writerSchema, this.schema);
        int totalRecords = 0;
        if (logBlockVersion.hasRecordCount()) {
            totalRecords = dis.readInt();
        }
        ArrayList<IndexedRecord> records = new ArrayList<IndexedRecord>(totalRecords);
        for (int i = 0; i < totalRecords; ++i) {
            int recordLength = dis.readInt();
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(this.getContent().get(), dis.getNumberOfBytesRead(), recordLength, this.decoderCache.get());
            this.decoderCache.set(decoder);
            IndexedRecord record = reader.read(null, decoder);
            records.add(record);
            dis.skipBytes(recordLength);
        }
        dis.close();
        this.records = records;
        this.deflate();
    }

    @Deprecated
    public HoodieAvroDataBlock(List<IndexedRecord> records, Schema schema) {
        super(new HashMap<HoodieLogBlock.HeaderMetadataType, String>(), new HashMap<HoodieLogBlock.HeaderMetadataType, String>(), Option.empty(), Option.empty(), null, false);
        this.records = records;
        this.schema = schema;
    }

    @Deprecated
    public static HoodieAvroDataBlock getBlock(byte[] content, Schema readerSchema) throws IOException {
        SizeAwareDataInputStream dis = new SizeAwareDataInputStream(new DataInputStream(new ByteArrayInputStream(content)));
        int schemaLength = dis.readInt();
        byte[] compressedSchema = new byte[schemaLength];
        dis.readFully(compressedSchema, 0, schemaLength);
        Schema writerSchema = new Schema.Parser().parse(HoodieAvroUtils.decompress(compressedSchema));
        if (readerSchema == null) {
            readerSchema = writerSchema;
        }
        GenericDatumReader<Object> reader = new GenericDatumReader<Object>(writerSchema, readerSchema);
        int totalRecords = dis.readInt();
        ArrayList<IndexedRecord> records = new ArrayList<IndexedRecord>(totalRecords);
        for (int i = 0; i < totalRecords; ++i) {
            int recordLength = dis.readInt();
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(content, dis.getNumberOfBytesRead(), recordLength, null);
            IndexedRecord record = reader.read(null, decoder);
            records.add(record);
            dis.skipBytes(recordLength);
        }
        dis.close();
        return new HoodieAvroDataBlock(records, readerSchema);
    }

    @Deprecated
    public byte[] getBytes(Schema schema) throws IOException {
        GenericDatumWriter<IndexedRecord> writer = new GenericDatumWriter<IndexedRecord>(schema);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(baos);
        byte[] schemaContent = HoodieAvroUtils.compress(schema.toString());
        output.writeInt(schemaContent.length);
        output.write(schemaContent);
        output.writeInt(this.records.size());
        Iterator itr = this.records.iterator();
        while (itr.hasNext()) {
            IndexedRecord s = (IndexedRecord)itr.next();
            ByteArrayOutputStream temp = new ByteArrayOutputStream();
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder(temp, null);
            try {
                writer.write(s, encoder);
                encoder.flush();
                int size = temp.toByteArray().length;
                output.writeInt(size);
                output.write(temp.toByteArray());
                itr.remove();
            }
            catch (IOException e) {
                throw new HoodieIOException("IOException converting HoodieAvroDataBlock to bytes", e);
            }
        }
        output.close();
        return baos.toByteArray();
    }
}

