/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;

public class HoodieDefaultTimeline
implements HoodieTimeline {
    private static final long serialVersionUID = 1L;
    private static final String HASHING_ALGORITHM = "SHA-256";
    protected transient Function<HoodieInstant, Option<byte[]>> details;
    private List<HoodieInstant> instants;
    private String timelineHash;

    public HoodieDefaultTimeline(Stream<HoodieInstant> instants, Function<HoodieInstant, Option<byte[]>> details) {
        this.details = details;
        this.setInstants(instants.collect(Collectors.toList()));
    }

    public void setInstants(List<HoodieInstant> instants) {
        MessageDigest md;
        this.instants = instants;
        try {
            md = MessageDigest.getInstance(HASHING_ALGORITHM);
            this.instants.forEach(i -> md.update(StringUtils.joinUsingDelim("_", i.getTimestamp(), i.getAction(), i.getState().name()).getBytes()));
        }
        catch (NoSuchAlgorithmException nse) {
            throw new HoodieException(nse);
        }
        this.timelineHash = StringUtils.toHexString(md.digest());
    }

    public HoodieDefaultTimeline() {
    }

    @Override
    public HoodieTimeline filterInflights() {
        return new HoodieDefaultTimeline(this.instants.stream().filter(HoodieInstant::isInflight), this.details);
    }

    @Override
    public HoodieTimeline filterInflightsAndRequested() {
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T i) -> i.getState().equals((Object)HoodieInstant.State.REQUESTED) || i.getState().equals((Object)HoodieInstant.State.INFLIGHT)), this.details);
    }

    @Override
    public HoodieTimeline filterPendingExcludingCompaction() {
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T instant) -> !instant.isCompleted() && !instant.getAction().equals("compaction")), this.details);
    }

    @Override
    public HoodieTimeline filterCompletedInstants() {
        return new HoodieDefaultTimeline(this.instants.stream().filter(HoodieInstant::isCompleted), this.details);
    }

    @Override
    public HoodieTimeline filterCompletedInstantsWithCommitMetadata() {
        return new HoodieDefaultTimeline(this.instants.stream().filter(HoodieInstant::isCompleted).filter((? super T i) -> !this.isDeletePartitionType((HoodieInstant)i)), this.details);
    }

    @Override
    public HoodieTimeline filterCompletedAndCompactionInstants() {
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T s) -> s.isCompleted() || s.getAction().equals("compaction")), this.details);
    }

    @Override
    public HoodieDefaultTimeline getWriteTimeline() {
        Set<String> validActions = CollectionUtils.createSet("commit", "deltacommit", "compaction", "replacecommit");
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T s) -> validActions.contains(s.getAction())), this.details);
    }

    @Override
    public HoodieTimeline getCompletedReplaceTimeline() {
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T s) -> s.getAction().equals("replacecommit")).filter(HoodieInstant::isCompleted), this.details);
    }

    @Override
    public HoodieTimeline filterPendingReplaceTimeline() {
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T s) -> s.getAction().equals("replacecommit") && !s.isCompleted()), this.details);
    }

    @Override
    public HoodieTimeline filterPendingRollbackTimeline() {
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T s) -> s.getAction().equals("rollback") && !s.isCompleted()), this.details);
    }

    @Override
    public HoodieTimeline filterPendingCompactionTimeline() {
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T s) -> s.getAction().equals("compaction") && !s.isCompleted()), this.details);
    }

    @Override
    public HoodieDefaultTimeline findInstantsInRange(String startTs, String endTs) {
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T s) -> HoodieTimeline.isInRange(s.getTimestamp(), startTs, endTs)), this.details);
    }

    @Override
    public HoodieDefaultTimeline findInstantsAfter(String instantTime, int numCommits) {
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T s) -> HoodieTimeline.compareTimestamps(s.getTimestamp(), GREATER_THAN, instantTime)).limit(numCommits), this.details);
    }

    @Override
    public HoodieTimeline findInstantsAfter(String instantTime) {
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T s) -> HoodieTimeline.compareTimestamps(s.getTimestamp(), GREATER_THAN, instantTime)), this.details);
    }

    @Override
    public HoodieDefaultTimeline findInstantsAfterOrEquals(String commitTime, int numCommits) {
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T s) -> HoodieTimeline.compareTimestamps(s.getTimestamp(), GREATER_THAN_OR_EQUALS, commitTime)).limit(numCommits), this.details);
    }

    @Override
    public HoodieDefaultTimeline findInstantsBefore(String instantTime) {
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T s) -> HoodieTimeline.compareTimestamps(s.getTimestamp(), LESSER_THAN, instantTime)), this.details);
    }

    @Override
    public HoodieDefaultTimeline findInstantsBeforeOrEquals(String instantTime) {
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T s) -> HoodieTimeline.compareTimestamps(s.getTimestamp(), LESSER_THAN_OR_EQUALS, instantTime)), this.details);
    }

    @Override
    public HoodieTimeline filter(Predicate<HoodieInstant> filter) {
        return new HoodieDefaultTimeline(this.instants.stream().filter(filter), this.details);
    }

    public HoodieTimeline getCommitsTimeline() {
        return this.getTimelineOfActions(CollectionUtils.createSet("commit", "deltacommit", "replacecommit"));
    }

    public HoodieTimeline getAllCommitsTimeline() {
        return this.getTimelineOfActions(CollectionUtils.createSet("commit", "deltacommit", "clean", "compaction", "savepoint", "rollback", "replacecommit"));
    }

    public HoodieTimeline getCommitTimeline() {
        return this.getTimelineOfActions(CollectionUtils.createSet("commit", "replacecommit"));
    }

    public HoodieTimeline getDeltaCommitTimeline() {
        return new HoodieDefaultTimeline(this.filterInstantsByAction("deltacommit"), this::getInstantDetails);
    }

    public HoodieTimeline getTimelineOfActions(Set<String> actions) {
        return new HoodieDefaultTimeline(this.getInstants().filter((? super T s) -> actions.contains(s.getAction())), this::getInstantDetails);
    }

    public HoodieTimeline getCleanerTimeline() {
        return new HoodieDefaultTimeline(this.filterInstantsByAction("clean"), this::getInstantDetails);
    }

    public HoodieTimeline getRollbackTimeline() {
        return new HoodieDefaultTimeline(this.filterInstantsByAction("rollback"), this::getInstantDetails);
    }

    public HoodieTimeline getRollbackAndRestoreTimeline() {
        return this.getTimelineOfActions(CollectionUtils.createSet("rollback", "restore"));
    }

    public HoodieTimeline getSavePointTimeline() {
        return new HoodieDefaultTimeline(this.filterInstantsByAction("savepoint"), this::getInstantDetails);
    }

    public HoodieTimeline getRestoreTimeline() {
        return new HoodieDefaultTimeline(this.filterInstantsByAction("restore"), this::getInstantDetails);
    }

    protected Stream<HoodieInstant> filterInstantsByAction(String action) {
        return this.getInstants().filter((? super T s) -> s.getAction().equals(action));
    }

    @Override
    public boolean empty() {
        return !this.instants.stream().findFirst().isPresent();
    }

    @Override
    public int countInstants() {
        return this.instants.size();
    }

    @Override
    public Option<HoodieInstant> firstInstant() {
        return Option.fromJavaOptional(this.instants.stream().findFirst());
    }

    @Override
    public Option<HoodieInstant> firstInstant(String action, HoodieInstant.State state) {
        return Option.fromJavaOptional(this.instants.stream().filter((? super T s) -> action.equals(s.getAction()) && state.equals((Object)s.getState())).findFirst());
    }

    @Override
    public Option<HoodieInstant> nthInstant(int n) {
        if (this.empty() || n >= this.countInstants()) {
            return Option.empty();
        }
        return Option.of(this.instants.get(n));
    }

    @Override
    public Option<HoodieInstant> lastInstant() {
        return this.empty() ? Option.empty() : this.nthInstant(this.countInstants() - 1);
    }

    @Override
    public Option<HoodieInstant> nthFromLastInstant(int n) {
        if (this.countInstants() < n + 1) {
            return Option.empty();
        }
        return this.nthInstant(this.countInstants() - 1 - n);
    }

    @Override
    public boolean containsInstant(HoodieInstant instant) {
        return this.instants.stream().anyMatch(s -> s.equals(instant));
    }

    @Override
    public boolean containsInstant(String ts) {
        return this.instants.stream().anyMatch(s -> s.getTimestamp().equals(ts));
    }

    @Override
    public boolean containsOrBeforeTimelineStarts(String instant) {
        return this.instants.stream().anyMatch(s -> s.getTimestamp().equals(instant)) || this.isBeforeTimelineStarts(instant);
    }

    @Override
    public String getTimelineHash() {
        return this.timelineHash;
    }

    @Override
    public Stream<HoodieInstant> getInstants() {
        return this.instants.stream();
    }

    @Override
    public Stream<HoodieInstant> getReverseOrderedInstants() {
        List instants = this.getInstants().collect(Collectors.toList());
        Collections.reverse(instants);
        return instants.stream();
    }

    @Override
    public boolean isBeforeTimelineStarts(String instant) {
        Option<HoodieInstant> firstCommit = this.firstInstant();
        return firstCommit.isPresent() && HoodieTimeline.compareTimestamps(instant, LESSER_THAN, firstCommit.get().getTimestamp());
    }

    @Override
    public Option<byte[]> getInstantDetails(HoodieInstant instant) {
        return this.details.apply(instant);
    }

    @Override
    public boolean isDeletePartitionType(HoodieInstant instant) {
        Option<Object> operationType;
        try {
            HoodieCommitMetadata commitMetadata = HoodieCommitMetadata.fromBytes(this.getInstantDetails(instant).get(), HoodieCommitMetadata.class);
            operationType = Option.of(commitMetadata.getOperationType());
        }
        catch (Exception e) {
            operationType = Option.empty();
        }
        return operationType.isPresent() && WriteOperationType.DELETE_PARTITION.equals(operationType.get());
    }

    @Override
    public boolean isEmpty(HoodieInstant instant) {
        return this.getInstantDetails(instant).get().length == 0;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.instants.stream().map(Object::toString).collect(Collectors.joining(","));
    }
}

