/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieInstantInfo;
import org.apache.hudi.avro.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPartitionMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.avro.model.HoodieSavepointPartitionMetadata;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.file.DataFileReader;
import org.apache.hudi.org.apache.avro.file.DataFileWriter;
import org.apache.hudi.org.apache.avro.file.FileReader;
import org.apache.hudi.org.apache.avro.file.SeekableByteArrayInput;
import org.apache.hudi.org.apache.avro.specific.SpecificData;
import org.apache.hudi.org.apache.avro.specific.SpecificDatumReader;
import org.apache.hudi.org.apache.avro.specific.SpecificDatumWriter;
import org.apache.hudi.org.apache.avro.specific.SpecificRecordBase;

public class TimelineMetadataUtils {
    private static final Integer DEFAULT_VERSION = 1;

    public static HoodieRestoreMetadata convertRestoreMetadata(String startRestoreTime, long durationInMs, List<HoodieInstant> instants, Map<String, List<HoodieRollbackMetadata>> instantToRollbackMetadata) {
        return new HoodieRestoreMetadata(startRestoreTime, durationInMs, instants.stream().map(HoodieInstant::getTimestamp).collect(Collectors.toList()), Collections.unmodifiableMap(instantToRollbackMetadata), DEFAULT_VERSION, instants.stream().map(instant -> new HoodieInstantInfo(instant.getTimestamp(), instant.getAction())).collect(Collectors.toList()));
    }

    public static HoodieRollbackMetadata convertRollbackMetadata(String startRollbackTime, Option<Long> durationInMs, List<HoodieInstant> instants, List<HoodieRollbackStat> rollbackStats) {
        HashMap<String, HoodieRollbackPartitionMetadata> partitionMetadataBuilder = new HashMap<String, HoodieRollbackPartitionMetadata>();
        int totalDeleted = 0;
        for (HoodieRollbackStat stat : rollbackStats) {
            Map<String, Long> rollbackLogFiles = stat.getCommandBlocksCount().keySet().stream().collect(Collectors.toMap(f -> f.getPath().toString(), FileStatus::getLen));
            Map<String, Long> probableLogFiles = stat.getWrittenLogFileSizeMap().keySet().stream().collect(Collectors.toMap(f -> f.getPath().toString(), FileStatus::getLen));
            HoodieRollbackPartitionMetadata metadata = new HoodieRollbackPartitionMetadata(stat.getPartitionPath(), stat.getSuccessDeleteFiles(), stat.getFailedDeleteFiles(), rollbackLogFiles, probableLogFiles);
            partitionMetadataBuilder.put(stat.getPartitionPath(), metadata);
            totalDeleted += stat.getSuccessDeleteFiles().size();
        }
        return new HoodieRollbackMetadata(startRollbackTime, durationInMs.orElseGet(() -> -1L), totalDeleted, instants.stream().map(HoodieInstant::getTimestamp).collect(Collectors.toList()), Collections.unmodifiableMap(partitionMetadataBuilder), DEFAULT_VERSION, instants.stream().map(instant -> new HoodieInstantInfo(instant.getTimestamp(), instant.getAction())).collect(Collectors.toList()));
    }

    public static HoodieSavepointMetadata convertSavepointMetadata(String user, String comment, Map<String, List<String>> latestFiles) {
        HashMap<String, HoodieSavepointPartitionMetadata> partitionMetadataBuilder = new HashMap<String, HoodieSavepointPartitionMetadata>();
        for (Map.Entry<String, List<String>> stat : latestFiles.entrySet()) {
            HoodieSavepointPartitionMetadata metadata = new HoodieSavepointPartitionMetadata(stat.getKey(), stat.getValue());
            partitionMetadataBuilder.put(stat.getKey(), metadata);
        }
        return new HoodieSavepointMetadata(user, System.currentTimeMillis(), comment, Collections.unmodifiableMap(partitionMetadataBuilder), DEFAULT_VERSION);
    }

    public static Option<byte[]> serializeCompactionPlan(HoodieCompactionPlan compactionWorkload) throws IOException {
        return TimelineMetadataUtils.serializeAvroMetadata(compactionWorkload, HoodieCompactionPlan.class);
    }

    public static Option<byte[]> serializeCleanerPlan(HoodieCleanerPlan cleanPlan) throws IOException {
        return TimelineMetadataUtils.serializeAvroMetadata(cleanPlan, HoodieCleanerPlan.class);
    }

    public static Option<byte[]> serializeRollbackPlan(HoodieRollbackPlan rollbackPlan) throws IOException {
        return TimelineMetadataUtils.serializeAvroMetadata(rollbackPlan, HoodieRollbackPlan.class);
    }

    public static Option<byte[]> serializeCleanMetadata(HoodieCleanMetadata metadata) throws IOException {
        return TimelineMetadataUtils.serializeAvroMetadata(metadata, HoodieCleanMetadata.class);
    }

    public static Option<byte[]> serializeSavepointMetadata(HoodieSavepointMetadata metadata) throws IOException {
        return TimelineMetadataUtils.serializeAvroMetadata(metadata, HoodieSavepointMetadata.class);
    }

    public static Option<byte[]> serializeRollbackMetadata(HoodieRollbackMetadata rollbackMetadata) throws IOException {
        return TimelineMetadataUtils.serializeAvroMetadata(rollbackMetadata, HoodieRollbackMetadata.class);
    }

    public static Option<byte[]> serializeRestoreMetadata(HoodieRestoreMetadata restoreMetadata) throws IOException {
        return TimelineMetadataUtils.serializeAvroMetadata(restoreMetadata, HoodieRestoreMetadata.class);
    }

    public static Option<byte[]> serializeRequestedReplaceMetadata(HoodieRequestedReplaceMetadata clusteringPlan) throws IOException {
        return TimelineMetadataUtils.serializeAvroMetadata(clusteringPlan, HoodieRequestedReplaceMetadata.class);
    }

    public static <T extends SpecificRecordBase> Option<byte[]> serializeAvroMetadata(T metadata, Class<T> clazz) throws IOException {
        SpecificDatumWriter<T> datumWriter = new SpecificDatumWriter<T>(clazz);
        DataFileWriter<T> fileWriter = new DataFileWriter<T>(datumWriter);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        fileWriter.create(metadata.getSchema(), baos);
        fileWriter.append(metadata);
        fileWriter.flush();
        return Option.of(baos.toByteArray());
    }

    public static HoodieCleanerPlan deserializeCleanerPlan(byte[] bytes) throws IOException {
        return TimelineMetadataUtils.deserializeAvroMetadata(bytes, HoodieCleanerPlan.class);
    }

    public static HoodieCompactionPlan deserializeCompactionPlan(byte[] bytes) throws IOException {
        return TimelineMetadataUtils.deserializeAvroMetadata(bytes, HoodieCompactionPlan.class);
    }

    public static HoodieCleanMetadata deserializeHoodieCleanMetadata(byte[] bytes) throws IOException {
        return TimelineMetadataUtils.deserializeAvroMetadata(bytes, HoodieCleanMetadata.class);
    }

    public static HoodieRollbackMetadata deserializeHoodieRollbackMetadata(byte[] bytes) throws IOException {
        return TimelineMetadataUtils.deserializeAvroMetadata(bytes, HoodieRollbackMetadata.class);
    }

    public static HoodieRestoreMetadata deserializeHoodieRestoreMetadata(byte[] bytes) throws IOException {
        return TimelineMetadataUtils.deserializeAvroMetadata(bytes, HoodieRestoreMetadata.class);
    }

    public static HoodieSavepointMetadata deserializeHoodieSavepointMetadata(byte[] bytes) throws IOException {
        return TimelineMetadataUtils.deserializeAvroMetadata(bytes, HoodieSavepointMetadata.class);
    }

    public static HoodieRequestedReplaceMetadata deserializeRequestedReplaceMetadata(byte[] bytes) throws IOException {
        return TimelineMetadataUtils.deserializeAvroMetadata(bytes, HoodieRequestedReplaceMetadata.class);
    }

    public static HoodieReplaceCommitMetadata deserializeHoodieReplaceMetadata(byte[] bytes) throws IOException {
        return TimelineMetadataUtils.deserializeAvroMetadata(bytes, HoodieReplaceCommitMetadata.class);
    }

    public static <T extends SpecificRecordBase> T deserializeAvroMetadata(byte[] bytes, Class<T> clazz) throws IOException {
        SpecificDatumReader<T> reader = new SpecificDatumReader<T>(clazz);
        FileReader<T> fileReader = DataFileReader.openReader(new SeekableByteArrayInput(bytes), reader);
        ValidationUtils.checkArgument(fileReader.hasNext(), "Could not deserialize metadata of type " + clazz);
        return (T)((SpecificRecordBase)fileReader.next());
    }

    public static <T extends SpecificRecordBase> T deserializeAvroRecordMetadata(byte[] bytes, Schema schema) throws IOException {
        return TimelineMetadataUtils.deserializeAvroRecordMetadata(HoodieAvroUtils.bytesToAvro(bytes, schema), schema);
    }

    public static <T extends SpecificRecordBase> T deserializeAvroRecordMetadata(Object object, Schema schema) {
        return (T)((SpecificRecordBase)SpecificData.get().deepCopy(schema, object));
    }
}

