/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HoodieCommitMetadata
implements Serializable {
    public static final String SCHEMA_KEY = "schema";
    private static final Logger LOG = LogManager.getLogger(HoodieCommitMetadata.class);
    protected Map<String, List<HoodieWriteStat>> partitionToWriteStats;
    protected Boolean compacted;
    protected Map<String, String> extraMetadata;
    protected WriteOperationType operationType = WriteOperationType.UNKNOWN;

    public HoodieCommitMetadata() {
        this(false);
    }

    public HoodieCommitMetadata(boolean compacted) {
        this.extraMetadata = new HashMap<String, String>();
        this.partitionToWriteStats = new HashMap<String, List<HoodieWriteStat>>();
        this.compacted = compacted;
    }

    public void addWriteStat(String partitionPath, HoodieWriteStat stat) {
        if (!this.partitionToWriteStats.containsKey(partitionPath)) {
            this.partitionToWriteStats.put(partitionPath, new ArrayList());
        }
        this.partitionToWriteStats.get(partitionPath).add(stat);
    }

    public void addMetadata(String metaKey, String value) {
        this.extraMetadata.put(metaKey, value);
    }

    public List<HoodieWriteStat> getWriteStats(String partitionPath) {
        return this.partitionToWriteStats.get(partitionPath);
    }

    public Map<String, String> getExtraMetadata() {
        return this.extraMetadata;
    }

    public Map<String, List<HoodieWriteStat>> getPartitionToWriteStats() {
        return this.partitionToWriteStats;
    }

    public List<HoodieWriteStat> getWriteStats() {
        return this.partitionToWriteStats.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public String getMetadata(String metaKey) {
        return this.extraMetadata.get(metaKey);
    }

    public Boolean getCompacted() {
        return this.compacted;
    }

    public void setCompacted(Boolean compacted) {
        this.compacted = compacted;
    }

    public HashMap<String, String> getFileIdAndRelativePaths() {
        HashMap<String, String> filePaths = new HashMap<String, String>();
        for (List<HoodieWriteStat> stats : this.getPartitionToWriteStats().values()) {
            for (HoodieWriteStat stat : stats) {
                filePaths.put(stat.getFileId(), stat.getPath());
            }
        }
        return filePaths;
    }

    public void setOperationType(WriteOperationType type) {
        this.operationType = type;
    }

    public WriteOperationType getOperationType() {
        return this.operationType;
    }

    public HashMap<String, String> getFileIdAndFullPaths(String basePath) {
        HashMap<String, String> fullPaths = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getFileIdAndRelativePaths().entrySet()) {
            String fullPath = entry.getValue() != null ? FSUtils.getPartitionPath(basePath, entry.getValue()).toString() : null;
            fullPaths.put(entry.getKey(), fullPath);
        }
        return fullPaths;
    }

    public Map<HoodieFileGroupId, String> getFileGroupIdAndFullPaths(String basePath) {
        HashMap<HoodieFileGroupId, String> fileGroupIdToFullPaths = new HashMap<HoodieFileGroupId, String>();
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.getPartitionToWriteStats().entrySet()) {
            for (HoodieWriteStat stat : entry.getValue()) {
                HoodieFileGroupId fileGroupId = new HoodieFileGroupId(stat.getPartitionPath(), stat.getFileId());
                Path fullPath = new Path(basePath, stat.getPath());
                fileGroupIdToFullPaths.put(fileGroupId, fullPath.toString());
            }
        }
        return fileGroupIdToFullPaths;
    }

    public Map<String, FileStatus> getFullPathToFileStatus(Configuration hadoopConf, String basePath) {
        HashMap<String, FileStatus> fullPathToFileStatus = new HashMap<String, FileStatus>();
        for (List<HoodieWriteStat> stats : this.getPartitionToWriteStats().values()) {
            for (HoodieWriteStat stat : stats) {
                String relativeFilePath = stat.getPath();
                Path fullPath = relativeFilePath != null ? FSUtils.getPartitionPath(basePath, relativeFilePath) : null;
                if (fullPath == null) continue;
                long blockSize = FSUtils.getFs(fullPath.toString(), hadoopConf).getDefaultBlockSize(fullPath);
                FileStatus fileStatus = new FileStatus(stat.getFileSizeInBytes(), false, 0, blockSize, 0L, fullPath);
                fullPathToFileStatus.put(fullPath.getName(), fileStatus);
            }
        }
        return fullPathToFileStatus;
    }

    public Map<String, FileStatus> getFileIdToFileStatus(Configuration hadoopConf, String basePath) {
        HashMap<String, FileStatus> fileIdToFileStatus = new HashMap<String, FileStatus>();
        for (List<HoodieWriteStat> stats : this.getPartitionToWriteStats().values()) {
            for (HoodieWriteStat stat : stats) {
                String relativeFilePath = stat.getPath();
                Path fullPath = relativeFilePath != null ? FSUtils.getPartitionPath(basePath, relativeFilePath) : null;
                if (fullPath == null) continue;
                FileStatus fileStatus = new FileStatus(stat.getFileSizeInBytes(), false, 0, 0L, 0L, fullPath);
                fileIdToFileStatus.put(stat.getFileId(), fileStatus);
            }
        }
        return fileIdToFileStatus;
    }

    public String toJsonString() throws IOException {
        if (this.partitionToWriteStats.containsKey(null)) {
            LOG.info((Object)("partition path is null for " + this.partitionToWriteStats.get(null)));
            this.partitionToWriteStats.remove(null);
        }
        return HoodieCommitMetadata.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
    }

    public static <T> T fromJsonString(String jsonStr, Class<T> clazz) throws Exception {
        if (jsonStr == null || jsonStr.isEmpty()) {
            return clazz.newInstance();
        }
        return (T)HoodieCommitMetadata.getObjectMapper().readValue(jsonStr, clazz);
    }

    public long fetchTotalPartitionsWritten() {
        return this.partitionToWriteStats.size();
    }

    public long fetchTotalFilesInsert() {
        long totalFilesInsert = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                if (stat.getPrevCommit() == null || !stat.getPrevCommit().equalsIgnoreCase("null")) continue;
                ++totalFilesInsert;
            }
        }
        return totalFilesInsert;
    }

    public long fetchTotalFilesUpdated() {
        long totalFilesUpdated = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                if (stat.getPrevCommit() == null || stat.getPrevCommit().equalsIgnoreCase("null")) continue;
                ++totalFilesUpdated;
            }
        }
        return totalFilesUpdated;
    }

    public long fetchTotalUpdateRecordsWritten() {
        long totalUpdateRecordsWritten = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                totalUpdateRecordsWritten += stat.getNumUpdateWrites();
            }
        }
        return totalUpdateRecordsWritten;
    }

    public long fetchTotalInsertRecordsWritten() {
        long totalInsertRecordsWritten = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                if (stat.getPrevCommit() == null) continue;
                totalInsertRecordsWritten += stat.getNumInserts();
            }
        }
        return totalInsertRecordsWritten;
    }

    public long fetchTotalRecordsWritten() {
        long totalRecordsWritten = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                totalRecordsWritten += stat.getNumWrites();
            }
        }
        return totalRecordsWritten;
    }

    public long fetchTotalBytesWritten() {
        long totalBytesWritten = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                totalBytesWritten += stat.getTotalWriteBytes();
            }
        }
        return totalBytesWritten;
    }

    public long fetchTotalWriteErrors() {
        long totalWriteErrors = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                totalWriteErrors += stat.getTotalWriteErrors();
            }
        }
        return totalWriteErrors;
    }

    public long getTotalRecordsDeleted() {
        long totalDeletes = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                totalDeletes += stat.getNumDeletes();
            }
        }
        return totalDeletes;
    }

    public Long getTotalLogRecordsCompacted() {
        Long totalLogRecords = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                totalLogRecords = totalLogRecords + writeStat.getTotalLogRecords();
            }
        }
        return totalLogRecords;
    }

    public Long getTotalLogFilesCompacted() {
        Long totalLogFiles = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                totalLogFiles = totalLogFiles + writeStat.getTotalLogFilesCompacted();
            }
        }
        return totalLogFiles;
    }

    public Long getTotalCompactedRecordsUpdated() {
        Long totalUpdateRecords = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                totalUpdateRecords = totalUpdateRecords + writeStat.getTotalUpdatedRecordsCompacted();
            }
        }
        return totalUpdateRecords;
    }

    public Long getTotalLogFilesSize() {
        Long totalLogFilesSize = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                totalLogFilesSize = totalLogFilesSize + writeStat.getTotalLogSizeCompacted();
            }
        }
        return totalLogFilesSize;
    }

    public Long getTotalScanTime() {
        Long totalScanTime = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                if (writeStat.getRuntimeStats() == null) continue;
                totalScanTime = totalScanTime + writeStat.getRuntimeStats().getTotalScanTime();
            }
        }
        return totalScanTime;
    }

    public Long getTotalCreateTime() {
        Long totalCreateTime = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                if (writeStat.getRuntimeStats() == null) continue;
                totalCreateTime = totalCreateTime + writeStat.getRuntimeStats().getTotalCreateTime();
            }
        }
        return totalCreateTime;
    }

    public Long getTotalUpsertTime() {
        Long totalUpsertTime = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                if (writeStat.getRuntimeStats() == null) continue;
                totalUpsertTime = totalUpsertTime + writeStat.getRuntimeStats().getTotalUpsertTime();
            }
        }
        return totalUpsertTime;
    }

    public Pair<Option<Long>, Option<Long>> getMinAndMaxEventTime() {
        long minEventTime = Long.MAX_VALUE;
        long maxEventTime = Long.MIN_VALUE;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                minEventTime = writeStat.getMinEventTime() != null ? Math.min(writeStat.getMinEventTime(), minEventTime) : minEventTime;
                maxEventTime = writeStat.getMaxEventTime() != null ? Math.max(writeStat.getMaxEventTime(), maxEventTime) : maxEventTime;
            }
        }
        return Pair.of(minEventTime == Long.MAX_VALUE ? Option.empty() : Option.of(minEventTime), maxEventTime == Long.MIN_VALUE ? Option.empty() : Option.of(maxEventTime));
    }

    public HashSet<String> getWritePartitionPaths() {
        return new HashSet<String>(this.partitionToWriteStats.keySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieCommitMetadata that = (HoodieCommitMetadata)o;
        if (!this.partitionToWriteStats.equals(that.partitionToWriteStats)) {
            return false;
        }
        return this.compacted.equals(that.compacted);
    }

    public int hashCode() {
        int result = this.partitionToWriteStats.hashCode();
        result = 31 * result + this.compacted.hashCode();
        return result;
    }

    public static <T> T fromBytes(byte[] bytes, Class<T> clazz) throws IOException {
        try {
            return HoodieCommitMetadata.fromJsonString(new String(bytes, StandardCharsets.UTF_8), clazz);
        }
        catch (Exception e) {
            throw new IOException("unable to read commit metadata", e);
        }
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        return mapper;
    }

    public String toString() {
        return "HoodieCommitMetadata{partitionToWriteStats=" + this.partitionToWriteStats + ", compacted=" + this.compacted + ", extraMetadata=" + this.extraMetadata + ", operationType=" + (Object)((Object)this.operationType) + '}';
    }
}

