/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIncompatibleSchemaException;
import org.apache.hudi.exception.InvalidTableException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.io.FileBasedInternalSchemaStorageManager;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.apache.hudi.io.storage.HoodieHFileReader;
import org.apache.hudi.io.storage.HoodieOrcReader;
import org.apache.hudi.org.apache.avro.JsonProperties;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.SchemaCompatibility;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hudi.org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.hudi.org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.hudi.org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.hudi.org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.hudi.org.apache.parquet.schema.MessageType;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TableSchemaResolver {
    private static final Logger LOG = LogManager.getLogger(TableSchemaResolver.class);
    private final HoodieTableMetaClient metaClient;
    private final boolean hasOperationField;

    public TableSchemaResolver(HoodieTableMetaClient metaClient) {
        this.metaClient = metaClient;
        this.hasOperationField = this.hasOperationField();
    }

    private MessageType getTableParquetSchemaFromDataFile() {
        HoodieActiveTimeline activeTimeline = this.metaClient.getActiveTimeline();
        Option<Pair<HoodieInstant, HoodieCommitMetadata>> instantAndCommitMetadata = activeTimeline.getLastCommitMetadataWithValidData();
        try {
            switch (this.metaClient.getTableType()) {
                case COPY_ON_WRITE: {
                    if (instantAndCommitMetadata.isPresent()) {
                        HoodieCommitMetadata commitMetadata = instantAndCommitMetadata.get().getRight();
                        String filePath = commitMetadata.getFileIdAndFullPaths(this.metaClient.getBasePath()).values().stream().findAny().get();
                        return this.readSchemaFromBaseFile(filePath);
                    }
                    throw new IllegalArgumentException("Could not find any data file written for commit, so could not get schema for table " + this.metaClient.getBasePath());
                }
                case MERGE_ON_READ: {
                    if (instantAndCommitMetadata.isPresent()) {
                        HoodieCommitMetadata commitMetadata = instantAndCommitMetadata.get().getRight();
                        String filePath = commitMetadata.getFileIdAndFullPaths(this.metaClient.getBasePath()).values().stream().findAny().get();
                        if (filePath.contains(HoodieFileFormat.HOODIE_LOG.getFileExtension())) {
                            return this.readSchemaFromLogFile(new Path(filePath));
                        }
                        return this.readSchemaFromBaseFile(filePath);
                    }
                    throw new IllegalArgumentException("Could not find any data file written for commit, so could not get schema for table " + this.metaClient.getBasePath());
                }
            }
            LOG.error((Object)("Unknown table type " + (Object)((Object)this.metaClient.getTableType())));
            throw new InvalidTableException(this.metaClient.getBasePath());
        }
        catch (IOException e) {
            throw new HoodieException("Failed to read data schema", e);
        }
    }

    private MessageType readSchemaFromBaseFile(String filePath) throws IOException {
        if (filePath.contains(HoodieFileFormat.PARQUET.getFileExtension())) {
            return this.readSchemaFromParquetBaseFile(new Path(filePath));
        }
        if (filePath.contains(HoodieFileFormat.HFILE.getFileExtension())) {
            return this.readSchemaFromHFileBaseFile(new Path(filePath));
        }
        if (filePath.contains(HoodieFileFormat.ORC.getFileExtension())) {
            return this.readSchemaFromORCBaseFile(new Path(filePath));
        }
        throw new IllegalArgumentException("Unknown base file format :" + filePath);
    }

    public Schema getTableAvroSchemaFromDataFile() {
        return this.convertParquetSchemaToAvro(this.getTableParquetSchemaFromDataFile());
    }

    public Schema getTableAvroSchema() throws Exception {
        return this.getTableAvroSchema(this.metaClient.getTableConfig().populateMetaFields());
    }

    public Schema getTableAvroSchema(boolean includeMetadataFields) throws Exception {
        Option<Schema> schemaFromTableConfig;
        Option<Schema> schemaFromCommitMetadata = this.getTableSchemaFromCommitMetadata(includeMetadataFields);
        Schema schema = schemaFromCommitMetadata.isPresent() ? schemaFromCommitMetadata.get() : ((schemaFromTableConfig = this.metaClient.getTableConfig().getTableCreateSchema()).isPresent() ? (includeMetadataFields ? HoodieAvroUtils.addMetadataFields(schemaFromTableConfig.get(), this.hasOperationField) : schemaFromTableConfig.get()) : (includeMetadataFields ? this.getTableAvroSchemaFromDataFile() : HoodieAvroUtils.removeMetadataFields(this.getTableAvroSchemaFromDataFile())));
        Option<String[]> partitionFieldsOpt = this.metaClient.getTableConfig().getPartitionFields();
        if (this.metaClient.getTableConfig().shouldDropPartitionColumns().booleanValue()) {
            schema = TableSchemaResolver.recreateSchemaWhenDropPartitionColumns(partitionFieldsOpt, schema);
        }
        return schema;
    }

    public static Schema recreateSchemaWhenDropPartitionColumns(Option<String[]> partitionFieldsOpt, Schema originSchema) {
        Schema schema = originSchema;
        if (partitionFieldsOpt.isPresent() && partitionFieldsOpt.get().length != 0) {
            List<Object> partitionFields = Arrays.asList((Object[])partitionFieldsOpt.get());
            Schema schema0 = originSchema;
            boolean hasPartitionColNotInSchema = partitionFields.stream().anyMatch(pt -> !HoodieAvroUtils.containsFieldInSchema(schema0, pt));
            boolean hasPartitionColInSchema = partitionFields.stream().anyMatch(pt -> HoodieAvroUtils.containsFieldInSchema(schema0, pt));
            if (hasPartitionColNotInSchema && hasPartitionColInSchema) {
                throw new HoodieIncompatibleSchemaException("Not support: Partial partition fields are still in the schema when enable hoodie.datasource.write.drop.partition.columns");
            }
            if (hasPartitionColNotInSchema) {
                ArrayList<Schema.Field> newFields = new ArrayList<Schema.Field>();
                for (String string : partitionFields) {
                    newFields.add(new Schema.Field(string, AvroSchemaUtils.createNullableSchema(Schema.Type.STRING), "", JsonProperties.NULL_VALUE));
                }
                schema = AvroSchemaUtils.appendFieldsToSchema(schema, newFields);
            }
        }
        return schema;
    }

    public MessageType getTableParquetSchema() throws Exception {
        Option<Schema> schemaFromCommitMetadata = this.getTableSchemaFromCommitMetadata(true);
        if (schemaFromCommitMetadata.isPresent()) {
            return this.convertAvroSchemaToParquet(schemaFromCommitMetadata.get());
        }
        Option<Schema> schemaFromTableConfig = this.metaClient.getTableConfig().getTableCreateSchema();
        if (schemaFromTableConfig.isPresent()) {
            Schema schema = HoodieAvroUtils.addMetadataFields(schemaFromTableConfig.get(), this.hasOperationField);
            return this.convertAvroSchemaToParquet(schema);
        }
        return this.getTableParquetSchemaFromDataFile();
    }

    @Deprecated
    public Schema getTableAvroSchemaWithoutMetadataFields() throws Exception {
        return this.getTableAvroSchema(false);
    }

    @Deprecated
    public Schema getTableAvroSchemaWithoutMetadataFields(HoodieInstant instant) throws Exception {
        Option<Schema> schemaFromCommitMetadata = this.getTableSchemaFromCommitMetadata(instant, false);
        if (schemaFromCommitMetadata.isPresent()) {
            return schemaFromCommitMetadata.get();
        }
        Option<Schema> schemaFromTableConfig = this.metaClient.getTableConfig().getTableCreateSchema();
        if (schemaFromTableConfig.isPresent()) {
            return schemaFromTableConfig.get();
        }
        return HoodieAvroUtils.removeMetadataFields(this.getTableAvroSchemaFromDataFile());
    }

    private Option<Schema> getTableSchemaFromCommitMetadata(boolean includeMetadataFields) {
        Option<Pair<HoodieInstant, HoodieCommitMetadata>> instantAndCommitMetadata = this.metaClient.getActiveTimeline().getLastCommitMetadataWithValidSchema();
        if (instantAndCommitMetadata.isPresent()) {
            HoodieCommitMetadata commitMetadata = instantAndCommitMetadata.get().getRight();
            String schemaStr = commitMetadata.getMetadata("schema");
            Schema schema = new Schema.Parser().parse(schemaStr);
            if (includeMetadataFields) {
                schema = HoodieAvroUtils.addMetadataFields(schema, this.hasOperationField);
            }
            return Option.of(schema);
        }
        return Option.empty();
    }

    private Option<Schema> getTableSchemaFromCommitMetadata(HoodieInstant instant, boolean includeMetadataFields) {
        try {
            HoodieTimeline timeline = this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
            byte[] data = timeline.getInstantDetails(instant).get();
            HoodieCommitMetadata metadata = HoodieCommitMetadata.fromBytes(data, HoodieCommitMetadata.class);
            String existingSchemaStr = metadata.getMetadata("schema");
            if (StringUtils.isNullOrEmpty(existingSchemaStr)) {
                return Option.empty();
            }
            Schema schema = new Schema.Parser().parse(existingSchemaStr);
            if (includeMetadataFields) {
                schema = HoodieAvroUtils.addMetadataFields(schema, this.hasOperationField);
            }
            return Option.of(schema);
        }
        catch (Exception e) {
            throw new HoodieException("Failed to read schema from commit metadata", e);
        }
    }

    public Schema convertParquetSchemaToAvro(MessageType parquetSchema) {
        AvroSchemaConverter avroSchemaConverter = new AvroSchemaConverter(this.metaClient.getHadoopConf());
        return avroSchemaConverter.convert(parquetSchema);
    }

    public MessageType convertAvroSchemaToParquet(Schema schema) {
        AvroSchemaConverter avroSchemaConverter = new AvroSchemaConverter(this.metaClient.getHadoopConf());
        return avroSchemaConverter.convert(schema);
    }

    public static boolean isSchemaCompatible(Schema oldSchema, Schema newSchema) {
        if (oldSchema.getType() == newSchema.getType() && newSchema.getType() == Schema.Type.RECORD) {
            if (!SchemaCompatibility.schemaNameEquals(newSchema, oldSchema)) {
                return false;
            }
            for (Schema.Field oldSchemaField : oldSchema.getFields()) {
                Schema.Field newSchemaField = SchemaCompatibility.lookupWriterField(newSchema, oldSchemaField);
                if (newSchemaField == null) {
                    return false;
                }
                if (TableSchemaResolver.isSchemaCompatible(oldSchemaField.schema(), newSchemaField.schema())) continue;
                return false;
            }
            for (Schema.Field newSchemaField : newSchema.getFields()) {
                Schema.Field oldSchemaField = SchemaCompatibility.lookupWriterField(oldSchema, newSchemaField);
                if (oldSchemaField != null || newSchemaField.defaultVal() != null) continue;
                return false;
            }
            return true;
        }
        SchemaCompatibility.SchemaPairCompatibility compatResult = SchemaCompatibility.checkReaderWriterCompatibility(newSchema, oldSchema);
        return compatResult.getType() == SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE;
    }

    public static boolean isSchemaCompatible(String oldSchema, String newSchema) {
        return TableSchemaResolver.isSchemaCompatible(new Schema.Parser().parse(oldSchema), new Schema.Parser().parse(newSchema));
    }

    public Schema getLatestSchema(Schema writeSchema, boolean convertTableSchemaToAddNamespace, Functions.Function1<Schema, Schema> converterFn) {
        Schema latestSchema = writeSchema;
        try {
            if (this.metaClient.isTimelineNonEmpty()) {
                Schema tableSchema = this.getTableAvroSchemaWithoutMetadataFields();
                if (convertTableSchemaToAddNamespace && converterFn != null) {
                    tableSchema = converterFn.apply(tableSchema);
                }
                if (writeSchema.getFields().size() < tableSchema.getFields().size() && TableSchemaResolver.isSchemaCompatible(writeSchema, tableSchema)) {
                    latestSchema = tableSchema;
                    LOG.debug((Object)("Using latest table schema to rewrite incoming records " + tableSchema.toString()));
                }
            }
        }
        catch (IllegalArgumentException | InvalidTableException e) {
            LOG.warn((Object)"Could not find any commits, falling back to using incoming batch's write schema");
        }
        catch (Exception e) {
            LOG.warn((Object)("Unknown exception thrown " + e.getMessage() + ", Falling back to using incoming batch's write schema"));
        }
        return latestSchema;
    }

    public MessageType readSchemaFromParquetBaseFile(Path parquetFilePath) throws IOException {
        LOG.info((Object)("Reading schema from " + parquetFilePath));
        FileSystem fs = this.metaClient.getRawFs();
        ParquetMetadata fileFooter = ParquetFileReader.readFooter(fs.getConf(), parquetFilePath, ParquetMetadataConverter.NO_FILTER);
        return fileFooter.getFileMetaData().getSchema();
    }

    public MessageType readSchemaFromHFileBaseFile(Path hFilePath) throws IOException {
        LOG.info((Object)("Reading schema from " + hFilePath));
        FileSystem fs = this.metaClient.getRawFs();
        CacheConfig cacheConfig = new CacheConfig(fs.getConf());
        HoodieHFileReader hFileReader = new HoodieHFileReader(fs.getConf(), hFilePath, cacheConfig);
        return this.convertAvroSchemaToParquet(hFileReader.getSchema());
    }

    public MessageType readSchemaFromORCBaseFile(Path orcFilePath) throws IOException {
        LOG.info((Object)("Reading schema from " + orcFilePath));
        FileSystem fs = this.metaClient.getRawFs();
        HoodieOrcReader orcReader = new HoodieOrcReader(fs.getConf(), orcFilePath);
        return this.convertAvroSchemaToParquet(orcReader.getSchema());
    }

    public MessageType readSchemaFromLastCompaction(Option<HoodieInstant> lastCompactionCommitOpt) throws Exception {
        HoodieActiveTimeline activeTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant lastCompactionCommit = lastCompactionCommitOpt.orElseThrow(() -> new Exception("Could not read schema from last compaction, no compaction commits found on path " + this.metaClient));
        HoodieCommitMetadata compactionMetadata = HoodieCommitMetadata.fromBytes(activeTimeline.getInstantDetails(lastCompactionCommit).get(), HoodieCommitMetadata.class);
        String filePath = compactionMetadata.getFileIdAndFullPaths(this.metaClient.getBasePath()).values().stream().findAny().orElseThrow(() -> new IllegalArgumentException("Could not find any data file written for compaction " + lastCompactionCommit + ", could not get schema for table " + this.metaClient.getBasePath()));
        return this.readSchemaFromBaseFile(filePath);
    }

    public MessageType readSchemaFromLogFile(Path path) throws IOException {
        return TableSchemaResolver.readSchemaFromLogFile(this.metaClient.getRawFs(), path);
    }

    public static MessageType readSchemaFromLogFile(FileSystem fs, Path path) throws IOException {
        try (HoodieLogFormat.Reader reader = HoodieLogFormat.newReader(fs, new HoodieLogFile(path), null);){
            HoodieDataBlock lastBlock = null;
            while (reader.hasNext()) {
                HoodieLogBlock block = (HoodieLogBlock)reader.next();
                if (!(block instanceof HoodieDataBlock)) continue;
                lastBlock = (HoodieDataBlock)block;
            }
            MessageType messageType = lastBlock != null ? new AvroSchemaConverter().convert(lastBlock.getSchema()) : null;
            return messageType;
        }
    }

    public boolean isHasOperationField() {
        return this.hasOperationField;
    }

    private boolean hasOperationField() {
        try {
            Schema tableAvroSchema = this.getTableAvroSchemaFromDataFile();
            return tableAvroSchema.getField("_hoodie_operation") != null;
        }
        catch (Exception e) {
            LOG.info((Object)String.format("Failed to read operation field from avro schema (%s)", e.getMessage()));
            return false;
        }
    }

    public Option<InternalSchema> getTableInternalSchemaFromCommitMetadata() {
        HoodieTimeline timeline = this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        if (timeline.lastInstant().isPresent()) {
            return this.getTableInternalSchemaFromCommitMetadata(timeline.lastInstant().get());
        }
        return Option.empty();
    }

    private Option<InternalSchema> getTableInternalSchemaFromCommitMetadata(HoodieInstant instant) {
        try {
            HoodieTimeline timeline = this.metaClient.getActiveTimeline().filterCompletedInstants();
            byte[] data = timeline.getInstantDetails(instant).get();
            HoodieCommitMetadata metadata = HoodieCommitMetadata.fromBytes(data, HoodieCommitMetadata.class);
            String latestInternalSchemaStr = metadata.getMetadata("latest_schema");
            if (latestInternalSchemaStr != null) {
                return SerDeHelper.fromJson(latestInternalSchemaStr);
            }
            return Option.empty();
        }
        catch (Exception e) {
            throw new HoodieException("Failed to read schema from commit metadata", e);
        }
    }

    public Option<String> getTableHistorySchemaStrFromCommitMetadata() {
        FileBasedInternalSchemaStorageManager manager = new FileBasedInternalSchemaStorageManager(this.metaClient);
        String result = manager.getHistorySchemaStr();
        return result.isEmpty() ? Option.empty() : Option.of(result);
    }
}

