/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieTableQueryType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hadoop.BootstrapBaseFileSplit;
import org.apache.hudi.hadoop.HiveHoodieTableFileIndex;
import org.apache.hudi.hadoop.HoodieTableInputFormat;
import org.apache.hudi.hadoop.InputPathHandler;
import org.apache.hudi.hadoop.PathWithBootstrapFileStatus;
import org.apache.hudi.hadoop.realtime.HoodieVirtualKeyInfo;
import org.apache.hudi.hadoop.utils.HoodieHiveUtils;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.hudi.org.apache.avro.Schema;

public class HoodieCopyOnWriteTableInputFormat
extends HoodieTableInputFormat {
    @Override
    protected boolean isSplitable(FileSystem fs, Path filename) {
        return !(filename instanceof PathWithBootstrapFileStatus);
    }

    @Override
    protected FileSplit makeSplit(Path file, long start, long length, String[] hosts) {
        FileSplit split = new FileSplit(file, start, length, hosts);
        if (file instanceof PathWithBootstrapFileStatus) {
            return this.makeExternalFileSplit((PathWithBootstrapFileStatus)file, split);
        }
        return split;
    }

    @Override
    protected FileSplit makeSplit(Path file, long start, long length, String[] hosts, String[] inMemoryHosts) {
        FileSplit split = new FileSplit(file, start, length, hosts, inMemoryHosts);
        if (file instanceof PathWithBootstrapFileStatus) {
            return this.makeExternalFileSplit((PathWithBootstrapFileStatus)file, split);
        }
        return split;
    }

    @Override
    public FileStatus[] listStatus(JobConf job) throws IOException {
        List<Path> snapshotPaths;
        List<String> incrementalTables = HoodieHiveUtils.getIncrementalTableNames((JobContext)Job.getInstance((Configuration)job));
        InputPathHandler inputPathHandler = new InputPathHandler(this.conf, HoodieCopyOnWriteTableInputFormat.getInputPaths((JobConf)job), incrementalTables);
        ArrayList<FileStatus> returns = new ArrayList<FileStatus>();
        Map<String, HoodieTableMetaClient> tableMetaClientMap = inputPathHandler.getTableMetaClientMap();
        for (String table : incrementalTables) {
            List<Path> inputPaths;
            List<FileStatus> result;
            HoodieTableMetaClient metaClient = tableMetaClientMap.get(table);
            if (metaClient == null || (result = this.listStatusForIncrementalMode(job, metaClient, inputPaths = inputPathHandler.getGroupedIncrementalPaths().get(metaClient), table)) == null) continue;
            returns.addAll(result);
        }
        List<Path> nonHoodiePaths = inputPathHandler.getNonHoodieInputPaths();
        if (nonHoodiePaths.size() > 0) {
            HoodieCopyOnWriteTableInputFormat.setInputPaths((JobConf)job, (Path[])nonHoodiePaths.toArray(new Path[nonHoodiePaths.size()]));
            FileStatus[] fileStatuses = this.doListStatus(job);
            returns.addAll(Arrays.asList(fileStatuses));
        }
        if ((snapshotPaths = inputPathHandler.getSnapshotPaths()).size() > 0) {
            returns.addAll(this.listStatusForSnapshotMode(job, tableMetaClientMap, snapshotPaths));
        }
        return returns.toArray(new FileStatus[0]);
    }

    public RecordReader<NullWritable, ArrayWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        throw new UnsupportedEncodingException("not implemented");
    }

    protected final FileStatus[] doListStatus(JobConf job) throws IOException {
        return super.listStatus(job);
    }

    protected List<FileStatus> listStatusForIncrementalMode(JobConf job, HoodieTableMetaClient tableMetaClient, List<Path> inputPaths, String incrementalTable) throws IOException {
        Job jobContext = Job.getInstance((Configuration)job);
        Option<HoodieTimeline> timeline = HoodieInputFormatUtils.getFilteredCommitsTimeline((JobContext)jobContext, tableMetaClient);
        if (!timeline.isPresent()) {
            return null;
        }
        Option<List<HoodieInstant>> commitsToCheck = HoodieInputFormatUtils.getCommitsForIncrementalQuery(jobContext, incrementalTable, timeline.get());
        if (!commitsToCheck.isPresent()) {
            return null;
        }
        Option<String> incrementalInputPaths = HoodieInputFormatUtils.getAffectedPartitions(commitsToCheck.get(), tableMetaClient, timeline.get(), inputPaths);
        if (!incrementalInputPaths.isPresent()) {
            return null;
        }
        HoodieCopyOnWriteTableInputFormat.setInputPaths((JobConf)job, (String)incrementalInputPaths.get());
        FileStatus[] fileStatuses = this.doListStatus(job);
        return HoodieInputFormatUtils.filterIncrementalFileStatus(jobContext, tableMetaClient, timeline.get(), fileStatuses, commitsToCheck.get());
    }

    protected FileStatus createFileStatusUnchecked(FileSlice fileSlice, HiveHoodieTableFileIndex fileIndex, Option<HoodieVirtualKeyInfo> virtualKeyInfoOpt) {
        Option<HoodieBaseFile> baseFileOpt = fileSlice.getBaseFile();
        if (baseFileOpt.isPresent()) {
            return HoodieCopyOnWriteTableInputFormat.getFileStatusUnchecked(baseFileOpt.get());
        }
        throw new IllegalStateException("Invalid state: base-file has to be present");
    }

    private BootstrapBaseFileSplit makeExternalFileSplit(PathWithBootstrapFileStatus file, FileSplit split) {
        try {
            LOG.info((Object)("Making external data split for " + (Object)((Object)file)));
            FileStatus externalFileStatus = file.getBootstrapFileStatus();
            FileSplit externalFileSplit = this.makeSplit(externalFileStatus.getPath(), 0L, externalFileStatus.getLen(), new String[0], new String[0]);
            return new BootstrapBaseFileSplit(split, externalFileSplit);
        }
        catch (IOException e) {
            throw new HoodieIOException(e.getMessage(), e);
        }
    }

    @Nonnull
    private List<FileStatus> listStatusForSnapshotMode(JobConf job, Map<String, HoodieTableMetaClient> tableMetaClientMap, List<Path> snapshotPaths) throws IOException {
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext((Configuration)job);
        ArrayList<FileStatus> targetFiles = new ArrayList<FileStatus>();
        TypedProperties props = new TypedProperties(new Properties());
        Map<HoodieTableMetaClient, List<Path>> groupedPaths = HoodieInputFormatUtils.groupSnapshotPathsByMetaClient(tableMetaClientMap.values(), snapshotPaths);
        for (Map.Entry<HoodieTableMetaClient, List<Path>> entry : groupedPaths.entrySet()) {
            HoodieTableMetaClient tableMetaClient = entry.getKey();
            List<Path> partitionPaths = entry.getValue();
            Option<String> queryCommitInstant = HoodieHiveUtils.getMaxCommit(job, tableMetaClient.getTableConfig().getTableName());
            boolean shouldIncludePendingCommits = HoodieHiveUtils.shouldIncludePendingCommits(job, tableMetaClient.getTableConfig().getTableName());
            HiveHoodieTableFileIndex fileIndex = new HiveHoodieTableFileIndex(engineContext, tableMetaClient, props, HoodieTableQueryType.SNAPSHOT, partitionPaths, queryCommitInstant, shouldIncludePendingCommits);
            Map<String, List<FileSlice>> partitionedFileSlices = fileIndex.listFileSlices();
            Option<HoodieVirtualKeyInfo> virtualKeyInfoOpt = HoodieCopyOnWriteTableInputFormat.getHoodieVirtualKeyInfo(tableMetaClient);
            targetFiles.addAll(partitionedFileSlices.values().stream().flatMap(Collection::stream).map(fileSlice -> this.createFileStatusUnchecked((FileSlice)fileSlice, fileIndex, virtualKeyInfoOpt)).collect(Collectors.toList()));
        }
        return targetFiles;
    }

    private void validate(List<FileStatus> targetFiles, List<FileStatus> legacyFileStatuses) {
        List<FileStatus> diff = CollectionUtils.diff(targetFiles, legacyFileStatuses);
        ValidationUtils.checkState(diff.isEmpty(), "Should be empty");
    }

    @Nonnull
    protected static FileStatus getFileStatusUnchecked(HoodieBaseFile baseFile) {
        try {
            return HoodieInputFormatUtils.getFileStatus(baseFile);
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Failed to get file-status", ioe);
        }
    }

    protected static Option<HoodieVirtualKeyInfo> getHoodieVirtualKeyInfo(HoodieTableMetaClient metaClient) {
        HoodieTableConfig tableConfig = metaClient.getTableConfig();
        if (tableConfig.populateMetaFields()) {
            return Option.empty();
        }
        TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(metaClient);
        try {
            Schema schema = tableSchemaResolver.getTableAvroSchema();
            return Option.of(new HoodieVirtualKeyInfo(tableConfig.getRecordKeyFieldProp(), tableConfig.getPartitionFieldProp(), schema.getField(tableConfig.getRecordKeyFieldProp()).pos(), schema.getField(tableConfig.getPartitionFieldProp()).pos()));
        }
        catch (Exception exception) {
            throw new HoodieException("Fetching table schema failed with exception ", exception);
        }
    }
}

