/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.io.storage.HoodieAvroParquetConfig;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.hudi.org.apache.parquet.hadoop.ParquetWriter;
import org.apache.hudi.org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.hudi.org.apache.parquet.io.OutputFile;
import org.apache.hudi.parquet.io.OutputStreamBackedOutputFile;

public class HoodieParquetStreamWriter<R extends IndexedRecord>
implements AutoCloseable {
    private final ParquetWriter<R> writer;
    private final HoodieAvroWriteSupport writeSupport;

    public HoodieParquetStreamWriter(FSDataOutputStream outputStream, HoodieAvroParquetConfig parquetConfig) throws IOException {
        this.writeSupport = (HoodieAvroWriteSupport)parquetConfig.getWriteSupport();
        this.writer = ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder(new OutputStreamBackedOutputFile(outputStream), this.writeSupport).withWriteMode(ParquetFileWriter.Mode.CREATE)).withCompressionCodec(parquetConfig.getCompressionCodecName())).withRowGroupSize(parquetConfig.getBlockSize())).withPageSize(parquetConfig.getPageSize())).withDictionaryPageSize(parquetConfig.getPageSize())).withDictionaryEncoding(parquetConfig.dictionaryEnabled())).withWriterVersion(ParquetWriter.DEFAULT_WRITER_VERSION)).withConf(parquetConfig.getHadoopConf())).build();
    }

    public void writeAvro(String key, R object) throws IOException {
        this.writer.write(object);
        this.writeSupport.add(key);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private static class Builder<T>
    extends ParquetWriter.Builder<T, Builder<T>> {
        private final WriteSupport<T> writeSupport;

        private Builder(Path file, WriteSupport<T> writeSupport) {
            super(file);
            this.writeSupport = writeSupport;
        }

        private Builder(OutputFile file, WriteSupport<T> writeSupport) {
            super(file);
            this.writeSupport = writeSupport;
        }

        @Override
        protected Builder<T> self() {
            return this;
        }

        @Override
        protected WriteSupport<T> getWriteSupport(Configuration conf) {
            return this.writeSupport;
        }
    }
}

