/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;

public abstract class BaseKeyGenerator
extends KeyGenerator {
    protected List<String> recordKeyFields;
    protected List<String> partitionPathFields;
    protected final boolean encodePartitionPath;
    protected final boolean hiveStylePartitioning;
    protected final boolean consistentLogicalTimestampEnabled;

    protected BaseKeyGenerator(TypedProperties config) {
        super(config);
        this.encodePartitionPath = config.getBoolean(KeyGeneratorOptions.URL_ENCODE_PARTITIONING.key(), Boolean.parseBoolean(KeyGeneratorOptions.URL_ENCODE_PARTITIONING.defaultValue()));
        this.hiveStylePartitioning = config.getBoolean(KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE.key(), Boolean.parseBoolean(KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE.defaultValue()));
        this.consistentLogicalTimestampEnabled = config.getBoolean(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), Boolean.parseBoolean(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.defaultValue()));
    }

    public abstract String getRecordKey(GenericRecord var1);

    public abstract String getPartitionPath(GenericRecord var1);

    @Override
    public final HoodieKey getKey(GenericRecord record) {
        if (this.getRecordKeyFields() == null || this.getPartitionPathFields() == null) {
            throw new HoodieKeyException("Unable to find field names for record key or partition path in cfg");
        }
        return new HoodieKey(this.getRecordKey(record), this.getPartitionPath(record));
    }

    @Override
    public final List<String> getRecordKeyFieldNames() {
        return this.getRecordKeyFields().stream().map(k -> {
            int idx = k.indexOf(46);
            return idx > 0 ? k.substring(0, idx) : k;
        }).collect(Collectors.toList());
    }

    public List<String> getRecordKeyFields() {
        return this.recordKeyFields;
    }

    public List<String> getPartitionPathFields() {
        return this.partitionPathFields;
    }

    public boolean isConsistentLogicalTimestampEnabled() {
        return this.consistentLogicalTimestampEnabled;
    }
}

