/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.namequeues.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.client.BalancerRejection;
import org.apache.hudi.org.apache.hadoop.hbase.namequeues.BalancerRejectionDetails;
import org.apache.hudi.org.apache.hadoop.hbase.namequeues.NamedQueuePayload;
import org.apache.hudi.org.apache.hadoop.hbase.namequeues.NamedQueueService;
import org.apache.hudi.org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import org.apache.hudi.org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.RecentLogs;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.EvictingQueue;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Queues;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class BalancerRejectionQueueService
implements NamedQueueService {
    private static final Logger LOG = LoggerFactory.getLogger(BalancerRejectionQueueService.class);
    private final boolean isBalancerRejectionRecording;
    private static final String BALANCER_REJECTION_QUEUE_SIZE = "hbase.master.balancer.rejection.queue.size";
    private static final int DEFAULT_BALANCER_REJECTION_QUEUE_SIZE = 250;
    private final Queue<RecentLogs.BalancerRejection> balancerRejectionQueue;

    public BalancerRejectionQueueService(Configuration conf) {
        this.isBalancerRejectionRecording = conf.getBoolean("hbase.master.balancer.rejection.buffer.enabled", false);
        if (!this.isBalancerRejectionRecording) {
            this.balancerRejectionQueue = null;
            return;
        }
        int queueSize = conf.getInt(BALANCER_REJECTION_QUEUE_SIZE, 250);
        EvictingQueue evictingQueue = EvictingQueue.create(queueSize);
        this.balancerRejectionQueue = Queues.synchronizedQueue(evictingQueue);
    }

    @Override
    public NamedQueuePayload.NamedQueueEvent getEvent() {
        return NamedQueuePayload.NamedQueueEvent.BALANCE_REJECTION;
    }

    @Override
    public void consumeEventFromDisruptor(NamedQueuePayload namedQueuePayload) {
        if (!this.isBalancerRejectionRecording) {
            return;
        }
        if (!(namedQueuePayload instanceof BalancerRejectionDetails)) {
            LOG.warn("BalancerRejectionQueueService: NamedQueuePayload is not of type BalancerRejectionDetails.");
            return;
        }
        BalancerRejectionDetails balancerRejectionDetails = (BalancerRejectionDetails)namedQueuePayload;
        BalancerRejection balancerRejectionRecord = balancerRejectionDetails.getBalancerRejection();
        RecentLogs.BalancerRejection BalancerRejection2 = RecentLogs.BalancerRejection.newBuilder().setReason(balancerRejectionRecord.getReason()).addAllCostFuncInfo(balancerRejectionRecord.getCostFuncInfoList()).build();
        this.balancerRejectionQueue.add(BalancerRejection2);
    }

    @Override
    public boolean clearNamedQueue() {
        if (!this.isBalancerRejectionRecording) {
            return false;
        }
        LOG.debug("Received request to clean up balancer rejection queue.");
        this.balancerRejectionQueue.clear();
        return true;
    }

    @Override
    public NamedQueueGetResponse getNamedQueueRecords(NamedQueueGetRequest request) {
        if (!this.isBalancerRejectionRecording) {
            return null;
        }
        List<RecentLogs.BalancerRejection> balancerRejections = Arrays.stream(this.balancerRejectionQueue.toArray(new RecentLogs.BalancerRejection[0])).collect(Collectors.toList());
        Collections.reverse(balancerRejections);
        int limit = balancerRejections.size();
        if (request.getBalancerRejectionsRequest().hasLimit()) {
            limit = Math.min(request.getBalancerRejectionsRequest().getLimit(), balancerRejections.size());
        }
        balancerRejections = balancerRejections.subList(0, limit);
        NamedQueueGetResponse namedQueueGetResponse = new NamedQueueGetResponse();
        namedQueueGetResponse.setNamedQueueEvent(2);
        namedQueueGetResponse.setBalancerRejections(balancerRejections);
        return namedQueueGetResponse;
    }

    @Override
    public void persistAll() {
    }
}

