/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.util.Objects;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.common.model.HoodieFileGroupId;

public class BootstrapFileMapping
implements Serializable,
Comparable<BootstrapFileMapping> {
    private final String bootstrapBasePath;
    private final String bootstrapPartitionPath;
    private final HoodieFileStatus bootstrapFileStatus;
    private final String partitionPath;
    private final String fileId;

    public BootstrapFileMapping(String bootstrapBasePath, String bootstrapPartitionPath, String partitionPath, HoodieFileStatus bootstrapFileStatus, String fileId) {
        this.bootstrapBasePath = bootstrapBasePath;
        this.bootstrapPartitionPath = bootstrapPartitionPath;
        this.partitionPath = partitionPath;
        this.bootstrapFileStatus = bootstrapFileStatus;
        this.fileId = fileId;
    }

    public String toString() {
        return "BootstrapFileMapping{bootstrapBasePath='" + this.bootstrapBasePath + '\'' + ", bootstrapPartitionPath='" + this.bootstrapPartitionPath + '\'' + ", bootstrapFileStatus=" + this.bootstrapFileStatus + ", partitionPath='" + this.partitionPath + '\'' + ", fileId='" + this.fileId + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BootstrapFileMapping mapping = (BootstrapFileMapping)o;
        return Objects.equals(this.bootstrapBasePath, mapping.bootstrapBasePath) && Objects.equals(this.bootstrapPartitionPath, mapping.bootstrapPartitionPath) && Objects.equals(this.partitionPath, mapping.partitionPath) && Objects.equals(this.bootstrapFileStatus, mapping.bootstrapFileStatus) && Objects.equals(this.fileId, mapping.fileId);
    }

    public int hashCode() {
        return Objects.hash(this.bootstrapBasePath, this.bootstrapPartitionPath, this.partitionPath, this.bootstrapFileStatus, this.fileId);
    }

    public String getBootstrapBasePath() {
        return this.bootstrapBasePath;
    }

    public String getBootstrapPartitionPath() {
        return this.bootstrapPartitionPath;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public HoodieFileStatus getBootstrapFileStatus() {
        return this.bootstrapFileStatus;
    }

    public String getFileId() {
        return this.fileId;
    }

    public HoodieFileGroupId getFileGroupId() {
        return new HoodieFileGroupId(this.partitionPath, this.fileId);
    }

    @Override
    public int compareTo(BootstrapFileMapping o) {
        int ret = this.partitionPath.compareTo(o.partitionPath);
        if (ret == 0) {
            ret = this.fileId.compareTo(o.fileId);
        }
        return ret;
    }
}

